// Generated by gtkmmproc -- DO NOT MODIFY!


#include <gtkmm/printoperation.h>
#include <gtkmm/private/printoperation_p.h>

// -*- c++ -*-
/* Copyright (C) 2006 The gtkmm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gtk/gtk.h>

// This Signal Proxy allows the C++ coder to specify a sigc::slot instead of a static function.

static void
SignalProxy_PrintSetupDone_gtk_callback(GtkPageSetup* page_setup, gpointer data)
{
  const Gtk::SlotPrintSetupDone* the_slot = static_cast<Gtk::SlotPrintSetupDone*>(data);

  try
  {
    Glib::RefPtr<Gtk::PageSetup> ps = Glib::wrap(page_setup);
    (*the_slot)(ps);
  }
  catch (...)
  {
    Glib::exception_handlers_invoke();
  }

  delete the_slot;
}

namespace Gtk
{

PrintOperationResult
PrintOperation::run(PrintOperationAction action)
{
  GError* gerror = 0;
  PrintOperationResult res =
    (PrintOperationResult)gtk_print_operation_run(this->gobj(), (GtkPrintOperationAction)action, 0, &gerror);

  if (res == PRINT_OPERATION_RESULT_ERROR)
  {
    gtk_print_operation_get_error(this->gobj(), &gerror);
    ::Glib::Error::throw_exception(gerror);
  }

  return res;
}

Glib::RefPtr<PageSetup>
run_page_setup_dialog(Window& parent,
                      const Glib::RefPtr<const PageSetup>& page_setup,
                      const Glib::RefPtr<const PrintSettings>& print_settings)
{
  // Specify the exact type with template specialization, to avoid possible
  // ambiguities between the const and non-const versions of unwrap() reported
  // by Sun's compiler (specifying unwrap<const Object> was reported
  // not to work):
  return Glib::wrap(
    gtk_print_run_page_setup_dialog(
      parent.gobj(),
      const_cast<GtkPageSetup*>(Glib::unwrap<PageSetup>(page_setup)),
      const_cast<GtkPrintSettings*>(Glib::unwrap<PrintSettings>(print_settings))));

}

Glib::RefPtr<PageSetup>
run_page_setup_dialog(Window& parent,
                      const Glib::RefPtr<const PrintSettings>& print_settings)
{
  // Specify the exact type with template specialization, to avoid possible
  // ambiguities between the const and non-const versions of unwrap() reported
  // by Sun's compiler (specifying unwrap<const Object> was reported
  // not to work):
  return Glib::wrap(
    gtk_print_run_page_setup_dialog(
      parent.gobj(),
      0,
      const_cast<GtkPrintSettings*>(Glib::unwrap<PrintSettings>(print_settings))));

}

void
run_page_setup_dialog_async(Window& parent,
                            const Glib::RefPtr<const PageSetup>& page_setup,
                            const Glib::RefPtr<const PrintSettings>& print_settings,
                            const SlotPrintSetupDone& slot)
{
  SlotPrintSetupDone* slot_copy = new SlotPrintSetupDone(slot);

  // Specify the exact type with template specialization, to avoid possible
  // ambiguities between the const and non-const versions of unwrap() reported
  // by Sun's compiler (specifying unwrap<const Object> was reported
  // not to work):
  gtk_print_run_page_setup_dialog_async(
    parent.gobj(),
    const_cast<GtkPageSetup*>(Glib::unwrap<PageSetup>(page_setup)),
    const_cast<GtkPrintSettings*>(Glib::unwrap<PrintSettings>(print_settings)),
    &SignalProxy_PrintSetupDone_gtk_callback,
    slot_copy);
}

void
run_page_setup_dialog_async(Window& parent,
                            const Glib::RefPtr<const PrintSettings>& print_settings,
                            const SlotPrintSetupDone& slot)
{
  SlotPrintSetupDone* slot_copy = new SlotPrintSetupDone(slot);

  // Specify the exact type with template specialization, to avoid possible
  // ambiguities between the const and non-const versions of unwrap() reported
  // by Sun's compiler (specifying unwrap<const Object> was reported
  // not to work):
  gtk_print_run_page_setup_dialog_async(
    parent.gobj(),
    0,
    const_cast<GtkPrintSettings*>(Glib::unwrap<PrintSettings>(print_settings)),
    &SignalProxy_PrintSetupDone_gtk_callback,
    slot_copy);
}

} // namespace Gtk

namespace
{


static void PrintOperation_signal_done_callback(GtkPrintOperation* self, GtkPrintOperationResult p0,void* data)
{
  using namespace Gtk;
  typedef sigc::slot< void,PrintOperationResult > SlotType;

  // Do not try to call a signal on a disassociated wrapper.
  if(Glib::ObjectBase::_get_current_wrapper((GObject*) self))
  {
    #ifdef GLIBMM_EXCEPTIONS_ENABLED
    try
    {
    #endif //GLIBMM_EXCEPTIONS_ENABLED
      if(sigc::slot_base *const slot = Glib::SignalProxyNormal::data_to_slot(data))
        (*static_cast<SlotType*>(slot))((PrintOperationResult)p0
);
    #ifdef GLIBMM_EXCEPTIONS_ENABLED
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
    #endif //GLIBMM_EXCEPTIONS_ENABLED
  }
}

static const Glib::SignalProxyInfo PrintOperation_signal_done_info =
{
  "done",
  (GCallback) &PrintOperation_signal_done_callback,
  (GCallback) &PrintOperation_signal_done_callback
};


static void PrintOperation_signal_begin_print_callback(GtkPrintOperation* self, GtkPrintContext* p0,void* data)
{
  using namespace Gtk;
  typedef sigc::slot< void,const Glib::RefPtr<PrintContext>& > SlotType;

  // Do not try to call a signal on a disassociated wrapper.
  if(Glib::ObjectBase::_get_current_wrapper((GObject*) self))
  {
    #ifdef GLIBMM_EXCEPTIONS_ENABLED
    try
    {
    #endif //GLIBMM_EXCEPTIONS_ENABLED
      if(sigc::slot_base *const slot = Glib::SignalProxyNormal::data_to_slot(data))
        (*static_cast<SlotType*>(slot))(Glib::wrap(p0, true)
);
    #ifdef GLIBMM_EXCEPTIONS_ENABLED
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
    #endif //GLIBMM_EXCEPTIONS_ENABLED
  }
}

static const Glib::SignalProxyInfo PrintOperation_signal_begin_print_info =
{
  "begin_print",
  (GCallback) &PrintOperation_signal_begin_print_callback,
  (GCallback) &PrintOperation_signal_begin_print_callback
};


static gboolean PrintOperation_signal_paginate_callback(GtkPrintOperation* self, GtkPrintContext* p0,void* data)
{
  using namespace Gtk;
  typedef sigc::slot< bool,const Glib::RefPtr<PrintContext>& > SlotType;

  // Do not try to call a signal on a disassociated wrapper.
  if(Glib::ObjectBase::_get_current_wrapper((GObject*) self))
  {
    #ifdef GLIBMM_EXCEPTIONS_ENABLED
    try
    {
    #endif //GLIBMM_EXCEPTIONS_ENABLED
      if(sigc::slot_base *const slot = Glib::SignalProxyNormal::data_to_slot(data))
        return static_cast<int>((*static_cast<SlotType*>(slot))(Glib::wrap(p0, true)
));
    #ifdef GLIBMM_EXCEPTIONS_ENABLED
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
    #endif //GLIBMM_EXCEPTIONS_ENABLED
  }

  typedef gboolean RType;
  return RType();
}

static gboolean PrintOperation_signal_paginate_notify_callback(GtkPrintOperation* self, GtkPrintContext* p0, void* data)
{
  using namespace Gtk;
  typedef sigc::slot< void,const Glib::RefPtr<PrintContext>& > SlotType;

  // Do not try to call a signal on a disassociated wrapper.
  if(Glib::ObjectBase::_get_current_wrapper((GObject*) self))
  {
    #ifdef GLIBMM_EXCEPTIONS_ENABLED
    try
    {
    #endif //GLIBMM_EXCEPTIONS_ENABLED
      if(sigc::slot_base *const slot = Glib::SignalProxyNormal::data_to_slot(data))
        (*static_cast<SlotType*>(slot))(Glib::wrap(p0, true)
);
    #ifdef GLIBMM_EXCEPTIONS_ENABLED
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
    #endif //GLIBMM_EXCEPTIONS_ENABLED
  }

  typedef gboolean RType;
  return RType();
}

static const Glib::SignalProxyInfo PrintOperation_signal_paginate_info =
{
  "paginate",
  (GCallback) &PrintOperation_signal_paginate_callback,
  (GCallback) &PrintOperation_signal_paginate_notify_callback
};


static void PrintOperation_signal_request_page_setup_callback(GtkPrintOperation* self, GtkPrintContext* p0,gint p1,GtkPageSetup* p2,void* data)
{
  using namespace Gtk;
  typedef sigc::slot< void,const Glib::RefPtr<PrintContext>&,int,const Glib::RefPtr<PageSetup>& > SlotType;

  // Do not try to call a signal on a disassociated wrapper.
  if(Glib::ObjectBase::_get_current_wrapper((GObject*) self))
  {
    #ifdef GLIBMM_EXCEPTIONS_ENABLED
    try
    {
    #endif //GLIBMM_EXCEPTIONS_ENABLED
      if(sigc::slot_base *const slot = Glib::SignalProxyNormal::data_to_slot(data))
        (*static_cast<SlotType*>(slot))(Glib::wrap(p0, true)
, p1
, Glib::wrap(p2, true)
);
    #ifdef GLIBMM_EXCEPTIONS_ENABLED
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
    #endif //GLIBMM_EXCEPTIONS_ENABLED
  }
}

static const Glib::SignalProxyInfo PrintOperation_signal_request_page_setup_info =
{
  "request_page_setup",
  (GCallback) &PrintOperation_signal_request_page_setup_callback,
  (GCallback) &PrintOperation_signal_request_page_setup_callback
};


static void PrintOperation_signal_draw_page_callback(GtkPrintOperation* self, GtkPrintContext* p0,gint p1,void* data)
{
  using namespace Gtk;
  typedef sigc::slot< void,const Glib::RefPtr<PrintContext>&,int > SlotType;

  // Do not try to call a signal on a disassociated wrapper.
  if(Glib::ObjectBase::_get_current_wrapper((GObject*) self))
  {
    #ifdef GLIBMM_EXCEPTIONS_ENABLED
    try
    {
    #endif //GLIBMM_EXCEPTIONS_ENABLED
      if(sigc::slot_base *const slot = Glib::SignalProxyNormal::data_to_slot(data))
        (*static_cast<SlotType*>(slot))(Glib::wrap(p0, true)
, p1
);
    #ifdef GLIBMM_EXCEPTIONS_ENABLED
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
    #endif //GLIBMM_EXCEPTIONS_ENABLED
  }
}

static const Glib::SignalProxyInfo PrintOperation_signal_draw_page_info =
{
  "draw_page",
  (GCallback) &PrintOperation_signal_draw_page_callback,
  (GCallback) &PrintOperation_signal_draw_page_callback
};


static void PrintOperation_signal_end_print_callback(GtkPrintOperation* self, GtkPrintContext* p0,void* data)
{
  using namespace Gtk;
  typedef sigc::slot< void,const Glib::RefPtr<PrintContext>& > SlotType;

  // Do not try to call a signal on a disassociated wrapper.
  if(Glib::ObjectBase::_get_current_wrapper((GObject*) self))
  {
    #ifdef GLIBMM_EXCEPTIONS_ENABLED
    try
    {
    #endif //GLIBMM_EXCEPTIONS_ENABLED
      if(sigc::slot_base *const slot = Glib::SignalProxyNormal::data_to_slot(data))
        (*static_cast<SlotType*>(slot))(Glib::wrap(p0, true)
);
    #ifdef GLIBMM_EXCEPTIONS_ENABLED
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
    #endif //GLIBMM_EXCEPTIONS_ENABLED
  }
}

static const Glib::SignalProxyInfo PrintOperation_signal_end_print_info =
{
  "end_print",
  (GCallback) &PrintOperation_signal_end_print_callback,
  (GCallback) &PrintOperation_signal_end_print_callback
};


static const Glib::SignalProxyInfo PrintOperation_signal_status_changed_info =
{
  "status_changed",
  (GCallback) &Glib::SignalProxyNormal::slot0_void_callback,
  (GCallback) &Glib::SignalProxyNormal::slot0_void_callback
};


static GtkWidget* PrintOperation_signal_create_custom_widget_callback(GtkPrintOperation* self, void* data)
{
  using namespace Gtk;
  typedef sigc::slot< Widget* > SlotType;

  // Do not try to call a signal on a disassociated wrapper.
  if(Glib::ObjectBase::_get_current_wrapper((GObject*) self))
  {
    #ifdef GLIBMM_EXCEPTIONS_ENABLED
    try
    {
    #endif //GLIBMM_EXCEPTIONS_ENABLED
      if(sigc::slot_base *const slot = Glib::SignalProxyNormal::data_to_slot(data))
        return (GtkWidget*)Glib::unwrap((*static_cast<SlotType*>(slot))());
    #ifdef GLIBMM_EXCEPTIONS_ENABLED
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
    #endif //GLIBMM_EXCEPTIONS_ENABLED
  }

  typedef GtkWidget* RType;
  return RType();
}

static GtkWidget* PrintOperation_signal_create_custom_widget_notify_callback(GtkPrintOperation* self,  void* data)
{
  using namespace Gtk;
  typedef sigc::slot< void > SlotType;

  // Do not try to call a signal on a disassociated wrapper.
  if(Glib::ObjectBase::_get_current_wrapper((GObject*) self))
  {
    #ifdef GLIBMM_EXCEPTIONS_ENABLED
    try
    {
    #endif //GLIBMM_EXCEPTIONS_ENABLED
      if(sigc::slot_base *const slot = Glib::SignalProxyNormal::data_to_slot(data))
        (*static_cast<SlotType*>(slot))();
    #ifdef GLIBMM_EXCEPTIONS_ENABLED
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
    #endif //GLIBMM_EXCEPTIONS_ENABLED
  }

  typedef GtkWidget* RType;
  return RType();
}

static const Glib::SignalProxyInfo PrintOperation_signal_create_custom_widget_info =
{
  "create_custom_widget",
  (GCallback) &PrintOperation_signal_create_custom_widget_callback,
  (GCallback) &PrintOperation_signal_create_custom_widget_notify_callback
};


static void PrintOperation_signal_custom_widget_apply_callback(GtkPrintOperation* self, GtkWidget* p0,void* data)
{
  using namespace Gtk;
  typedef sigc::slot< void,Widget* > SlotType;

  // Do not try to call a signal on a disassociated wrapper.
  if(Glib::ObjectBase::_get_current_wrapper((GObject*) self))
  {
    #ifdef GLIBMM_EXCEPTIONS_ENABLED
    try
    {
    #endif //GLIBMM_EXCEPTIONS_ENABLED
      if(sigc::slot_base *const slot = Glib::SignalProxyNormal::data_to_slot(data))
        (*static_cast<SlotType*>(slot))(Glib::wrap(p0)
);
    #ifdef GLIBMM_EXCEPTIONS_ENABLED
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
    #endif //GLIBMM_EXCEPTIONS_ENABLED
  }
}

static const Glib::SignalProxyInfo PrintOperation_signal_custom_widget_apply_info =
{
  "custom_widget_apply",
  (GCallback) &PrintOperation_signal_custom_widget_apply_callback,
  (GCallback) &PrintOperation_signal_custom_widget_apply_callback
};


static gboolean PrintOperation_signal_preview_callback(GtkPrintOperation* self, GtkPrintOperationPreview* p0,GtkPrintContext* p1,GtkWindow* p2,void* data)
{
  using namespace Gtk;
  typedef sigc::slot< bool,const Glib::RefPtr<PrintOperationPreview>&,const Glib::RefPtr<PrintContext>&,Window* > SlotType;

  // Do not try to call a signal on a disassociated wrapper.
  if(Glib::ObjectBase::_get_current_wrapper((GObject*) self))
  {
    #ifdef GLIBMM_EXCEPTIONS_ENABLED
    try
    {
    #endif //GLIBMM_EXCEPTIONS_ENABLED
      if(sigc::slot_base *const slot = Glib::SignalProxyNormal::data_to_slot(data))
        return static_cast<int>((*static_cast<SlotType*>(slot))(Glib::wrap(p0, true)
, Glib::wrap(p1, true)
, Glib::wrap(p2)
));
    #ifdef GLIBMM_EXCEPTIONS_ENABLED
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
    #endif //GLIBMM_EXCEPTIONS_ENABLED
  }

  typedef gboolean RType;
  return RType();
}

static gboolean PrintOperation_signal_preview_notify_callback(GtkPrintOperation* self, GtkPrintOperationPreview* p0,GtkPrintContext* p1,GtkWindow* p2, void* data)
{
  using namespace Gtk;
  typedef sigc::slot< void,const Glib::RefPtr<PrintOperationPreview>&,const Glib::RefPtr<PrintContext>&,Window* > SlotType;

  // Do not try to call a signal on a disassociated wrapper.
  if(Glib::ObjectBase::_get_current_wrapper((GObject*) self))
  {
    #ifdef GLIBMM_EXCEPTIONS_ENABLED
    try
    {
    #endif //GLIBMM_EXCEPTIONS_ENABLED
      if(sigc::slot_base *const slot = Glib::SignalProxyNormal::data_to_slot(data))
        (*static_cast<SlotType*>(slot))(Glib::wrap(p0, true)
, Glib::wrap(p1, true)
, Glib::wrap(p2)
);
    #ifdef GLIBMM_EXCEPTIONS_ENABLED
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
    #endif //GLIBMM_EXCEPTIONS_ENABLED
  }

  typedef gboolean RType;
  return RType();
}

static const Glib::SignalProxyInfo PrintOperation_signal_preview_info =
{
  "preview",
  (GCallback) &PrintOperation_signal_preview_callback,
  (GCallback) &PrintOperation_signal_preview_notify_callback
};


static void PrintOperation_signal_update_custom_widget_callback(GtkPrintOperation* self, GtkWidget* p0,GtkPageSetup* p1,GtkPrintSettings* p2,void* data)
{
  using namespace Gtk;
  typedef sigc::slot< void,Gtk::Widget*,const Glib::RefPtr<PageSetup>&,const Glib::RefPtr<PrintSettings>& > SlotType;

  // Do not try to call a signal on a disassociated wrapper.
  if(Glib::ObjectBase::_get_current_wrapper((GObject*) self))
  {
    #ifdef GLIBMM_EXCEPTIONS_ENABLED
    try
    {
    #endif //GLIBMM_EXCEPTIONS_ENABLED
      if(sigc::slot_base *const slot = Glib::SignalProxyNormal::data_to_slot(data))
        (*static_cast<SlotType*>(slot))(Glib::wrap(p0)
, Glib::wrap(p1, true)
, Glib::wrap(p2, true)
);
    #ifdef GLIBMM_EXCEPTIONS_ENABLED
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
    #endif //GLIBMM_EXCEPTIONS_ENABLED
  }
}

static const Glib::SignalProxyInfo PrintOperation_signal_update_custom_widget_info =
{
  "update_custom_widget",
  (GCallback) &PrintOperation_signal_update_custom_widget_callback,
  (GCallback) &PrintOperation_signal_update_custom_widget_callback
};


} // anonymous namespace

// static
GType Glib::Value<Gtk::PrintStatus>::value_type()
{
  return gtk_print_status_get_type();
}

// static
GType Glib::Value<Gtk::PrintOperationResult>::value_type()
{
  return gtk_print_operation_result_get_type();
}

// static
GType Glib::Value<Gtk::PrintOperationAction>::value_type()
{
  return gtk_print_operation_action_get_type();
}


Gtk::PrintError::PrintError(Gtk::PrintError::Code error_code, const Glib::ustring& error_message)
:
  Glib::Error (GTK_PRINT_ERROR, error_code, error_message)
{}

Gtk::PrintError::PrintError(GError* gobject)
:
  Glib::Error (gobject)
{}

Gtk::PrintError::Code Gtk::PrintError::code() const
{
  return static_cast<Code>(Glib::Error::code());
}

void Gtk::PrintError::throw_func(GError* gobject)
{
  throw Gtk::PrintError(gobject);
}

// static
GType Glib::Value<Gtk::PrintError::Code>::value_type()
{
  return gtk_print_error_get_type();
}


namespace Glib
{

Glib::RefPtr<Gtk::PrintOperation> wrap(GtkPrintOperation* object, bool take_copy)
{
  return Glib::RefPtr<Gtk::PrintOperation>( dynamic_cast<Gtk::PrintOperation*> (Glib::wrap_auto ((GObject*)(object), take_copy)) );
  //We use dynamic_cast<> in case of multiple inheritance.
}

} /* namespace Glib */


namespace Gtk
{


/* The *_Class implementation: */

const Glib::Class& PrintOperation_Class::init()
{
  if(!gtype_) // create the GType if necessary
  {
    // Glib::Class has to know the class init function to clone custom types.
    class_init_func_ = &PrintOperation_Class::class_init_function;

    // This is actually just optimized away, apparently with no harm.
    // Make sure that the parent type has been created.
    //CppClassParent::CppObjectType::get_type();

    // Create the wrapper type, with the same class/instance size as the base type.
    register_derived_type(gtk_print_operation_get_type());

    // Add derived versions of interfaces, if the C type implements any interfaces:
  PrintOperationPreview::add_interface(get_type());

  }

  return *this;
}


void PrintOperation_Class::class_init_function(void* g_class, void* class_data)
{
  BaseClassType *const klass = static_cast<BaseClassType*>(g_class);
  CppClassParent::class_init_function(klass, class_data);


  klass->done = &done_callback;
  klass->begin_print = &begin_print_callback;
  klass->paginate = &paginate_callback;
  klass->request_page_setup = &request_page_setup_callback;
  klass->draw_page = &draw_page_callback;
  klass->end_print = &end_print_callback;
  klass->status_changed = &status_changed_callback;
  klass->create_custom_widget = &create_custom_widget_callback;
  klass->custom_widget_apply = &custom_widget_apply_callback;
  klass->preview = &preview_callback;
}


void PrintOperation_Class::done_callback(GtkPrintOperation* self, GtkPrintOperationResult p0)
{
  Glib::ObjectBase *const obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    CppObjectType *const obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
      #endif //GLIBMM_EXCEPTIONS_ENABLED
        // Call the virtual member method, which derived classes might override.
        obj->on_done((PrintOperationResult)p0
);
        return;
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
      #endif //GLIBMM_EXCEPTIONS_ENABLED
    }
  }

  BaseClassType *const base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
    );

  // Call the original underlying C function:
  if(base && base->done)
    (*base->done)(self, p0);
}
void PrintOperation_Class::begin_print_callback(GtkPrintOperation* self, GtkPrintContext* p0)
{
  Glib::ObjectBase *const obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    CppObjectType *const obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
      #endif //GLIBMM_EXCEPTIONS_ENABLED
        // Call the virtual member method, which derived classes might override.
        obj->on_begin_print(Glib::wrap(p0, true)
);
        return;
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
      #endif //GLIBMM_EXCEPTIONS_ENABLED
    }
  }

  BaseClassType *const base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
    );

  // Call the original underlying C function:
  if(base && base->begin_print)
    (*base->begin_print)(self, p0);
}
gboolean PrintOperation_Class::paginate_callback(GtkPrintOperation* self, GtkPrintContext* p0)
{
  Glib::ObjectBase *const obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    CppObjectType *const obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
      #endif //GLIBMM_EXCEPTIONS_ENABLED
        // Call the virtual member method, which derived classes might override.
        return static_cast<int>(obj->on_paginate(Glib::wrap(p0, true)
));
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
      #endif //GLIBMM_EXCEPTIONS_ENABLED
    }
  }

  BaseClassType *const base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
    );

  // Call the original underlying C function:
  if(base && base->paginate)
    return (*base->paginate)(self, p0);

  typedef gboolean RType;
  return RType();
}
void PrintOperation_Class::request_page_setup_callback(GtkPrintOperation* self, GtkPrintContext* p0, gint p1, GtkPageSetup* p2)
{
  Glib::ObjectBase *const obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    CppObjectType *const obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
      #endif //GLIBMM_EXCEPTIONS_ENABLED
        // Call the virtual member method, which derived classes might override.
        obj->on_request_page_setup(Glib::wrap(p0, true)
, p1
, Glib::wrap(p2, true)
);
        return;
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
      #endif //GLIBMM_EXCEPTIONS_ENABLED
    }
  }

  BaseClassType *const base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
    );

  // Call the original underlying C function:
  if(base && base->request_page_setup)
    (*base->request_page_setup)(self, p0, p1, p2);
}
void PrintOperation_Class::draw_page_callback(GtkPrintOperation* self, GtkPrintContext* p0, gint p1)
{
  Glib::ObjectBase *const obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    CppObjectType *const obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
      #endif //GLIBMM_EXCEPTIONS_ENABLED
        // Call the virtual member method, which derived classes might override.
        obj->on_draw_page(Glib::wrap(p0, true)
, p1
);
        return;
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
      #endif //GLIBMM_EXCEPTIONS_ENABLED
    }
  }

  BaseClassType *const base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
    );

  // Call the original underlying C function:
  if(base && base->draw_page)
    (*base->draw_page)(self, p0, p1);
}
void PrintOperation_Class::end_print_callback(GtkPrintOperation* self, GtkPrintContext* p0)
{
  Glib::ObjectBase *const obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    CppObjectType *const obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
      #endif //GLIBMM_EXCEPTIONS_ENABLED
        // Call the virtual member method, which derived classes might override.
        obj->on_end_print(Glib::wrap(p0, true)
);
        return;
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
      #endif //GLIBMM_EXCEPTIONS_ENABLED
    }
  }

  BaseClassType *const base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
    );

  // Call the original underlying C function:
  if(base && base->end_print)
    (*base->end_print)(self, p0);
}
void PrintOperation_Class::status_changed_callback(GtkPrintOperation* self)
{
  Glib::ObjectBase *const obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    CppObjectType *const obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
      #endif //GLIBMM_EXCEPTIONS_ENABLED
        // Call the virtual member method, which derived classes might override.
        obj->on_status_changed();
        return;
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
      #endif //GLIBMM_EXCEPTIONS_ENABLED
    }
  }

  BaseClassType *const base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
    );

  // Call the original underlying C function:
  if(base && base->status_changed)
    (*base->status_changed)(self);
}
GtkWidget* PrintOperation_Class::create_custom_widget_callback(GtkPrintOperation* self)
{
  Glib::ObjectBase *const obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    CppObjectType *const obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
      #endif //GLIBMM_EXCEPTIONS_ENABLED
        // Call the virtual member method, which derived classes might override.
        return (GtkWidget*)Glib::unwrap(obj->on_create_custom_widget());
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
      #endif //GLIBMM_EXCEPTIONS_ENABLED
    }
  }

  BaseClassType *const base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
    );

  // Call the original underlying C function:
  if(base && base->create_custom_widget)
    return (*base->create_custom_widget)(self);

  typedef GtkWidget* RType;
  return RType();
}
void PrintOperation_Class::custom_widget_apply_callback(GtkPrintOperation* self, GtkWidget* p0)
{
  Glib::ObjectBase *const obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    CppObjectType *const obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
      #endif //GLIBMM_EXCEPTIONS_ENABLED
        // Call the virtual member method, which derived classes might override.
        obj->on_custom_widget_apply(Glib::wrap(p0)
);
        return;
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
      #endif //GLIBMM_EXCEPTIONS_ENABLED
    }
  }

  BaseClassType *const base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
    );

  // Call the original underlying C function:
  if(base && base->custom_widget_apply)
    (*base->custom_widget_apply)(self, p0);
}
gboolean PrintOperation_Class::preview_callback(GtkPrintOperation* self, GtkPrintOperationPreview* p0, GtkPrintContext* p1, GtkWindow* p2)
{
  Glib::ObjectBase *const obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    CppObjectType *const obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
      #endif //GLIBMM_EXCEPTIONS_ENABLED
        // Call the virtual member method, which derived classes might override.
        return static_cast<int>(obj->on_preview(Glib::wrap(p0, true)
, Glib::wrap(p1, true)
, Glib::wrap(p2)
));
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
      #endif //GLIBMM_EXCEPTIONS_ENABLED
    }
  }

  BaseClassType *const base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
    );

  // Call the original underlying C function:
  if(base && base->preview)
    return (*base->preview)(self, p0, p1, p2);

  typedef gboolean RType;
  return RType();
}


Glib::ObjectBase* PrintOperation_Class::wrap_new(GObject* object)
{
  return new PrintOperation((GtkPrintOperation*)object);
}


/* The implementation: */

GtkPrintOperation* PrintOperation::gobj_copy()
{
  reference();
  return gobj();
}

PrintOperation::PrintOperation(const Glib::ConstructParams& construct_params)
:
  Glib::Object(construct_params)
{

}

PrintOperation::PrintOperation(GtkPrintOperation* castitem)
:
  Glib::Object((GObject*)(castitem))
{}


PrintOperation::~PrintOperation()
{}


PrintOperation::CppClassType PrintOperation::printoperation_class_; // initialize static member

GType PrintOperation::get_type()
{
  return printoperation_class_.init().get_type();
}


GType PrintOperation::get_base_type()
{
  return gtk_print_operation_get_type();
}


PrintOperation::PrintOperation()
:
  // Mark this class as non-derived to allow C++ vfuncs to be skipped.
  Glib::ObjectBase(0),
  Glib::Object(Glib::ConstructParams(printoperation_class_.init()))
{
  

}

Glib::RefPtr<PrintOperation> PrintOperation::create()
{
  return Glib::RefPtr<PrintOperation>( new PrintOperation() );
}

void PrintOperation::set_default_page_setup(const Glib::RefPtr<PageSetup>& default_page_setup)
{
gtk_print_operation_set_default_page_setup(gobj(), Glib::unwrap(default_page_setup)); 
}

Glib::RefPtr<PageSetup> PrintOperation::get_default_page_setup() const
{

  Glib::RefPtr<PageSetup> retvalue = Glib::wrap(gtk_print_operation_get_default_page_setup(const_cast<GtkPrintOperation*>(gobj())));
  if(retvalue)
    retvalue->reference(); //The function does not do a ref for us.
  return retvalue;

}

void PrintOperation::set_print_settings(const Glib::RefPtr<PrintSettings>& print_settings)
{
gtk_print_operation_set_print_settings(gobj(), Glib::unwrap(print_settings)); 
}

Glib::RefPtr<PrintSettings> PrintOperation::get_print_settings() const
{

  Glib::RefPtr<PrintSettings> retvalue = Glib::wrap(gtk_print_operation_get_print_settings(const_cast<GtkPrintOperation*>(gobj())));
  if(retvalue)
    retvalue->reference(); //The function does not do a ref for us.
  return retvalue;

}

void PrintOperation::set_job_name(const Glib::ustring& job_name)
{
gtk_print_operation_set_job_name(gobj(), job_name.c_str()); 
}

void PrintOperation::set_n_pages(int n_pages)
{
gtk_print_operation_set_n_pages(gobj(), n_pages); 
}

void PrintOperation::set_current_page(int current_page)
{
gtk_print_operation_set_current_page(gobj(), current_page); 
}

void PrintOperation::set_use_full_page(bool use_full_page)
{
gtk_print_operation_set_use_full_page(gobj(), static_cast<int>(use_full_page)); 
}

void PrintOperation::set_unit(Unit unit)
{
gtk_print_operation_set_unit(gobj(), ((GtkUnit)(unit))); 
}

void PrintOperation::set_export_filename(const std::string& filename)
{
gtk_print_operation_set_export_filename(gobj(), filename.c_str()); 
}

void PrintOperation::set_track_print_status(bool track_status)
{
gtk_print_operation_set_track_print_status(gobj(), static_cast<int>(track_status)); 
}

void PrintOperation::set_show_progress(bool show_progress)
{
gtk_print_operation_set_show_progress(gobj(), static_cast<int>(show_progress)); 
}

void PrintOperation::set_allow_async(bool allow_async)
{
gtk_print_operation_set_allow_async(gobj(), static_cast<int>(allow_async)); 
}

void PrintOperation::set_custom_tab_label(const Glib::ustring& label)
{
gtk_print_operation_set_custom_tab_label(gobj(), label.c_str()); 
}

PrintOperationResult PrintOperation::run(PrintOperationAction action, Window& parent)
{
  GError* gerror = 0;
  PrintOperationResult retvalue = (PrintOperationResult)gtk_print_operation_run(gobj(), ((GtkPrintOperationAction)(action)), (parent).gobj(), &(gerror));
  if(gerror)
    ::Glib::Error::throw_exception(gerror);

  return retvalue;

}

PrintStatus PrintOperation::get_status() const
{
  return (PrintStatus)gtk_print_operation_get_status(const_cast<GtkPrintOperation*>(gobj()));
}

Glib::ustring PrintOperation::get_status_string() const
{
  return Glib::convert_const_gchar_ptr_to_ustring(gtk_print_operation_get_status_string(const_cast<GtkPrintOperation*>(gobj())));
}

void PrintOperation::cancel()
{
gtk_print_operation_cancel(gobj()); 
}

bool PrintOperation::is_finished() const
{
  return gtk_print_operation_is_finished(const_cast<GtkPrintOperation*>(gobj()));
}

void PrintOperation::draw_page_finish()
{
gtk_print_operation_draw_page_finish(gobj()); 
}

void PrintOperation::set_defer_drawing()
{
gtk_print_operation_set_defer_drawing(gobj()); 
}

void PrintOperation::set_support_selection(bool support_selection)
{
gtk_print_operation_set_support_selection(gobj(), static_cast<int>(support_selection)); 
}

bool PrintOperation::get_support_selection() const
{
  return gtk_print_operation_get_support_selection(const_cast<GtkPrintOperation*>(gobj()));
}

void PrintOperation::set_has_selection(bool has_selection)
{
gtk_print_operation_set_has_selection(gobj(), static_cast<int>(has_selection)); 
}

bool PrintOperation::get_has_selection() const
{
  return gtk_print_operation_get_has_selection(const_cast<GtkPrintOperation*>(gobj()));
}

void PrintOperation::set_embed_page_setup(bool embed)
{
gtk_print_operation_set_embed_page_setup(gobj(), static_cast<int>(embed)); 
}

bool PrintOperation::get_embed_page_setup() const
{
  return gtk_print_operation_get_embed_page_setup(const_cast<GtkPrintOperation*>(gobj()));
}

int PrintOperation::get_n_pages_to_print() const
{
  return gtk_print_operation_get_n_pages_to_print(const_cast<GtkPrintOperation*>(gobj()));
}


Glib::SignalProxy1< void,PrintOperationResult > PrintOperation::signal_done()
{
  return Glib::SignalProxy1< void,PrintOperationResult >(this, &PrintOperation_signal_done_info);
}


Glib::SignalProxy1< void,const Glib::RefPtr<PrintContext>& > PrintOperation::signal_begin_print()
{
  return Glib::SignalProxy1< void,const Glib::RefPtr<PrintContext>& >(this, &PrintOperation_signal_begin_print_info);
}


Glib::SignalProxy1< bool,const Glib::RefPtr<PrintContext>& > PrintOperation::signal_paginate()
{
  return Glib::SignalProxy1< bool,const Glib::RefPtr<PrintContext>& >(this, &PrintOperation_signal_paginate_info);
}


Glib::SignalProxy3< void,const Glib::RefPtr<PrintContext>&,int,const Glib::RefPtr<PageSetup>& > PrintOperation::signal_request_page_setup()
{
  return Glib::SignalProxy3< void,const Glib::RefPtr<PrintContext>&,int,const Glib::RefPtr<PageSetup>& >(this, &PrintOperation_signal_request_page_setup_info);
}


Glib::SignalProxy2< void,const Glib::RefPtr<PrintContext>&,int > PrintOperation::signal_draw_page()
{
  return Glib::SignalProxy2< void,const Glib::RefPtr<PrintContext>&,int >(this, &PrintOperation_signal_draw_page_info);
}


Glib::SignalProxy1< void,const Glib::RefPtr<PrintContext>& > PrintOperation::signal_end_print()
{
  return Glib::SignalProxy1< void,const Glib::RefPtr<PrintContext>& >(this, &PrintOperation_signal_end_print_info);
}


Glib::SignalProxy0< void > PrintOperation::signal_status_changed()
{
  return Glib::SignalProxy0< void >(this, &PrintOperation_signal_status_changed_info);
}


Glib::SignalProxy0< Widget* > PrintOperation::signal_create_custom_widget()
{
  return Glib::SignalProxy0< Widget* >(this, &PrintOperation_signal_create_custom_widget_info);
}


Glib::SignalProxy1< void,Widget* > PrintOperation::signal_custom_widget_apply()
{
  return Glib::SignalProxy1< void,Widget* >(this, &PrintOperation_signal_custom_widget_apply_info);
}


Glib::SignalProxy3< bool,const Glib::RefPtr<PrintOperationPreview>&,const Glib::RefPtr<PrintContext>&,Window* > PrintOperation::signal_preview()
{
  return Glib::SignalProxy3< bool,const Glib::RefPtr<PrintOperationPreview>&,const Glib::RefPtr<PrintContext>&,Window* >(this, &PrintOperation_signal_preview_info);
}


Glib::SignalProxy3< void,Gtk::Widget*,const Glib::RefPtr<PageSetup>&,const Glib::RefPtr<PrintSettings>& > PrintOperation::signal_update_custom_widget()
{
  return Glib::SignalProxy3< void,Gtk::Widget*,const Glib::RefPtr<PageSetup>&,const Glib::RefPtr<PrintSettings>& >(this, &PrintOperation_signal_update_custom_widget_info);
}


#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy< Glib::RefPtr<PageSetup> > PrintOperation::property_default_page_setup() 
{
  return Glib::PropertyProxy< Glib::RefPtr<PageSetup> >(this, "default-page-setup");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy_ReadOnly< Glib::RefPtr<PageSetup> > PrintOperation::property_default_page_setup() const
{
  return Glib::PropertyProxy_ReadOnly< Glib::RefPtr<PageSetup> >(this, "default-page-setup");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy< Glib::RefPtr<PrintSettings> > PrintOperation::property_print_settings() 
{
  return Glib::PropertyProxy< Glib::RefPtr<PrintSettings> >(this, "print-settings");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy_ReadOnly< Glib::RefPtr<PrintSettings> > PrintOperation::property_print_settings() const
{
  return Glib::PropertyProxy_ReadOnly< Glib::RefPtr<PrintSettings> >(this, "print-settings");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy<Glib::ustring> PrintOperation::property_job_name() 
{
  return Glib::PropertyProxy<Glib::ustring>(this, "job-name");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy_ReadOnly<Glib::ustring> PrintOperation::property_job_name() const
{
  return Glib::PropertyProxy_ReadOnly<Glib::ustring>(this, "job-name");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy<int> PrintOperation::property_n_pages() 
{
  return Glib::PropertyProxy<int>(this, "n-pages");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy_ReadOnly<int> PrintOperation::property_n_pages() const
{
  return Glib::PropertyProxy_ReadOnly<int>(this, "n-pages");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy<int> PrintOperation::property_current_page() 
{
  return Glib::PropertyProxy<int>(this, "current-page");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy_ReadOnly<int> PrintOperation::property_current_page() const
{
  return Glib::PropertyProxy_ReadOnly<int>(this, "current-page");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy<bool> PrintOperation::property_use_full_page() 
{
  return Glib::PropertyProxy<bool>(this, "use-full-page");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy_ReadOnly<bool> PrintOperation::property_use_full_page() const
{
  return Glib::PropertyProxy_ReadOnly<bool>(this, "use-full-page");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy<bool> PrintOperation::property_track_print_status() 
{
  return Glib::PropertyProxy<bool>(this, "track-print-status");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy_ReadOnly<bool> PrintOperation::property_track_print_status() const
{
  return Glib::PropertyProxy_ReadOnly<bool>(this, "track-print-status");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy<Unit> PrintOperation::property_unit() 
{
  return Glib::PropertyProxy<Unit>(this, "unit");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy_ReadOnly<Unit> PrintOperation::property_unit() const
{
  return Glib::PropertyProxy_ReadOnly<Unit>(this, "unit");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy<bool> PrintOperation::property_show_progress() 
{
  return Glib::PropertyProxy<bool>(this, "show-progress");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy_ReadOnly<bool> PrintOperation::property_show_progress() const
{
  return Glib::PropertyProxy_ReadOnly<bool>(this, "show-progress");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy<bool> PrintOperation::property_allow_async() 
{
  return Glib::PropertyProxy<bool>(this, "allow-async");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy_ReadOnly<bool> PrintOperation::property_allow_async() const
{
  return Glib::PropertyProxy_ReadOnly<bool>(this, "allow-async");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy<std::string> PrintOperation::property_export_filename() 
{
  return Glib::PropertyProxy<std::string>(this, "export-filename");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy_ReadOnly<std::string> PrintOperation::property_export_filename() const
{
  return Glib::PropertyProxy_ReadOnly<std::string>(this, "export-filename");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy_ReadOnly<PrintStatus> PrintOperation::property_status() const
{
  return Glib::PropertyProxy_ReadOnly<PrintStatus>(this, "status");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy_ReadOnly<Glib::ustring> PrintOperation::property_status_string() const
{
  return Glib::PropertyProxy_ReadOnly<Glib::ustring>(this, "status-string");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy<Glib::ustring> PrintOperation::property_custom_tab_label() 
{
  return Glib::PropertyProxy<Glib::ustring>(this, "custom-tab-label");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy_ReadOnly<Glib::ustring> PrintOperation::property_custom_tab_label() const
{
  return Glib::PropertyProxy_ReadOnly<Glib::ustring>(this, "custom-tab-label");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy<bool> PrintOperation::property_support_selection() 
{
  return Glib::PropertyProxy<bool>(this, "support-selection");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy_ReadOnly<bool> PrintOperation::property_support_selection() const
{
  return Glib::PropertyProxy_ReadOnly<bool>(this, "support-selection");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy<bool> PrintOperation::property_has_selection() 
{
  return Glib::PropertyProxy<bool>(this, "has-selection");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy_ReadOnly<bool> PrintOperation::property_has_selection() const
{
  return Glib::PropertyProxy_ReadOnly<bool>(this, "has-selection");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy<bool> PrintOperation::property_embed_page_setup() 
{
  return Glib::PropertyProxy<bool>(this, "embed-page-setup");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy_ReadOnly<bool> PrintOperation::property_embed_page_setup() const
{
  return Glib::PropertyProxy_ReadOnly<bool>(this, "embed-page-setup");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy_ReadOnly<int> PrintOperation::property_n_pages_to_print() const
{
  return Glib::PropertyProxy_ReadOnly<int>(this, "n-pages-to-print");
}
#endif //GLIBMM_PROPERTIES_ENABLED


void Gtk::PrintOperation::on_done(PrintOperationResult result)
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->done)
    (*base->done)(gobj(),((GtkPrintOperationResult)(result)));
}
void Gtk::PrintOperation::on_begin_print(const Glib::RefPtr<PrintContext>& context)
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->begin_print)
    (*base->begin_print)(gobj(),Glib::unwrap(context));
}
bool Gtk::PrintOperation::on_paginate(const Glib::RefPtr<PrintContext>& context)
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->paginate)
    return (*base->paginate)(gobj(),Glib::unwrap(context));

  typedef bool RType;
  return RType();
}
void Gtk::PrintOperation::on_request_page_setup(const Glib::RefPtr<PrintContext>& context, int page_no, const Glib::RefPtr<PageSetup>& setup)
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->request_page_setup)
    (*base->request_page_setup)(gobj(),Glib::unwrap(context),page_no,Glib::unwrap(setup));
}
void Gtk::PrintOperation::on_draw_page(const Glib::RefPtr<PrintContext>& context, int page_nr)
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->draw_page)
    (*base->draw_page)(gobj(),Glib::unwrap(context),page_nr);
}
void Gtk::PrintOperation::on_end_print(const Glib::RefPtr<PrintContext>& context)
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->end_print)
    (*base->end_print)(gobj(),Glib::unwrap(context));
}
void Gtk::PrintOperation::on_status_changed()
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->status_changed)
    (*base->status_changed)(gobj());
}
Widget* Gtk::PrintOperation::on_create_custom_widget()
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->create_custom_widget)
    return Glib::wrap((*base->create_custom_widget)(gobj()));

  typedef Widget* RType;
  return RType();
}
void Gtk::PrintOperation::on_custom_widget_apply(Widget* widget)
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->custom_widget_apply)
    (*base->custom_widget_apply)(gobj(),(GtkWidget*)Glib::unwrap(widget));
}
bool Gtk::PrintOperation::on_preview(const Glib::RefPtr<PrintOperationPreview>& preview, const Glib::RefPtr<PrintContext>& context, Window* parent)
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->preview)
    return (*base->preview)(gobj(),(Glib::unwrap(preview)),Glib::unwrap(context),Glib::unwrap(parent));

  typedef bool RType;
  return RType();
}


} // namespace Gtk


