/*
 *  Notes - panel plugin for Xfce Desktop Environment
 *  Copyright (c) 2009  Mike Massonnet <mmassonnet@xfce.org>
 *
 *  TODO:
 *  - Follow GNOME bug #551184 to change accelerators hexa values
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301, USA
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <gdk/gdk.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>
#include <pango/pango.h>


#define XNP_TYPE_WINDOW (xnp_window_get_type ())
#define XNP_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), XNP_TYPE_WINDOW, XnpWindow))
#define XNP_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), XNP_TYPE_WINDOW, XnpWindowClass))
#define XNP_IS_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), XNP_TYPE_WINDOW))
#define XNP_IS_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), XNP_TYPE_WINDOW))
#define XNP_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), XNP_TYPE_WINDOW, XnpWindowClass))

typedef struct _XnpWindow XnpWindow;
typedef struct _XnpWindowClass XnpWindowClass;
typedef struct _XnpWindowPrivate XnpWindowPrivate;

#define XNP_TYPE_NOTE (xnp_note_get_type ())
#define XNP_NOTE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), XNP_TYPE_NOTE, XnpNote))
#define XNP_NOTE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), XNP_TYPE_NOTE, XnpNoteClass))
#define XNP_IS_NOTE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), XNP_TYPE_NOTE))
#define XNP_IS_NOTE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), XNP_TYPE_NOTE))
#define XNP_NOTE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), XNP_TYPE_NOTE, XnpNoteClass))

typedef struct _XnpNote XnpNote;
typedef struct _XnpNoteClass XnpNoteClass;
typedef struct _XnpNotePrivate XnpNotePrivate;

#define XNP_TYPE_HYPERTEXT_VIEW (xnp_hypertext_view_get_type ())
#define XNP_HYPERTEXT_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), XNP_TYPE_HYPERTEXT_VIEW, XnpHypertextView))
#define XNP_HYPERTEXT_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), XNP_TYPE_HYPERTEXT_VIEW, XnpHypertextViewClass))
#define XNP_IS_HYPERTEXT_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), XNP_TYPE_HYPERTEXT_VIEW))
#define XNP_IS_HYPERTEXT_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), XNP_TYPE_HYPERTEXT_VIEW))
#define XNP_HYPERTEXT_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), XNP_TYPE_HYPERTEXT_VIEW, XnpHypertextViewClass))

typedef struct _XnpHypertextView XnpHypertextView;
typedef struct _XnpHypertextViewClass XnpHypertextViewClass;

struct _XnpWindow {
	GtkWindow parent_instance;
	XnpWindowPrivate * priv;
};

struct _XnpWindowClass {
	GtkWindowClass parent_class;
};

struct _XnpWindowPrivate {
	gint width;
	gint height;
	GtkMenu* menu;
	GtkCheckMenuItem* mi_above;
	GtkCheckMenuItem* mi_sticky;
	GtkLabel* title_label;
	GtkVBox* content_box;
	GtkNotebook* notebook;
	GtkHBox* navigation_box;
	guint navigation_timeout;
	GtkButton* goleft_box;
	GtkButton* goright_box;
	GtkUIManager* ui;
	GtkActionGroup* action_group;
	gint CORNER_MARGIN;
	GdkCursor* CURSOR_TOP_LC;
	GdkCursor* CURSOR_TOP_RC;
	GdkCursor* CURSOR_BOTTOM_RC;
	GdkCursor* CURSOR_BOTTOM;
	GdkCursor* CURSOR_BOTTOM_LC;
	GSList* window_list;
	char* _name;
	gboolean _above;
	gboolean _sticky;
};

struct _XnpNote {
	GtkBin parent_instance;
	XnpNotePrivate * priv;
	GtkScrolledWindow* scrolled_window;
	XnpHypertextView* text_view;
};

struct _XnpNoteClass {
	GtkBinClass parent_class;
};



GType xnp_window_get_type (void);
#define XNP_WINDOW_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), XNP_TYPE_WINDOW, XnpWindowPrivate))
enum  {
	XNP_WINDOW_DUMMY_PROPERTY,
	XNP_WINDOW_NAME,
	XNP_WINDOW_ABOVE,
	XNP_WINDOW_STICKY
};
#define XNP_WINDOW_ui_string "\n<ui>\n  <accelerator action=\"close-window\" />\n  <accelerator action=\"new-window\" />\n  <accelerator action=\"delete-window\" />\n  <accelerator action=\"rename-window\" />\n  <accelerator action=\"new-note\" />\n  <accelerator action=\"delete-note\" />\n  <accelerator action=\"rename-note\" />\n  <accelerator action=\"cancel\" />\n  <accelerator action=\"next-note\" />\n  <accelerator action=\"prev-note\" />\n</ui>\n"
void xnp_window_hide (XnpWindow* self);
static void _xnp_window_hide_gtk_action_callback (GtkAction* action, gpointer self);
static void xnp_window_action_new_window (XnpWindow* self);
static void _xnp_window_action_new_window_gtk_action_callback (GtkAction* action, gpointer self);
static void xnp_window_action_delete_window (XnpWindow* self);
static void _xnp_window_action_delete_window_gtk_action_callback (GtkAction* action, gpointer self);
static void xnp_window_action_rename_window (XnpWindow* self);
static void _xnp_window_action_rename_window_gtk_action_callback (GtkAction* action, gpointer self);
static void xnp_window_action_new_note (XnpWindow* self);
static void _xnp_window_action_new_note_gtk_action_callback (GtkAction* action, gpointer self);
static void xnp_window_action_delete_note (XnpWindow* self);
static void _xnp_window_action_delete_note_gtk_action_callback (GtkAction* action, gpointer self);
static void xnp_window_action_rename_note (XnpWindow* self);
static void _xnp_window_action_rename_note_gtk_action_callback (GtkAction* action, gpointer self);
static void xnp_window_action_cancel (XnpWindow* self);
static void _xnp_window_action_cancel_gtk_action_callback (GtkAction* action, gpointer self);
static void xnp_window_action_next_note (XnpWindow* self);
static void _xnp_window_action_next_note_gtk_action_callback (GtkAction* action, gpointer self);
static void xnp_window_action_prev_note (XnpWindow* self);
static void _xnp_window_action_prev_note_gtk_action_callback (GtkAction* action, gpointer self);
static GtkMenu* xnp_window_build_menu (XnpWindow* self);
static gboolean xnp_window_menu_box_pressed_cb (XnpWindow* self, GtkEventBox* box, const GdkEventButton* event);
static gboolean _xnp_window_menu_box_pressed_cb_gtk_widget_button_press_event (GtkEventBox* _sender, const GdkEventButton* event, gpointer self);
static void _lambda8_ (XnpWindow* self);
static void __lambda8__gtk_button_clicked (GtkButton* _sender, gpointer self);
static void _xnp_window_action_new_note_gtk_button_clicked (GtkButton* _sender, gpointer self);
static void _xnp_window_action_delete_note_gtk_button_clicked (GtkButton* _sender, gpointer self);
static void _xnp_window_action_prev_note_gtk_button_clicked (GtkButton* _sender, gpointer self);
static void _xnp_window_action_next_note_gtk_button_clicked (GtkButton* _sender, gpointer self);
static gboolean _lambda9_ (XnpWindow* self);
static gboolean __lambda9__gtk_widget_delete_event (XnpWindow* _sender, const GdkEvent* event, gpointer self);
static gboolean _lambda10_ (XnpWindow* self);
static gboolean __lambda10__gtk_widget_focus_in_event (XnpWindow* _sender, const GdkEventFocus* event, gpointer self);
static gboolean _lambda11_ (XnpWindow* self);
static gboolean __lambda11__gtk_widget_focus_out_event (XnpWindow* _sender, const GdkEventFocus* event, gpointer self);
static gboolean xnp_window_navigation_leaved_cb (XnpWindow* self);
static gboolean _xnp_window_navigation_leaved_cb_gtk_widget_leave_notify_event (XnpWindow* _sender, const GdkEventCrossing* event, gpointer self);
static gboolean xnp_window_navigation_motion_cb (XnpWindow* self);
static gboolean _xnp_window_navigation_motion_cb_gtk_widget_motion_notify_event (XnpWindow* _sender, const GdkEventMotion* event, gpointer self);
static gboolean xnp_window_window_leaved_cb (XnpWindow* self);
static gboolean _xnp_window_window_leaved_cb_gtk_widget_leave_notify_event (XnpWindow* _sender, const GdkEventCrossing* event, gpointer self);
static gboolean xnp_window_window_motion_cb (XnpWindow* self, GtkWidget* widget, const GdkEventMotion* event);
static gboolean _xnp_window_window_motion_cb_gtk_widget_motion_notify_event (XnpWindow* _sender, const GdkEventMotion* event, gpointer self);
static gboolean xnp_window_window_pressed_cb (XnpWindow* self, GtkWidget* widget, const GdkEventButton* event);
static gboolean _xnp_window_window_pressed_cb_gtk_widget_button_press_event (XnpWindow* _sender, const GdkEventButton* event, gpointer self);
static gboolean xnp_window_window_state_cb (XnpWindow* self, GtkWidget* widget, const GdkEventWindowState* event);
static gboolean _xnp_window_window_state_cb_gtk_widget_window_state_event (XnpWindow* _sender, const GdkEventWindowState* event, gpointer self);
static gboolean xnp_window_title_evbox_pressed_cb (XnpWindow* self, GtkEventBox* box, const GdkEventButton* event);
static gboolean _xnp_window_title_evbox_pressed_cb_gtk_widget_button_press_event (GtkEventBox* _sender, const GdkEventButton* event, gpointer self);
static gboolean xnp_window_title_evbox_scrolled_cb (XnpWindow* self, GtkEventBox* box, const GdkEventScroll* event);
static gboolean _xnp_window_title_evbox_scrolled_cb_gtk_widget_scroll_event (GtkEventBox* _sender, const GdkEventScroll* event, gpointer self);
static void xnp_window_update_navigation_sensitivity (XnpWindow* self, gint page_num);
static void _lambda13_ (GtkNotebook* n, GtkWidget* c, guint p, XnpWindow* self);
static void __lambda13__gtk_notebook_page_added (GtkNotebook* _sender, GtkWidget* p0, guint p1, gpointer self);
static void _lambda14_ (GtkNotebook* n, GtkWidget* c, guint p, XnpWindow* self);
static void __lambda14__gtk_notebook_page_removed (GtkNotebook* _sender, GtkWidget* p0, guint p1, gpointer self);
GType xnp_note_get_type (void);
static void xnp_window_update_title (XnpWindow* self, const char* note_name);
const char* xnp_note_get_name (XnpNote* self);
static void _lambda15_ (GtkNotebook* n, void* c, guint p, XnpWindow* self);
static void __lambda15__gtk_notebook_switch_page (GtkNotebook* _sender, void* page, guint page_num, gpointer self);
static void _lambda16_ (XnpWindow* o, GParamSpec* p, XnpWindow* self);
static void __lambda16__g_object_notify (XnpWindow* _sender, GParamSpec* pspec, gpointer self);
XnpWindow* xnp_window_new (void);
XnpWindow* xnp_window_construct (GType object_type);
XnpWindow* xnp_window_new (void);
static void xnp_window_unshade (XnpWindow* self);
static gboolean _lambda12_ (XnpWindow* self);
static gboolean __lambda12__gsource_func (gpointer self);
static void xnp_window_shade (XnpWindow* self);
static void xnp_window_note_notify (XnpWindow* self, GObject* object, GParamSpec* pspec);
XnpNote* xnp_window_insert_note (XnpWindow* self);
void xnp_window_delete_current_note (XnpWindow* self);
void xnp_window_rename_current_note (XnpWindow* self);
GType xnp_hypertext_view_get_type (void);
void xnp_hypertext_view_undo (XnpHypertextView* self);
static void xnp_window_menu_position (XnpWindow* self, GtkMenu* menu, gint* x, gint* y, gboolean* push_in);
static void _xnp_window_menu_position_gtk_menu_position_func (GtkMenu* menu, gint* x, gint* y, gboolean* push_in, gpointer self);
static void xnp_window_update_menu_go (XnpWindow* self, GtkMenu* menu);
static void _xnp_window_update_menu_go_gtk_widget_show (GtkMenu* _sender, gpointer self);
static void _xnp_window_action_new_note_gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self);
static void _xnp_window_action_delete_note_gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self);
static void _xnp_window_action_rename_note_gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self);
static void _xnp_window_action_cancel_gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self);
static void _lambda5_ (XnpWindow* self);
static void __lambda5__gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self);
gboolean xnp_window_get_above (XnpWindow* self);
void xnp_window_set_above (XnpWindow* self, gboolean value);
static void _lambda6_ (GtkCheckMenuItem* o, XnpWindow* self);
static void __lambda6__gtk_check_menu_item_toggled (GtkCheckMenuItem* _sender, gpointer self);
gboolean xnp_window_get_sticky (XnpWindow* self);
void xnp_window_set_sticky (XnpWindow* self, gboolean value);
static void _lambda7_ (GtkCheckMenuItem* o, XnpWindow* self);
static void __lambda7__gtk_check_menu_item_toggled (GtkCheckMenuItem* _sender, gpointer self);
static void _lambda2_ (GtkWidget* w, XnpWindow* self);
static void __lambda2__gtk_callback (GtkWidget* widget, gpointer self);
const char* xnp_window_get_name (XnpWindow* self);
static void _lambda3_ (GtkMenuItem* i, XnpWindow* self);
static void __lambda3__gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self);
static void _lambda4_ (GtkMenuItem* i, XnpWindow* self);
static void __lambda4__gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self);
static void _xnp_window_action_rename_window_gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self);
static void _xnp_window_action_delete_window_gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self);
static void _xnp_window_action_new_window_gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self);
void xnp_window_get_geometry (XnpWindow* self, gint* winx, gint* winy, gint* width, gint* height);
void xnp_window_set_window_list (XnpWindow* self, GSList* list);
gint xnp_window_compare_func (XnpWindow* self, XnpWindow* win2);
gint xnp_window_get_current_page (XnpWindow* self);
void xnp_window_set_current_page (XnpWindow* self, gint page);
static gboolean xnp_window_note_name_exists (XnpWindow* self, const char* name);
XnpNote* xnp_note_new (const char* name);
XnpNote* xnp_note_construct (GType object_type, const char* name);
static void _xnp_window_note_notify_g_object_notify (XnpNote* _sender, GParamSpec* pspec, gpointer self);
static void _lambda1_ (XnpNote* note, XnpWindow* self);
static void __lambda1__xnp_note_save_data (XnpNote* _sender, gpointer self);
void xnp_window_delete_note (XnpWindow* self, gint page);
void xnp_note_set_name (XnpNote* self, const char* value);
const char* xnp_hypertext_view_get_font (XnpHypertextView* self);
void xnp_hypertext_view_set_font (XnpHypertextView* self, const char* value);
void xnp_window_set_font (XnpWindow* self);
gboolean xnp_note_get_dirty (XnpNote* self);
void xnp_note_set_dirty (XnpNote* self, gboolean value);
void xnp_window_save_notes (XnpWindow* self);
void xnp_window_set_name (XnpWindow* self, const char* value);
static GObject * xnp_window_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static gpointer xnp_window_parent_class = NULL;
static void xnp_window_finalize (GObject* obj);
static void xnp_window_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void xnp_window_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static int _vala_strcmp0 (const char * str1, const char * str2);

static const GtkActionEntry XNP_WINDOW_action_entries[] = {{"close-window", NULL, NULL, "Escape", NULL, (GCallback) _xnp_window_hide_gtk_action_callback}, {"new-window", NULL, NULL, "<Ctrl><Shift>n", NULL, (GCallback) _xnp_window_action_new_window_gtk_action_callback}, {"delete-window", NULL, NULL, "<Ctrl><Shift>w", NULL, (GCallback) _xnp_window_action_delete_window_gtk_action_callback}, {"rename-window", NULL, NULL, "<Shift>F2", NULL, (GCallback) _xnp_window_action_rename_window_gtk_action_callback}, {"new-note", NULL, NULL, "<Ctrl>n", NULL, (GCallback) _xnp_window_action_new_note_gtk_action_callback}, {"delete-note", NULL, NULL, "<Ctrl>w", NULL, (GCallback) _xnp_window_action_delete_note_gtk_action_callback}, {"rename-note", NULL, NULL, "F2", NULL, (GCallback) _xnp_window_action_rename_note_gtk_action_callback}, {"cancel", NULL, NULL, "<Ctrl>z", NULL, (GCallback) _xnp_window_action_cancel_gtk_action_callback}, {"next-note", NULL, NULL, "<Ctrl>Page_Down", NULL, (GCallback) _xnp_window_action_next_note_gtk_action_callback}, {"prev-note", NULL, NULL, "<Ctrl>Page_Up", NULL, (GCallback) _xnp_window_action_prev_note_gtk_action_callback}};

static void g_cclosure_user_marshal_VOID__OBJECT_STRING (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);

static void _xnp_window_hide_gtk_action_callback (GtkAction* action, gpointer self) {
	xnp_window_hide (self);
}


static void _xnp_window_action_new_window_gtk_action_callback (GtkAction* action, gpointer self) {
	xnp_window_action_new_window (self);
}


static void _xnp_window_action_delete_window_gtk_action_callback (GtkAction* action, gpointer self) {
	xnp_window_action_delete_window (self);
}


static void _xnp_window_action_rename_window_gtk_action_callback (GtkAction* action, gpointer self) {
	xnp_window_action_rename_window (self);
}


static void _xnp_window_action_new_note_gtk_action_callback (GtkAction* action, gpointer self) {
	xnp_window_action_new_note (self);
}


static void _xnp_window_action_delete_note_gtk_action_callback (GtkAction* action, gpointer self) {
	xnp_window_action_delete_note (self);
}


static void _xnp_window_action_rename_note_gtk_action_callback (GtkAction* action, gpointer self) {
	xnp_window_action_rename_note (self);
}


static void _xnp_window_action_cancel_gtk_action_callback (GtkAction* action, gpointer self) {
	xnp_window_action_cancel (self);
}


static void _xnp_window_action_next_note_gtk_action_callback (GtkAction* action, gpointer self) {
	xnp_window_action_next_note (self);
}


static void _xnp_window_action_prev_note_gtk_action_callback (GtkAction* action, gpointer self) {
	xnp_window_action_prev_note (self);
}


static gboolean _xnp_window_menu_box_pressed_cb_gtk_widget_button_press_event (GtkEventBox* _sender, const GdkEventButton* event, gpointer self) {
	return xnp_window_menu_box_pressed_cb (self, _sender, event);
}


static void _lambda8_ (XnpWindow* self) {
	xnp_window_hide (self);
}


static void __lambda8__gtk_button_clicked (GtkButton* _sender, gpointer self) {
	_lambda8_ (self);
}


static void _xnp_window_action_new_note_gtk_button_clicked (GtkButton* _sender, gpointer self) {
	xnp_window_action_new_note (self);
}


static void _xnp_window_action_delete_note_gtk_button_clicked (GtkButton* _sender, gpointer self) {
	xnp_window_action_delete_note (self);
}


static void _xnp_window_action_prev_note_gtk_button_clicked (GtkButton* _sender, gpointer self) {
	xnp_window_action_prev_note (self);
}


static void _xnp_window_action_next_note_gtk_button_clicked (GtkButton* _sender, gpointer self) {
	xnp_window_action_next_note (self);
}


static gboolean _lambda9_ (XnpWindow* self) {
	/* Replace ALT+F4 action */
	xnp_window_hide (self);
	return TRUE;
}


static gboolean __lambda9__gtk_widget_delete_event (XnpWindow* _sender, const GdkEvent* event, gpointer self) {
	return _lambda9_ (self);
}


static gboolean _lambda10_ (XnpWindow* self) {
	g_object_set ((GtkWidget*) self->priv->title_label, "sensitive", TRUE, NULL);
	return FALSE;
}


static gboolean __lambda10__gtk_widget_focus_in_event (XnpWindow* _sender, const GdkEventFocus* event, gpointer self) {
	return _lambda10_ (self);
}


static gboolean _lambda11_ (XnpWindow* self) {
	g_object_set ((GtkWidget*) self->priv->title_label, "sensitive", FALSE, NULL);
	return FALSE;
}


static gboolean __lambda11__gtk_widget_focus_out_event (XnpWindow* _sender, const GdkEventFocus* event, gpointer self) {
	return _lambda11_ (self);
}


static gboolean _xnp_window_navigation_leaved_cb_gtk_widget_leave_notify_event (XnpWindow* _sender, const GdkEventCrossing* event, gpointer self) {
	return xnp_window_navigation_leaved_cb (self);
}


static gboolean _xnp_window_navigation_motion_cb_gtk_widget_motion_notify_event (XnpWindow* _sender, const GdkEventMotion* event, gpointer self) {
	return xnp_window_navigation_motion_cb (self);
}


static gboolean _xnp_window_window_leaved_cb_gtk_widget_leave_notify_event (XnpWindow* _sender, const GdkEventCrossing* event, gpointer self) {
	return xnp_window_window_leaved_cb (self);
}


static gboolean _xnp_window_window_motion_cb_gtk_widget_motion_notify_event (XnpWindow* _sender, const GdkEventMotion* event, gpointer self) {
	return xnp_window_window_motion_cb (self, _sender, event);
}


static gboolean _xnp_window_window_pressed_cb_gtk_widget_button_press_event (XnpWindow* _sender, const GdkEventButton* event, gpointer self) {
	return xnp_window_window_pressed_cb (self, _sender, event);
}


static gboolean _xnp_window_window_state_cb_gtk_widget_window_state_event (XnpWindow* _sender, const GdkEventWindowState* event, gpointer self) {
	return xnp_window_window_state_cb (self, _sender, event);
}


static gboolean _xnp_window_title_evbox_pressed_cb_gtk_widget_button_press_event (GtkEventBox* _sender, const GdkEventButton* event, gpointer self) {
	return xnp_window_title_evbox_pressed_cb (self, _sender, event);
}


static gboolean _xnp_window_title_evbox_scrolled_cb_gtk_widget_scroll_event (GtkEventBox* _sender, const GdkEventScroll* event, gpointer self) {
	return xnp_window_title_evbox_scrolled_cb (self, _sender, event);
}


static void _lambda13_ (GtkNotebook* n, GtkWidget* c, guint p, XnpWindow* self) {
	g_return_if_fail (n != NULL);
	g_return_if_fail (c != NULL);
	gtk_notebook_set_current_page (self->priv->notebook, (gint) p);
	xnp_window_update_navigation_sensitivity (self, (gint) p);
}


static void __lambda13__gtk_notebook_page_added (GtkNotebook* _sender, GtkWidget* p0, guint p1, gpointer self) {
	_lambda13_ (_sender, p0, p1, self);
}


static void _lambda14_ (GtkNotebook* n, GtkWidget* c, guint p, XnpWindow* self) {
	g_return_if_fail (n != NULL);
	g_return_if_fail (c != NULL);
	xnp_window_update_navigation_sensitivity (self, (gint) p);
}


static void __lambda14__gtk_notebook_page_removed (GtkNotebook* _sender, GtkWidget* p0, guint p1, gpointer self) {
	_lambda14_ (_sender, p0, p1, self);
}


static void _lambda15_ (GtkNotebook* n, void* c, guint p, XnpWindow* self) {
	XnpNote* _tmp0_;
	XnpNote* note;
	g_return_if_fail (n != NULL);
	_tmp0_ = NULL;
	note = (_tmp0_ = XNP_NOTE (gtk_notebook_get_nth_page (self->priv->notebook, (gint) p)), (_tmp0_ == NULL) ? NULL : g_object_ref (_tmp0_));
	xnp_window_update_title (self, xnp_note_get_name (note));
	xnp_window_update_navigation_sensitivity (self, (gint) p);
	(note == NULL) ? NULL : (note = (g_object_unref (note), NULL));
}


static void __lambda15__gtk_notebook_switch_page (GtkNotebook* _sender, void* page, guint page_num, gpointer self) {
	_lambda15_ (_sender, page, page_num, self);
}


static void _lambda16_ (XnpWindow* o, GParamSpec* p, XnpWindow* self) {
	g_return_if_fail (o != NULL);
	g_return_if_fail (p != NULL);
	if (_vala_strcmp0 (p->name, "name") == 0) {
		gint page;
		XnpNote* _tmp0_;
		XnpNote* current_note;
		page = gtk_notebook_get_current_page (self->priv->notebook);
		if (page == (-1)) {
			return;
		}
		_tmp0_ = NULL;
		current_note = (_tmp0_ = XNP_NOTE (gtk_notebook_get_nth_page (self->priv->notebook, page)), (_tmp0_ == NULL) ? NULL : g_object_ref (_tmp0_));
		xnp_window_update_title (self, xnp_note_get_name (current_note));
		(current_note == NULL) ? NULL : (current_note = (g_object_unref (current_note), NULL));
	} else {
		if (_vala_strcmp0 (p->name, "title") == 0) {
			char* _tmp2_;
			char* _tmp1_;
			_tmp2_ = NULL;
			_tmp1_ = NULL;
			gtk_label_set_markup (self->priv->title_label, _tmp2_ = g_strconcat (_tmp1_ = g_strconcat ("<b>", gtk_window_get_title ((GtkWindow*) self), NULL), "</b>", NULL));
			_tmp2_ = (g_free (_tmp2_), NULL);
			_tmp1_ = (g_free (_tmp1_), NULL);
		}
	}
}


static void __lambda16__g_object_notify (XnpWindow* _sender, GParamSpec* pspec, gpointer self) {
	_lambda16_ (_sender, pspec, self);
}


XnpWindow* xnp_window_construct (GType object_type) {
	GError * _inner_error_;
	XnpWindow * self;
	GtkActionGroup* _tmp0_;
	GtkUIManager* _tmp1_;
	GtkMenu* _tmp2_;
	GtkFrame* frame;
	GtkRcStyle* _tmp3_;
	GtkRcStyle* style;
	GtkVBox* vbox_frame;
	GtkHBox* title_box;
	GtkEventBox* menu_box;
	GtkImage* menu_image;
	GtkEventBox* title_evbox;
	GtkLabel* _tmp4_;
	char* _tmp6_;
	char* _tmp5_;
	GtkButton* close_box;
	GtkLabel* close_label;
	GtkVBox* _tmp7_;
	GtkNotebook* _tmp8_;
	GtkHBox* _tmp9_;
	GtkButton* _tmp10_;
	GtkLabel* goleft_label;
	GtkButton* add_box;
	GtkLabel* add_label;
	GtkButton* del_box;
	GtkLabel* del_label;
	GtkButton* _tmp11_;
	GtkLabel* goright_label;
	_inner_error_ = NULL;
	self = g_object_newv (object_type, 0, NULL);
	gtk_widget_add_events ((GtkWidget*) self, (gint) ((GDK_POINTER_MOTION_MASK | GDK_POINTER_MOTION_HINT_MASK) | GDK_BUTTON_PRESS_MASK));
	_tmp0_ = NULL;
	self->priv->action_group = (_tmp0_ = gtk_action_group_new ("XNP"), (self->priv->action_group == NULL) ? NULL : (self->priv->action_group = (g_object_unref (self->priv->action_group), NULL)), _tmp0_);
	gtk_action_group_add_actions (self->priv->action_group, XNP_WINDOW_action_entries, G_N_ELEMENTS (XNP_WINDOW_action_entries), self);
	_tmp1_ = NULL;
	self->priv->ui = (_tmp1_ = gtk_ui_manager_new (), (self->priv->ui == NULL) ? NULL : (self->priv->ui = (g_object_unref (self->priv->ui), NULL)), _tmp1_);
	gtk_ui_manager_insert_action_group (self->priv->ui, self->priv->action_group, 0);
	{
		gtk_ui_manager_add_ui_from_string (self->priv->ui, XNP_WINDOW_ui_string, (gssize) (-1), &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch3_g_error;
			goto __finally3;
		}
		gtk_window_add_accel_group ((GtkWindow*) self, gtk_ui_manager_get_accel_group (self->priv->ui));
	}
	goto __finally3;
	__catch3_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
			g_warning ("window.vala:143: %s", e->message);
			(e == NULL) ? NULL : (e = (g_error_free (e), NULL));
		}
	}
	__finally3:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	_tmp2_ = NULL;
	self->priv->menu = (_tmp2_ = xnp_window_build_menu (self), (self->priv->menu == NULL) ? NULL : (self->priv->menu = (g_object_unref (self->priv->menu), NULL)), _tmp2_);
	gtk_widget_show_all ((GtkWidget*) self->priv->menu);
	frame = g_object_ref_sink ((GtkFrame*) gtk_frame_new (NULL));
	gtk_frame_set_shadow_type (frame, GTK_SHADOW_NONE);
	_tmp3_ = NULL;
	style = (_tmp3_ = gtk_widget_get_modifier_style ((GtkWidget*) frame), (_tmp3_ == NULL) ? NULL : g_object_ref (_tmp3_));
	style->xthickness = 1;
	style->ythickness = 3;
	gtk_widget_modify_style ((GtkWidget*) frame, style);
	gtk_widget_show ((GtkWidget*) frame);
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) frame);
	vbox_frame = g_object_ref_sink ((GtkVBox*) gtk_vbox_new (FALSE, 0));
	gtk_box_set_spacing ((GtkBox*) vbox_frame, 1);
	gtk_widget_show ((GtkWidget*) vbox_frame);
	gtk_container_add ((GtkContainer*) frame, (GtkWidget*) vbox_frame);
	title_box = g_object_ref_sink ((GtkHBox*) gtk_hbox_new (FALSE, 0));
	menu_box = g_object_ref_sink ((GtkEventBox*) gtk_event_box_new ());
	menu_image = g_object_ref_sink ((GtkImage*) gtk_image_new_from_icon_name ("xfce4-notes-plugin", GTK_ICON_SIZE_MENU));
	gtk_container_add ((GtkContainer*) menu_box, (GtkWidget*) menu_image);
	gtk_box_pack_start ((GtkBox*) title_box, (GtkWidget*) menu_box, FALSE, FALSE, (guint) 4);
	title_evbox = g_object_ref_sink ((GtkEventBox*) gtk_event_box_new ());
	_tmp4_ = NULL;
	self->priv->title_label = (_tmp4_ = g_object_ref_sink ((GtkLabel*) gtk_label_new (NULL)), (self->priv->title_label == NULL) ? NULL : (self->priv->title_label = (g_object_unref (self->priv->title_label), NULL)), _tmp4_);
	_tmp6_ = NULL;
	_tmp5_ = NULL;
	gtk_label_set_markup (self->priv->title_label, _tmp6_ = g_strconcat (_tmp5_ = g_strconcat ("<b>", gtk_window_get_title ((GtkWindow*) self), NULL), "</b>", NULL));
	_tmp6_ = (g_free (_tmp6_), NULL);
	_tmp5_ = (g_free (_tmp5_), NULL);
	gtk_label_set_ellipsize (self->priv->title_label, PANGO_ELLIPSIZE_END);
	gtk_container_add ((GtkContainer*) title_evbox, (GtkWidget*) self->priv->title_label);
	gtk_box_pack_start ((GtkBox*) title_box, (GtkWidget*) title_evbox, TRUE, TRUE, (guint) 0);
	close_box = g_object_ref_sink ((GtkButton*) gtk_button_new ());
	gtk_widget_set_tooltip_text ((GtkWidget*) close_box, gtk_accelerator_get_label ((guint) 0xff1b, 0));
	gtk_button_set_relief (close_box, GTK_RELIEF_NONE);
	g_object_set ((GtkWidget*) close_box, "can-focus", FALSE, NULL);
	close_label = g_object_ref_sink ((GtkLabel*) gtk_label_new ("<b>x</b>"));
	gtk_label_set_use_markup (close_label, TRUE);
	gtk_container_add ((GtkContainer*) close_box, (GtkWidget*) close_label);
	gtk_box_pack_start ((GtkBox*) title_box, (GtkWidget*) close_box, FALSE, FALSE, (guint) 4);
	gtk_widget_show_all ((GtkWidget*) title_box);
	gtk_box_pack_start ((GtkBox*) vbox_frame, (GtkWidget*) title_box, FALSE, FALSE, (guint) 0);
	if (((GtkWidget*) close_box)->allocation.width < 22) {
		gtk_widget_set_size_request ((GtkWidget*) close_box, 22, -1);
	}
	_tmp7_ = NULL;
	self->priv->content_box = (_tmp7_ = g_object_ref_sink ((GtkVBox*) gtk_vbox_new (FALSE, 0)), (self->priv->content_box == NULL) ? NULL : (self->priv->content_box = (g_object_unref (self->priv->content_box), NULL)), _tmp7_);
	gtk_widget_show ((GtkWidget*) self->priv->content_box);
	gtk_box_pack_start ((GtkBox*) vbox_frame, (GtkWidget*) self->priv->content_box, TRUE, TRUE, (guint) 0);
	_tmp8_ = NULL;
	self->priv->notebook = (_tmp8_ = g_object_ref_sink ((GtkNotebook*) gtk_notebook_new ()), (self->priv->notebook == NULL) ? NULL : (self->priv->notebook = (g_object_unref (self->priv->notebook), NULL)), _tmp8_);
	gtk_notebook_set_show_border (self->priv->notebook, FALSE);
	gtk_notebook_set_show_tabs (self->priv->notebook, FALSE);
	gtk_widget_show ((GtkWidget*) self->priv->notebook);
	gtk_box_pack_start ((GtkBox*) self->priv->content_box, (GtkWidget*) self->priv->notebook, TRUE, TRUE, (guint) 0);
	_tmp9_ = NULL;
	self->priv->navigation_box = (_tmp9_ = g_object_ref_sink ((GtkHBox*) gtk_hbox_new (FALSE, 2)), (self->priv->navigation_box == NULL) ? NULL : (self->priv->navigation_box = (g_object_unref (self->priv->navigation_box), NULL)), _tmp9_);
	_tmp10_ = NULL;
	self->priv->goleft_box = (_tmp10_ = g_object_ref_sink ((GtkButton*) gtk_button_new ()), (self->priv->goleft_box == NULL) ? NULL : (self->priv->goleft_box = (g_object_unref (self->priv->goleft_box), NULL)), _tmp10_);
	gtk_widget_set_tooltip_text ((GtkWidget*) self->priv->goleft_box, gtk_accelerator_get_label ((guint) 0xff55, GDK_CONTROL_MASK));
	gtk_button_set_relief (self->priv->goleft_box, GTK_RELIEF_NONE);
	g_object_set ((GtkWidget*) self->priv->goleft_box, "can-focus", FALSE, NULL);
	g_object_set ((GtkWidget*) self->priv->goleft_box, "sensitive", FALSE, NULL);
	goleft_label = g_object_ref_sink ((GtkLabel*) gtk_label_new ("<b>&lt;</b>"));
	gtk_label_set_use_markup (goleft_label, TRUE);
	gtk_container_add ((GtkContainer*) self->priv->goleft_box, (GtkWidget*) goleft_label);
	gtk_box_pack_start ((GtkBox*) self->priv->navigation_box, (GtkWidget*) self->priv->goleft_box, TRUE, FALSE, (guint) 0);
	if (((GtkWidget*) self->priv->goleft_box)->allocation.width < 22) {
		gtk_widget_set_size_request ((GtkWidget*) self->priv->goleft_box, 22, -1);
	}
	add_box = g_object_ref_sink ((GtkButton*) gtk_button_new ());
	gtk_widget_set_tooltip_text ((GtkWidget*) add_box, gtk_accelerator_get_label ((guint) 'N', GDK_CONTROL_MASK));
	gtk_button_set_relief (add_box, GTK_RELIEF_NONE);
	g_object_set ((GtkWidget*) add_box, "can-focus", FALSE, NULL);
	add_label = g_object_ref_sink ((GtkLabel*) gtk_label_new ("<b>+</b>"));
	gtk_label_set_use_markup (add_label, TRUE);
	gtk_container_add ((GtkContainer*) add_box, (GtkWidget*) add_label);
	gtk_box_pack_start ((GtkBox*) self->priv->navigation_box, (GtkWidget*) add_box, TRUE, FALSE, (guint) 0);
	if (((GtkWidget*) add_box)->allocation.width < 22) {
		gtk_widget_set_size_request ((GtkWidget*) add_box, 22, -1);
	}
	del_box = g_object_ref_sink ((GtkButton*) gtk_button_new ());
	gtk_widget_set_tooltip_text ((GtkWidget*) del_box, gtk_accelerator_get_label ((guint) 'W', GDK_CONTROL_MASK));
	gtk_button_set_relief (del_box, GTK_RELIEF_NONE);
	g_object_set ((GtkWidget*) del_box, "can-focus", FALSE, NULL);
	del_label = g_object_ref_sink ((GtkLabel*) gtk_label_new ("<b>−</b>"));
	gtk_label_set_use_markup (del_label, TRUE);
	gtk_container_add ((GtkContainer*) del_box, (GtkWidget*) del_label);
	gtk_box_pack_start ((GtkBox*) self->priv->navigation_box, (GtkWidget*) del_box, TRUE, FALSE, (guint) 0);
	if (((GtkWidget*) del_box)->allocation.width < 22) {
		gtk_widget_set_size_request ((GtkWidget*) del_box, 22, -1);
	}
	_tmp11_ = NULL;
	self->priv->goright_box = (_tmp11_ = g_object_ref_sink ((GtkButton*) gtk_button_new ()), (self->priv->goright_box == NULL) ? NULL : (self->priv->goright_box = (g_object_unref (self->priv->goright_box), NULL)), _tmp11_);
	gtk_widget_set_tooltip_text ((GtkWidget*) self->priv->goright_box, gtk_accelerator_get_label ((guint) 0xff56, GDK_CONTROL_MASK));
	gtk_button_set_relief (self->priv->goright_box, GTK_RELIEF_NONE);
	g_object_set ((GtkWidget*) self->priv->goright_box, "can-focus", FALSE, NULL);
	g_object_set ((GtkWidget*) self->priv->goright_box, "sensitive", FALSE, NULL);
	goright_label = g_object_ref_sink ((GtkLabel*) gtk_label_new ("<b>&gt;</b>"));
	gtk_label_set_use_markup (goright_label, TRUE);
	gtk_container_add ((GtkContainer*) self->priv->goright_box, (GtkWidget*) goright_label);
	gtk_box_pack_start ((GtkBox*) self->priv->navigation_box, (GtkWidget*) self->priv->goright_box, TRUE, FALSE, (guint) 0);
	if (((GtkWidget*) self->priv->goright_box)->allocation.width < 22) {
		gtk_widget_set_size_request ((GtkWidget*) self->priv->goright_box, 22, -1);
	}
	gtk_widget_show_all ((GtkWidget*) self->priv->navigation_box);
	gtk_widget_hide ((GtkWidget*) self->priv->navigation_box);
	gtk_box_pack_start ((GtkBox*) self->priv->content_box, (GtkWidget*) self->priv->navigation_box, FALSE, FALSE, (guint) 1);
	g_signal_connect_object ((GtkWidget*) menu_box, "button-press-event", (GCallback) _xnp_window_menu_box_pressed_cb_gtk_widget_button_press_event, self, 0);
	g_signal_connect (close_box, "clicked", (GCallback) __lambda8__gtk_button_clicked, self);
	g_signal_connect_object (add_box, "clicked", (GCallback) _xnp_window_action_new_note_gtk_button_clicked, self, 0);
	g_signal_connect_object (del_box, "clicked", (GCallback) _xnp_window_action_delete_note_gtk_button_clicked, self, 0);
	g_signal_connect_object (self->priv->goleft_box, "clicked", (GCallback) _xnp_window_action_prev_note_gtk_button_clicked, self, 0);
	g_signal_connect_object (self->priv->goright_box, "clicked", (GCallback) _xnp_window_action_next_note_gtk_button_clicked, self, 0);
	g_signal_connect ((GtkWidget*) self, "delete-event", (GCallback) __lambda9__gtk_widget_delete_event, self);
	g_signal_connect ((GtkWidget*) self, "focus-in-event", (GCallback) __lambda10__gtk_widget_focus_in_event, self);
	g_signal_connect ((GtkWidget*) self, "focus-out-event", (GCallback) __lambda11__gtk_widget_focus_out_event, self);
	g_signal_connect_object ((GtkWidget*) self, "leave-notify-event", (GCallback) _xnp_window_navigation_leaved_cb_gtk_widget_leave_notify_event, self, 0);
	g_signal_connect_object ((GtkWidget*) self, "motion-notify-event", (GCallback) _xnp_window_navigation_motion_cb_gtk_widget_motion_notify_event, self, 0);
	g_signal_connect_object ((GtkWidget*) self, "leave-notify-event", (GCallback) _xnp_window_window_leaved_cb_gtk_widget_leave_notify_event, self, 0);
	g_signal_connect_object ((GtkWidget*) self, "motion-notify-event", (GCallback) _xnp_window_window_motion_cb_gtk_widget_motion_notify_event, self, 0);
	g_signal_connect_object ((GtkWidget*) self, "button-press-event", (GCallback) _xnp_window_window_pressed_cb_gtk_widget_button_press_event, self, 0);
	g_signal_connect_object ((GtkWidget*) self, "window-state-event", (GCallback) _xnp_window_window_state_cb_gtk_widget_window_state_event, self, 0);
	g_signal_connect_object ((GtkWidget*) title_evbox, "button-press-event", (GCallback) _xnp_window_title_evbox_pressed_cb_gtk_widget_button_press_event, self, 0);
	g_signal_connect_object ((GtkWidget*) title_evbox, "scroll-event", (GCallback) _xnp_window_title_evbox_scrolled_cb_gtk_widget_scroll_event, self, 0);
	g_signal_connect (self->priv->notebook, "page-added", (GCallback) __lambda13__gtk_notebook_page_added, self);
	g_signal_connect (self->priv->notebook, "page-removed", (GCallback) __lambda14__gtk_notebook_page_removed, self);
	g_signal_connect (self->priv->notebook, "switch-page", (GCallback) __lambda15__gtk_notebook_switch_page, self);
	g_signal_connect ((GObject*) self, "notify", (GCallback) __lambda16__g_object_notify, self);
	(frame == NULL) ? NULL : (frame = (g_object_unref (frame), NULL));
	(style == NULL) ? NULL : (style = (g_object_unref (style), NULL));
	(vbox_frame == NULL) ? NULL : (vbox_frame = (g_object_unref (vbox_frame), NULL));
	(title_box == NULL) ? NULL : (title_box = (g_object_unref (title_box), NULL));
	(menu_box == NULL) ? NULL : (menu_box = (g_object_unref (menu_box), NULL));
	(menu_image == NULL) ? NULL : (menu_image = (g_object_unref (menu_image), NULL));
	(title_evbox == NULL) ? NULL : (title_evbox = (g_object_unref (title_evbox), NULL));
	(close_box == NULL) ? NULL : (close_box = (g_object_unref (close_box), NULL));
	(close_label == NULL) ? NULL : (close_label = (g_object_unref (close_label), NULL));
	(goleft_label == NULL) ? NULL : (goleft_label = (g_object_unref (goleft_label), NULL));
	(add_box == NULL) ? NULL : (add_box = (g_object_unref (add_box), NULL));
	(add_label == NULL) ? NULL : (add_label = (g_object_unref (add_label), NULL));
	(del_box == NULL) ? NULL : (del_box = (g_object_unref (del_box), NULL));
	(del_label == NULL) ? NULL : (del_label = (g_object_unref (del_label), NULL));
	(goright_label == NULL) ? NULL : (goright_label = (g_object_unref (goright_label), NULL));
	return self;
}


XnpWindow* xnp_window_new (void) {
	return xnp_window_construct (XNP_TYPE_WINDOW);
}


/*
 * Signal callbacks
 
*
 * hide:
 *
 * Save position before hidding.
 */
void xnp_window_hide (XnpWindow* self) {
	gint winx;
	gint winy;
	g_return_if_fail (self != NULL);
	winx = 0;
	winy = 0;
	gtk_window_get_position ((GtkWindow*) self, &winx, &winy);
	GTK_WIDGET_CLASS (xnp_window_parent_class)->hide ((GtkWidget*) GTK_WINDOW (self));
	gtk_window_deiconify ((GtkWindow*) self);
	xnp_window_unshade (self);
	gtk_window_move ((GtkWindow*) self, winx, winy);
}


static gboolean _lambda12_ (XnpWindow* self) {
	gtk_widget_hide ((GtkWidget*) self->priv->navigation_box);
	self->priv->navigation_timeout = (guint) 0;
	return FALSE;
}


static gboolean __lambda12__gsource_func (gpointer self) {
	return _lambda12_ (self);
}


/**
 * navigation_leaved_cb:
 *
 * Hide the navigation when the mouse pointer is leaving the window.
 */
static gboolean xnp_window_navigation_leaved_cb (XnpWindow* self) {
	gint timeout;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	timeout = 2;
	if ((g_object_get ((GtkWindow*) self, "is-active", &_tmp0_, NULL), _tmp0_)) {
		gint x;
		gint y;
		gboolean _tmp1_;
		gboolean _tmp2_;
		gboolean _tmp3_;
		x = 0;
		y = 0;
		gtk_widget_get_pointer ((GtkWidget*) self, &x, &y);
		_tmp1_ = FALSE;
		_tmp2_ = FALSE;
		_tmp3_ = FALSE;
		if (x >= 0) {
			_tmp3_ = x < ((GtkWidget*) self)->allocation.width;
		} else {
			_tmp3_ = FALSE;
		}
		if (_tmp3_) {
			_tmp2_ = y >= 0;
		} else {
			_tmp2_ = FALSE;
		}
		if (_tmp2_) {
			_tmp1_ = y < ((GtkWidget*) self)->allocation.height;
		} else {
			_tmp1_ = FALSE;
		}
		if (_tmp1_) {
			timeout = 10;
		}
	}
	self->priv->navigation_timeout = g_timeout_add_seconds ((guint) timeout, __lambda12__gsource_func, self);
	return FALSE;
}


/**
 * navigation_motion_cb:
 *
 * Show the navigation when the mouse pointer is hovering the window.
 */
static gboolean xnp_window_navigation_motion_cb (XnpWindow* self) {
	g_return_val_if_fail (self != NULL, FALSE);
	if (self->priv->navigation_timeout != 0) {
		g_source_remove (self->priv->navigation_timeout);
		self->priv->navigation_timeout = (guint) 0;
	}
	gtk_widget_show ((GtkWidget*) self->priv->navigation_box);
	return FALSE;
}


/**
 * window_leaved_cb:
 *
 * Reset the mouse cursor.
 */
static gboolean xnp_window_window_leaved_cb (XnpWindow* self) {
	g_return_val_if_fail (self != NULL, FALSE);
	gdk_window_set_cursor (gtk_widget_get_window ((GtkWidget*) self), NULL);
	return TRUE;
}


/**
 * window_motion_cb:
 *
 * Update mouse cursor.
 */
static gboolean xnp_window_window_motion_cb (XnpWindow* self, GtkWidget* widget, const GdkEventMotion* event) {
	gboolean _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp4_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (widget != NULL, FALSE);
	_tmp0_ = FALSE;
	_tmp1_ = FALSE;
	_tmp2_ = FALSE;
	if ((*event).x > 4) {
		_tmp2_ = (*event).y > 4;
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		_tmp1_ = (*event).x < (((GtkWidget*) self)->allocation.width - 4);
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		_tmp0_ = (*event).y < (((GtkWidget*) self)->allocation.height - 4);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gdk_window_set_cursor (gtk_widget_get_window ((GtkWidget*) self), NULL);
		return FALSE;
	}
	_tmp4_ = FALSE;
	if ((*event).x <= 4) {
		_tmp4_ = (*event).y <= self->priv->CORNER_MARGIN;
	} else {
		_tmp4_ = FALSE;
	}
	/* Top left corner*/
	if (_tmp4_) {
		gdk_window_set_cursor (gtk_widget_get_window ((GtkWidget*) self), self->priv->CURSOR_TOP_LC);
	} else {
		gboolean _tmp5_;
		_tmp5_ = FALSE;
		if ((*event).x >= (((GtkWidget*) self)->allocation.width - 4)) {
			_tmp5_ = (*event).y <= self->priv->CORNER_MARGIN;
		} else {
			_tmp5_ = FALSE;
		}
		if (_tmp5_) {
			gdk_window_set_cursor (gtk_widget_get_window ((GtkWidget*) self), self->priv->CURSOR_TOP_RC);
		} else {
			gboolean _tmp6_;
			_tmp6_ = FALSE;
			if ((*event).x >= (((GtkWidget*) self)->allocation.width - self->priv->CORNER_MARGIN)) {
				_tmp6_ = (*event).y >= (((GtkWidget*) self)->allocation.height - self->priv->CORNER_MARGIN);
			} else {
				_tmp6_ = FALSE;
			}
			if (_tmp6_) {
				gdk_window_set_cursor (gtk_widget_get_window ((GtkWidget*) self), self->priv->CURSOR_BOTTOM_RC);
			} else {
				gboolean _tmp7_;
				gboolean _tmp8_;
				_tmp7_ = FALSE;
				_tmp8_ = FALSE;
				if ((*event).x > self->priv->CORNER_MARGIN) {
					_tmp8_ = (*event).y > (((GtkWidget*) self)->allocation.height - self->priv->CORNER_MARGIN);
				} else {
					_tmp8_ = FALSE;
				}
				if (_tmp8_) {
					_tmp7_ = (*event).x < (((GtkWidget*) self)->allocation.width - self->priv->CORNER_MARGIN);
				} else {
					_tmp7_ = FALSE;
				}
				if (_tmp7_) {
					gdk_window_set_cursor (gtk_widget_get_window ((GtkWidget*) self), self->priv->CURSOR_BOTTOM);
				} else {
					gboolean _tmp9_;
					_tmp9_ = FALSE;
					if ((*event).x <= self->priv->CORNER_MARGIN) {
						_tmp9_ = (*event).y >= (((GtkWidget*) self)->allocation.height - self->priv->CORNER_MARGIN);
					} else {
						_tmp9_ = FALSE;
					}
					if (_tmp9_) {
						gdk_window_set_cursor (gtk_widget_get_window ((GtkWidget*) self), self->priv->CURSOR_BOTTOM_LC);
					} else {
						gdk_window_set_cursor (gtk_widget_get_window ((GtkWidget*) self), NULL);
					}
				}
			}
		}
	}
	return TRUE;
}


/**
 * window_pressed_cb:
 *
 * Start a window resize depending on mouse pointer location.
 */
static gboolean xnp_window_window_pressed_cb (XnpWindow* self, GtkWidget* widget, const GdkEventButton* event) {
	GdkWindowEdge edge;
	gboolean _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp4_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (widget != NULL, FALSE);
	edge = 0;
	_tmp0_ = FALSE;
	_tmp1_ = FALSE;
	_tmp2_ = FALSE;
	if ((*event).x > 4) {
		_tmp2_ = (*event).y > 4;
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		_tmp1_ = (*event).x < (((GtkWidget*) self)->allocation.width - 4);
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		_tmp0_ = (*event).y < (((GtkWidget*) self)->allocation.height - 4);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		return FALSE;
	}
	_tmp4_ = FALSE;
	if ((*event).x <= 4) {
		_tmp4_ = (*event).y <= self->priv->CORNER_MARGIN;
	} else {
		_tmp4_ = FALSE;
	}
	/* Top left corner*/
	if (_tmp4_) {
		edge = GDK_WINDOW_EDGE_NORTH_WEST;
	} else {
		gboolean _tmp5_;
		_tmp5_ = FALSE;
		if ((*event).x >= (((GtkWidget*) self)->allocation.width - 4)) {
			_tmp5_ = (*event).y <= self->priv->CORNER_MARGIN;
		} else {
			_tmp5_ = FALSE;
		}
		if (_tmp5_) {
			edge = GDK_WINDOW_EDGE_NORTH_EAST;
		} else {
			gboolean _tmp6_;
			gboolean _tmp7_;
			_tmp6_ = FALSE;
			_tmp7_ = FALSE;
			if ((*event).y > self->priv->CORNER_MARGIN) {
				_tmp7_ = (*event).x > (((GtkWidget*) self)->allocation.width - self->priv->CORNER_MARGIN);
			} else {
				_tmp7_ = FALSE;
			}
			if (_tmp7_) {
				_tmp6_ = (*event).y < (((GtkWidget*) self)->allocation.height - self->priv->CORNER_MARGIN);
			} else {
				_tmp6_ = FALSE;
			}
			if (_tmp6_) {
				edge = GDK_WINDOW_EDGE_EAST;
			} else {
				gboolean _tmp8_;
				_tmp8_ = FALSE;
				if ((*event).x >= (((GtkWidget*) self)->allocation.width - self->priv->CORNER_MARGIN)) {
					_tmp8_ = (*event).y >= (((GtkWidget*) self)->allocation.height - self->priv->CORNER_MARGIN);
				} else {
					_tmp8_ = FALSE;
				}
				if (_tmp8_) {
					edge = GDK_WINDOW_EDGE_SOUTH_EAST;
				} else {
					gboolean _tmp9_;
					gboolean _tmp10_;
					_tmp9_ = FALSE;
					_tmp10_ = FALSE;
					if ((*event).x > self->priv->CORNER_MARGIN) {
						_tmp10_ = (*event).y > (((GtkWidget*) self)->allocation.height - self->priv->CORNER_MARGIN);
					} else {
						_tmp10_ = FALSE;
					}
					if (_tmp10_) {
						_tmp9_ = (*event).x < (((GtkWidget*) self)->allocation.width - self->priv->CORNER_MARGIN);
					} else {
						_tmp9_ = FALSE;
					}
					if (_tmp9_) {
						edge = GDK_WINDOW_EDGE_SOUTH;
					} else {
						gboolean _tmp11_;
						_tmp11_ = FALSE;
						if ((*event).x <= self->priv->CORNER_MARGIN) {
							_tmp11_ = (*event).y >= (((GtkWidget*) self)->allocation.height - self->priv->CORNER_MARGIN);
						} else {
							_tmp11_ = FALSE;
						}
						if (_tmp11_) {
							edge = GDK_WINDOW_EDGE_SOUTH_WEST;
						} else {
							gboolean _tmp12_;
							gboolean _tmp13_;
							_tmp12_ = FALSE;
							_tmp13_ = FALSE;
							if ((*event).y > self->priv->CORNER_MARGIN) {
								_tmp13_ = (*event).x < self->priv->CORNER_MARGIN;
							} else {
								_tmp13_ = FALSE;
							}
							if (_tmp13_) {
								_tmp12_ = (*event).y < (((GtkWidget*) self)->allocation.height - self->priv->CORNER_MARGIN);
							} else {
								_tmp12_ = FALSE;
							}
							if (_tmp12_) {
								edge = GDK_WINDOW_EDGE_WEST;
							} else {
								return FALSE;
							}
						}
					}
				}
			}
		}
	}
	gtk_window_begin_resize_drag ((GtkWindow*) self, edge, (gint) (*event).button, (gint) (*event).x_root, (gint) (*event).y_root, (*event).time);
	return TRUE;
}


/**
 * window_state_cb:
 *
 * Watch window manager actions always on top and sticky
 * window.
 */
static gboolean xnp_window_window_state_cb (XnpWindow* self, GtkWidget* widget, const GdkEventWindowState* event) {
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (widget != NULL, FALSE);
	if ((gboolean) ((*event).changed_mask & GDK_WINDOW_STATE_ABOVE)) {
		/* FIXME above state is never notified despit
		 * of xfwm4 switching the state */
		gtk_check_menu_item_set_active (self->priv->mi_above, (gboolean) ((*event).new_window_state & GDK_WINDOW_STATE_ABOVE));
	}
	_tmp0_ = FALSE;
	if ((gboolean) ((*event).changed_mask & GDK_WINDOW_STATE_STICKY)) {
		_tmp0_ = (gboolean) (GTK_WIDGET_FLAGS ((GtkWidget*) self) & GTK_VISIBLE);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gtk_check_menu_item_set_active (self->priv->mi_sticky, (gboolean) ((*event).new_window_state & GDK_WINDOW_STATE_STICKY));
	}
	return FALSE;
}


/**
 * title_evbox_pressed_cb:
 *
 * Raise/lower the window and popup window menu.
 */
static gboolean xnp_window_title_evbox_pressed_cb (XnpWindow* self, GtkEventBox* box, const GdkEventButton* event) {
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (box != NULL, FALSE);
	if ((*event).type != GDK_BUTTON_PRESS) {
		return FALSE;
	}
	if ((*event).button == 1) {
		gint winx;
		gint winy;
		gint curx;
		gint cury;
		gdk_window_show (gtk_widget_get_window ((GtkWidget*) self));
		winx = 0;
		winy = 0;
		curx = 0;
		cury = 0;
		gtk_window_get_position ((GtkWindow*) self, &winx, &winy);
		gtk_widget_get_pointer ((GtkWidget*) self, &curx, &cury);
		winx = winx + curx;
		winy = winy + cury;
		gtk_window_begin_move_drag ((GtkWindow*) self, 1, winx, winy, gtk_get_current_event_time ());
	} else {
		if ((*event).button == 2) {
			gdk_window_lower (gtk_widget_get_window ((GtkWidget*) self));
		} else {
			if ((*event).button == 3) {
				gtk_menu_popup (self->priv->menu, NULL, NULL, NULL, NULL, (guint) 0, gtk_get_current_event_time ());
			}
		}
	}
	return FALSE;
}


/**
 * title_evbox_scrolled_cb:
 *
 * Shade/unshade the window and set transparency by holding ALT.
 */
static gboolean xnp_window_title_evbox_scrolled_cb (XnpWindow* self, GtkEventBox* box, const GdkEventScroll* event) {
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (box != NULL, FALSE);
	if ((gboolean) ((*event).state & GDK_MOD1_MASK)) {
		if ((*event).direction == GDK_SCROLL_UP) {
			gtk_window_set_opacity ((GtkWindow*) self, gtk_window_get_opacity ((GtkWindow*) self) + 0.1);
		} else {
			if ((*event).direction == GDK_SCROLL_DOWN) {
				if ((gtk_window_get_opacity ((GtkWindow*) self) - 0.1) >= 0.1) {
					gtk_window_set_opacity ((GtkWindow*) self, gtk_window_get_opacity ((GtkWindow*) self) - 0.1);
				}
			}
		}
	} else {
		if ((*event).direction == GDK_SCROLL_UP) {
			xnp_window_shade (self);
		} else {
			if ((*event).direction == GDK_SCROLL_DOWN) {
				xnp_window_unshade (self);
			}
		}
	}
	return FALSE;
}


/**
 * note_notify:
 *
 * Update the window title on note name changes.
 */
static void xnp_window_note_notify (XnpWindow* self, GObject* object, GParamSpec* pspec) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (object != NULL);
	g_return_if_fail (pspec != NULL);
	if (_vala_strcmp0 (pspec->name, "name") == 0) {
		XnpNote* _tmp0_;
		XnpNote* note;
		gint page;
		XnpNote* _tmp1_;
		XnpNote* current_note;
		/* Update the window title */
		_tmp0_ = NULL;
		note = (_tmp0_ = XNP_NOTE (object), (_tmp0_ == NULL) ? NULL : g_object_ref (_tmp0_));
		page = gtk_notebook_get_current_page (self->priv->notebook);
		_tmp1_ = NULL;
		current_note = (_tmp1_ = XNP_NOTE (gtk_notebook_get_nth_page (self->priv->notebook, page)), (_tmp1_ == NULL) ? NULL : g_object_ref (_tmp1_));
		if (note == current_note) {
			xnp_window_update_title (self, xnp_note_get_name (note));
		}
		(note == NULL) ? NULL : (note = (g_object_unref (note), NULL));
		(current_note == NULL) ? NULL : (current_note = (g_object_unref (current_note), NULL));
	}
}


/*
 * Action callbacks
 */
static void xnp_window_action_new_window (XnpWindow* self) {
	g_return_if_fail (self != NULL);
	g_signal_emit_by_name (self, "action", "create-new-window");
}


static void xnp_window_action_delete_window (XnpWindow* self) {
	g_return_if_fail (self != NULL);
	g_signal_emit_by_name (self, "action", "delete");
}


static void xnp_window_action_rename_window (XnpWindow* self) {
	g_return_if_fail (self != NULL);
	g_signal_emit_by_name (self, "action", "rename");
}


static void xnp_window_action_new_note (XnpWindow* self) {
	XnpNote* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = NULL;
	_tmp0_ = xnp_window_insert_note (self);
	(_tmp0_ == NULL) ? NULL : (_tmp0_ = (g_object_unref (_tmp0_), NULL));
}


static void xnp_window_action_delete_note (XnpWindow* self) {
	g_return_if_fail (self != NULL);
	xnp_window_delete_current_note (self);
}


static void xnp_window_action_rename_note (XnpWindow* self) {
	g_return_if_fail (self != NULL);
	xnp_window_rename_current_note (self);
}


static void xnp_window_action_cancel (XnpWindow* self) {
	gint page;
	GtkWidget* _tmp0_;
	GtkWidget* child;
	g_return_if_fail (self != NULL);
	page = gtk_notebook_get_current_page (self->priv->notebook);
	if (page < 0) {
		return;
	}
	_tmp0_ = NULL;
	child = (_tmp0_ = gtk_notebook_get_nth_page (self->priv->notebook, page), (_tmp0_ == NULL) ? NULL : g_object_ref (_tmp0_));
	xnp_hypertext_view_undo (XNP_NOTE (child)->text_view);
	(child == NULL) ? NULL : (child = (g_object_unref (child), NULL));
}


static void xnp_window_action_next_note (XnpWindow* self) {
	g_return_if_fail (self != NULL);
	gtk_notebook_next_page (self->priv->notebook);
}


static void xnp_window_action_prev_note (XnpWindow* self) {
	g_return_if_fail (self != NULL);
	gtk_notebook_prev_page (self->priv->notebook);
}


static void _xnp_window_menu_position_gtk_menu_position_func (GtkMenu* menu, gint* x, gint* y, gboolean* push_in, gpointer self) {
	xnp_window_menu_position (self, menu, x, y, push_in);
}


/*
 * Window menu
 
*
 * menu_box_pressed_cb:
 *
 * Popup the window menu.
 */
static gboolean xnp_window_menu_box_pressed_cb (XnpWindow* self, GtkEventBox* box, const GdkEventButton* event) {
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (box != NULL, FALSE);
	gtk_menu_popup (self->priv->menu, NULL, NULL, _xnp_window_menu_position_gtk_menu_position_func, self, (guint) 0, gtk_get_current_event_time ());
	return FALSE;
}


/**
 * menu_position:
 *
 * Menu position function for the window menu.
 */
static void xnp_window_menu_position (XnpWindow* self, GtkMenu* menu, gint* x, gint* y, gboolean* push_in) {
	gint winx;
	gint winy;
	gint width;
	gint height;
	gint depth;
	GtkRequisition requisition = {0};
	g_return_if_fail (self != NULL);
	g_return_if_fail (menu != NULL);
	winx = 0;
	winy = 0;
	width = 0;
	height = 0;
	depth = 0;
	gdk_window_get_geometry (gtk_widget_get_window ((GtkWidget*) self), &winx, &winy, &width, &height, &depth);
	gdk_window_get_origin (gtk_widget_get_window ((GtkWidget*) self), &(*x), &(*y));
	gtk_widget_size_request ((GtkWidget*) menu, &requisition);
	if ((((*y) + ((GtkWidget*) self->priv->content_box)->allocation.y) + requisition.height) > gdk_screen_height ()) {
		/* Show menu above */
		(*y) = (*y) - requisition.height;
	} else {
		/* Show menu below */
		(*y) = (*y) + ((GtkWidget*) self->priv->content_box)->allocation.y;
	}
	if (((*x) + requisition.width) > gdk_screen_width ()) {
		/* Adjust menu left */
		(*x) = ((*x) - ((GtkWidget*) menu)->requisition.width) + ((GtkWidget*) self->priv->content_box)->allocation.y;
	}
}


static void _xnp_window_update_menu_go_gtk_widget_show (GtkMenu* _sender, gpointer self) {
	xnp_window_update_menu_go (self, _sender);
}


static void _xnp_window_action_new_note_gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self) {
	xnp_window_action_new_note (self);
}


static void _xnp_window_action_delete_note_gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self) {
	xnp_window_action_delete_note (self);
}


static void _xnp_window_action_rename_note_gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self) {
	xnp_window_action_rename_note (self);
}


static void _xnp_window_action_cancel_gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self) {
	xnp_window_action_cancel (self);
}


static void _lambda5_ (XnpWindow* self) {
	g_signal_emit_by_name (self, "action", "properties");
}


static void __lambda5__gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self) {
	_lambda5_ (self);
}


static void _lambda6_ (GtkCheckMenuItem* o, XnpWindow* self) {
	g_return_if_fail (o != NULL);
	xnp_window_set_above (self, gtk_check_menu_item_get_active (o));
}


static void __lambda6__gtk_check_menu_item_toggled (GtkCheckMenuItem* _sender, gpointer self) {
	_lambda6_ (_sender, self);
}


static void _lambda7_ (GtkCheckMenuItem* o, XnpWindow* self) {
	g_return_if_fail (o != NULL);
	xnp_window_set_sticky (self, gtk_check_menu_item_get_active (o));
}


static void __lambda7__gtk_check_menu_item_toggled (GtkCheckMenuItem* _sender, gpointer self) {
	_lambda7_ (_sender, self);
}


/**
 * build_menu:
 *
 * Build the window menu.
 */
static GtkMenu* xnp_window_build_menu (XnpWindow* self) {
	GtkMenu* menu;
	GtkMenuItem* mi;
	GtkMenu* menu_go;
	GtkMenuItem* _tmp0_;
	GtkMenuItem* _tmp1_;
	GtkMenuItem* _tmp2_;
	GtkMenuItem* _tmp3_;
	GtkImage* image;
	GtkMenuItem* _tmp4_;
	GtkMenuItem* _tmp5_;
	GtkMenuItem* _tmp6_;
	GtkMenuItem* _tmp9_;
	GtkMenuItem* _tmp8_;
	GtkCheckMenuItem* _tmp7_;
	GtkMenuItem* _tmp12_;
	GtkMenuItem* _tmp11_;
	GtkCheckMenuItem* _tmp10_;
	GtkMenu* _tmp13_;
	g_return_val_if_fail (self != NULL, NULL);
	menu = g_object_ref_sink ((GtkMenu*) gtk_menu_new ());
	gtk_menu_set_accel_group (menu, gtk_ui_manager_get_accel_group (self->priv->ui));
	mi = g_object_ref_sink ((GtkMenuItem*) gtk_menu_item_new_with_mnemonic (_ ("_Go")));
	gtk_menu_shell_append ((GtkMenuShell*) menu, (GtkWidget*) mi);
	/* Navigation */
	menu_go = g_object_ref_sink ((GtkMenu*) gtk_menu_new ());
	gtk_menu_set_accel_group (menu_go, gtk_ui_manager_get_accel_group (self->priv->ui));
	g_signal_connect_object ((GtkWidget*) menu_go, "show", (GCallback) _xnp_window_update_menu_go_gtk_widget_show, self, 0);
	gtk_menu_item_set_submenu (mi, (GtkWidget*) menu_go);
	/* Note items */
	_tmp0_ = NULL;
	mi = (_tmp0_ = (GtkMenuItem*) g_object_ref_sink ((GtkSeparatorMenuItem*) gtk_separator_menu_item_new ()), (mi == NULL) ? NULL : (mi = (g_object_unref (mi), NULL)), _tmp0_);
	gtk_menu_shell_append ((GtkMenuShell*) menu, (GtkWidget*) mi);
	_tmp1_ = NULL;
	mi = (_tmp1_ = (GtkMenuItem*) g_object_ref_sink ((GtkImageMenuItem*) gtk_image_menu_item_new_from_stock (GTK_STOCK_NEW, NULL)), (mi == NULL) ? NULL : (mi = (g_object_unref (mi), NULL)), _tmp1_);
	gtk_menu_item_set_accel_path (mi, gtk_action_get_accel_path (gtk_action_group_get_action (self->priv->action_group, "new-note")));
	g_signal_connect_object (mi, "activate", (GCallback) _xnp_window_action_new_note_gtk_menu_item_activate, self, 0);
	gtk_menu_shell_append ((GtkMenuShell*) menu, (GtkWidget*) mi);
	_tmp2_ = NULL;
	mi = (_tmp2_ = (GtkMenuItem*) g_object_ref_sink ((GtkImageMenuItem*) gtk_image_menu_item_new_from_stock (GTK_STOCK_DELETE, NULL)), (mi == NULL) ? NULL : (mi = (g_object_unref (mi), NULL)), _tmp2_);
	gtk_menu_item_set_accel_path (mi, gtk_action_get_accel_path (gtk_action_group_get_action (self->priv->action_group, "delete-note")));
	g_signal_connect_object (mi, "activate", (GCallback) _xnp_window_action_delete_note_gtk_menu_item_activate, self, 0);
	gtk_menu_shell_append ((GtkMenuShell*) menu, (GtkWidget*) mi);
	_tmp3_ = NULL;
	mi = (_tmp3_ = (GtkMenuItem*) g_object_ref_sink ((GtkImageMenuItem*) gtk_image_menu_item_new_with_mnemonic (_ ("_Rename"))), (mi == NULL) ? NULL : (mi = (g_object_unref (mi), NULL)), _tmp3_);
	image = g_object_ref_sink ((GtkImage*) gtk_image_new_from_stock (GTK_STOCK_EDIT, GTK_ICON_SIZE_MENU));
	gtk_image_menu_item_set_image (GTK_IMAGE_MENU_ITEM (mi), (GtkWidget*) image);
	gtk_menu_item_set_accel_path (mi, gtk_action_get_accel_path (gtk_action_group_get_action (self->priv->action_group, "rename-note")));
	g_signal_connect_object (mi, "activate", (GCallback) _xnp_window_action_rename_note_gtk_menu_item_activate, self, 0);
	gtk_menu_shell_append ((GtkMenuShell*) menu, (GtkWidget*) mi);
	_tmp4_ = NULL;
	mi = (_tmp4_ = (GtkMenuItem*) g_object_ref_sink ((GtkImageMenuItem*) gtk_image_menu_item_new_from_stock (GTK_STOCK_UNDO, NULL)), (mi == NULL) ? NULL : (mi = (g_object_unref (mi), NULL)), _tmp4_);
	gtk_menu_item_set_accel_path (mi, gtk_action_get_accel_path (gtk_action_group_get_action (self->priv->action_group, "cancel")));
	g_signal_connect_object (mi, "activate", (GCallback) _xnp_window_action_cancel_gtk_menu_item_activate, self, 0);
	gtk_menu_shell_append ((GtkMenuShell*) menu, (GtkWidget*) mi);
	/* Window options */
	_tmp5_ = NULL;
	mi = (_tmp5_ = (GtkMenuItem*) g_object_ref_sink ((GtkSeparatorMenuItem*) gtk_separator_menu_item_new ()), (mi == NULL) ? NULL : (mi = (g_object_unref (mi), NULL)), _tmp5_);
	gtk_menu_shell_append ((GtkMenuShell*) menu, (GtkWidget*) mi);
	_tmp6_ = NULL;
	mi = (_tmp6_ = (GtkMenuItem*) g_object_ref_sink ((GtkImageMenuItem*) gtk_image_menu_item_new_from_stock (GTK_STOCK_PROPERTIES, NULL)), (mi == NULL) ? NULL : (mi = (g_object_unref (mi), NULL)), _tmp6_);
	g_signal_connect (mi, "activate", (GCallback) __lambda5__gtk_menu_item_activate, self);
	gtk_menu_shell_append ((GtkMenuShell*) menu, (GtkWidget*) mi);
	_tmp9_ = NULL;
	_tmp8_ = NULL;
	_tmp7_ = NULL;
	mi = (_tmp9_ = (_tmp8_ = (GtkMenuItem*) (self->priv->mi_above = (_tmp7_ = g_object_ref_sink ((GtkCheckMenuItem*) gtk_check_menu_item_new_with_label (_ ("Always on top"))), (self->priv->mi_above == NULL) ? NULL : (self->priv->mi_above = (g_object_unref (self->priv->mi_above), NULL)), _tmp7_)), (_tmp8_ == NULL) ? NULL : g_object_ref (_tmp8_)), (mi == NULL) ? NULL : (mi = (g_object_unref (mi), NULL)), _tmp9_);
	gtk_check_menu_item_set_active (GTK_CHECK_MENU_ITEM (mi), xnp_window_get_above (self));
	g_signal_connect (GTK_CHECK_MENU_ITEM (mi), "toggled", (GCallback) __lambda6__gtk_check_menu_item_toggled, self);
	gtk_menu_shell_append ((GtkMenuShell*) menu, (GtkWidget*) mi);
	_tmp12_ = NULL;
	_tmp11_ = NULL;
	_tmp10_ = NULL;
	mi = (_tmp12_ = (_tmp11_ = (GtkMenuItem*) (self->priv->mi_sticky = (_tmp10_ = g_object_ref_sink ((GtkCheckMenuItem*) gtk_check_menu_item_new_with_label (_ ("Sticky window"))), (self->priv->mi_sticky == NULL) ? NULL : (self->priv->mi_sticky = (g_object_unref (self->priv->mi_sticky), NULL)), _tmp10_)), (_tmp11_ == NULL) ? NULL : g_object_ref (_tmp11_)), (mi == NULL) ? NULL : (mi = (g_object_unref (mi), NULL)), _tmp12_);
	gtk_check_menu_item_set_active (GTK_CHECK_MENU_ITEM (mi), xnp_window_get_sticky (self));
	g_signal_connect (GTK_CHECK_MENU_ITEM (mi), "toggled", (GCallback) __lambda7__gtk_check_menu_item_toggled, self);
	gtk_menu_shell_append ((GtkMenuShell*) menu, (GtkWidget*) mi);
	_tmp13_ = NULL;
	return (_tmp13_ = menu, (mi == NULL) ? NULL : (mi = (g_object_unref (mi), NULL)), (menu_go == NULL) ? NULL : (menu_go = (g_object_unref (menu_go), NULL)), (image == NULL) ? NULL : (image = (g_object_unref (image), NULL)), _tmp13_);
}


static void _lambda2_ (GtkWidget* w, XnpWindow* self) {
	g_return_if_fail (w != NULL);
	gtk_object_destroy ((GtkObject*) w);
}


static void __lambda2__gtk_callback (GtkWidget* widget, gpointer self) {
	_lambda2_ (widget, self);
}


static void _lambda3_ (GtkMenuItem* i, XnpWindow* self) {
	gint page;
	g_return_if_fail (i != NULL);
	page = (gint) g_object_get_data ((GObject*) i, "page");
	gtk_notebook_set_current_page (self->priv->notebook, page);
}


static void __lambda3__gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self) {
	_lambda3_ (_sender, self);
}


static void _lambda4_ (GtkMenuItem* i, XnpWindow* self) {
	XnpWindow* _tmp0_;
	XnpWindow* w;
	g_return_if_fail (i != NULL);
	_tmp0_ = NULL;
	w = (_tmp0_ = XNP_WINDOW (g_object_get_data ((GObject*) i, "window")), (_tmp0_ == NULL) ? NULL : g_object_ref (_tmp0_));
	gtk_window_present ((GtkWindow*) w);
	(w == NULL) ? NULL : (w = (g_object_unref (w), NULL));
}


static void __lambda4__gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self) {
	_lambda4_ (_sender, self);
}


static void _xnp_window_action_rename_window_gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self) {
	xnp_window_action_rename_window (self);
}


static void _xnp_window_action_delete_window_gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self) {
	xnp_window_action_delete_window (self);
}


static void _xnp_window_action_new_window_gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self) {
	xnp_window_action_new_window (self);
}


/**
 * update_menu_go:
 *
 * Update the menu Go when it is shown.
 */
static void xnp_window_update_menu_go (XnpWindow* self, GtkMenu* menu) {
	GtkMenuItem* mi;
	GtkImage* image;
	GtkMenuItem* _tmp8_;
	GtkImage* _tmp9_;
	GtkMenuItem* _tmp10_;
	GtkImage* _tmp11_;
	GtkMenuItem* _tmp12_;
	GtkImage* _tmp13_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (menu != NULL);
	mi = NULL;
	image = NULL;
	gtk_container_foreach ((GtkContainer*) menu, __lambda2__gtk_callback, self);
	{
		GSList* win_collection;
		GSList* win_it;
		win_collection = self->priv->window_list;
		for (win_it = win_collection; win_it != NULL; win_it = win_it->next) {
			XnpWindow* win;
			win = (XnpWindow*) win_it->data;
			{
				if (win == self) {
					GtkMenuItem* _tmp0_;
					gint current_page;
					XnpNote* _tmp1_;
					XnpNote* current_note;
					gint n_pages;
					GtkMenuItem* _tmp5_;
					_tmp0_ = NULL;
					mi = (_tmp0_ = g_object_ref_sink ((GtkMenuItem*) gtk_menu_item_new_with_label (win->priv->_name)), (mi == NULL) ? NULL : (mi = (g_object_unref (mi), NULL)), _tmp0_);
					g_object_set ((GtkWidget*) mi, "sensitive", FALSE, NULL);
					gtk_menu_shell_append ((GtkMenuShell*) menu, (GtkWidget*) mi);
					current_page = gtk_notebook_get_current_page (self->priv->notebook);
					_tmp1_ = NULL;
					current_note = (_tmp1_ = XNP_NOTE (gtk_notebook_get_nth_page (self->priv->notebook, current_page)), (_tmp1_ == NULL) ? NULL : g_object_ref (_tmp1_));
					n_pages = gtk_notebook_get_n_pages (self->priv->notebook);
					{
						gint p;
						p = 0;
						for (; p < n_pages; p++) {
							XnpNote* _tmp2_;
							XnpNote* note;
							GtkMenuItem* _tmp3_;
							_tmp2_ = NULL;
							note = (_tmp2_ = XNP_NOTE (gtk_notebook_get_nth_page (self->priv->notebook, p)), (_tmp2_ == NULL) ? NULL : g_object_ref (_tmp2_));
							_tmp3_ = NULL;
							mi = (_tmp3_ = (GtkMenuItem*) g_object_ref_sink ((GtkImageMenuItem*) gtk_image_menu_item_new_with_label (xnp_note_get_name (note))), (mi == NULL) ? NULL : (mi = (g_object_unref (mi), NULL)), _tmp3_);
							if (note == current_note) {
								GtkImage* _tmp4_;
								_tmp4_ = NULL;
								image = (_tmp4_ = g_object_ref_sink ((GtkImage*) gtk_image_new_from_stock (GTK_STOCK_GO_FORWARD, GTK_ICON_SIZE_MENU)), (image == NULL) ? NULL : (image = (g_object_unref (image), NULL)), _tmp4_);
								gtk_image_menu_item_set_image (GTK_IMAGE_MENU_ITEM (mi), (GtkWidget*) image);
							}
							g_object_set_data ((GObject*) mi, "page", (void*) p);
							g_signal_connect (mi, "activate", (GCallback) __lambda3__gtk_menu_item_activate, self);
							gtk_menu_shell_append ((GtkMenuShell*) menu, (GtkWidget*) mi);
							(note == NULL) ? NULL : (note = (g_object_unref (note), NULL));
						}
					}
					_tmp5_ = NULL;
					mi = (_tmp5_ = (GtkMenuItem*) g_object_ref_sink ((GtkSeparatorMenuItem*) gtk_separator_menu_item_new ()), (mi == NULL) ? NULL : (mi = (g_object_unref (mi), NULL)), _tmp5_);
					gtk_menu_shell_append ((GtkMenuShell*) menu, (GtkWidget*) mi);
					(current_note == NULL) ? NULL : (current_note = (g_object_unref (current_note), NULL));
				} else {
					GtkMenuItem* _tmp6_;
					GtkMenuItem* _tmp7_;
					_tmp6_ = NULL;
					mi = (_tmp6_ = g_object_ref_sink ((GtkMenuItem*) gtk_menu_item_new_with_label (win->priv->_name)), (mi == NULL) ? NULL : (mi = (g_object_unref (mi), NULL)), _tmp6_);
					g_object_set_data ((GObject*) mi, "window", (void*) win);
					g_signal_connect (mi, "activate", (GCallback) __lambda4__gtk_menu_item_activate, self);
					gtk_menu_shell_append ((GtkMenuShell*) menu, (GtkWidget*) mi);
					_tmp7_ = NULL;
					mi = (_tmp7_ = (GtkMenuItem*) g_object_ref_sink ((GtkSeparatorMenuItem*) gtk_separator_menu_item_new ()), (mi == NULL) ? NULL : (mi = (g_object_unref (mi), NULL)), _tmp7_);
					gtk_menu_shell_append ((GtkMenuShell*) menu, (GtkWidget*) mi);
				}
			}
		}
	}
	_tmp8_ = NULL;
	mi = (_tmp8_ = (GtkMenuItem*) g_object_ref_sink ((GtkImageMenuItem*) gtk_image_menu_item_new_with_mnemonic (_ ("_Rename group"))), (mi == NULL) ? NULL : (mi = (g_object_unref (mi), NULL)), _tmp8_);
	_tmp9_ = NULL;
	image = (_tmp9_ = g_object_ref_sink ((GtkImage*) gtk_image_new_from_stock (GTK_STOCK_EDIT, GTK_ICON_SIZE_MENU)), (image == NULL) ? NULL : (image = (g_object_unref (image), NULL)), _tmp9_);
	gtk_image_menu_item_set_image (GTK_IMAGE_MENU_ITEM (mi), (GtkWidget*) image);
	gtk_menu_item_set_accel_path (mi, gtk_action_get_accel_path (gtk_action_group_get_action (self->priv->action_group, "rename-window")));
	g_signal_connect_object (mi, "activate", (GCallback) _xnp_window_action_rename_window_gtk_menu_item_activate, self, 0);
	gtk_menu_shell_append ((GtkMenuShell*) menu, (GtkWidget*) mi);
	_tmp10_ = NULL;
	mi = (_tmp10_ = (GtkMenuItem*) g_object_ref_sink ((GtkImageMenuItem*) gtk_image_menu_item_new_with_mnemonic (_ ("_Delete group"))), (mi == NULL) ? NULL : (mi = (g_object_unref (mi), NULL)), _tmp10_);
	_tmp11_ = NULL;
	image = (_tmp11_ = g_object_ref_sink ((GtkImage*) gtk_image_new_from_stock (GTK_STOCK_REMOVE, GTK_ICON_SIZE_MENU)), (image == NULL) ? NULL : (image = (g_object_unref (image), NULL)), _tmp11_);
	gtk_image_menu_item_set_image (GTK_IMAGE_MENU_ITEM (mi), (GtkWidget*) image);
	gtk_menu_item_set_accel_path (mi, gtk_action_get_accel_path (gtk_action_group_get_action (self->priv->action_group, "delete-window")));
	g_signal_connect_object (mi, "activate", (GCallback) _xnp_window_action_delete_window_gtk_menu_item_activate, self, 0);
	gtk_menu_shell_append ((GtkMenuShell*) menu, (GtkWidget*) mi);
	_tmp12_ = NULL;
	mi = (_tmp12_ = (GtkMenuItem*) g_object_ref_sink ((GtkImageMenuItem*) gtk_image_menu_item_new_with_mnemonic (_ ("_Add a new group"))), (mi == NULL) ? NULL : (mi = (g_object_unref (mi), NULL)), _tmp12_);
	_tmp13_ = NULL;
	image = (_tmp13_ = g_object_ref_sink ((GtkImage*) gtk_image_new_from_stock (GTK_STOCK_ADD, GTK_ICON_SIZE_MENU)), (image == NULL) ? NULL : (image = (g_object_unref (image), NULL)), _tmp13_);
	gtk_image_menu_item_set_image (GTK_IMAGE_MENU_ITEM (mi), (GtkWidget*) image);
	gtk_menu_item_set_accel_path (mi, gtk_action_get_accel_path (gtk_action_group_get_action (self->priv->action_group, "new-window")));
	g_signal_connect_object (mi, "activate", (GCallback) _xnp_window_action_new_window_gtk_menu_item_activate, self, 0);
	gtk_menu_shell_append ((GtkMenuShell*) menu, (GtkWidget*) mi);
	gtk_widget_show_all ((GtkWidget*) menu);
	(mi == NULL) ? NULL : (mi = (g_object_unref (mi), NULL));
	(image == NULL) ? NULL : (image = (g_object_unref (image), NULL));
}


/**
 * get_geometry:
 *
 * Returns the X,Y position and width/height.
 */
void xnp_window_get_geometry (XnpWindow* self, gint* winx, gint* winy, gint* width, gint* height) {
	g_return_if_fail (self != NULL);
	/* Window is shaded*/
	if (!((gboolean) (GTK_WIDGET_FLAGS ((GtkWidget*) self->priv->content_box) & GTK_VISIBLE))) {
		gtk_window_get_size ((GtkWindow*) self, &self->priv->width, NULL);
	} else {
		gtk_window_get_size ((GtkWindow*) self, &self->priv->width, &self->priv->height);
	}
	gtk_window_get_position ((GtkWindow*) self, &(*winx), &(*winy));
	(*width) = self->priv->width;
	(*height) = self->priv->height;
}


/**
 * set_window_list:
 *
 * Saves a list of window inside window.window_list to be shown
 * within the window menu.
 */
void xnp_window_set_window_list (XnpWindow* self, GSList* list) {
	g_return_if_fail (self != NULL);
	self->priv->window_list = list;
}


/**
 * compare_func:
 *
 * Compare function for the window name to use with GLib.CompareFunc delegates.
 */
gint xnp_window_compare_func (XnpWindow* self, XnpWindow* win2) {
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (win2 != NULL, 0);
	return g_utf8_collate (self->priv->_name, win2->priv->_name);
}


/**
 * get_current_page:
 *
 * Get the current page in the notebook.
 */
gint xnp_window_get_current_page (XnpWindow* self) {
	g_return_val_if_fail (self != NULL, 0);
	return gtk_notebook_get_current_page (self->priv->notebook);
}


/**
 * set_current_page:
 *
 * Set the current page in the notebook.
 */
void xnp_window_set_current_page (XnpWindow* self, gint page) {
	g_return_if_fail (self != NULL);
	gtk_notebook_set_current_page (self->priv->notebook, page);
}


/*
 * Window management
 
*
 * shade:
 *
 * Shade the window (roll up) to show only the title bar.
 */
static void xnp_window_shade (XnpWindow* self) {
	g_return_if_fail (self != NULL);
	if ((gboolean) (GTK_WIDGET_FLAGS ((GtkWidget*) self->priv->content_box) & GTK_VISIBLE)) {
		gtk_widget_hide ((GtkWidget*) self->priv->content_box);
		gtk_window_get_size ((GtkWindow*) self, &self->priv->width, &self->priv->height);
		gtk_window_resize ((GtkWindow*) self, self->priv->width, 1);
	}
}


/**
 * unshade:
 *
 * Unshade the window (roll down).
 */
static void xnp_window_unshade (XnpWindow* self) {
	g_return_if_fail (self != NULL);
	if (!((gboolean) (GTK_WIDGET_FLAGS ((GtkWidget*) self->priv->content_box) & GTK_VISIBLE))) {
		gtk_widget_show ((GtkWidget*) self->priv->content_box);
		gtk_window_get_size ((GtkWindow*) self, &self->priv->width, NULL);
		gtk_window_resize ((GtkWindow*) self, self->priv->width, self->priv->height);
	}
}


/**
 * update_title:
 *
 * Updates the window title.
 */
static void xnp_window_update_title (XnpWindow* self, const char* note_name) {
	char* _tmp1_;
	char* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (note_name != NULL);
	_tmp1_ = NULL;
	_tmp0_ = NULL;
	gtk_window_set_title ((GtkWindow*) self, _tmp1_ = g_strconcat (_tmp0_ = g_strconcat (self->priv->_name, " - ", NULL), note_name, NULL));
	_tmp1_ = (g_free (_tmp1_), NULL);
	_tmp0_ = (g_free (_tmp0_), NULL);
}


/**
 * update_navigation_sensitivity:
 *
 * Update the goleft/right sensitivities.
 */
static void xnp_window_update_navigation_sensitivity (XnpWindow* self, gint page_num) {
	gint n_pages;
	g_return_if_fail (self != NULL);
	n_pages = gtk_notebook_get_n_pages (self->priv->notebook);
	if (n_pages <= 1) {
		g_object_set ((GtkWidget*) self->priv->goleft_box, "sensitive", FALSE, NULL);
		g_object_set ((GtkWidget*) self->priv->goright_box, "sensitive", FALSE, NULL);
	} else {
		gboolean _tmp0_;
		gboolean _tmp1_;
		_tmp0_ = FALSE;
		if (page_num > 0) {
			_tmp0_ = TRUE;
		} else {
			_tmp0_ = FALSE;
		}
		g_object_set ((GtkWidget*) self->priv->goleft_box, "sensitive", _tmp0_, NULL);
		_tmp1_ = FALSE;
		if ((page_num + 1) < n_pages) {
			_tmp1_ = TRUE;
		} else {
			_tmp1_ = FALSE;
		}
		g_object_set ((GtkWidget*) self->priv->goright_box, "sensitive", _tmp1_, NULL);
	}
}


static void _xnp_window_note_notify_g_object_notify (XnpNote* _sender, GParamSpec* pspec, gpointer self) {
	xnp_window_note_notify (self, _sender, pspec);
}


static void _lambda1_ (XnpNote* note, XnpWindow* self) {
	g_return_if_fail (note != NULL);
	g_signal_emit_by_name (self, "save-data", note);
}


static void __lambda1__xnp_note_save_data (XnpNote* _sender, gpointer self) {
	_lambda1_ (_sender, self);
}


/*
 * Note management
 
*
 * insert_note:
 *
 * Create a new note and insert it inside the notebook after
 * the current position.
 */
XnpNote* xnp_window_insert_note (XnpWindow* self) {
	gint len;
	const char* _tmp0_;
	char* name;
	gint page;
	XnpNote* note;
	XnpNote* _tmp2_;
	g_return_val_if_fail (self != NULL, NULL);
	len = gtk_notebook_get_n_pages (self->priv->notebook);
	_tmp0_ = NULL;
	name = (_tmp0_ = _ ("Notes"), (_tmp0_ == NULL) ? NULL : g_strdup (_tmp0_));
	{
		gint id;
		id = 1;
		for (; id <= (len + 1); id++) {
			if (id > 1) {
				char* _tmp1_;
				_tmp1_ = NULL;
				name = (_tmp1_ = g_strdup_printf (_ ("Notes %d"), id), name = (g_free (name), NULL), _tmp1_);
			}
			if (!xnp_window_note_name_exists (self, name)) {
				break;
			}
		}
	}
	page = gtk_notebook_get_current_page (self->priv->notebook) + 1;
	note = g_object_ref_sink (xnp_note_new (name));
	g_signal_connect_object ((GObject*) note, "notify", (GCallback) _xnp_window_note_notify_g_object_notify, self, 0);
	g_signal_connect (note, "save-data", (GCallback) __lambda1__xnp_note_save_data, self);
	gtk_widget_show ((GtkWidget*) note);
	gtk_notebook_insert_page (self->priv->notebook, (GtkWidget*) note, NULL, page);
	g_signal_emit_by_name (self, "note-inserted", note);
	_tmp2_ = NULL;
	return (_tmp2_ = note, name = (g_free (name), NULL), _tmp2_);
}


/**
 * delete_current_note:
 *
 * Delete the current note.
 */
void xnp_window_delete_current_note (XnpWindow* self) {
	g_return_if_fail (self != NULL);
	xnp_window_delete_note (self, gtk_notebook_get_current_page (self->priv->notebook));
}


/**
 * delete_note:
 *
 * Delete note at page @page.
 */
void xnp_window_delete_note (XnpWindow* self, gint page) {
	XnpNote* _tmp0_;
	XnpNote* note;
	g_return_if_fail (self != NULL);
	_tmp0_ = NULL;
	note = (_tmp0_ = XNP_NOTE (gtk_notebook_get_nth_page (self->priv->notebook, page)), (_tmp0_ == NULL) ? NULL : g_object_ref (_tmp0_));
	if (gtk_text_buffer_get_char_count (gtk_text_view_get_buffer ((GtkTextView*) note->text_view)) > 0) {
		GtkMessageDialog* dialog;
		gint res;
		dialog = g_object_ref_sink ((GtkMessageDialog*) gtk_message_dialog_new ((GtkWindow*) self, GTK_DIALOG_DESTROY_WITH_PARENT, GTK_MESSAGE_QUESTION, GTK_BUTTONS_YES_NO, _ ("Are you sure you want to delete this note?"), NULL));
		res = gtk_dialog_run ((GtkDialog*) dialog);
		gtk_object_destroy ((GtkObject*) dialog);
		if (res != GTK_RESPONSE_YES) {
			(dialog == NULL) ? NULL : (dialog = (g_object_unref (dialog), NULL));
			(note == NULL) ? NULL : (note = (g_object_unref (note), NULL));
			return;
		}
		(dialog == NULL) ? NULL : (dialog = (g_object_unref (dialog), NULL));
	}
	gtk_notebook_remove_page (self->priv->notebook, page);
	g_signal_emit_by_name (self, "note-deleted", note);
	gtk_object_destroy ((GtkObject*) note);
	if (gtk_notebook_get_n_pages (self->priv->notebook) == 0) {
		XnpNote* _tmp1_;
		_tmp1_ = NULL;
		_tmp1_ = xnp_window_insert_note (self);
		(_tmp1_ == NULL) ? NULL : (_tmp1_ = (g_object_unref (_tmp1_), NULL));
	}
	(note == NULL) ? NULL : (note = (g_object_unref (note), NULL));
}


/**
 * rename_current_note:
 *
 * Rename the current note.
 */
void xnp_window_rename_current_note (XnpWindow* self) {
	gint page;
	XnpNote* _tmp0_;
	XnpNote* note;
	GtkDialog* dialog;
	GtkEntry* entry;
	gint res;
	g_return_if_fail (self != NULL);
	page = gtk_notebook_get_current_page (self->priv->notebook);
	if (page == (-1)) {
		return;
	}
	_tmp0_ = NULL;
	note = (_tmp0_ = XNP_NOTE (gtk_notebook_get_nth_page (self->priv->notebook, page)), (_tmp0_ == NULL) ? NULL : g_object_ref (_tmp0_));
	dialog = g_object_ref_sink ((GtkDialog*) gtk_dialog_new_with_buttons (_ ("Rename note"), GTK_WINDOW (gtk_widget_get_toplevel ((GtkWidget*) self)), (GTK_DIALOG_MODAL | GTK_DIALOG_DESTROY_WITH_PARENT) | GTK_DIALOG_NO_SEPARATOR, GTK_STOCK_CANCEL, GTK_RESPONSE_CANCEL, GTK_STOCK_OK, GTK_RESPONSE_OK, NULL));
	gtk_dialog_set_default_response (dialog, (gint) GTK_RESPONSE_OK);
	gtk_window_set_resizable ((GtkWindow*) dialog, FALSE);
	gtk_window_set_icon_name ((GtkWindow*) dialog, GTK_STOCK_EDIT);
	gtk_container_set_border_width ((GtkContainer*) dialog, (guint) 4);
	gtk_container_set_border_width ((GtkContainer*) dialog->vbox, (guint) 6);
	entry = g_object_ref_sink ((GtkEntry*) gtk_entry_new ());
	gtk_entry_set_text (entry, xnp_note_get_name (note));
	gtk_entry_set_activates_default (entry, TRUE);
	gtk_container_add ((GtkContainer*) dialog->vbox, (GtkWidget*) entry);
	gtk_widget_show_all ((GtkWidget*) dialog->vbox);
	res = gtk_dialog_run (dialog);
	gtk_widget_hide ((GtkWidget*) dialog);
	if (res == GTK_RESPONSE_OK) {
		const char* name;
		name = gtk_entry_get_text (entry);
		if (xnp_window_note_name_exists (self, name)) {
			GtkMessageDialog* error_dialog;
			error_dialog = g_object_ref_sink ((GtkMessageDialog*) gtk_message_dialog_new ((GtkWindow*) self, GTK_DIALOG_DESTROY_WITH_PARENT, GTK_MESSAGE_ERROR, GTK_BUTTONS_CLOSE, _ ("The name %s is already in use"), name, NULL));
			gtk_dialog_run ((GtkDialog*) error_dialog);
			gtk_object_destroy ((GtkObject*) error_dialog);
			(error_dialog == NULL) ? NULL : (error_dialog = (g_object_unref (error_dialog), NULL));
		} else {
			const char* _tmp1_;
			char* old_name;
			_tmp1_ = NULL;
			old_name = (_tmp1_ = xnp_note_get_name (note), (_tmp1_ == NULL) ? NULL : g_strdup (_tmp1_));
			xnp_note_set_name (note, name);
			g_signal_emit_by_name (self, "note-renamed", note, old_name);
			old_name = (g_free (old_name), NULL);
		}
	}
	gtk_object_destroy ((GtkObject*) dialog);
	(note == NULL) ? NULL : (note = (g_object_unref (note), NULL));
	(dialog == NULL) ? NULL : (dialog = (g_object_unref (dialog), NULL));
	(entry == NULL) ? NULL : (entry = (g_object_unref (entry), NULL));
}


/**
 * set_font:
 *
 * Set the font for the window.
 */
void xnp_window_set_font (XnpWindow* self) {
	gint page;
	XnpNote* _tmp0_;
	XnpNote* note;
	GtkFontSelectionDialog* dialog;
	gint res;
	g_return_if_fail (self != NULL);
	page = gtk_notebook_get_current_page (self->priv->notebook);
	if (page == (-1)) {
		return;
	}
	_tmp0_ = NULL;
	note = (_tmp0_ = XNP_NOTE (gtk_notebook_get_nth_page (self->priv->notebook, page)), (_tmp0_ == NULL) ? NULL : g_object_ref (_tmp0_));
	dialog = g_object_ref_sink ((GtkFontSelectionDialog*) gtk_font_selection_dialog_new ("Choose current note font"));
	gtk_font_selection_dialog_set_font_name (dialog, xnp_hypertext_view_get_font (note->text_view));
	res = gtk_dialog_run ((GtkDialog*) dialog);
	gtk_widget_hide ((GtkWidget*) dialog);
	if (res == GTK_RESPONSE_OK) {
		xnp_hypertext_view_set_font (note->text_view, gtk_font_selection_dialog_get_font_name (dialog));
	}
	gtk_object_destroy ((GtkObject*) dialog);
	(note == NULL) ? NULL : (note = (g_object_unref (note), NULL));
	(dialog == NULL) ? NULL : (dialog = (g_object_unref (dialog), NULL));
}


/**
 * note_name_exists:
 *
 * Verify if the given name already exists in the notebook.
 */
static gboolean xnp_window_note_name_exists (XnpWindow* self, const char* name) {
	gint n_pages;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (name != NULL, FALSE);
	n_pages = gtk_notebook_get_n_pages (self->priv->notebook);
	{
		gint p;
		p = 0;
		for (; p < n_pages; p++) {
			XnpNote* _tmp0_;
			XnpNote* note;
			_tmp0_ = NULL;
			note = (_tmp0_ = XNP_NOTE (gtk_notebook_get_nth_page (self->priv->notebook, p)), (_tmp0_ == NULL) ? NULL : g_object_ref (_tmp0_));
			if (_vala_strcmp0 (xnp_note_get_name (note), name) == 0) {
				gboolean _tmp1_;
				return (_tmp1_ = TRUE, (note == NULL) ? NULL : (note = (g_object_unref (note), NULL)), _tmp1_);
			}
			(note == NULL) ? NULL : (note = (g_object_unref (note), NULL));
		}
	}
	return FALSE;
}


/**
 * save_notes:
 *
 * Send the save-data signal on every dirty note.
 */
void xnp_window_save_notes (XnpWindow* self) {
	gint n_pages;
	g_return_if_fail (self != NULL);
	n_pages = gtk_notebook_get_n_pages (self->priv->notebook);
	{
		gint p;
		p = 0;
		for (; p < n_pages; p++) {
			XnpNote* _tmp0_;
			XnpNote* note;
			_tmp0_ = NULL;
			note = (_tmp0_ = XNP_NOTE (gtk_notebook_get_nth_page (self->priv->notebook, p)), (_tmp0_ == NULL) ? NULL : g_object_ref (_tmp0_));
			if (xnp_note_get_dirty (note)) {
				xnp_note_set_dirty (note, FALSE);
				g_signal_emit_by_name (self, "save-data", note);
			}
			(note == NULL) ? NULL : (note = (g_object_unref (note), NULL));
		}
	}
}


const char* xnp_window_get_name (XnpWindow* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return self->priv->_name;
}


void xnp_window_set_name (XnpWindow* self, const char* value) {
	char* _tmp2_;
	const char* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp2_ = NULL;
	_tmp1_ = NULL;
	self->priv->_name = (_tmp2_ = (_tmp1_ = value, (_tmp1_ == NULL) ? NULL : g_strdup (_tmp1_)), self->priv->_name = (g_free (self->priv->_name), NULL), _tmp2_);
	g_object_notify ((GObject *) self, "name");
}


gboolean xnp_window_get_above (XnpWindow* self) {
	g_return_val_if_fail (self != NULL, FALSE);
	return self->priv->_above;
}


void xnp_window_set_above (XnpWindow* self, gboolean value) {
	g_return_if_fail (self != NULL);
	self->priv->_above = value;
	gtk_window_set_keep_above ((GtkWindow*) self, value);
	g_object_notify ((GObject *) self, "above");
}


gboolean xnp_window_get_sticky (XnpWindow* self) {
	g_return_val_if_fail (self != NULL, FALSE);
	return self->priv->_sticky;
}


void xnp_window_set_sticky (XnpWindow* self, gboolean value) {
	g_return_if_fail (self != NULL);
	self->priv->_sticky = value;
	if (value == TRUE) {
		gtk_window_stick ((GtkWindow*) self);
	} else {
		gtk_window_unstick ((GtkWindow*) self);
	}
	g_object_notify ((GObject *) self, "sticky");
}


static GObject * xnp_window_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	XnpWindowClass * klass;
	GObjectClass * parent_class;
	XnpWindow * self;
	klass = XNP_WINDOW_CLASS (g_type_class_peek (XNP_TYPE_WINDOW));
	parent_class = G_OBJECT_CLASS (g_type_class_peek_parent (klass));
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = XNP_WINDOW (obj);
	{
		gtk_widget_set_name ((GtkWidget*) GTK_WINDOW (self), "xfce4-notes-plugin");
		gtk_window_set_title ((GtkWindow*) self, _ ("Notes"));
		gtk_window_set_deletable ((GtkWindow*) self, FALSE);
		gtk_window_set_skip_taskbar_hint ((GtkWindow*) self, TRUE);
		g_object_set ((GtkWindow*) self, "default-height", 380, NULL);
		g_object_set ((GtkWindow*) self, "default-width", 300, NULL);
		gtk_window_set_decorated ((GtkWindow*) self, FALSE);
		gtk_window_set_icon_name ((GtkWindow*) self, "xfce4-notes-plugin");
		xnp_window_set_sticky (self, TRUE);
		gtk_window_set_opacity ((GtkWindow*) self, 0.9);
	}
	return obj;
}


static void xnp_window_class_init (XnpWindowClass * klass) {
	xnp_window_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (XnpWindowPrivate));
	G_OBJECT_CLASS (klass)->get_property = xnp_window_get_property;
	G_OBJECT_CLASS (klass)->set_property = xnp_window_set_property;
	G_OBJECT_CLASS (klass)->constructor = xnp_window_constructor;
	G_OBJECT_CLASS (klass)->finalize = xnp_window_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), XNP_WINDOW_NAME, g_param_spec_string ("name", "name", "name", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), XNP_WINDOW_ABOVE, g_param_spec_boolean ("above", "above", "above", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), XNP_WINDOW_STICKY, g_param_spec_boolean ("sticky", "sticky", "sticky", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_signal_new ("action", XNP_TYPE_WINDOW, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__STRING, G_TYPE_NONE, 1, G_TYPE_STRING);
	g_signal_new ("save_data", XNP_TYPE_WINDOW, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, XNP_TYPE_NOTE);
	g_signal_new ("note_inserted", XNP_TYPE_WINDOW, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, XNP_TYPE_NOTE);
	g_signal_new ("note_deleted", XNP_TYPE_WINDOW, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, XNP_TYPE_NOTE);
	g_signal_new ("note_renamed", XNP_TYPE_WINDOW, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__OBJECT_STRING, G_TYPE_NONE, 2, XNP_TYPE_NOTE, G_TYPE_STRING);
}


static void xnp_window_instance_init (XnpWindow * self) {
	const char* _tmp0_;
	self->priv = XNP_WINDOW_GET_PRIVATE (self);
	self->priv->navigation_timeout = (guint) 0;
	self->priv->CORNER_MARGIN = 20;
	self->priv->CURSOR_TOP_LC = gdk_cursor_new (GDK_TOP_LEFT_CORNER);
	self->priv->CURSOR_TOP_RC = gdk_cursor_new (GDK_TOP_RIGHT_CORNER);
	self->priv->CURSOR_BOTTOM_RC = gdk_cursor_new (GDK_BOTTOM_RIGHT_CORNER);
	self->priv->CURSOR_BOTTOM = gdk_cursor_new (GDK_BOTTOM_SIDE);
	self->priv->CURSOR_BOTTOM_LC = gdk_cursor_new (GDK_BOTTOM_LEFT_CORNER);
	self->priv->_name = (_tmp0_ = _ ("Notes"), (_tmp0_ == NULL) ? NULL : g_strdup (_tmp0_));
	_tmp0_ = NULL;
}


static void xnp_window_finalize (GObject* obj) {
	XnpWindow * self;
	self = XNP_WINDOW (obj);
	{
		if (self->priv->navigation_timeout != 0) {
			g_source_remove (self->priv->navigation_timeout);
		}
	}
	(self->priv->menu == NULL) ? NULL : (self->priv->menu = (g_object_unref (self->priv->menu), NULL));
	(self->priv->mi_above == NULL) ? NULL : (self->priv->mi_above = (g_object_unref (self->priv->mi_above), NULL));
	(self->priv->mi_sticky == NULL) ? NULL : (self->priv->mi_sticky = (g_object_unref (self->priv->mi_sticky), NULL));
	(self->priv->title_label == NULL) ? NULL : (self->priv->title_label = (g_object_unref (self->priv->title_label), NULL));
	(self->priv->content_box == NULL) ? NULL : (self->priv->content_box = (g_object_unref (self->priv->content_box), NULL));
	(self->priv->notebook == NULL) ? NULL : (self->priv->notebook = (g_object_unref (self->priv->notebook), NULL));
	(self->priv->navigation_box == NULL) ? NULL : (self->priv->navigation_box = (g_object_unref (self->priv->navigation_box), NULL));
	(self->priv->goleft_box == NULL) ? NULL : (self->priv->goleft_box = (g_object_unref (self->priv->goleft_box), NULL));
	(self->priv->goright_box == NULL) ? NULL : (self->priv->goright_box = (g_object_unref (self->priv->goright_box), NULL));
	(self->priv->ui == NULL) ? NULL : (self->priv->ui = (g_object_unref (self->priv->ui), NULL));
	(self->priv->action_group == NULL) ? NULL : (self->priv->action_group = (g_object_unref (self->priv->action_group), NULL));
	(self->priv->CURSOR_TOP_LC == NULL) ? NULL : (self->priv->CURSOR_TOP_LC = (gdk_cursor_unref (self->priv->CURSOR_TOP_LC), NULL));
	(self->priv->CURSOR_TOP_RC == NULL) ? NULL : (self->priv->CURSOR_TOP_RC = (gdk_cursor_unref (self->priv->CURSOR_TOP_RC), NULL));
	(self->priv->CURSOR_BOTTOM_RC == NULL) ? NULL : (self->priv->CURSOR_BOTTOM_RC = (gdk_cursor_unref (self->priv->CURSOR_BOTTOM_RC), NULL));
	(self->priv->CURSOR_BOTTOM == NULL) ? NULL : (self->priv->CURSOR_BOTTOM = (gdk_cursor_unref (self->priv->CURSOR_BOTTOM), NULL));
	(self->priv->CURSOR_BOTTOM_LC == NULL) ? NULL : (self->priv->CURSOR_BOTTOM_LC = (gdk_cursor_unref (self->priv->CURSOR_BOTTOM_LC), NULL));
	self->priv->_name = (g_free (self->priv->_name), NULL);
	G_OBJECT_CLASS (xnp_window_parent_class)->finalize (obj);
}


GType xnp_window_get_type (void) {
	static GType xnp_window_type_id = 0;
	if (xnp_window_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (XnpWindowClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) xnp_window_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (XnpWindow), 0, (GInstanceInitFunc) xnp_window_instance_init, NULL };
		xnp_window_type_id = g_type_register_static (GTK_TYPE_WINDOW, "XnpWindow", &g_define_type_info, 0);
	}
	return xnp_window_type_id;
}


static void xnp_window_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	XnpWindow * self;
	gpointer boxed;
	self = XNP_WINDOW (object);
	switch (property_id) {
		case XNP_WINDOW_NAME:
		g_value_set_string (value, xnp_window_get_name (self));
		break;
		case XNP_WINDOW_ABOVE:
		g_value_set_boolean (value, xnp_window_get_above (self));
		break;
		case XNP_WINDOW_STICKY:
		g_value_set_boolean (value, xnp_window_get_sticky (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void xnp_window_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	XnpWindow * self;
	self = XNP_WINDOW (object);
	switch (property_id) {
		case XNP_WINDOW_NAME:
		xnp_window_set_name (self, g_value_get_string (value));
		break;
		case XNP_WINDOW_ABOVE:
		xnp_window_set_above (self, g_value_get_boolean (value));
		break;
		case XNP_WINDOW_STICKY:
		xnp_window_set_sticky (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static int _vala_strcmp0 (const char * str1, const char * str2) {
	if (str1 == NULL) {
		return -(str1 != str2);
	}
	if (str2 == NULL) {
		return str1 != str2;
	}
	return strcmp (str1, str2);
}



static void g_cclosure_user_marshal_VOID__OBJECT_STRING (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__OBJECT_STRING) (gpointer data1, gpointer arg_1, const char* arg_2, gpointer data2);
	register GMarshalFunc_VOID__OBJECT_STRING callback;
	register GCClosure * cc;
	register gpointer data1, data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 3);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__OBJECT_STRING) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_object (param_values + 1), g_value_get_string (param_values + 2), data2);
}



