/*
 *  Notes - panel plugin for Xfce Desktop Environment
 *  Copyright (c) 2009  Mike Massonnet <mmassonnet@xfce.org>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301, USA
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <stdlib.h>
#include <string.h>
#include <gdk/gdk.h>


#define XNP_TYPE_NOTE (xnp_note_get_type ())
#define XNP_NOTE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), XNP_TYPE_NOTE, XnpNote))
#define XNP_NOTE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), XNP_TYPE_NOTE, XnpNoteClass))
#define XNP_IS_NOTE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), XNP_TYPE_NOTE))
#define XNP_IS_NOTE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), XNP_TYPE_NOTE))
#define XNP_NOTE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), XNP_TYPE_NOTE, XnpNoteClass))

typedef struct _XnpNote XnpNote;
typedef struct _XnpNoteClass XnpNoteClass;
typedef struct _XnpNotePrivate XnpNotePrivate;

#define XNP_TYPE_HYPERTEXT_VIEW (xnp_hypertext_view_get_type ())
#define XNP_HYPERTEXT_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), XNP_TYPE_HYPERTEXT_VIEW, XnpHypertextView))
#define XNP_HYPERTEXT_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), XNP_TYPE_HYPERTEXT_VIEW, XnpHypertextViewClass))
#define XNP_IS_HYPERTEXT_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), XNP_TYPE_HYPERTEXT_VIEW))
#define XNP_IS_HYPERTEXT_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), XNP_TYPE_HYPERTEXT_VIEW))
#define XNP_HYPERTEXT_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), XNP_TYPE_HYPERTEXT_VIEW, XnpHypertextViewClass))

typedef struct _XnpHypertextView XnpHypertextView;
typedef struct _XnpHypertextViewClass XnpHypertextViewClass;

struct _XnpNote {
	GtkBin parent_instance;
	XnpNotePrivate * priv;
	GtkScrolledWindow* scrolled_window;
	XnpHypertextView* text_view;
};

struct _XnpNoteClass {
	GtkBinClass parent_class;
};

struct _XnpNotePrivate {
	char* _name;
	guint save_timeout;
	gboolean _dirty;
};



GType xnp_note_get_type (void);
GType xnp_hypertext_view_get_type (void);
#define XNP_NOTE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), XNP_TYPE_NOTE, XnpNotePrivate))
enum  {
	XNP_NOTE_DUMMY_PROPERTY,
	XNP_NOTE_NAME,
	XNP_NOTE_DIRTY
};
void xnp_note_set_name (XnpNote* self, const char* value);
XnpHypertextView* xnp_hypertext_view_new (void);
XnpHypertextView* xnp_hypertext_view_construct (GType object_type);
static void xnp_note_buffer_changed_cb (XnpNote* self);
static void _xnp_note_buffer_changed_cb_gtk_text_buffer_changed (GtkTextBuffer* _sender, gpointer self);
XnpNote* xnp_note_new (const char* name);
XnpNote* xnp_note_construct (GType object_type, const char* name);
XnpNote* xnp_note_new (const char* name);
static void xnp_note_real_size_request (GtkWidget* base, GtkRequisition* requisition);
static void xnp_note_real_size_allocate (GtkWidget* base, const GdkRectangle* allocation);
void xnp_note_set_dirty (XnpNote* self, gboolean value);
static gboolean xnp_note_save_cb (XnpNote* self);
const char* xnp_note_get_name (XnpNote* self);
gboolean xnp_note_get_dirty (XnpNote* self);
static gboolean _xnp_note_save_cb_gsource_func (gpointer self);
static gpointer xnp_note_parent_class = NULL;
static void xnp_note_finalize (GObject* obj);
static void xnp_note_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void xnp_note_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);



static void _xnp_note_buffer_changed_cb_gtk_text_buffer_changed (GtkTextBuffer* _sender, gpointer self) {
	xnp_note_buffer_changed_cb (self);
}


XnpNote* xnp_note_construct (GType object_type, const char* name) {
	XnpNote * self;
	GtkScrolledWindow* _tmp0_;
	XnpHypertextView* _tmp1_;
	GtkTextBuffer* _tmp2_;
	GtkTextBuffer* buffer;
	g_return_val_if_fail (name != NULL, NULL);
	self = g_object_newv (object_type, 0, NULL);
	xnp_note_set_name (self, name);
	_tmp0_ = NULL;
	self->scrolled_window = (_tmp0_ = g_object_ref_sink ((GtkScrolledWindow*) gtk_scrolled_window_new (NULL, NULL)), (self->scrolled_window == NULL) ? NULL : (self->scrolled_window = (g_object_unref (self->scrolled_window), NULL)), _tmp0_);
	gtk_scrolled_window_set_policy (self->scrolled_window, GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);
	_tmp1_ = NULL;
	self->text_view = (_tmp1_ = g_object_ref_sink (xnp_hypertext_view_new ()), (self->text_view == NULL) ? NULL : (self->text_view = (g_object_unref (self->text_view), NULL)), _tmp1_);
	gtk_text_view_set_wrap_mode ((GtkTextView*) self->text_view, GTK_WRAP_WORD);
	gtk_text_view_set_left_margin ((GtkTextView*) self->text_view, 2);
	gtk_text_view_set_right_margin ((GtkTextView*) self->text_view, 2);
	gtk_text_view_set_pixels_above_lines ((GtkTextView*) self->text_view, 1);
	gtk_text_view_set_pixels_below_lines ((GtkTextView*) self->text_view, 1);
	gtk_container_add ((GtkContainer*) self->scrolled_window, (GtkWidget*) self->text_view);
	gtk_widget_show_all ((GtkWidget*) self->scrolled_window);
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) self->scrolled_window);
	_tmp2_ = NULL;
	buffer = (_tmp2_ = gtk_text_view_get_buffer ((GtkTextView*) self->text_view), (_tmp2_ == NULL) ? NULL : g_object_ref (_tmp2_));
	g_signal_connect_object (buffer, "changed", (GCallback) _xnp_note_buffer_changed_cb_gtk_text_buffer_changed, self, 0);
	(buffer == NULL) ? NULL : (buffer = (g_object_unref (buffer), NULL));
	return self;
}


XnpNote* xnp_note_new (const char* name) {
	return xnp_note_construct (XNP_TYPE_NOTE, name);
}


static void xnp_note_real_size_request (GtkWidget* base, GtkRequisition* requisition) {
	XnpNote * self;
	GtkRequisition child_requisition = {0};
	gboolean _tmp0_;
	self = (XnpNote*) base;
	_tmp0_ = FALSE;
	if (((GtkBin*) self)->child != NULL) {
		_tmp0_ = (gboolean) (GTK_WIDGET_FLAGS (((GtkBin*) self)->child) & GTK_VISIBLE);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gtk_widget_size_request (((GtkBin*) self)->child, &child_requisition);
		(*requisition) = child_requisition;
	} else {
		(*requisition).width = 0;
		(*requisition).height = 0;
	}
}


static void xnp_note_real_size_allocate (GtkWidget* base, const GdkRectangle* allocation) {
	XnpNote * self;
	gboolean _tmp0_;
	self = (XnpNote*) base;
	((GtkWidget*) self)->allocation = (GtkAllocation) (*allocation);
	_tmp0_ = FALSE;
	if (((GtkBin*) self)->child != NULL) {
		_tmp0_ = (gboolean) (GTK_WIDGET_FLAGS (((GtkBin*) self)->child) & GTK_VISIBLE);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gtk_widget_size_allocate (((GtkBin*) self)->child, &(*allocation));
	}
}


/*
 * Signal callbacks
 
*
 * buffer_changed_cb:
 *
 * Reset the save_timeout as long as the buffer is under constant
 * changes and send the save-data signal.
 */
static void xnp_note_buffer_changed_cb (XnpNote* self) {
	g_return_if_fail (self != NULL);
	xnp_note_set_dirty (self, TRUE);
}


/**
 * save_cb:
 *
 * Send save-data signal.
 */
static gboolean xnp_note_save_cb (XnpNote* self) {
	g_return_val_if_fail (self != NULL, FALSE);
	g_signal_emit_by_name (self, "save-data");
	self->priv->save_timeout = (guint) 0;
	self->priv->_dirty = FALSE;
	return FALSE;
}


const char* xnp_note_get_name (XnpNote* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return self->priv->_name;
}


void xnp_note_set_name (XnpNote* self, const char* value) {
	char* _tmp2_;
	const char* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp2_ = NULL;
	_tmp1_ = NULL;
	self->priv->_name = (_tmp2_ = (_tmp1_ = value, (_tmp1_ == NULL) ? NULL : g_strdup (_tmp1_)), self->priv->_name = (g_free (self->priv->_name), NULL), _tmp2_);
	g_object_notify ((GObject *) self, "name");
}


gboolean xnp_note_get_dirty (XnpNote* self) {
	g_return_val_if_fail (self != NULL, FALSE);
	return self->priv->_dirty;
}


static gboolean _xnp_note_save_cb_gsource_func (gpointer self) {
	return xnp_note_save_cb (self);
}


void xnp_note_set_dirty (XnpNote* self, gboolean value) {
	g_return_if_fail (self != NULL);
	self->priv->_dirty = value;
	if (self->priv->save_timeout > 0) {
		g_source_remove (self->priv->save_timeout);
	}
	if (value == FALSE) {
		self->priv->save_timeout = (guint) 0;
	} else {
		self->priv->save_timeout = g_timeout_add_seconds ((guint) 60, _xnp_note_save_cb_gsource_func, self);
	}
	g_object_notify ((GObject *) self, "dirty");
}


static void xnp_note_class_init (XnpNoteClass * klass) {
	xnp_note_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (XnpNotePrivate));
	GTK_WIDGET_CLASS (klass)->size_request = xnp_note_real_size_request;
	GTK_WIDGET_CLASS (klass)->size_allocate = xnp_note_real_size_allocate;
	G_OBJECT_CLASS (klass)->get_property = xnp_note_get_property;
	G_OBJECT_CLASS (klass)->set_property = xnp_note_set_property;
	G_OBJECT_CLASS (klass)->finalize = xnp_note_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), XNP_NOTE_NAME, g_param_spec_string ("name", "name", "name", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), XNP_NOTE_DIRTY, g_param_spec_boolean ("dirty", "dirty", "dirty", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_signal_new ("save_data", XNP_TYPE_NOTE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}


static void xnp_note_instance_init (XnpNote * self) {
	self->priv = XNP_NOTE_GET_PRIVATE (self);
}


static void xnp_note_finalize (GObject* obj) {
	XnpNote * self;
	self = XNP_NOTE (obj);
	{
		xnp_note_set_dirty (self, FALSE);
	}
	(self->scrolled_window == NULL) ? NULL : (self->scrolled_window = (g_object_unref (self->scrolled_window), NULL));
	(self->text_view == NULL) ? NULL : (self->text_view = (g_object_unref (self->text_view), NULL));
	self->priv->_name = (g_free (self->priv->_name), NULL);
	G_OBJECT_CLASS (xnp_note_parent_class)->finalize (obj);
}


GType xnp_note_get_type (void) {
	static GType xnp_note_type_id = 0;
	if (xnp_note_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (XnpNoteClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) xnp_note_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (XnpNote), 0, (GInstanceInitFunc) xnp_note_instance_init, NULL };
		xnp_note_type_id = g_type_register_static (GTK_TYPE_BIN, "XnpNote", &g_define_type_info, 0);
	}
	return xnp_note_type_id;
}


static void xnp_note_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	XnpNote * self;
	gpointer boxed;
	self = XNP_NOTE (object);
	switch (property_id) {
		case XNP_NOTE_NAME:
		g_value_set_string (value, xnp_note_get_name (self));
		break;
		case XNP_NOTE_DIRTY:
		g_value_set_boolean (value, xnp_note_get_dirty (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void xnp_note_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	XnpNote * self;
	self = XNP_NOTE (object);
	switch (property_id) {
		case XNP_NOTE_NAME:
		xnp_note_set_name (self, g_value_get_string (value));
		break;
		case XNP_NOTE_DIRTY:
		xnp_note_set_dirty (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}




