/*  XFC: Xfce Foundation Classes (User Interface Library)
 *  Copyright (C) 2004 The XFC Development Team.
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 */

/// @file xfc/gtk/gtk.hh
/// @brief Main Gtk header file
///
/// This header file includes all the Gtk header files. You can safely include
/// this header file only, with minimal extra overhead, because each header file
/// uses include guards to prevent multiple inclusions.

#ifndef XFC_GTK_HH
#define XFC_GTK_HH

#include <xfc/gtk/accellabel.hh>
#include <xfc/gtk/accelmap.hh>
#include <xfc/gtk/accessible.hh>
#include <xfc/gtk/alignment.hh>
#include <xfc/gtk/arrow.hh>
#include <xfc/gtk/aspectframe.hh>
#include <xfc/gtk/buttonbox.hh>
#include <xfc/gtk/calendar.hh>
#include <xfc/gtk/clipboard.hh>
#include <xfc/gtk/colorbutton.hh>
#include <xfc/gtk/colorselection.hh>
#include <xfc/gtk/comboboxentry.hh>
#include <xfc/gtk/curve.hh>
#include <xfc/gtk/entrycompletion.hh>
#include <xfc/gtk/eventbox.hh>
#include <xfc/gtk/expander.hh>
#include <xfc/gtk/filechooserdialog.hh>
#include <xfc/gtk/filechooserwidget.hh>
#include <xfc/gtk/fixed.hh>
#include <xfc/gtk/fontbutton.hh>
#include <xfc/gtk/fontselection.hh>
#include <xfc/gtk/gammacurve.hh>
#include <xfc/gtk/gc.hh>
#include <xfc/gtk/handlebox.hh>
#include <xfc/gtk/iconfactory.hh>
#include <xfc/gtk/icontheme.hh>
#include <xfc/gtk/image.hh>
#include <xfc/gtk/imagemenuitem.hh>
#include <xfc/gtk/invisible.hh>
#include <xfc/gtk/item.hh>
#include <xfc/gtk/layout.hh>
#include <xfc/gtk/liststore.hh>
#include <xfc/gtk/menu.hh>
#include <xfc/gtk/menubar.hh>
#include <xfc/gtk/messagedialog.hh>
#include <xfc/gtk/notebook.hh>
#include <xfc/gtk/paned.hh>
#include <xfc/gtk/plug.hh>
#include <xfc/gtk/progressbar.hh>
#include <xfc/gtk/radiobutton.hh>
#include <xfc/gtk/radiomenuitem.hh>
#include <xfc/gtk/rc.hh>
#include <xfc/gtk/ruler.hh>
#include <xfc/gtk/scale.hh>
#include <xfc/gtk/scrollbar.hh>
#include <xfc/gtk/scrolledwindow.hh>
#include <xfc/gtk/selection.hh>
#include <xfc/gtk/separator.hh>
#include <xfc/gtk/separatormenuitem.hh>
#include <xfc/gtk/settings.hh>
#include <xfc/gtk/sizegroup.hh>
#include <xfc/gtk/socket.hh>
#include <xfc/gtk/spinbutton.hh>
#include <xfc/gtk/statusbar.hh>
#include <xfc/gtk/stock.hh>
#include <xfc/gtk/style.hh>
#include <xfc/gtk/table.hh>
#include <xfc/gtk/tearoffmenuitem.hh>
#include <xfc/gtk/textview.hh>
#include <xfc/gtk/toolbar.hh>
#include <xfc/gtk/tooltips.hh>
#include <xfc/gtk/treemodelsort.hh>
#include <xfc/gtk/treestore.hh>
#include <xfc/gtk/treeview.hh>
#include <xfc/gtk/uimanager.hh>
#include <xfc/gtk/viewport.hh>

#endif // XFC_GTK_HH

