/*  XFC: Xfce Foundation Classes (User Interface Library)
 *  Copyright (C) 2004-2005 The XFC Development Team.
 *
 *  keymapsignals.cc - Gdk::Keymap virtual signal handlers
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
 
#include "keymap.hh"
#include "keymapsignals.hh"
#include "private/keymapclass.hh"

using namespace Xfc;

/*  Gdk::KeymapSignals
 */

Gdk::KeymapSignals::KeymapSignals(Keymap *keymap)
: G::ObjectSignals(keymap)
{
}

Gdk::KeymapSignals::~KeymapSignals()
{
}

void
Gdk::KeymapSignals::on_direction_changed()
{
	GdkKeymapClass *g_class = KeymapClass::get_parent_class(instance_);
	if (g_class && g_class->direction_changed)
		g_class->direction_changed((GdkKeymap*)instance_);
}

void
Gdk::KeymapSignals::on_keys_changed()
{
	GdkKeymapClass *g_class = KeymapClass::get_parent_class(instance_);
	if (g_class && g_class->keys_changed)
		g_class->keys_changed((GdkKeymap*)instance_);
}

