/*
  Utility function to make sure stuff gets written properly.
 
  Copyright (C) 2010 Federico Heinz <fheinz@vialibre.org.ar>

  This program is free software: you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation, either version 3 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <stdio.h>
#include <errno.h>
#include "do_write.h"

int do_write(void *p, unsigned int len) {
	unsigned int written = 0;
	
	while (written < len) {
		int n = fwrite(p+written, 1, len-written, stdout);
		if (n < 0) return errno;
		written += n;
	}
	return 0;
}

