# - Try to find Calligra Libraries
# Once done this will define
#
#  CALLIGRALIBS_FOUND - system has Calligra
#  CALLIGRALIBS_INCLUDE_DIR - the Calligra include directory
# KOMAIN_LIBRARY
# KOTEXT_LIBRARY
# KOODF_LIBRARY
# KOPAGEAPP_LIBRARY
# KOKROSS_LIBRARY
# FLAKE_LIBRARY
# KOWIDGETS_LIBRARY
# PIGMENTCMS_LIBRARY
# Redistribution and use is allowed according to the terms of the BSD license.
# For details see the accompanying COPYING-CMAKE-SCRIPTS file.
#

find_package(KDE4 REQUIRED)

if ( CALLIGRALIBS_INCLUDE_DIR AND CALLIGRALIBS_LIBRARIES )
   # in cache already
   SET( CALLIGRALIBS_FIND_QUIETLY TRUE )
endif ( CALLIGRALIBS_INCLUDE_DIR AND CALLIGRALIBS_LIBRARIES )

FIND_PATH( CALLIGRALIBS_INCLUDE_DIR NAMES KoDocument.h)# HINTS ${CMAKE_INSTALL_PREFIX}/include)

FIND_LIBRARY(KOMAIN_LIBRARY NAMES komain)
FIND_LIBRARY(KOTEXT_LIBRARY NAMES kotext)
FIND_LIBRARY(KOPLUGIN_LIBRARY NAMES koplugin)
FIND_LIBRARY(KOODF_LIBRARY NAMES koodf)
FIND_LIBRARY(KOPAGEAPP_LIBRARY NAMES kopageapp)
FIND_LIBRARY(KOKROSS_LIBRARY NAMES kokross)
FIND_LIBRARY(FLAKE_LIBRARY NAMES flake)
FIND_LIBRARY(PIGMENTCMS_LIBRARY NAMES pigmentcms)
FIND_LIBRARY(KOWIDGETS_LIBRARY NAMES kowidgets)

#following are the LIBS with dependencies fulfilled (naming scheme recycled from kde)

SET (KOODF_LIBS
    ${KDE4_KIO_LIBS}
    ${KOPLUGIN_LIBRARY}
    ${KOODF_LIBRARY}
)

SET (PIGMENTCMS_LIBS
    ${PIGMENTCMS_LIBRARY}
    ${KOPLUGIN_LIBRARY}
    ${QT_QTXML_LIBRARY} ${QT_QTGUI_LIBRARY}
)

SET (FLAKE_LIBS
    ${FLAKE_LIBRARY}
    ${PIGMENTCMS_LIBS}
    ${KOODF_LIBS}
)

SET (KOTEXT_LIBS
    ${KOTEXT_LIBRARY}
    ${FLAKE_LIBS}
)

SET (KOWIDGETS_LIBS
    ${KOTEXT_LIBS}
    ${PIGMENTCMS_LIBS}
    ${KDE4_KDEUI_LIBS}
)

SET (KOMAIN_LIBS
    ${KOMAIN_LIBRARY}
    ${KOTEXT_LIBS}
    ${KOWIDGETS_LIBS}
    ${KDE4_KPARTS_LIBS}
)

# legacy;
SET( CALLIGRACORE_LIBRARIES
    ${KOODF_LIBRARY}
    ${FLAKE_LIBRARY}
    ${KOTEXT_LIBRARY}
    ${KOPAGEAPP_LIBRARY}
    ${KOPLUGIN_LIBRARY}
    ${KOMAIN_LIBRARY}
)
# legacy;
SET( CALLIGRALIBS_LIBRARIES
    ${KOKROSS_LIBRARY}
    ${PIGMENTCMS_LIBRARY}
    ${KOWIDGETS_LIBRARY}
)

# these are defined inside of Calligra, so lets define them for people using calligra too
set(KOPLUGIN_INCLUDES ${CALLIGRALIBS_INCLUDE_DIR})
set(KOODF_INCLUDES ${CALLIGRALIBS_INCLUDE_DIR})
set(PIGMENT_INCLUDES ${CALLIGRALIBS_INCLUDE_DIR})
set(FLAKE_INCLUDES ${CALLIGRALIBS_INCLUDE_DIR})
set(KOTEXT_INCLUDES ${CALLIGRALIBS_INCLUDE_DIR})
set(KOMAIN_INCLUDES ${CALLIGRALIBS_INCLUDE_DIR})

set(WORDS_INCLUDES ${CALLIGRALIBS_INCLUDE_DIR}/words)
set(STAGE_INCLUDES ${CALLIGRALIBS_INCLUDE_DIR}/stage)
set(TABLES_INCLUDES ${CALLIGRALIBS_INCLUDE_DIR}/tables)

include( FindPackageHandleStandardArgs )

FIND_PACKAGE_HANDLE_STANDARD_ARGS( CalligraLibs DEFAULT_MSG CALLIGRALIBS_INCLUDE_DIR CALLIGRACORE_LIBRARIES )

# show the CALLIGRALIBS_INCLUDE_DIR and CALLIGRALIBS_LIBRARIES variables only in the advanced view
MARK_AS_ADVANCED(CALLIGRALIBS_INCLUDE_DIR
    KOMAIN_LIBRARY
    KOTEXT_LIBRARY
    KOPLUGIN_LIBRARY
    KOODF_LIBRARY
    KOPAGEAPP_LIBRARY
    KOKROSS_LIBRARY
    FLAKE_LIBRARY
    KOWIDGETS_LIBRARY
    PIGMENTCMS_LIBRARY
    CALLIGRALIBS_LIBRARIES )

# define the generic version of the Calligra libraries here
# this makes it easy to advance it when the next Calligra release comes
set(GENERIC_CALLIGRA_LIB_VERSION "9.0.0")
set(GENERIC_CALLIGRA_LIB_SOVERSION "9")
