# For the Marvell units (and probably many other
# embedded headless ARM devices) we want to open a serial login 
# on ttyS0.
# Actually the 'pcansi' is the most feature rich (works with 'dialog')
# which the Slackware curses-based menus use) terminal type I've
# seen so far, but vt100 is more standard.
#
# egrep -q "Marvell" /proc/cpuinfo > /dev/null 2>&1 && \
# Just add this in anyway regardless of which device we find ourselves on.
# Each ARM device tends to be configurable from u-boot which is accessed via serial.
# If anybody thinks this is a security hole, don't plug in a serial cable.
#
# QEMU uses ttyAMA0 and init will error with a "s0 respawning too fast" message if
# we use ttyS0, so we'll accomodate this, and for all others we'll use ttyS0.
egrep -q "Versatile" /proc/cpuinfo > /dev/null 2>&1 && \
sed -i '/^# Local serial lines:/ a\s0:12345:respawn:/sbin/agetty 115200 ttyAMA0 vt100' etc/inittab.new || \
sed -i '/^# Local serial lines:/ a\s0:12345:respawn:/sbin/agetty 115200 ttyS0 vt100' etc/inittab.new

config() {
  NEW="$1"
  OLD="`dirname $NEW`/`basename $NEW .new`"
  # If there's no config file by that name, mv it over:
  if [ ! -r $OLD ]; then
    mv $NEW $OLD
  elif [ "`cat $OLD | md5sum`" = "`cat $NEW | md5sum`" ]; then # toss the redundant copy
    rm $NEW
  fi
  # Otherwise, we leave the .new copy for the admin to consider...
}
# Slackware scripts
config etc/inittab.new
config etc/rc.d/rc.4.new
config etc/rc.d/rc.6.new
config etc/rc.d/rc.K.new
config etc/rc.d/rc.M.new
config etc/rc.d/rc.S.new
config etc/rc.d/rc.local.new
config etc/rc.d/rc.loop.new
config etc/rc.d/rc.sysvinit.new

( cd etc/rc.d ; rm -rf rc.0 )
( cd etc/rc.d ; ln -sf rc.6 rc.0 )

