/*
 * DO NOT EDIT.  THIS FILE IS GENERATED FROM nsISmtpService.idl
 */

#ifndef __gen_nsISmtpService_h__
#define __gen_nsISmtpService_h__


#ifndef __gen_nsISupports_h__
#include "nsISupports.h"
#endif

/* For IDL files that don't want to include root IDL files. */
#ifndef NS_NO_VTABLE
#define NS_NO_VTABLE
#endif
class nsISmtpServer; /* forward declaration */

class nsIURI; /* forward declaration */

class nsIUrlListener; /* forward declaration */

class nsIMsgIdentity; /* forward declaration */

class nsIInterfaceRequestor; /* forward declaration */

class nsIFile; /* forward declaration */

class nsIMsgStatusFeedback; /* forward declaration */

class nsIRequest; /* forward declaration */

class nsISimpleEnumerator; /* forward declaration */

class nsIMsgWindow; /* forward declaration */


/* starting interface:    nsISmtpService */
#define NS_ISMTPSERVICE_IID_STR "8c5c5d5b-3b69-4a80-bf4b-d6c22865a3c3"

#define NS_ISMTPSERVICE_IID \
  {0x8c5c5d5b, 0x3b69, 0x4a80, \
    { 0xbf, 0x4b, 0xd6, 0xc2, 0x28, 0x65, 0xa3, 0xc3 }}

class NS_NO_VTABLE NS_SCRIPTABLE nsISmtpService : public nsISupports {
 public: 

  NS_DECLARE_STATIC_IID_ACCESSOR(NS_ISMTPSERVICE_IID)

  /**
   * Sends a mail message via the given parameters. This function builds an
   * SMTP URL and makes an SMTP connection, and then runs the url.
   * The SMTP server defined
   * in the aSenderIdentity object (see nsIMsgIdentity) will be used to send
   * the message. If there is no SMTP server defined in aSenderIdentity, the
   * default SMTP server will be used.
   *
   * @note The file to send must be in the format specified by RFC 2822 for
   *       sending data. This includes having the correct CRLF line endings
   *       throughout the file, and the <CRLF>.<CRLF> at the end of the file.
   *       sendMailMessage does no processing/additions on the file.
   *
   * @param aFilePath               The file to send.
   * @param aRecipients             A comma delimited list of recipients.
   * @param aSenderIdentity         The identity of the sender.
   * @param aPassword               Pass this in to prevent a dialog if the
   *                                password is needed for secure transmission.
   * @param aUrlListener            A listener to listen to the URL being run,
   *                                this parameter may be null.
   * @param aStatusListener         A feedback listener for slightly different
   *                                feedback on the message send status. This
   *                                parameter may be null.
   * @param aNotificationCallbacks  More notification callbacks
   * @param aRequestDSN             Pass true to request Delivery Status
   *                                Notification.
   * @param aURL                    Provides a handle on the running url. You
   *                                can later interrupt the action by asking the
   *                                netlib service manager to interrupt the url
   *                                you are given back. This parameter may be
   *                                null.
   * @param aRequest                Provides a handle to the running request.
   *                                This parameter may be null.
   */
  /* void sendMailMessage (in nsIFile aFilePath, in string aRecipients, in nsIMsgIdentity aSenderIdentity, in string aPassword, in nsIUrlListener aUrlListener, in nsIMsgStatusFeedback aStatusListener, in nsIInterfaceRequestor aNotificationCallbacks, in boolean aRequestDSN, out nsIURI aURL, out nsIRequest aRequest); */
  NS_SCRIPTABLE NS_IMETHOD SendMailMessage(nsIFile *aFilePath, const char *aRecipients, nsIMsgIdentity *aSenderIdentity, const char *aPassword, nsIUrlListener *aUrlListener, nsIMsgStatusFeedback *aStatusListener, nsIInterfaceRequestor *aNotificationCallbacks, PRBool aRequestDSN, nsIURI **aURL NS_OUTPARAM, nsIRequest **aRequest NS_OUTPARAM) = 0;

  /**
   * Verifies that we can logon to the server with given password
   *
   * @param  aSmtpServer       Server to try to logon to.
   * @param  aUrlListener      Listener that will get notified whether logon
   *                           was successful or not.
   * @param aMsgWindow         nsIMsgWindow to use for notification callbacks.
   * @return - the url that we run.
   */
  /* nsIURI verifyLogon (in nsISmtpServer aServer, in nsIUrlListener aListener, in nsIMsgWindow aMsgWindow); */
  NS_SCRIPTABLE NS_IMETHOD VerifyLogon(nsISmtpServer *aServer, nsIUrlListener *aListener, nsIMsgWindow *aMsgWindow, nsIURI **_retval NS_OUTPARAM) = 0;

  /**
   * Return the SMTP server that is associated with an identity.
   */
  /* void GetSmtpServerByIdentity (in nsIMsgIdentity aSenderIdentity, out nsISmtpServer aServer); */
  NS_SCRIPTABLE NS_IMETHOD GetSmtpServerByIdentity(nsIMsgIdentity *aSenderIdentity, nsISmtpServer **aServer NS_OUTPARAM) = 0;

  /**
   * A copy of the array of SMTP servers, as stored in the preferences
   */
  /* readonly attribute nsISimpleEnumerator smtpServers; */
  NS_SCRIPTABLE NS_IMETHOD GetSmtpServers(nsISimpleEnumerator **aSmtpServers) = 0;

  /**
   * The default server, across sessions of the app
   * (eventually there will be a session default which does not
   * persist past shutdown)
   */
  /* attribute nsISmtpServer defaultServer; */
  NS_SCRIPTABLE NS_IMETHOD GetDefaultServer(nsISmtpServer **aDefaultServer) = 0;
  NS_SCRIPTABLE NS_IMETHOD SetDefaultServer(nsISmtpServer *aDefaultServer) = 0;

  /**
   * The "session default" server - this is never saved, and only used
   * for the current session. Always falls back to the default server
   * unless explicitly set.
   */
  /* attribute nsISmtpServer sessionDefaultServer; */
  NS_SCRIPTABLE NS_IMETHOD GetSessionDefaultServer(nsISmtpServer **aSessionDefaultServer) = 0;
  NS_SCRIPTABLE NS_IMETHOD SetSessionDefaultServer(nsISmtpServer *aSessionDefaultServer) = 0;

  /**
   * Create a new SMTP server.
   * Use this instead of createInstance(), so that the SMTP Service can
   * be aware of this server
   */
  /* nsISmtpServer createSmtpServer (); */
  NS_SCRIPTABLE NS_IMETHOD CreateSmtpServer(nsISmtpServer **_retval NS_OUTPARAM) = 0;

  /**
   * Find the first server with the given hostname and/or username.
   * Note: if either username or hostname is empty, then that parameter will
   * not be used in the matching process.
   * @param username  the username for the server
   * @param hostname  the hostname of the server
   * @returns         null if no server is found
   */
  /* nsISmtpServer findServer (in string username, in string hostname); */
  NS_SCRIPTABLE NS_IMETHOD FindServer(const char *username, const char *hostname, nsISmtpServer **_retval NS_OUTPARAM) = 0;

  /**
   * Look up the server with the given key
   * If the server does not exist, create it and add it to our list
   */
  /* nsISmtpServer getServerByKey (in string key); */
  NS_SCRIPTABLE NS_IMETHOD GetServerByKey(const char *key, nsISmtpServer **_retval NS_OUTPARAM) = 0;

  /**
   * Delete the given server from the server list - does nothing if the server
   * does not exist
   * @param server   the server to delete. Use findServer() if you only know
   *                 the hostname
   */
  /* void deleteSmtpServer (in nsISmtpServer server); */
  NS_SCRIPTABLE NS_IMETHOD DeleteSmtpServer(nsISmtpServer *server) = 0;

};

  NS_DEFINE_STATIC_IID_ACCESSOR(nsISmtpService, NS_ISMTPSERVICE_IID)

/* Use this macro when declaring classes that implement this interface. */
#define NS_DECL_NSISMTPSERVICE \
  NS_SCRIPTABLE NS_IMETHOD SendMailMessage(nsIFile *aFilePath, const char *aRecipients, nsIMsgIdentity *aSenderIdentity, const char *aPassword, nsIUrlListener *aUrlListener, nsIMsgStatusFeedback *aStatusListener, nsIInterfaceRequestor *aNotificationCallbacks, PRBool aRequestDSN, nsIURI **aURL NS_OUTPARAM, nsIRequest **aRequest NS_OUTPARAM); \
  NS_SCRIPTABLE NS_IMETHOD VerifyLogon(nsISmtpServer *aServer, nsIUrlListener *aListener, nsIMsgWindow *aMsgWindow, nsIURI **_retval NS_OUTPARAM); \
  NS_SCRIPTABLE NS_IMETHOD GetSmtpServerByIdentity(nsIMsgIdentity *aSenderIdentity, nsISmtpServer **aServer NS_OUTPARAM); \
  NS_SCRIPTABLE NS_IMETHOD GetSmtpServers(nsISimpleEnumerator **aSmtpServers); \
  NS_SCRIPTABLE NS_IMETHOD GetDefaultServer(nsISmtpServer **aDefaultServer); \
  NS_SCRIPTABLE NS_IMETHOD SetDefaultServer(nsISmtpServer *aDefaultServer); \
  NS_SCRIPTABLE NS_IMETHOD GetSessionDefaultServer(nsISmtpServer **aSessionDefaultServer); \
  NS_SCRIPTABLE NS_IMETHOD SetSessionDefaultServer(nsISmtpServer *aSessionDefaultServer); \
  NS_SCRIPTABLE NS_IMETHOD CreateSmtpServer(nsISmtpServer **_retval NS_OUTPARAM); \
  NS_SCRIPTABLE NS_IMETHOD FindServer(const char *username, const char *hostname, nsISmtpServer **_retval NS_OUTPARAM); \
  NS_SCRIPTABLE NS_IMETHOD GetServerByKey(const char *key, nsISmtpServer **_retval NS_OUTPARAM); \
  NS_SCRIPTABLE NS_IMETHOD DeleteSmtpServer(nsISmtpServer *server); 

/* Use this macro to declare functions that forward the behavior of this interface to another object. */
#define NS_FORWARD_NSISMTPSERVICE(_to) \
  NS_SCRIPTABLE NS_IMETHOD SendMailMessage(nsIFile *aFilePath, const char *aRecipients, nsIMsgIdentity *aSenderIdentity, const char *aPassword, nsIUrlListener *aUrlListener, nsIMsgStatusFeedback *aStatusListener, nsIInterfaceRequestor *aNotificationCallbacks, PRBool aRequestDSN, nsIURI **aURL NS_OUTPARAM, nsIRequest **aRequest NS_OUTPARAM) { return _to SendMailMessage(aFilePath, aRecipients, aSenderIdentity, aPassword, aUrlListener, aStatusListener, aNotificationCallbacks, aRequestDSN, aURL, aRequest); } \
  NS_SCRIPTABLE NS_IMETHOD VerifyLogon(nsISmtpServer *aServer, nsIUrlListener *aListener, nsIMsgWindow *aMsgWindow, nsIURI **_retval NS_OUTPARAM) { return _to VerifyLogon(aServer, aListener, aMsgWindow, _retval); } \
  NS_SCRIPTABLE NS_IMETHOD GetSmtpServerByIdentity(nsIMsgIdentity *aSenderIdentity, nsISmtpServer **aServer NS_OUTPARAM) { return _to GetSmtpServerByIdentity(aSenderIdentity, aServer); } \
  NS_SCRIPTABLE NS_IMETHOD GetSmtpServers(nsISimpleEnumerator **aSmtpServers) { return _to GetSmtpServers(aSmtpServers); } \
  NS_SCRIPTABLE NS_IMETHOD GetDefaultServer(nsISmtpServer **aDefaultServer) { return _to GetDefaultServer(aDefaultServer); } \
  NS_SCRIPTABLE NS_IMETHOD SetDefaultServer(nsISmtpServer *aDefaultServer) { return _to SetDefaultServer(aDefaultServer); } \
  NS_SCRIPTABLE NS_IMETHOD GetSessionDefaultServer(nsISmtpServer **aSessionDefaultServer) { return _to GetSessionDefaultServer(aSessionDefaultServer); } \
  NS_SCRIPTABLE NS_IMETHOD SetSessionDefaultServer(nsISmtpServer *aSessionDefaultServer) { return _to SetSessionDefaultServer(aSessionDefaultServer); } \
  NS_SCRIPTABLE NS_IMETHOD CreateSmtpServer(nsISmtpServer **_retval NS_OUTPARAM) { return _to CreateSmtpServer(_retval); } \
  NS_SCRIPTABLE NS_IMETHOD FindServer(const char *username, const char *hostname, nsISmtpServer **_retval NS_OUTPARAM) { return _to FindServer(username, hostname, _retval); } \
  NS_SCRIPTABLE NS_IMETHOD GetServerByKey(const char *key, nsISmtpServer **_retval NS_OUTPARAM) { return _to GetServerByKey(key, _retval); } \
  NS_SCRIPTABLE NS_IMETHOD DeleteSmtpServer(nsISmtpServer *server) { return _to DeleteSmtpServer(server); } 

/* Use this macro to declare functions that forward the behavior of this interface to another object in a safe way. */
#define NS_FORWARD_SAFE_NSISMTPSERVICE(_to) \
  NS_SCRIPTABLE NS_IMETHOD SendMailMessage(nsIFile *aFilePath, const char *aRecipients, nsIMsgIdentity *aSenderIdentity, const char *aPassword, nsIUrlListener *aUrlListener, nsIMsgStatusFeedback *aStatusListener, nsIInterfaceRequestor *aNotificationCallbacks, PRBool aRequestDSN, nsIURI **aURL NS_OUTPARAM, nsIRequest **aRequest NS_OUTPARAM) { return !_to ? NS_ERROR_NULL_POINTER : _to->SendMailMessage(aFilePath, aRecipients, aSenderIdentity, aPassword, aUrlListener, aStatusListener, aNotificationCallbacks, aRequestDSN, aURL, aRequest); } \
  NS_SCRIPTABLE NS_IMETHOD VerifyLogon(nsISmtpServer *aServer, nsIUrlListener *aListener, nsIMsgWindow *aMsgWindow, nsIURI **_retval NS_OUTPARAM) { return !_to ? NS_ERROR_NULL_POINTER : _to->VerifyLogon(aServer, aListener, aMsgWindow, _retval); } \
  NS_SCRIPTABLE NS_IMETHOD GetSmtpServerByIdentity(nsIMsgIdentity *aSenderIdentity, nsISmtpServer **aServer NS_OUTPARAM) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetSmtpServerByIdentity(aSenderIdentity, aServer); } \
  NS_SCRIPTABLE NS_IMETHOD GetSmtpServers(nsISimpleEnumerator **aSmtpServers) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetSmtpServers(aSmtpServers); } \
  NS_SCRIPTABLE NS_IMETHOD GetDefaultServer(nsISmtpServer **aDefaultServer) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetDefaultServer(aDefaultServer); } \
  NS_SCRIPTABLE NS_IMETHOD SetDefaultServer(nsISmtpServer *aDefaultServer) { return !_to ? NS_ERROR_NULL_POINTER : _to->SetDefaultServer(aDefaultServer); } \
  NS_SCRIPTABLE NS_IMETHOD GetSessionDefaultServer(nsISmtpServer **aSessionDefaultServer) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetSessionDefaultServer(aSessionDefaultServer); } \
  NS_SCRIPTABLE NS_IMETHOD SetSessionDefaultServer(nsISmtpServer *aSessionDefaultServer) { return !_to ? NS_ERROR_NULL_POINTER : _to->SetSessionDefaultServer(aSessionDefaultServer); } \
  NS_SCRIPTABLE NS_IMETHOD CreateSmtpServer(nsISmtpServer **_retval NS_OUTPARAM) { return !_to ? NS_ERROR_NULL_POINTER : _to->CreateSmtpServer(_retval); } \
  NS_SCRIPTABLE NS_IMETHOD FindServer(const char *username, const char *hostname, nsISmtpServer **_retval NS_OUTPARAM) { return !_to ? NS_ERROR_NULL_POINTER : _to->FindServer(username, hostname, _retval); } \
  NS_SCRIPTABLE NS_IMETHOD GetServerByKey(const char *key, nsISmtpServer **_retval NS_OUTPARAM) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetServerByKey(key, _retval); } \
  NS_SCRIPTABLE NS_IMETHOD DeleteSmtpServer(nsISmtpServer *server) { return !_to ? NS_ERROR_NULL_POINTER : _to->DeleteSmtpServer(server); } 

#if 0
/* Use the code below as a template for the implementation class for this interface. */

/* Header file */
class nsSmtpService : public nsISmtpService
{
public:
  NS_DECL_ISUPPORTS
  NS_DECL_NSISMTPSERVICE

  nsSmtpService();

private:
  ~nsSmtpService();

protected:
  /* additional members */
};

/* Implementation file */
NS_IMPL_ISUPPORTS1(nsSmtpService, nsISmtpService)

nsSmtpService::nsSmtpService()
{
  /* member initializers and constructor code */
}

nsSmtpService::~nsSmtpService()
{
  /* destructor code */
}

/* void sendMailMessage (in nsIFile aFilePath, in string aRecipients, in nsIMsgIdentity aSenderIdentity, in string aPassword, in nsIUrlListener aUrlListener, in nsIMsgStatusFeedback aStatusListener, in nsIInterfaceRequestor aNotificationCallbacks, in boolean aRequestDSN, out nsIURI aURL, out nsIRequest aRequest); */
NS_IMETHODIMP nsSmtpService::SendMailMessage(nsIFile *aFilePath, const char *aRecipients, nsIMsgIdentity *aSenderIdentity, const char *aPassword, nsIUrlListener *aUrlListener, nsIMsgStatusFeedback *aStatusListener, nsIInterfaceRequestor *aNotificationCallbacks, PRBool aRequestDSN, nsIURI **aURL NS_OUTPARAM, nsIRequest **aRequest NS_OUTPARAM)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* nsIURI verifyLogon (in nsISmtpServer aServer, in nsIUrlListener aListener, in nsIMsgWindow aMsgWindow); */
NS_IMETHODIMP nsSmtpService::VerifyLogon(nsISmtpServer *aServer, nsIUrlListener *aListener, nsIMsgWindow *aMsgWindow, nsIURI **_retval NS_OUTPARAM)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void GetSmtpServerByIdentity (in nsIMsgIdentity aSenderIdentity, out nsISmtpServer aServer); */
NS_IMETHODIMP nsSmtpService::GetSmtpServerByIdentity(nsIMsgIdentity *aSenderIdentity, nsISmtpServer **aServer NS_OUTPARAM)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* readonly attribute nsISimpleEnumerator smtpServers; */
NS_IMETHODIMP nsSmtpService::GetSmtpServers(nsISimpleEnumerator **aSmtpServers)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* attribute nsISmtpServer defaultServer; */
NS_IMETHODIMP nsSmtpService::GetDefaultServer(nsISmtpServer **aDefaultServer)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}
NS_IMETHODIMP nsSmtpService::SetDefaultServer(nsISmtpServer *aDefaultServer)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* attribute nsISmtpServer sessionDefaultServer; */
NS_IMETHODIMP nsSmtpService::GetSessionDefaultServer(nsISmtpServer **aSessionDefaultServer)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}
NS_IMETHODIMP nsSmtpService::SetSessionDefaultServer(nsISmtpServer *aSessionDefaultServer)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* nsISmtpServer createSmtpServer (); */
NS_IMETHODIMP nsSmtpService::CreateSmtpServer(nsISmtpServer **_retval NS_OUTPARAM)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* nsISmtpServer findServer (in string username, in string hostname); */
NS_IMETHODIMP nsSmtpService::FindServer(const char *username, const char *hostname, nsISmtpServer **_retval NS_OUTPARAM)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* nsISmtpServer getServerByKey (in string key); */
NS_IMETHODIMP nsSmtpService::GetServerByKey(const char *key, nsISmtpServer **_retval NS_OUTPARAM)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void deleteSmtpServer (in nsISmtpServer server); */
NS_IMETHODIMP nsSmtpService::DeleteSmtpServer(nsISmtpServer *server)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* End of implementation class template. */
#endif


#endif /* __gen_nsISmtpService_h__ */
