/*
 * DO NOT EDIT.  THIS FILE IS GENERATED FROM nsIShellService.idl
 */

#ifndef __gen_nsIShellService_h__
#define __gen_nsIShellService_h__


#ifndef __gen_nsISupports_h__
#include "nsISupports.h"
#endif

/* For IDL files that don't want to include root IDL files. */
#ifndef NS_NO_VTABLE
#define NS_NO_VTABLE
#endif
class nsIDOMElement; /* forward declaration */

class nsILocalFile; /* forward declaration */


/* starting interface:    nsIShellService */
#define NS_ISHELLSERVICE_IID_STR "bebb8b6a-8af4-4cf2-85ac-022f7c6a87a9"

#define NS_ISHELLSERVICE_IID \
  {0xbebb8b6a, 0x8af4, 0x4cf2, \
    { 0x85, 0xac, 0x02, 0x2f, 0x7c, 0x6a, 0x87, 0xa9 }}

class NS_NO_VTABLE NS_SCRIPTABLE nsIShellService : public nsISupports {
 public: 

  NS_DECLARE_STATIC_IID_ACCESSOR(NS_ISHELLSERVICE_IID)

  /**
   * app types we can be registered to handle
   */
  enum { BROWSER = 1U };

  enum { MAIL = 2U };

  enum { NEWS = 4U };

  enum { RSS = 8U };

  /**
   * Determines whether or not SeaMonkey is the "Default Client" for the
   * passed in app type.
   *
   * This is simply whether or not SeaMonkey is registered to handle
   * the url schemes associated with the app.
   *
   * @param aStartupCheck true if this is the check being performed
   *                      by the first window at startup,
   *                      false otherwise.
   * @param aApps the application types being tested (Browser, Mail, News, RSS)
   */
  /* boolean isDefaultClient (in boolean aStartupCheck, in unsigned short aApps); */
  NS_SCRIPTABLE NS_IMETHOD IsDefaultClient(PRBool aStartupCheck, PRUint16 aApps, PRBool *_retval NS_OUTPARAM) = 0;

  /**
   * Registers SeaMonkey as the "Default Client" for the
   * passed in app types.
   *
   * @param aForAllUsers   Whether or not SeaMonkey should attempt
   *                       to become the default client for all
   *                       users on a multi-user system.
   * @param aClaimAllTypes Register SeaMonkey as the handler for
   *                       additional protocols (ftp, chrome etc)
   *                       and web documents (.html, .xhtml etc).
   * @param aApps the application types being tested (Mail, News, Browser, RSS)
   */
  /* void setDefaultClient (in boolean aForAllUsers, in boolean aClaimAllTypes, in unsigned short aApps); */
  NS_SCRIPTABLE NS_IMETHOD SetDefaultClient(PRBool aForAllUsers, PRBool aClaimAllTypes, PRUint16 aApps) = 0;

  /**
   * Used to determine whether or not to show a "Set Default Client"
   * query dialog. This attribute is true if the application is starting
   * up and "shell.checkDefaultClient" is true, otherwise it
   * is false.
   */
  /* attribute boolean shouldCheckDefaultClient; */
  NS_SCRIPTABLE NS_IMETHOD GetShouldCheckDefaultClient(PRBool *aShouldCheckDefaultClient) = 0;
  NS_SCRIPTABLE NS_IMETHOD SetShouldCheckDefaultClient(PRBool aShouldCheckDefaultClient) = 0;

  /**
   * Returns the appTypes constants we should be the default client for.
   * Saves/reads the default apps to/from the pref shell.checkDefaultApps
   */
  /* attribute unsigned short shouldBeDefaultClientFor; */
  NS_SCRIPTABLE NS_IMETHOD GetShouldBeDefaultClientFor(PRUint16 *aShouldBeDefaultClientFor) = 0;
  NS_SCRIPTABLE NS_IMETHOD SetShouldBeDefaultClientFor(PRUint16 aShouldBeDefaultClientFor) = 0;

  /**
   * Sets the desktop background image using either the HTML <IMG>
   * element supplied or the background image of the element supplied.
   *
   * @param aImageElement Either a HTML <IMG> element or an element with
   *                      a background image from which to source the
   *                      background image.
   * @param aPosition     How to place the image on the desktop
   */
  /* void setDesktopBackground (in nsIDOMElement aElement, in long aPosition); */
  NS_SCRIPTABLE NS_IMETHOD SetDesktopBackground(nsIDOMElement *aElement, PRInt32 aPosition) = 0;

  /**
   * Flags for positioning/sizing of the Desktop Background image.
   */
  enum { BACKGROUND_TILE = 1 };

  enum { BACKGROUND_STRETCH = 2 };

  enum { BACKGROUND_CENTER = 3 };

  /**
   * The desktop background color, visible when no background image is
   * used, or if the background image is centered and does not fill the
   * entire screen. An RGB value (r << 16 | g << 8 | b)
   */
  /* attribute unsigned long desktopBackgroundColor; */
  NS_SCRIPTABLE NS_IMETHOD GetDesktopBackgroundColor(PRUint32 *aDesktopBackgroundColor) = 0;
  NS_SCRIPTABLE NS_IMETHOD SetDesktopBackgroundColor(PRUint32 aDesktopBackgroundColor) = 0;

  /**
   * Opens an application with a specific URI to load.
   * @param   application
   *          The application file (or bundle directory, on OS X)
   * @param   uri
   *          The uri to be loaded by the application
   */
  /* void openApplicationWithURI (in nsILocalFile aApplication, in ACString aURI); */
  NS_SCRIPTABLE NS_IMETHOD OpenApplicationWithURI(nsILocalFile *aApplication, const nsACString & aURI) = 0;

  /**
   * The default system handler for web feeds
   */
  /* readonly attribute nsILocalFile defaultFeedReader; */
  NS_SCRIPTABLE NS_IMETHOD GetDefaultFeedReader(nsILocalFile **aDefaultFeedReader) = 0;

};

  NS_DEFINE_STATIC_IID_ACCESSOR(nsIShellService, NS_ISHELLSERVICE_IID)

/* Use this macro when declaring classes that implement this interface. */
#define NS_DECL_NSISHELLSERVICE \
  NS_SCRIPTABLE NS_IMETHOD IsDefaultClient(PRBool aStartupCheck, PRUint16 aApps, PRBool *_retval NS_OUTPARAM); \
  NS_SCRIPTABLE NS_IMETHOD SetDefaultClient(PRBool aForAllUsers, PRBool aClaimAllTypes, PRUint16 aApps); \
  NS_SCRIPTABLE NS_IMETHOD GetShouldCheckDefaultClient(PRBool *aShouldCheckDefaultClient); \
  NS_SCRIPTABLE NS_IMETHOD SetShouldCheckDefaultClient(PRBool aShouldCheckDefaultClient); \
  NS_SCRIPTABLE NS_IMETHOD GetShouldBeDefaultClientFor(PRUint16 *aShouldBeDefaultClientFor); \
  NS_SCRIPTABLE NS_IMETHOD SetShouldBeDefaultClientFor(PRUint16 aShouldBeDefaultClientFor); \
  NS_SCRIPTABLE NS_IMETHOD SetDesktopBackground(nsIDOMElement *aElement, PRInt32 aPosition); \
  NS_SCRIPTABLE NS_IMETHOD GetDesktopBackgroundColor(PRUint32 *aDesktopBackgroundColor); \
  NS_SCRIPTABLE NS_IMETHOD SetDesktopBackgroundColor(PRUint32 aDesktopBackgroundColor); \
  NS_SCRIPTABLE NS_IMETHOD OpenApplicationWithURI(nsILocalFile *aApplication, const nsACString & aURI); \
  NS_SCRIPTABLE NS_IMETHOD GetDefaultFeedReader(nsILocalFile **aDefaultFeedReader); 

/* Use this macro to declare functions that forward the behavior of this interface to another object. */
#define NS_FORWARD_NSISHELLSERVICE(_to) \
  NS_SCRIPTABLE NS_IMETHOD IsDefaultClient(PRBool aStartupCheck, PRUint16 aApps, PRBool *_retval NS_OUTPARAM) { return _to IsDefaultClient(aStartupCheck, aApps, _retval); } \
  NS_SCRIPTABLE NS_IMETHOD SetDefaultClient(PRBool aForAllUsers, PRBool aClaimAllTypes, PRUint16 aApps) { return _to SetDefaultClient(aForAllUsers, aClaimAllTypes, aApps); } \
  NS_SCRIPTABLE NS_IMETHOD GetShouldCheckDefaultClient(PRBool *aShouldCheckDefaultClient) { return _to GetShouldCheckDefaultClient(aShouldCheckDefaultClient); } \
  NS_SCRIPTABLE NS_IMETHOD SetShouldCheckDefaultClient(PRBool aShouldCheckDefaultClient) { return _to SetShouldCheckDefaultClient(aShouldCheckDefaultClient); } \
  NS_SCRIPTABLE NS_IMETHOD GetShouldBeDefaultClientFor(PRUint16 *aShouldBeDefaultClientFor) { return _to GetShouldBeDefaultClientFor(aShouldBeDefaultClientFor); } \
  NS_SCRIPTABLE NS_IMETHOD SetShouldBeDefaultClientFor(PRUint16 aShouldBeDefaultClientFor) { return _to SetShouldBeDefaultClientFor(aShouldBeDefaultClientFor); } \
  NS_SCRIPTABLE NS_IMETHOD SetDesktopBackground(nsIDOMElement *aElement, PRInt32 aPosition) { return _to SetDesktopBackground(aElement, aPosition); } \
  NS_SCRIPTABLE NS_IMETHOD GetDesktopBackgroundColor(PRUint32 *aDesktopBackgroundColor) { return _to GetDesktopBackgroundColor(aDesktopBackgroundColor); } \
  NS_SCRIPTABLE NS_IMETHOD SetDesktopBackgroundColor(PRUint32 aDesktopBackgroundColor) { return _to SetDesktopBackgroundColor(aDesktopBackgroundColor); } \
  NS_SCRIPTABLE NS_IMETHOD OpenApplicationWithURI(nsILocalFile *aApplication, const nsACString & aURI) { return _to OpenApplicationWithURI(aApplication, aURI); } \
  NS_SCRIPTABLE NS_IMETHOD GetDefaultFeedReader(nsILocalFile **aDefaultFeedReader) { return _to GetDefaultFeedReader(aDefaultFeedReader); } 

/* Use this macro to declare functions that forward the behavior of this interface to another object in a safe way. */
#define NS_FORWARD_SAFE_NSISHELLSERVICE(_to) \
  NS_SCRIPTABLE NS_IMETHOD IsDefaultClient(PRBool aStartupCheck, PRUint16 aApps, PRBool *_retval NS_OUTPARAM) { return !_to ? NS_ERROR_NULL_POINTER : _to->IsDefaultClient(aStartupCheck, aApps, _retval); } \
  NS_SCRIPTABLE NS_IMETHOD SetDefaultClient(PRBool aForAllUsers, PRBool aClaimAllTypes, PRUint16 aApps) { return !_to ? NS_ERROR_NULL_POINTER : _to->SetDefaultClient(aForAllUsers, aClaimAllTypes, aApps); } \
  NS_SCRIPTABLE NS_IMETHOD GetShouldCheckDefaultClient(PRBool *aShouldCheckDefaultClient) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetShouldCheckDefaultClient(aShouldCheckDefaultClient); } \
  NS_SCRIPTABLE NS_IMETHOD SetShouldCheckDefaultClient(PRBool aShouldCheckDefaultClient) { return !_to ? NS_ERROR_NULL_POINTER : _to->SetShouldCheckDefaultClient(aShouldCheckDefaultClient); } \
  NS_SCRIPTABLE NS_IMETHOD GetShouldBeDefaultClientFor(PRUint16 *aShouldBeDefaultClientFor) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetShouldBeDefaultClientFor(aShouldBeDefaultClientFor); } \
  NS_SCRIPTABLE NS_IMETHOD SetShouldBeDefaultClientFor(PRUint16 aShouldBeDefaultClientFor) { return !_to ? NS_ERROR_NULL_POINTER : _to->SetShouldBeDefaultClientFor(aShouldBeDefaultClientFor); } \
  NS_SCRIPTABLE NS_IMETHOD SetDesktopBackground(nsIDOMElement *aElement, PRInt32 aPosition) { return !_to ? NS_ERROR_NULL_POINTER : _to->SetDesktopBackground(aElement, aPosition); } \
  NS_SCRIPTABLE NS_IMETHOD GetDesktopBackgroundColor(PRUint32 *aDesktopBackgroundColor) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetDesktopBackgroundColor(aDesktopBackgroundColor); } \
  NS_SCRIPTABLE NS_IMETHOD SetDesktopBackgroundColor(PRUint32 aDesktopBackgroundColor) { return !_to ? NS_ERROR_NULL_POINTER : _to->SetDesktopBackgroundColor(aDesktopBackgroundColor); } \
  NS_SCRIPTABLE NS_IMETHOD OpenApplicationWithURI(nsILocalFile *aApplication, const nsACString & aURI) { return !_to ? NS_ERROR_NULL_POINTER : _to->OpenApplicationWithURI(aApplication, aURI); } \
  NS_SCRIPTABLE NS_IMETHOD GetDefaultFeedReader(nsILocalFile **aDefaultFeedReader) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetDefaultFeedReader(aDefaultFeedReader); } 

#if 0
/* Use the code below as a template for the implementation class for this interface. */

/* Header file */
class nsShellService : public nsIShellService
{
public:
  NS_DECL_ISUPPORTS
  NS_DECL_NSISHELLSERVICE

  nsShellService();

private:
  ~nsShellService();

protected:
  /* additional members */
};

/* Implementation file */
NS_IMPL_ISUPPORTS1(nsShellService, nsIShellService)

nsShellService::nsShellService()
{
  /* member initializers and constructor code */
}

nsShellService::~nsShellService()
{
  /* destructor code */
}

/* boolean isDefaultClient (in boolean aStartupCheck, in unsigned short aApps); */
NS_IMETHODIMP nsShellService::IsDefaultClient(PRBool aStartupCheck, PRUint16 aApps, PRBool *_retval NS_OUTPARAM)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void setDefaultClient (in boolean aForAllUsers, in boolean aClaimAllTypes, in unsigned short aApps); */
NS_IMETHODIMP nsShellService::SetDefaultClient(PRBool aForAllUsers, PRBool aClaimAllTypes, PRUint16 aApps)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* attribute boolean shouldCheckDefaultClient; */
NS_IMETHODIMP nsShellService::GetShouldCheckDefaultClient(PRBool *aShouldCheckDefaultClient)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}
NS_IMETHODIMP nsShellService::SetShouldCheckDefaultClient(PRBool aShouldCheckDefaultClient)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* attribute unsigned short shouldBeDefaultClientFor; */
NS_IMETHODIMP nsShellService::GetShouldBeDefaultClientFor(PRUint16 *aShouldBeDefaultClientFor)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}
NS_IMETHODIMP nsShellService::SetShouldBeDefaultClientFor(PRUint16 aShouldBeDefaultClientFor)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void setDesktopBackground (in nsIDOMElement aElement, in long aPosition); */
NS_IMETHODIMP nsShellService::SetDesktopBackground(nsIDOMElement *aElement, PRInt32 aPosition)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* attribute unsigned long desktopBackgroundColor; */
NS_IMETHODIMP nsShellService::GetDesktopBackgroundColor(PRUint32 *aDesktopBackgroundColor)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}
NS_IMETHODIMP nsShellService::SetDesktopBackgroundColor(PRUint32 aDesktopBackgroundColor)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void openApplicationWithURI (in nsILocalFile aApplication, in ACString aURI); */
NS_IMETHODIMP nsShellService::OpenApplicationWithURI(nsILocalFile *aApplication, const nsACString & aURI)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* readonly attribute nsILocalFile defaultFeedReader; */
NS_IMETHODIMP nsShellService::GetDefaultFeedReader(nsILocalFile **aDefaultFeedReader)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* End of implementation class template. */
#endif


#endif /* __gen_nsIShellService_h__ */
