/*
 * DO NOT EDIT.  THIS FILE IS GENERATED FROM nsINntpUrl.idl
 */

#ifndef __gen_nsINntpUrl_h__
#define __gen_nsINntpUrl_h__


#ifndef __gen_nsISupports_h__
#include "nsISupports.h"
#endif

#ifndef __gen_MailNewsTypes2_h__
#include "MailNewsTypes2.h"
#endif

/* For IDL files that don't want to include root IDL files. */
#ifndef NS_NO_VTABLE
#define NS_NO_VTABLE
#endif
class nsIMsgDBHdr; /* forward declaration */

class nsINNTPNewsgroupPost; /* forward declaration */

typedef PRInt32  nsNewsAction;


/* starting interface:    nsINntpUrl */
#define NS_INNTPURL_IID_STR "b8bb6567-7433-4a52-beae-20e8122deb78"

#define NS_INNTPURL_IID \
  {0xb8bb6567, 0x7433, 0x4a52, \
    { 0xbe, 0xae, 0x20, 0xe8, 0x12, 0x2d, 0xeb, 0x78 }}

/**
 * Represents specific attributes to a URL for news usage.
 *
 * Note that the urls represented by this interface can be one of five schemes:
 * [s]news, nntp[s], or news-message. Any URI that is valid under RFC 5538 will
 * be accepted. However, it is possible for some queries to be invalid. There
 * are also a few important things to note:
 *
 * - Missing authorities in [s]news: URIs cause nsIMsgMailNewsUrl::server and
 *   nsIMsgMessageUrl::folder to be null.
 * - nsIMsgMailNewsUrl::server and nsIMsgMessageUrl::folder will be null if the
 *   specified server does not actually exist. In addition, the folder is null
 *   if the group is not currently subscribed on that server.
 * - Although news-message URIs are parsable, there is no protocol handler
 *   associated with this url. To run these, you should convert these to the
 *   corresponding [s]news or nntp URL, and set the original one in
 *   nsIMsgMessageUrl::uri and ::originalSpec.
 * - A URI that results in an ActionUnknown will not be run.
 * - Cancel URIs require the original spec to also be set, so it can find both
 *   the message ID and the group/key combination.
 * * Some actions require either a group or a message id. Since actions can be
 *   set after the fact, these conditions are not verified.
 */
class NS_NO_VTABLE NS_SCRIPTABLE nsINntpUrl : public nsISupports {
 public: 

  NS_DECLARE_STATIC_IID_ACCESSOR(NS_INNTPURL_IID)

  /* attribute nsINNTPNewsgroupPost messageToPost; */
  NS_SCRIPTABLE NS_IMETHOD GetMessageToPost(nsINNTPNewsgroupPost **aMessageToPost) = 0;
  NS_SCRIPTABLE NS_IMETHOD SetMessageToPost(nsINNTPNewsgroupPost *aMessageToPost) = 0;

  /**
   * The action that this URL will take when run.
   *
   * Most actions can be automatically determined from the URL spec as follows:
   *
   * 1. The query string is searched for the appropriate action.
   *
   * 2. A non-empty message ID or key is found (sets ActionFetchArticle).
   *
   * 3. A non-empty group is found (ActionGetNewNews or ActionListGroups).
   */
  /* attribute nsNewsAction newsAction; */
  NS_SCRIPTABLE NS_IMETHOD GetNewsAction(nsNewsAction *aNewsAction) = 0;
  NS_SCRIPTABLE NS_IMETHOD SetNewsAction(nsNewsAction aNewsAction) = 0;

  /* attribute boolean getOldMessages; */
  NS_SCRIPTABLE NS_IMETHOD GetGetOldMessages(PRBool *aGetOldMessages) = 0;
  NS_SCRIPTABLE NS_IMETHOD SetGetOldMessages(PRBool aGetOldMessages) = 0;

  enum { ActionUnknown = 0 };

  enum { ActionFetchArticle = 1 };

  enum { ActionFetchPart = 2 };

  enum { ActionSaveMessageToDisk = 3 };

  enum { ActionCancelArticle = 4 };

  enum { ActionPostArticle = 5 };

  enum { ActionListIds = 6 };

  enum { ActionSearch = 7 };

  enum { ActionGetNewNews = 8 };

  enum { ActionListGroups = 9 };

  enum { ActionListNewGroups = 10 };

  enum { DEFAULT_NNTP_PORT = 119 };

  enum { DEFAULT_NNTPS_PORT = 563 };

};

  NS_DEFINE_STATIC_IID_ACCESSOR(nsINntpUrl, NS_INNTPURL_IID)

/* Use this macro when declaring classes that implement this interface. */
#define NS_DECL_NSINNTPURL \
  NS_SCRIPTABLE NS_IMETHOD GetMessageToPost(nsINNTPNewsgroupPost **aMessageToPost); \
  NS_SCRIPTABLE NS_IMETHOD SetMessageToPost(nsINNTPNewsgroupPost *aMessageToPost); \
  NS_SCRIPTABLE NS_IMETHOD GetNewsAction(nsNewsAction *aNewsAction); \
  NS_SCRIPTABLE NS_IMETHOD SetNewsAction(nsNewsAction aNewsAction); \
  NS_SCRIPTABLE NS_IMETHOD GetGetOldMessages(PRBool *aGetOldMessages); \
  NS_SCRIPTABLE NS_IMETHOD SetGetOldMessages(PRBool aGetOldMessages); \

/* Use this macro to declare functions that forward the behavior of this interface to another object. */
#define NS_FORWARD_NSINNTPURL(_to) \
  NS_SCRIPTABLE NS_IMETHOD GetMessageToPost(nsINNTPNewsgroupPost **aMessageToPost) { return _to GetMessageToPost(aMessageToPost); } \
  NS_SCRIPTABLE NS_IMETHOD SetMessageToPost(nsINNTPNewsgroupPost *aMessageToPost) { return _to SetMessageToPost(aMessageToPost); } \
  NS_SCRIPTABLE NS_IMETHOD GetNewsAction(nsNewsAction *aNewsAction) { return _to GetNewsAction(aNewsAction); } \
  NS_SCRIPTABLE NS_IMETHOD SetNewsAction(nsNewsAction aNewsAction) { return _to SetNewsAction(aNewsAction); } \
  NS_SCRIPTABLE NS_IMETHOD GetGetOldMessages(PRBool *aGetOldMessages) { return _to GetGetOldMessages(aGetOldMessages); } \
  NS_SCRIPTABLE NS_IMETHOD SetGetOldMessages(PRBool aGetOldMessages) { return _to SetGetOldMessages(aGetOldMessages); } \

/* Use this macro to declare functions that forward the behavior of this interface to another object in a safe way. */
#define NS_FORWARD_SAFE_NSINNTPURL(_to) \
  NS_SCRIPTABLE NS_IMETHOD GetMessageToPost(nsINNTPNewsgroupPost **aMessageToPost) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetMessageToPost(aMessageToPost); } \
  NS_SCRIPTABLE NS_IMETHOD SetMessageToPost(nsINNTPNewsgroupPost *aMessageToPost) { return !_to ? NS_ERROR_NULL_POINTER : _to->SetMessageToPost(aMessageToPost); } \
  NS_SCRIPTABLE NS_IMETHOD GetNewsAction(nsNewsAction *aNewsAction) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetNewsAction(aNewsAction); } \
  NS_SCRIPTABLE NS_IMETHOD SetNewsAction(nsNewsAction aNewsAction) { return !_to ? NS_ERROR_NULL_POINTER : _to->SetNewsAction(aNewsAction); } \
  NS_SCRIPTABLE NS_IMETHOD GetGetOldMessages(PRBool *aGetOldMessages) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetGetOldMessages(aGetOldMessages); } \
  NS_SCRIPTABLE NS_IMETHOD SetGetOldMessages(PRBool aGetOldMessages) { return !_to ? NS_ERROR_NULL_POINTER : _to->SetGetOldMessages(aGetOldMessages); } \

#if 0
/* Use the code below as a template for the implementation class for this interface. */

/* Header file */
class nsNntpUrl : public nsINntpUrl
{
public:
  NS_DECL_ISUPPORTS
  NS_DECL_NSINNTPURL

  nsNntpUrl();

private:
  ~nsNntpUrl();

protected:
  /* additional members */
};

/* Implementation file */
NS_IMPL_ISUPPORTS1(nsNntpUrl, nsINntpUrl)

nsNntpUrl::nsNntpUrl()
{
  /* member initializers and constructor code */
}

nsNntpUrl::~nsNntpUrl()
{
  /* destructor code */
}

/* attribute nsINNTPNewsgroupPost messageToPost; */
NS_IMETHODIMP nsNntpUrl::GetMessageToPost(nsINNTPNewsgroupPost **aMessageToPost)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}
NS_IMETHODIMP nsNntpUrl::SetMessageToPost(nsINNTPNewsgroupPost *aMessageToPost)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* attribute nsNewsAction newsAction; */
NS_IMETHODIMP nsNntpUrl::GetNewsAction(nsNewsAction *aNewsAction)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}
NS_IMETHODIMP nsNntpUrl::SetNewsAction(nsNewsAction aNewsAction)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* attribute boolean getOldMessages; */
NS_IMETHODIMP nsNntpUrl::GetGetOldMessages(PRBool *aGetOldMessages)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}
NS_IMETHODIMP nsNntpUrl::SetGetOldMessages(PRBool aGetOldMessages)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* End of implementation class template. */
#endif


#endif /* __gen_nsINntpUrl_h__ */
