/*
 * DO NOT EDIT.  THIS FILE IS GENERATED FROM nsIMsgMessageService.idl
 */

#ifndef __gen_nsIMsgMessageService_h__
#define __gen_nsIMsgMessageService_h__


#ifndef __gen_nsISupports_h__
#include "nsISupports.h"
#endif

/* For IDL files that don't want to include root IDL files. */
#ifndef NS_NO_VTABLE
#define NS_NO_VTABLE
#endif
class nsIURI; /* forward declaration */

class nsIUrlListener; /* forward declaration */

class nsIStreamListener; /* forward declaration */

class nsIMsgWindow; /* forward declaration */

class nsIFile; /* forward declaration */

class nsIMsgFolder; /* forward declaration */

class nsIMsgSearchSession; /* forward declaration */

class nsIMsgDBHdr; /* forward declaration */

class nsIStreamConverter; /* forward declaration */

class nsICacheEntryDescriptor; /* forward declaration */

#include "MailNewsTypes.h"
#include "nsTArray.h"

/* starting interface:    nsIMsgMessageService */
#define NS_IMSGMESSAGESERVICE_IID_STR "5f173e8d-0046-4eec-b178-b850a7211654"

#define NS_IMSGMESSAGESERVICE_IID \
  {0x5f173e8d, 0x0046, 0x4eec, \
    { 0xb1, 0x78, 0xb8, 0x50, 0xa7, 0x21, 0x16, 0x54 }}

class NS_NO_VTABLE NS_SCRIPTABLE nsIMsgMessageService : public nsISupports {
 public: 

  NS_DECLARE_STATIC_IID_ACCESSOR(NS_IMSGMESSAGESERVICE_IID)

  /**
   * If you want a handle on the running task, pass in a valid nsIURI 
   * ptr. You can later interrupt this action by asking the netlib 
   * service manager to interrupt the url you are given back. 
   * Remember to release aURL when you are done with it. Pass nsnull
   * in for aURL if you don't care about the returned URL.
   */
/**
   * Pass in the URI for the message you want to have copied.
   *
   * @param aSrcURI
   * @param aCopyListener already knows about the destination folder. 
   * @param aMoveMessage TRUE if you want the message to be moved.
   *                     FALSE leaves it as just a copy.
   * @param aUrlListener 
   * @param aMsgWindow
   * @param aURL
   */
  /* void CopyMessage (in string aSrcURI, in nsIStreamListener aCopyListener, in boolean aMoveMessage, in nsIUrlListener aUrlListener, in nsIMsgWindow aMsgWindow, out nsIURI aURL); */
  NS_SCRIPTABLE NS_IMETHOD CopyMessage(const char *aSrcURI, nsIStreamListener *aCopyListener, PRBool aMoveMessage, nsIUrlListener *aUrlListener, nsIMsgWindow *aMsgWindow, nsIURI **aURL NS_OUTPARAM) = 0;

  /**
   * Copy multiple messages at a time 
   *
   * @param keys
   * @param srcFolder
   * @param aCopyListener
   * @param aMoveMessage
   * @param aUrlListener
   * @param aMsgWindow
   * @param aURL
   */
  /* [noscript] void CopyMessages (in nsMsgKeyArrayRef keys, in nsIMsgFolder srcFolder, in nsIStreamListener aCopyListener, in boolean aMoveMessage, in nsIUrlListener aUrlListener, in nsIMsgWindow aMsgWindow, out nsIURI aURL); */
  NS_IMETHOD CopyMessages(nsTArray<nsMsgKey> & keys, nsIMsgFolder *srcFolder, nsIStreamListener *aCopyListener, PRBool aMoveMessage, nsIUrlListener *aUrlListener, nsIMsgWindow *aMsgWindow, nsIURI **aURL NS_OUTPARAM) = 0;

  /**
   * When you want a message displayed....
   *
   * @param aMessageURI Is a uri representing the message to display.
   * @param aDisplayConsumer Is (for now) an nsIDocShell which we'll use to load 
   *                         the message into.
   *                         XXXbz Should it be an nsIWebNavigation or something?
   * @param aMsgWindow
   * @param aUrlListener
   * @param aCharsetOverride (optional) character set over ride to force the message to use.
   * @param aURL
   */
  /* void DisplayMessage (in string aMessageURI, in nsISupports aDisplayConsumer, in nsIMsgWindow aMsgWindow, in nsIUrlListener aUrlListener, in string aCharsetOverride, out nsIURI aURL); */
  NS_SCRIPTABLE NS_IMETHOD DisplayMessage(const char *aMessageURI, nsISupports *aDisplayConsumer, nsIMsgWindow *aMsgWindow, nsIUrlListener *aUrlListener, const char *aCharsetOverride, nsIURI **aURL NS_OUTPARAM) = 0;

  /**
   * When you want an attachment downloaded
   *
   * @param aContentType We need to know the content type of the attachment
   * @param aFileName The name of the attachment.
   * @param aUrl String representation of the original url associated with the msg.
   * @param aMessageUri RDF resource that describes the message
   * @param aDisplayConsumer
   * @param aMsgWindow Message window
   * @param aUrlListener
   */
  /* void openAttachment (in string aContentType, in string aFileName, in string aUrl, in string aMessageUri, in nsISupports aDisplayConsumer, in nsIMsgWindow aMsgWindow, in nsIUrlListener aUrlListener); */
  NS_SCRIPTABLE NS_IMETHOD OpenAttachment(const char *aContentType, const char *aFileName, const char *aUrl, const char *aMessageUri, nsISupports *aDisplayConsumer, nsIMsgWindow *aMsgWindow, nsIUrlListener *aUrlListener) = 0;

  /**
   * When you want to spool a message out to a file on disk. 
   * This is an asynch operation of course. You must pass in a
   * url listener in order to figure out when the operation is done.
   *
   * @param aMessageURI The uri representing the message to spool out to disk.
   * @param aFile The file you want the message saved to
   * @param aGenerateDummyEnvelope Usually FALSE. Set to TRUE if you want the msg
   *        appended at the end of the file.
   * @param aUrlListener
   * @param aURL
   * @param canonicalLineEnding
   * @param aMsgWindow
   */
  /* void SaveMessageToDisk (in string aMessageURI, in nsIFile aFile, in boolean aGenerateDummyEnvelope, in nsIUrlListener aUrlListener, out nsIURI aURL, in boolean canonicalLineEnding, in nsIMsgWindow aMsgWindow); */
  NS_SCRIPTABLE NS_IMETHOD SaveMessageToDisk(const char *aMessageURI, nsIFile *aFile, PRBool aGenerateDummyEnvelope, nsIUrlListener *aUrlListener, nsIURI **aURL NS_OUTPARAM, PRBool canonicalLineEnding, nsIMsgWindow *aMsgWindow) = 0;

  /**
   * When you have a uri and you would like to convert that
   * to a url which can be run through necko, you can use this method.
   * the Uri MUST refer to a message and not a folder! 
   *
   * @param aMessageURI A message uri to convert.
   * @param aURL URL which can be run through necko.
   * @param aMsgWindow    
   */
  /* void GetUrlForUri (in string aMessageURI, out nsIURI aURL, in nsIMsgWindow aMsgWindow); */
  NS_SCRIPTABLE NS_IMETHOD GetUrlForUri(const char *aMessageURI, nsIURI **aURL NS_OUTPARAM, nsIMsgWindow *aMsgWindow) = 0;

  /**
   * When you want a message displayed in a format that is suitable for printing....
   *
   * @param aMessageURI A uri representing the message to display.
   * @param aDisplayConsumer is (for now) a nsIDocShell which we'll use to load 
   *        the message into. 
   *        XXXbz should it be an nsIWebNavigation?
   * @param aMsgWindow
   * @param aUrlListener
   * @param aURL 
   */
  /* void DisplayMessageForPrinting (in string aMessageURI, in nsISupports aDisplayConsumer, in nsIMsgWindow aMsgWindow, in nsIUrlListener aUrlListener, out nsIURI aURL); */
  NS_SCRIPTABLE NS_IMETHOD DisplayMessageForPrinting(const char *aMessageURI, nsISupports *aDisplayConsumer, nsIMsgWindow *aMsgWindow, nsIUrlListener *aUrlListener, nsIURI **aURL NS_OUTPARAM) = 0;

  /**
   *
   *
   * @param aSearchSession
   * @param aMsgWindow
   * @param aMsgFolder
   * @param aSearchUri
   */
  /* void Search (in nsIMsgSearchSession aSearchSession, in nsIMsgWindow aMsgWindow, in nsIMsgFolder aMsgFolder, in string aSearchUri); */
  NS_SCRIPTABLE NS_IMETHOD Search(nsIMsgSearchSession *aSearchSession, nsIMsgWindow *aMsgWindow, nsIMsgFolder *aMsgFolder, const char *aSearchUri) = 0;

  /** 
   * This methot streams a message to the passed in consumer. If aConvertData is true, it
   * will create a stream converter from message rfc822 to star/star. It will also tack
   * aAdditionalHeader onto the url (e.g., "header=filter").
   *
   * @param aMessageURI  uri of message to stream
   * @param aConsumer    generally, a stream listener listening to the message
   * @param aMsgWindow   msgWindow for give progress and status feedback
   * @param aUrlListener gets notified when url starts and stops
   * @param aConvertData should we create a stream converter?
   * @param aAdditionalHeader added to URI, e.g., "header=filter"
   * @param aLocalOnly whether data should be retrieved only from local caches
   *        If streaming over the network is required and this is true, then
   *        an exception is thrown. This defaults to false.
   *
   * @note If we're offline, then even if aLocalOnly is false, we won't stream over the
   *       network
   *
   * @return the URL that gets run
   */
  /* nsIURI streamMessage (in string aMessageURI, in nsISupports aConsumer, in nsIMsgWindow aMsgWindow, in nsIUrlListener aUrlListener, in boolean aConvertData, in ACString aAdditionalHeader, [optional] in boolean aLocalOnly); */
  NS_SCRIPTABLE NS_IMETHOD StreamMessage(const char *aMessageURI, nsISupports *aConsumer, nsIMsgWindow *aMsgWindow, nsIUrlListener *aUrlListener, PRBool aConvertData, const nsACString & aAdditionalHeader, PRBool aLocalOnly, nsIURI **_retval NS_OUTPARAM) = 0;

  /**
   * Determines whether a message is in the memory cache. Local folders
   * don't implement this.
   *
   * @param aUrl The URL of the message, possibly with an appropriate command in it
   * @param aFolder The folder this message is in
   * @param aCacheEntry If a cache entry is found, then a pointer to it
   * 
   * @return TRUE if the message is in mem cache; FALSE if it is not.
   */
  /* boolean isMsgInMemCache (in nsIURI aUrl, in nsIMsgFolder aFolder, out nsICacheEntryDescriptor aCacheEntry); */
  NS_SCRIPTABLE NS_IMETHOD IsMsgInMemCache(nsIURI *aUrl, nsIMsgFolder *aFolder, nsICacheEntryDescriptor **aCacheEntry NS_OUTPARAM, PRBool *_retval NS_OUTPARAM) = 0;

  /**
   * now the the message datasource is going away
   * we need away to go from message uri to go nsIMsgDBHdr
   *
   * @param uri A message uri to get nsIMsgDBHdr for.
   *
   * @return nsIMsgDBHdr for specified uri or null if failed. 
   */
  /* nsIMsgDBHdr messageURIToMsgHdr (in string uri); */
  NS_SCRIPTABLE NS_IMETHOD MessageURIToMsgHdr(const char *uri, nsIMsgDBHdr **_retval NS_OUTPARAM) = 0;

};

  NS_DEFINE_STATIC_IID_ACCESSOR(nsIMsgMessageService, NS_IMSGMESSAGESERVICE_IID)

/* Use this macro when declaring classes that implement this interface. */
#define NS_DECL_NSIMSGMESSAGESERVICE \
  NS_SCRIPTABLE NS_IMETHOD CopyMessage(const char *aSrcURI, nsIStreamListener *aCopyListener, PRBool aMoveMessage, nsIUrlListener *aUrlListener, nsIMsgWindow *aMsgWindow, nsIURI **aURL NS_OUTPARAM); \
  NS_IMETHOD CopyMessages(nsTArray<nsMsgKey> & keys, nsIMsgFolder *srcFolder, nsIStreamListener *aCopyListener, PRBool aMoveMessage, nsIUrlListener *aUrlListener, nsIMsgWindow *aMsgWindow, nsIURI **aURL NS_OUTPARAM); \
  NS_SCRIPTABLE NS_IMETHOD DisplayMessage(const char *aMessageURI, nsISupports *aDisplayConsumer, nsIMsgWindow *aMsgWindow, nsIUrlListener *aUrlListener, const char *aCharsetOverride, nsIURI **aURL NS_OUTPARAM); \
  NS_SCRIPTABLE NS_IMETHOD OpenAttachment(const char *aContentType, const char *aFileName, const char *aUrl, const char *aMessageUri, nsISupports *aDisplayConsumer, nsIMsgWindow *aMsgWindow, nsIUrlListener *aUrlListener); \
  NS_SCRIPTABLE NS_IMETHOD SaveMessageToDisk(const char *aMessageURI, nsIFile *aFile, PRBool aGenerateDummyEnvelope, nsIUrlListener *aUrlListener, nsIURI **aURL NS_OUTPARAM, PRBool canonicalLineEnding, nsIMsgWindow *aMsgWindow); \
  NS_SCRIPTABLE NS_IMETHOD GetUrlForUri(const char *aMessageURI, nsIURI **aURL NS_OUTPARAM, nsIMsgWindow *aMsgWindow); \
  NS_SCRIPTABLE NS_IMETHOD DisplayMessageForPrinting(const char *aMessageURI, nsISupports *aDisplayConsumer, nsIMsgWindow *aMsgWindow, nsIUrlListener *aUrlListener, nsIURI **aURL NS_OUTPARAM); \
  NS_SCRIPTABLE NS_IMETHOD Search(nsIMsgSearchSession *aSearchSession, nsIMsgWindow *aMsgWindow, nsIMsgFolder *aMsgFolder, const char *aSearchUri); \
  NS_SCRIPTABLE NS_IMETHOD StreamMessage(const char *aMessageURI, nsISupports *aConsumer, nsIMsgWindow *aMsgWindow, nsIUrlListener *aUrlListener, PRBool aConvertData, const nsACString & aAdditionalHeader, PRBool aLocalOnly, nsIURI **_retval NS_OUTPARAM); \
  NS_SCRIPTABLE NS_IMETHOD IsMsgInMemCache(nsIURI *aUrl, nsIMsgFolder *aFolder, nsICacheEntryDescriptor **aCacheEntry NS_OUTPARAM, PRBool *_retval NS_OUTPARAM); \
  NS_SCRIPTABLE NS_IMETHOD MessageURIToMsgHdr(const char *uri, nsIMsgDBHdr **_retval NS_OUTPARAM); 

/* Use this macro to declare functions that forward the behavior of this interface to another object. */
#define NS_FORWARD_NSIMSGMESSAGESERVICE(_to) \
  NS_SCRIPTABLE NS_IMETHOD CopyMessage(const char *aSrcURI, nsIStreamListener *aCopyListener, PRBool aMoveMessage, nsIUrlListener *aUrlListener, nsIMsgWindow *aMsgWindow, nsIURI **aURL NS_OUTPARAM) { return _to CopyMessage(aSrcURI, aCopyListener, aMoveMessage, aUrlListener, aMsgWindow, aURL); } \
  NS_IMETHOD CopyMessages(nsTArray<nsMsgKey> & keys, nsIMsgFolder *srcFolder, nsIStreamListener *aCopyListener, PRBool aMoveMessage, nsIUrlListener *aUrlListener, nsIMsgWindow *aMsgWindow, nsIURI **aURL NS_OUTPARAM) { return _to CopyMessages(keys, srcFolder, aCopyListener, aMoveMessage, aUrlListener, aMsgWindow, aURL); } \
  NS_SCRIPTABLE NS_IMETHOD DisplayMessage(const char *aMessageURI, nsISupports *aDisplayConsumer, nsIMsgWindow *aMsgWindow, nsIUrlListener *aUrlListener, const char *aCharsetOverride, nsIURI **aURL NS_OUTPARAM) { return _to DisplayMessage(aMessageURI, aDisplayConsumer, aMsgWindow, aUrlListener, aCharsetOverride, aURL); } \
  NS_SCRIPTABLE NS_IMETHOD OpenAttachment(const char *aContentType, const char *aFileName, const char *aUrl, const char *aMessageUri, nsISupports *aDisplayConsumer, nsIMsgWindow *aMsgWindow, nsIUrlListener *aUrlListener) { return _to OpenAttachment(aContentType, aFileName, aUrl, aMessageUri, aDisplayConsumer, aMsgWindow, aUrlListener); } \
  NS_SCRIPTABLE NS_IMETHOD SaveMessageToDisk(const char *aMessageURI, nsIFile *aFile, PRBool aGenerateDummyEnvelope, nsIUrlListener *aUrlListener, nsIURI **aURL NS_OUTPARAM, PRBool canonicalLineEnding, nsIMsgWindow *aMsgWindow) { return _to SaveMessageToDisk(aMessageURI, aFile, aGenerateDummyEnvelope, aUrlListener, aURL, canonicalLineEnding, aMsgWindow); } \
  NS_SCRIPTABLE NS_IMETHOD GetUrlForUri(const char *aMessageURI, nsIURI **aURL NS_OUTPARAM, nsIMsgWindow *aMsgWindow) { return _to GetUrlForUri(aMessageURI, aURL, aMsgWindow); } \
  NS_SCRIPTABLE NS_IMETHOD DisplayMessageForPrinting(const char *aMessageURI, nsISupports *aDisplayConsumer, nsIMsgWindow *aMsgWindow, nsIUrlListener *aUrlListener, nsIURI **aURL NS_OUTPARAM) { return _to DisplayMessageForPrinting(aMessageURI, aDisplayConsumer, aMsgWindow, aUrlListener, aURL); } \
  NS_SCRIPTABLE NS_IMETHOD Search(nsIMsgSearchSession *aSearchSession, nsIMsgWindow *aMsgWindow, nsIMsgFolder *aMsgFolder, const char *aSearchUri) { return _to Search(aSearchSession, aMsgWindow, aMsgFolder, aSearchUri); } \
  NS_SCRIPTABLE NS_IMETHOD StreamMessage(const char *aMessageURI, nsISupports *aConsumer, nsIMsgWindow *aMsgWindow, nsIUrlListener *aUrlListener, PRBool aConvertData, const nsACString & aAdditionalHeader, PRBool aLocalOnly, nsIURI **_retval NS_OUTPARAM) { return _to StreamMessage(aMessageURI, aConsumer, aMsgWindow, aUrlListener, aConvertData, aAdditionalHeader, aLocalOnly, _retval); } \
  NS_SCRIPTABLE NS_IMETHOD IsMsgInMemCache(nsIURI *aUrl, nsIMsgFolder *aFolder, nsICacheEntryDescriptor **aCacheEntry NS_OUTPARAM, PRBool *_retval NS_OUTPARAM) { return _to IsMsgInMemCache(aUrl, aFolder, aCacheEntry, _retval); } \
  NS_SCRIPTABLE NS_IMETHOD MessageURIToMsgHdr(const char *uri, nsIMsgDBHdr **_retval NS_OUTPARAM) { return _to MessageURIToMsgHdr(uri, _retval); } 

/* Use this macro to declare functions that forward the behavior of this interface to another object in a safe way. */
#define NS_FORWARD_SAFE_NSIMSGMESSAGESERVICE(_to) \
  NS_SCRIPTABLE NS_IMETHOD CopyMessage(const char *aSrcURI, nsIStreamListener *aCopyListener, PRBool aMoveMessage, nsIUrlListener *aUrlListener, nsIMsgWindow *aMsgWindow, nsIURI **aURL NS_OUTPARAM) { return !_to ? NS_ERROR_NULL_POINTER : _to->CopyMessage(aSrcURI, aCopyListener, aMoveMessage, aUrlListener, aMsgWindow, aURL); } \
  NS_IMETHOD CopyMessages(nsTArray<nsMsgKey> & keys, nsIMsgFolder *srcFolder, nsIStreamListener *aCopyListener, PRBool aMoveMessage, nsIUrlListener *aUrlListener, nsIMsgWindow *aMsgWindow, nsIURI **aURL NS_OUTPARAM) { return !_to ? NS_ERROR_NULL_POINTER : _to->CopyMessages(keys, srcFolder, aCopyListener, aMoveMessage, aUrlListener, aMsgWindow, aURL); } \
  NS_SCRIPTABLE NS_IMETHOD DisplayMessage(const char *aMessageURI, nsISupports *aDisplayConsumer, nsIMsgWindow *aMsgWindow, nsIUrlListener *aUrlListener, const char *aCharsetOverride, nsIURI **aURL NS_OUTPARAM) { return !_to ? NS_ERROR_NULL_POINTER : _to->DisplayMessage(aMessageURI, aDisplayConsumer, aMsgWindow, aUrlListener, aCharsetOverride, aURL); } \
  NS_SCRIPTABLE NS_IMETHOD OpenAttachment(const char *aContentType, const char *aFileName, const char *aUrl, const char *aMessageUri, nsISupports *aDisplayConsumer, nsIMsgWindow *aMsgWindow, nsIUrlListener *aUrlListener) { return !_to ? NS_ERROR_NULL_POINTER : _to->OpenAttachment(aContentType, aFileName, aUrl, aMessageUri, aDisplayConsumer, aMsgWindow, aUrlListener); } \
  NS_SCRIPTABLE NS_IMETHOD SaveMessageToDisk(const char *aMessageURI, nsIFile *aFile, PRBool aGenerateDummyEnvelope, nsIUrlListener *aUrlListener, nsIURI **aURL NS_OUTPARAM, PRBool canonicalLineEnding, nsIMsgWindow *aMsgWindow) { return !_to ? NS_ERROR_NULL_POINTER : _to->SaveMessageToDisk(aMessageURI, aFile, aGenerateDummyEnvelope, aUrlListener, aURL, canonicalLineEnding, aMsgWindow); } \
  NS_SCRIPTABLE NS_IMETHOD GetUrlForUri(const char *aMessageURI, nsIURI **aURL NS_OUTPARAM, nsIMsgWindow *aMsgWindow) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetUrlForUri(aMessageURI, aURL, aMsgWindow); } \
  NS_SCRIPTABLE NS_IMETHOD DisplayMessageForPrinting(const char *aMessageURI, nsISupports *aDisplayConsumer, nsIMsgWindow *aMsgWindow, nsIUrlListener *aUrlListener, nsIURI **aURL NS_OUTPARAM) { return !_to ? NS_ERROR_NULL_POINTER : _to->DisplayMessageForPrinting(aMessageURI, aDisplayConsumer, aMsgWindow, aUrlListener, aURL); } \
  NS_SCRIPTABLE NS_IMETHOD Search(nsIMsgSearchSession *aSearchSession, nsIMsgWindow *aMsgWindow, nsIMsgFolder *aMsgFolder, const char *aSearchUri) { return !_to ? NS_ERROR_NULL_POINTER : _to->Search(aSearchSession, aMsgWindow, aMsgFolder, aSearchUri); } \
  NS_SCRIPTABLE NS_IMETHOD StreamMessage(const char *aMessageURI, nsISupports *aConsumer, nsIMsgWindow *aMsgWindow, nsIUrlListener *aUrlListener, PRBool aConvertData, const nsACString & aAdditionalHeader, PRBool aLocalOnly, nsIURI **_retval NS_OUTPARAM) { return !_to ? NS_ERROR_NULL_POINTER : _to->StreamMessage(aMessageURI, aConsumer, aMsgWindow, aUrlListener, aConvertData, aAdditionalHeader, aLocalOnly, _retval); } \
  NS_SCRIPTABLE NS_IMETHOD IsMsgInMemCache(nsIURI *aUrl, nsIMsgFolder *aFolder, nsICacheEntryDescriptor **aCacheEntry NS_OUTPARAM, PRBool *_retval NS_OUTPARAM) { return !_to ? NS_ERROR_NULL_POINTER : _to->IsMsgInMemCache(aUrl, aFolder, aCacheEntry, _retval); } \
  NS_SCRIPTABLE NS_IMETHOD MessageURIToMsgHdr(const char *uri, nsIMsgDBHdr **_retval NS_OUTPARAM) { return !_to ? NS_ERROR_NULL_POINTER : _to->MessageURIToMsgHdr(uri, _retval); } 

#if 0
/* Use the code below as a template for the implementation class for this interface. */

/* Header file */
class nsMsgMessageService : public nsIMsgMessageService
{
public:
  NS_DECL_ISUPPORTS
  NS_DECL_NSIMSGMESSAGESERVICE

  nsMsgMessageService();

private:
  ~nsMsgMessageService();

protected:
  /* additional members */
};

/* Implementation file */
NS_IMPL_ISUPPORTS1(nsMsgMessageService, nsIMsgMessageService)

nsMsgMessageService::nsMsgMessageService()
{
  /* member initializers and constructor code */
}

nsMsgMessageService::~nsMsgMessageService()
{
  /* destructor code */
}

/* void CopyMessage (in string aSrcURI, in nsIStreamListener aCopyListener, in boolean aMoveMessage, in nsIUrlListener aUrlListener, in nsIMsgWindow aMsgWindow, out nsIURI aURL); */
NS_IMETHODIMP nsMsgMessageService::CopyMessage(const char *aSrcURI, nsIStreamListener *aCopyListener, PRBool aMoveMessage, nsIUrlListener *aUrlListener, nsIMsgWindow *aMsgWindow, nsIURI **aURL NS_OUTPARAM)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* [noscript] void CopyMessages (in nsMsgKeyArrayRef keys, in nsIMsgFolder srcFolder, in nsIStreamListener aCopyListener, in boolean aMoveMessage, in nsIUrlListener aUrlListener, in nsIMsgWindow aMsgWindow, out nsIURI aURL); */
NS_IMETHODIMP nsMsgMessageService::CopyMessages(nsTArray<nsMsgKey> & keys, nsIMsgFolder *srcFolder, nsIStreamListener *aCopyListener, PRBool aMoveMessage, nsIUrlListener *aUrlListener, nsIMsgWindow *aMsgWindow, nsIURI **aURL NS_OUTPARAM)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void DisplayMessage (in string aMessageURI, in nsISupports aDisplayConsumer, in nsIMsgWindow aMsgWindow, in nsIUrlListener aUrlListener, in string aCharsetOverride, out nsIURI aURL); */
NS_IMETHODIMP nsMsgMessageService::DisplayMessage(const char *aMessageURI, nsISupports *aDisplayConsumer, nsIMsgWindow *aMsgWindow, nsIUrlListener *aUrlListener, const char *aCharsetOverride, nsIURI **aURL NS_OUTPARAM)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void openAttachment (in string aContentType, in string aFileName, in string aUrl, in string aMessageUri, in nsISupports aDisplayConsumer, in nsIMsgWindow aMsgWindow, in nsIUrlListener aUrlListener); */
NS_IMETHODIMP nsMsgMessageService::OpenAttachment(const char *aContentType, const char *aFileName, const char *aUrl, const char *aMessageUri, nsISupports *aDisplayConsumer, nsIMsgWindow *aMsgWindow, nsIUrlListener *aUrlListener)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void SaveMessageToDisk (in string aMessageURI, in nsIFile aFile, in boolean aGenerateDummyEnvelope, in nsIUrlListener aUrlListener, out nsIURI aURL, in boolean canonicalLineEnding, in nsIMsgWindow aMsgWindow); */
NS_IMETHODIMP nsMsgMessageService::SaveMessageToDisk(const char *aMessageURI, nsIFile *aFile, PRBool aGenerateDummyEnvelope, nsIUrlListener *aUrlListener, nsIURI **aURL NS_OUTPARAM, PRBool canonicalLineEnding, nsIMsgWindow *aMsgWindow)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void GetUrlForUri (in string aMessageURI, out nsIURI aURL, in nsIMsgWindow aMsgWindow); */
NS_IMETHODIMP nsMsgMessageService::GetUrlForUri(const char *aMessageURI, nsIURI **aURL NS_OUTPARAM, nsIMsgWindow *aMsgWindow)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void DisplayMessageForPrinting (in string aMessageURI, in nsISupports aDisplayConsumer, in nsIMsgWindow aMsgWindow, in nsIUrlListener aUrlListener, out nsIURI aURL); */
NS_IMETHODIMP nsMsgMessageService::DisplayMessageForPrinting(const char *aMessageURI, nsISupports *aDisplayConsumer, nsIMsgWindow *aMsgWindow, nsIUrlListener *aUrlListener, nsIURI **aURL NS_OUTPARAM)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void Search (in nsIMsgSearchSession aSearchSession, in nsIMsgWindow aMsgWindow, in nsIMsgFolder aMsgFolder, in string aSearchUri); */
NS_IMETHODIMP nsMsgMessageService::Search(nsIMsgSearchSession *aSearchSession, nsIMsgWindow *aMsgWindow, nsIMsgFolder *aMsgFolder, const char *aSearchUri)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* nsIURI streamMessage (in string aMessageURI, in nsISupports aConsumer, in nsIMsgWindow aMsgWindow, in nsIUrlListener aUrlListener, in boolean aConvertData, in ACString aAdditionalHeader, [optional] in boolean aLocalOnly); */
NS_IMETHODIMP nsMsgMessageService::StreamMessage(const char *aMessageURI, nsISupports *aConsumer, nsIMsgWindow *aMsgWindow, nsIUrlListener *aUrlListener, PRBool aConvertData, const nsACString & aAdditionalHeader, PRBool aLocalOnly, nsIURI **_retval NS_OUTPARAM)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* boolean isMsgInMemCache (in nsIURI aUrl, in nsIMsgFolder aFolder, out nsICacheEntryDescriptor aCacheEntry); */
NS_IMETHODIMP nsMsgMessageService::IsMsgInMemCache(nsIURI *aUrl, nsIMsgFolder *aFolder, nsICacheEntryDescriptor **aCacheEntry NS_OUTPARAM, PRBool *_retval NS_OUTPARAM)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* nsIMsgDBHdr messageURIToMsgHdr (in string uri); */
NS_IMETHODIMP nsMsgMessageService::MessageURIToMsgHdr(const char *uri, nsIMsgDBHdr **_retval NS_OUTPARAM)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* End of implementation class template. */
#endif


/* starting interface:    nsIMsgMessageFetchPartService */
#define NS_IMSGMESSAGEFETCHPARTSERVICE_IID_STR "3728c255-480c-11d4-98d0-001083010e9b"

#define NS_IMSGMESSAGEFETCHPARTSERVICE_IID \
  {0x3728c255, 0x480c, 0x11d4, \
    { 0x98, 0xd0, 0x00, 0x10, 0x83, 0x01, 0x0e, 0x9b }}

/** 
 * Some mail protocols (like imap) allow you to fetch individual mime parts. We use this interface
 * to represent message services whose protocols support this. To use this interface, you should get
 * the message service then QI for this interface. If it's present, then can fetch a mime part.
 */
class NS_NO_VTABLE NS_SCRIPTABLE nsIMsgMessageFetchPartService : public nsISupports {
 public: 

  NS_DECLARE_STATIC_IID_ACCESSOR(NS_IMSGMESSAGEFETCHPARTSERVICE_IID)

  /**
   * Used to fetch an individual mime part
   *
   * @param aURI url representing the message
   * @param aMessageURI RDF URI including the part to fetch
   * @param aDisplayConsumer
   * @param aMsgWindow
   * @param aUrlListener
   *
   * @return
   */
  /* nsIURI fetchMimePart (in nsIURI aURI, in string aMessageUri, in nsISupports aDisplayConsumer, in nsIMsgWindow aMsgWindow, in nsIUrlListener aUrlListener); */
  NS_SCRIPTABLE NS_IMETHOD FetchMimePart(nsIURI *aURI, const char *aMessageUri, nsISupports *aDisplayConsumer, nsIMsgWindow *aMsgWindow, nsIUrlListener *aUrlListener, nsIURI **_retval NS_OUTPARAM) = 0;

};

  NS_DEFINE_STATIC_IID_ACCESSOR(nsIMsgMessageFetchPartService, NS_IMSGMESSAGEFETCHPARTSERVICE_IID)

/* Use this macro when declaring classes that implement this interface. */
#define NS_DECL_NSIMSGMESSAGEFETCHPARTSERVICE \
  NS_SCRIPTABLE NS_IMETHOD FetchMimePart(nsIURI *aURI, const char *aMessageUri, nsISupports *aDisplayConsumer, nsIMsgWindow *aMsgWindow, nsIUrlListener *aUrlListener, nsIURI **_retval NS_OUTPARAM); 

/* Use this macro to declare functions that forward the behavior of this interface to another object. */
#define NS_FORWARD_NSIMSGMESSAGEFETCHPARTSERVICE(_to) \
  NS_SCRIPTABLE NS_IMETHOD FetchMimePart(nsIURI *aURI, const char *aMessageUri, nsISupports *aDisplayConsumer, nsIMsgWindow *aMsgWindow, nsIUrlListener *aUrlListener, nsIURI **_retval NS_OUTPARAM) { return _to FetchMimePart(aURI, aMessageUri, aDisplayConsumer, aMsgWindow, aUrlListener, _retval); } 

/* Use this macro to declare functions that forward the behavior of this interface to another object in a safe way. */
#define NS_FORWARD_SAFE_NSIMSGMESSAGEFETCHPARTSERVICE(_to) \
  NS_SCRIPTABLE NS_IMETHOD FetchMimePart(nsIURI *aURI, const char *aMessageUri, nsISupports *aDisplayConsumer, nsIMsgWindow *aMsgWindow, nsIUrlListener *aUrlListener, nsIURI **_retval NS_OUTPARAM) { return !_to ? NS_ERROR_NULL_POINTER : _to->FetchMimePart(aURI, aMessageUri, aDisplayConsumer, aMsgWindow, aUrlListener, _retval); } 

#if 0
/* Use the code below as a template for the implementation class for this interface. */

/* Header file */
class nsMsgMessageFetchPartService : public nsIMsgMessageFetchPartService
{
public:
  NS_DECL_ISUPPORTS
  NS_DECL_NSIMSGMESSAGEFETCHPARTSERVICE

  nsMsgMessageFetchPartService();

private:
  ~nsMsgMessageFetchPartService();

protected:
  /* additional members */
};

/* Implementation file */
NS_IMPL_ISUPPORTS1(nsMsgMessageFetchPartService, nsIMsgMessageFetchPartService)

nsMsgMessageFetchPartService::nsMsgMessageFetchPartService()
{
  /* member initializers and constructor code */
}

nsMsgMessageFetchPartService::~nsMsgMessageFetchPartService()
{
  /* destructor code */
}

/* nsIURI fetchMimePart (in nsIURI aURI, in string aMessageUri, in nsISupports aDisplayConsumer, in nsIMsgWindow aMsgWindow, in nsIUrlListener aUrlListener); */
NS_IMETHODIMP nsMsgMessageFetchPartService::FetchMimePart(nsIURI *aURI, const char *aMessageUri, nsISupports *aDisplayConsumer, nsIMsgWindow *aMsgWindow, nsIUrlListener *aUrlListener, nsIURI **_retval NS_OUTPARAM)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* End of implementation class template. */
#endif


#endif /* __gen_nsIMsgMessageService_h__ */
