/*
 * DO NOT EDIT.  THIS FILE IS GENERATED FROM nsIMsgCopyService.idl
 */

#ifndef __gen_nsIMsgCopyService_h__
#define __gen_nsIMsgCopyService_h__


#ifndef __gen_nsrootidl_h__
#include "nsrootidl.h"
#endif

#ifndef __gen_nsISupports_h__
#include "nsISupports.h"
#endif

#ifndef __gen_nsIMsgFolder_h__
#include "nsIMsgFolder.h"
#endif

#ifndef __gen_nsIMsgCopyServiceListener_h__
#include "nsIMsgCopyServiceListener.h"
#endif

/* For IDL files that don't want to include root IDL files. */
#ifndef NS_NO_VTABLE
#define NS_NO_VTABLE
#endif
class nsIMsgDBHdr; /* forward declaration */

#include "nsITransactionManager.h"
class nsITransactionManager; /* forward declaration */

class nsIMsgWindow; /* forward declaration */

class nsIFile; /* forward declaration */

class nsIArray; /* forward declaration */


/* starting interface:    nsIMsgCopyService */
#define NS_IMSGCOPYSERVICE_IID_STR "f21e428b-73c5-4607-993b-d37325b33722"

#define NS_IMSGCOPYSERVICE_IID \
  {0xf21e428b, 0x73c5, 0x4607, \
    { 0x99, 0x3b, 0xd3, 0x73, 0x25, 0xb3, 0x37, 0x22 }}

class NS_NO_VTABLE NS_SCRIPTABLE nsIMsgCopyService : public nsISupports {
 public: 

  NS_DECLARE_STATIC_IID_ACCESSOR(NS_IMSGCOPYSERVICE_IID)

  /**
   * Copies or moves existing messages from source folder to destination folder.
   *
   * @param srcFolder  Source folder of an operation.
   * @param messages   The array of nsIMsgHdrs in source folder which will be moved/copied.
   * @param dstFolder  Destination folder of operation.
   * @param isMove     false for copy operation, true for move operation.
   * @param listener   Listener which receive operation notifications
   * @param msgWindow  Window for notification callbacks, can be null.
   * @param allowUndo  Specifies if this operation will be done as an transaction
   *                   that can be undone.
   */
  /* void CopyMessages (in nsIMsgFolder srcFolder, in nsIArray messages, in nsIMsgFolder dstFolder, in boolean isMove, in nsIMsgCopyServiceListener listener, in nsIMsgWindow msgWindow, in boolean allowUndo); */
  NS_SCRIPTABLE NS_IMETHOD CopyMessages(nsIMsgFolder *srcFolder, nsIArray *messages, nsIMsgFolder *dstFolder, PRBool isMove, nsIMsgCopyServiceListener *listener, nsIMsgWindow *msgWindow, PRBool allowUndo) = 0;

  /**
   * Copies or moves existing folders do destination folder.
   *
   * @param folders    The array of nsIMsgFolders which will be moved/copied.
   * @param dstFolder  The destination folder of operation.
   * @param isMove     false for copy operation, true for move operation.
   * @param listener   Listener which receive operation notifications.
   * @param msgWindow  Window for notification callbacks, can be null.
   */
  /* void CopyFolders (in nsIArray folders, in nsIMsgFolder dstFolder, in boolean isMove, in nsIMsgCopyServiceListener listener, in nsIMsgWindow msgWindow); */
  NS_SCRIPTABLE NS_IMETHOD CopyFolders(nsIArray *folders, nsIMsgFolder *dstFolder, PRBool isMove, nsIMsgCopyServiceListener *listener, nsIMsgWindow *msgWindow) = 0;

  /**
   * Copies message in rfc format from file to folder.
   *
   * @param aFile             A file which contains message in rfc format which
   *                          will copied to destFolder.
   * @param dstFolder         Destination folder where a message will be copied.
   * @param msgToReplace      Header which identifies a message to use as a source
   *                          of message properties, or null. For example, when
   *                          deleting an attachment, the processed message is
   *                          stored in a file, but the metadata should be copied
   *                          from the original message. This method will NOT delete
   *                          the original message.
   * @param isDraftOrTemplate Specifies whether a message is a stored in draft
   *                          folder or not. If is true listener should
   *                          implement GetMessageId and return unique id for
   *                          message in destination folder. This is important
   *                          for IMAP servers which doesn't support uidplus.
   *                          If destination folder contains message with the
   *                          same message-id then it is possible that listener
   *                          get wrong message key in callback
   *                          nsIMsgCopyServiceListener::SetMessageKey.
   * @param aMsgFlags         Message flags which will be set after message is
   *                          copied
   * @param aMsgKeywords      Keywords which will be set for newly copied
   *                          message.
   * @param listener          Listener which receive copy notifications.
   * @param msgWindow         Window for notification callbacks, can be null.
   */
  /* void CopyFileMessage (in nsIFile aFile, in nsIMsgFolder dstFolder, in nsIMsgDBHdr msgToReplace, in boolean isDraftOrTemplate, in unsigned long aMsgFlags, in ACString aMsgKeywords, in nsIMsgCopyServiceListener listener, in nsIMsgWindow msgWindow); */
  NS_SCRIPTABLE NS_IMETHOD CopyFileMessage(nsIFile *aFile, nsIMsgFolder *dstFolder, nsIMsgDBHdr *msgToReplace, PRBool isDraftOrTemplate, PRUint32 aMsgFlags, const nsACString & aMsgKeywords, nsIMsgCopyServiceListener *listener, nsIMsgWindow *msgWindow) = 0;

  /**
   * Notify the message copy service that the destination folder has finished
   * it's messages copying operation so that the copy service can continue
   * copying the rest of the messages if there are more to copy with.
   * aSupport and dstFolder uniquely identify a copy service request.
   *
   * @param aSupport   The originator of CopyMessages or CopyFileMessage; it can
   *                   be either a nsIMsgFolder or a nsIFile
   * @param dstFolder  The destination folder which performs the copy operation
   * @param result     The result of the copy operation
   */
  /* void NotifyCompletion (in nsISupports aSupport, in nsIMsgFolder dstFolder, in nsresult result); */
  NS_SCRIPTABLE NS_IMETHOD NotifyCompletion(nsISupports *aSupport, nsIMsgFolder *dstFolder, nsresult result) = 0;

};

  NS_DEFINE_STATIC_IID_ACCESSOR(nsIMsgCopyService, NS_IMSGCOPYSERVICE_IID)

/* Use this macro when declaring classes that implement this interface. */
#define NS_DECL_NSIMSGCOPYSERVICE \
  NS_SCRIPTABLE NS_IMETHOD CopyMessages(nsIMsgFolder *srcFolder, nsIArray *messages, nsIMsgFolder *dstFolder, PRBool isMove, nsIMsgCopyServiceListener *listener, nsIMsgWindow *msgWindow, PRBool allowUndo); \
  NS_SCRIPTABLE NS_IMETHOD CopyFolders(nsIArray *folders, nsIMsgFolder *dstFolder, PRBool isMove, nsIMsgCopyServiceListener *listener, nsIMsgWindow *msgWindow); \
  NS_SCRIPTABLE NS_IMETHOD CopyFileMessage(nsIFile *aFile, nsIMsgFolder *dstFolder, nsIMsgDBHdr *msgToReplace, PRBool isDraftOrTemplate, PRUint32 aMsgFlags, const nsACString & aMsgKeywords, nsIMsgCopyServiceListener *listener, nsIMsgWindow *msgWindow); \
  NS_SCRIPTABLE NS_IMETHOD NotifyCompletion(nsISupports *aSupport, nsIMsgFolder *dstFolder, nsresult result); 

/* Use this macro to declare functions that forward the behavior of this interface to another object. */
#define NS_FORWARD_NSIMSGCOPYSERVICE(_to) \
  NS_SCRIPTABLE NS_IMETHOD CopyMessages(nsIMsgFolder *srcFolder, nsIArray *messages, nsIMsgFolder *dstFolder, PRBool isMove, nsIMsgCopyServiceListener *listener, nsIMsgWindow *msgWindow, PRBool allowUndo) { return _to CopyMessages(srcFolder, messages, dstFolder, isMove, listener, msgWindow, allowUndo); } \
  NS_SCRIPTABLE NS_IMETHOD CopyFolders(nsIArray *folders, nsIMsgFolder *dstFolder, PRBool isMove, nsIMsgCopyServiceListener *listener, nsIMsgWindow *msgWindow) { return _to CopyFolders(folders, dstFolder, isMove, listener, msgWindow); } \
  NS_SCRIPTABLE NS_IMETHOD CopyFileMessage(nsIFile *aFile, nsIMsgFolder *dstFolder, nsIMsgDBHdr *msgToReplace, PRBool isDraftOrTemplate, PRUint32 aMsgFlags, const nsACString & aMsgKeywords, nsIMsgCopyServiceListener *listener, nsIMsgWindow *msgWindow) { return _to CopyFileMessage(aFile, dstFolder, msgToReplace, isDraftOrTemplate, aMsgFlags, aMsgKeywords, listener, msgWindow); } \
  NS_SCRIPTABLE NS_IMETHOD NotifyCompletion(nsISupports *aSupport, nsIMsgFolder *dstFolder, nsresult result) { return _to NotifyCompletion(aSupport, dstFolder, result); } 

/* Use this macro to declare functions that forward the behavior of this interface to another object in a safe way. */
#define NS_FORWARD_SAFE_NSIMSGCOPYSERVICE(_to) \
  NS_SCRIPTABLE NS_IMETHOD CopyMessages(nsIMsgFolder *srcFolder, nsIArray *messages, nsIMsgFolder *dstFolder, PRBool isMove, nsIMsgCopyServiceListener *listener, nsIMsgWindow *msgWindow, PRBool allowUndo) { return !_to ? NS_ERROR_NULL_POINTER : _to->CopyMessages(srcFolder, messages, dstFolder, isMove, listener, msgWindow, allowUndo); } \
  NS_SCRIPTABLE NS_IMETHOD CopyFolders(nsIArray *folders, nsIMsgFolder *dstFolder, PRBool isMove, nsIMsgCopyServiceListener *listener, nsIMsgWindow *msgWindow) { return !_to ? NS_ERROR_NULL_POINTER : _to->CopyFolders(folders, dstFolder, isMove, listener, msgWindow); } \
  NS_SCRIPTABLE NS_IMETHOD CopyFileMessage(nsIFile *aFile, nsIMsgFolder *dstFolder, nsIMsgDBHdr *msgToReplace, PRBool isDraftOrTemplate, PRUint32 aMsgFlags, const nsACString & aMsgKeywords, nsIMsgCopyServiceListener *listener, nsIMsgWindow *msgWindow) { return !_to ? NS_ERROR_NULL_POINTER : _to->CopyFileMessage(aFile, dstFolder, msgToReplace, isDraftOrTemplate, aMsgFlags, aMsgKeywords, listener, msgWindow); } \
  NS_SCRIPTABLE NS_IMETHOD NotifyCompletion(nsISupports *aSupport, nsIMsgFolder *dstFolder, nsresult result) { return !_to ? NS_ERROR_NULL_POINTER : _to->NotifyCompletion(aSupport, dstFolder, result); } 

#if 0
/* Use the code below as a template for the implementation class for this interface. */

/* Header file */
class nsMsgCopyService : public nsIMsgCopyService
{
public:
  NS_DECL_ISUPPORTS
  NS_DECL_NSIMSGCOPYSERVICE

  nsMsgCopyService();

private:
  ~nsMsgCopyService();

protected:
  /* additional members */
};

/* Implementation file */
NS_IMPL_ISUPPORTS1(nsMsgCopyService, nsIMsgCopyService)

nsMsgCopyService::nsMsgCopyService()
{
  /* member initializers and constructor code */
}

nsMsgCopyService::~nsMsgCopyService()
{
  /* destructor code */
}

/* void CopyMessages (in nsIMsgFolder srcFolder, in nsIArray messages, in nsIMsgFolder dstFolder, in boolean isMove, in nsIMsgCopyServiceListener listener, in nsIMsgWindow msgWindow, in boolean allowUndo); */
NS_IMETHODIMP nsMsgCopyService::CopyMessages(nsIMsgFolder *srcFolder, nsIArray *messages, nsIMsgFolder *dstFolder, PRBool isMove, nsIMsgCopyServiceListener *listener, nsIMsgWindow *msgWindow, PRBool allowUndo)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void CopyFolders (in nsIArray folders, in nsIMsgFolder dstFolder, in boolean isMove, in nsIMsgCopyServiceListener listener, in nsIMsgWindow msgWindow); */
NS_IMETHODIMP nsMsgCopyService::CopyFolders(nsIArray *folders, nsIMsgFolder *dstFolder, PRBool isMove, nsIMsgCopyServiceListener *listener, nsIMsgWindow *msgWindow)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void CopyFileMessage (in nsIFile aFile, in nsIMsgFolder dstFolder, in nsIMsgDBHdr msgToReplace, in boolean isDraftOrTemplate, in unsigned long aMsgFlags, in ACString aMsgKeywords, in nsIMsgCopyServiceListener listener, in nsIMsgWindow msgWindow); */
NS_IMETHODIMP nsMsgCopyService::CopyFileMessage(nsIFile *aFile, nsIMsgFolder *dstFolder, nsIMsgDBHdr *msgToReplace, PRBool isDraftOrTemplate, PRUint32 aMsgFlags, const nsACString & aMsgKeywords, nsIMsgCopyServiceListener *listener, nsIMsgWindow *msgWindow)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void NotifyCompletion (in nsISupports aSupport, in nsIMsgFolder dstFolder, in nsresult result); */
NS_IMETHODIMP nsMsgCopyService::NotifyCompletion(nsISupports *aSupport, nsIMsgFolder *dstFolder, nsresult result)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* End of implementation class template. */
#endif


#endif /* __gen_nsIMsgCopyService_h__ */
