/*
 * DO NOT EDIT.  THIS FILE IS GENERATED FROM nsIMsgComposeService.idl
 */

#ifndef __gen_nsIMsgComposeService_h__
#define __gen_nsIMsgComposeService_h__


#ifndef __gen_nsISupports_h__
#include "nsISupports.h"
#endif

#ifndef __gen_nsIMsgCompose_h__
#include "nsIMsgCompose.h"
#endif

#ifndef __gen_nsIMsgComposeParams_h__
#include "nsIMsgComposeParams.h"
#endif

/* For IDL files that don't want to include root IDL files. */
#ifndef NS_NO_VTABLE
#define NS_NO_VTABLE
#endif
class nsIURI; /* forward declaration */

class nsIDocShell; /* forward declaration */

class nsIMsgWindow; /* forward declaration */

class nsIMsgIdentity; /* forward declaration */

class nsIMsgIncomingServer; /* forward declaration */

class nsIMsgDBHdr; /* forward declaration */


/* starting interface:    nsIMsgComposeService */
#define NS_IMSGCOMPOSESERVICE_IID_STR "b73dae1e-7e97-45aa-8669-dacbb7e9fbd0"

#define NS_IMSGCOMPOSESERVICE_IID \
  {0xb73dae1e, 0x7e97, 0x45aa, \
    { 0x86, 0x69, 0xda, 0xcb, 0xb7, 0xe9, 0xfb, 0xd0 }}

class NS_NO_VTABLE NS_SCRIPTABLE nsIMsgComposeService : public nsISupports {
 public: 

  NS_DECLARE_STATIC_IID_ACCESSOR(NS_IMSGCOMPOSESERVICE_IID)

  /* void OpenComposeWindow (in string msgComposeWindowURL, in nsIMsgDBHdr msgHdr, in string originalMsgURI, in MSG_ComposeType type, in MSG_ComposeFormat format, in nsIMsgIdentity identity, in nsIMsgWindow aMsgWindow); */
  NS_SCRIPTABLE NS_IMETHOD OpenComposeWindow(const char *msgComposeWindowURL, nsIMsgDBHdr *msgHdr, const char *originalMsgURI, MSG_ComposeType type, MSG_ComposeFormat format, nsIMsgIdentity *identity, nsIMsgWindow *aMsgWindow) = 0;

  /* void OpenComposeWindowWithURI (in string msgComposeWindowURL, in nsIURI aURI); */
  NS_SCRIPTABLE NS_IMETHOD OpenComposeWindowWithURI(const char *msgComposeWindowURL, nsIURI *aURI) = 0;

  /* void OpenComposeWindowWithParams (in string msgComposeWindowURL, in nsIMsgComposeParams params); */
  NS_SCRIPTABLE NS_IMETHOD OpenComposeWindowWithParams(const char *msgComposeWindowURL, nsIMsgComposeParams *params) = 0;

  /**
   * Creates an nsIMsgCompose instance, initalizes it, and manages the window
   * recycling cache.
   *
   * @param aParams   An nsIMsgComposeParams object containing the initial
   *                  details for the compose.
   * @param aWindow   The optional window associated with this compose object.
   * @param aDocShell The optional docShell of the editor element that is used
   *                  for composing.
   */
  /* nsIMsgCompose initCompose (in nsIMsgComposeParams aParams, [optional] in nsIDOMWindowInternal aWindow, [optional] in nsIDocShell aDocShell); */
  NS_SCRIPTABLE NS_IMETHOD InitCompose(nsIMsgComposeParams *aParams, nsIDOMWindowInternal *aWindow, nsIDocShell *aDocShell, nsIMsgCompose **_retval NS_OUTPARAM) = 0;

  /**
  * defaultIdentity
  *
  * @return the default identity, in case no identity has been setup yet, will return null
  */
  /* readonly attribute nsIMsgIdentity defaultIdentity; */
  NS_SCRIPTABLE NS_IMETHOD GetDefaultIdentity(nsIMsgIdentity **aDefaultIdentity) = 0;

  /* void TimeStamp (in string label, in boolean resetTime); */
  NS_SCRIPTABLE NS_IMETHOD TimeStamp(const char *label, PRBool resetTime) = 0;

  /* readonly attribute boolean logComposePerformance; */
  NS_SCRIPTABLE NS_IMETHOD GetLogComposePerformance(PRBool *aLogComposePerformance) = 0;

  /* [noscript] boolean determineComposeHTML (in nsIMsgIdentity aIdentity, in MSG_ComposeFormat aFormat); */
  NS_IMETHOD DetermineComposeHTML(nsIMsgIdentity *aIdentity, MSG_ComposeFormat aFormat, PRBool *_retval NS_OUTPARAM) = 0;

  /* [noscript] void cacheWindow (in nsIDOMWindowInternal aWindow, in boolean aComposeHTML, in nsIMsgComposeRecyclingListener listener); */
  NS_IMETHOD CacheWindow(nsIDOMWindowInternal *aWindow, PRBool aComposeHTML, nsIMsgComposeRecyclingListener *listener) = 0;

  /* boolean isCachedWindow (in nsIDOMWindowInternal aWindow); */
  NS_SCRIPTABLE NS_IMETHOD IsCachedWindow(nsIDOMWindowInternal *aWindow, PRBool *_retval NS_OUTPARAM) = 0;

  /** 
   * given a mailto url, parse the attributes and turn them into a nsIMsgComposeParams object
   * @return nsIMsgComposeParams which corresponds to the passed in mailto url
   */
  /* nsIMsgComposeParams getParamsForMailto (in nsIURI aURI); */
  NS_SCRIPTABLE NS_IMETHOD GetParamsForMailto(nsIURI *aURI, nsIMsgComposeParams **_retval NS_OUTPARAM) = 0;

  /**
   * @{
   * These constants control how to forward messages in forwardMessage.
   * kForwardAsDefault uses value of pref "mail.forward_message_mode".
   */
  enum { kForwardAsDefault = 0U };

  enum { kForwardAsAttachment = 1U };

  enum { kForwardInline = 2U };

  /** @} */
/**
   * Allow filters to automatically forward a message to the given address(es).
   * @param forwardTo the address(es) to forward to
   * @param msgHdr the header of the message being replied to
   * @param msgWindow message window to use
   * @param server server to use for determining which account to send from
   * @param aForwardType - How to forward the message one of 3 values:
   *                       kForwardAsDefault, kForwardInline, or
   *                       kForwardAsAttachment.
   */
  /* void forwardMessage (in AString forwardTo, in nsIMsgDBHdr msgHdr, in nsIMsgWindow msgWindow, in nsIMsgIncomingServer server, in unsigned long aForwardType); */
  NS_SCRIPTABLE NS_IMETHOD ForwardMessage(const nsAString & forwardTo, nsIMsgDBHdr *msgHdr, nsIMsgWindow *msgWindow, nsIMsgIncomingServer *server, PRUint32 aForwardType) = 0;

  /**
   * Allow filters to automatically reply to a message. The reply message is
   * based on the given template.
   * @param msgHdr the header of the message being replied to
   * @param templateUri uri of the template to base ther reply on
   * @param msgWindow message window to use
   * @param server server to use for determining which account to send from
   */
  /* void replyWithTemplate (in nsIMsgDBHdr msgHdr, in string templateUri, in nsIMsgWindow msgWindow, in nsIMsgIncomingServer server); */
  NS_SCRIPTABLE NS_IMETHOD ReplyWithTemplate(nsIMsgDBHdr *msgHdr, const char *templateUri, nsIMsgWindow *msgWindow, nsIMsgIncomingServer *server) = 0;

  /** 
   * The docShell of each editor element used for composing should be registered
   * with this service. docShells passed to initCompose get registered
   * automatically. The registrations are typically used to get the msgCompose
   * window when determining what remote content to allow to be displayed.
   *
   * @param aDocShell The nsIDocShell of the editor element. 
   * @param aMsgCompose The compose object associated with the compose window
   */
  /* void registerComposeDocShell (in nsIDocShell aDocShell, in nsIMsgCompose aMsgCompose); */
  NS_SCRIPTABLE NS_IMETHOD RegisterComposeDocShell(nsIDocShell *aDocShell, nsIMsgCompose *aMsgCompose) = 0;

  /** 
   * When an editor docShell is being closed (or recycled), you should
   * unregister it from this service. nsIMsgCompose normally calls this
   * automatically for items passed to initCompose.
   *
   * @param aDocShell The nsIDocShell of the editor element. 
   */
  /* void unregisterComposeDocShell (in nsIDocShell aDocShell); */
  NS_SCRIPTABLE NS_IMETHOD UnregisterComposeDocShell(nsIDocShell *aDocShell) = 0;

  /**
   * For a given docShell, returns the nsIMsgCompose object associated with it.
   *
   * @param aDocShell The nsIDocShell of the editor element. 
   *
   * @return NS_ERROR_FAILURE if we could not find a nsIMsgCompose for
   *         the passed in docShell.
   */
  /* nsIMsgCompose getMsgComposeForDocShell (in nsIDocShell aDocShell); */
  NS_SCRIPTABLE NS_IMETHOD GetMsgComposeForDocShell(nsIDocShell *aDocShell, nsIMsgCompose **_retval NS_OUTPARAM) = 0;

};

  NS_DEFINE_STATIC_IID_ACCESSOR(nsIMsgComposeService, NS_IMSGCOMPOSESERVICE_IID)

/* Use this macro when declaring classes that implement this interface. */
#define NS_DECL_NSIMSGCOMPOSESERVICE \
  NS_SCRIPTABLE NS_IMETHOD OpenComposeWindow(const char *msgComposeWindowURL, nsIMsgDBHdr *msgHdr, const char *originalMsgURI, MSG_ComposeType type, MSG_ComposeFormat format, nsIMsgIdentity *identity, nsIMsgWindow *aMsgWindow); \
  NS_SCRIPTABLE NS_IMETHOD OpenComposeWindowWithURI(const char *msgComposeWindowURL, nsIURI *aURI); \
  NS_SCRIPTABLE NS_IMETHOD OpenComposeWindowWithParams(const char *msgComposeWindowURL, nsIMsgComposeParams *params); \
  NS_SCRIPTABLE NS_IMETHOD InitCompose(nsIMsgComposeParams *aParams, nsIDOMWindowInternal *aWindow, nsIDocShell *aDocShell, nsIMsgCompose **_retval NS_OUTPARAM); \
  NS_SCRIPTABLE NS_IMETHOD GetDefaultIdentity(nsIMsgIdentity **aDefaultIdentity); \
  NS_SCRIPTABLE NS_IMETHOD TimeStamp(const char *label, PRBool resetTime); \
  NS_SCRIPTABLE NS_IMETHOD GetLogComposePerformance(PRBool *aLogComposePerformance); \
  NS_IMETHOD DetermineComposeHTML(nsIMsgIdentity *aIdentity, MSG_ComposeFormat aFormat, PRBool *_retval NS_OUTPARAM); \
  NS_IMETHOD CacheWindow(nsIDOMWindowInternal *aWindow, PRBool aComposeHTML, nsIMsgComposeRecyclingListener *listener); \
  NS_SCRIPTABLE NS_IMETHOD IsCachedWindow(nsIDOMWindowInternal *aWindow, PRBool *_retval NS_OUTPARAM); \
  NS_SCRIPTABLE NS_IMETHOD GetParamsForMailto(nsIURI *aURI, nsIMsgComposeParams **_retval NS_OUTPARAM); \
  NS_SCRIPTABLE NS_IMETHOD ForwardMessage(const nsAString & forwardTo, nsIMsgDBHdr *msgHdr, nsIMsgWindow *msgWindow, nsIMsgIncomingServer *server, PRUint32 aForwardType); \
  NS_SCRIPTABLE NS_IMETHOD ReplyWithTemplate(nsIMsgDBHdr *msgHdr, const char *templateUri, nsIMsgWindow *msgWindow, nsIMsgIncomingServer *server); \
  NS_SCRIPTABLE NS_IMETHOD RegisterComposeDocShell(nsIDocShell *aDocShell, nsIMsgCompose *aMsgCompose); \
  NS_SCRIPTABLE NS_IMETHOD UnregisterComposeDocShell(nsIDocShell *aDocShell); \
  NS_SCRIPTABLE NS_IMETHOD GetMsgComposeForDocShell(nsIDocShell *aDocShell, nsIMsgCompose **_retval NS_OUTPARAM); 

/* Use this macro to declare functions that forward the behavior of this interface to another object. */
#define NS_FORWARD_NSIMSGCOMPOSESERVICE(_to) \
  NS_SCRIPTABLE NS_IMETHOD OpenComposeWindow(const char *msgComposeWindowURL, nsIMsgDBHdr *msgHdr, const char *originalMsgURI, MSG_ComposeType type, MSG_ComposeFormat format, nsIMsgIdentity *identity, nsIMsgWindow *aMsgWindow) { return _to OpenComposeWindow(msgComposeWindowURL, msgHdr, originalMsgURI, type, format, identity, aMsgWindow); } \
  NS_SCRIPTABLE NS_IMETHOD OpenComposeWindowWithURI(const char *msgComposeWindowURL, nsIURI *aURI) { return _to OpenComposeWindowWithURI(msgComposeWindowURL, aURI); } \
  NS_SCRIPTABLE NS_IMETHOD OpenComposeWindowWithParams(const char *msgComposeWindowURL, nsIMsgComposeParams *params) { return _to OpenComposeWindowWithParams(msgComposeWindowURL, params); } \
  NS_SCRIPTABLE NS_IMETHOD InitCompose(nsIMsgComposeParams *aParams, nsIDOMWindowInternal *aWindow, nsIDocShell *aDocShell, nsIMsgCompose **_retval NS_OUTPARAM) { return _to InitCompose(aParams, aWindow, aDocShell, _retval); } \
  NS_SCRIPTABLE NS_IMETHOD GetDefaultIdentity(nsIMsgIdentity **aDefaultIdentity) { return _to GetDefaultIdentity(aDefaultIdentity); } \
  NS_SCRIPTABLE NS_IMETHOD TimeStamp(const char *label, PRBool resetTime) { return _to TimeStamp(label, resetTime); } \
  NS_SCRIPTABLE NS_IMETHOD GetLogComposePerformance(PRBool *aLogComposePerformance) { return _to GetLogComposePerformance(aLogComposePerformance); } \
  NS_IMETHOD DetermineComposeHTML(nsIMsgIdentity *aIdentity, MSG_ComposeFormat aFormat, PRBool *_retval NS_OUTPARAM) { return _to DetermineComposeHTML(aIdentity, aFormat, _retval); } \
  NS_IMETHOD CacheWindow(nsIDOMWindowInternal *aWindow, PRBool aComposeHTML, nsIMsgComposeRecyclingListener *listener) { return _to CacheWindow(aWindow, aComposeHTML, listener); } \
  NS_SCRIPTABLE NS_IMETHOD IsCachedWindow(nsIDOMWindowInternal *aWindow, PRBool *_retval NS_OUTPARAM) { return _to IsCachedWindow(aWindow, _retval); } \
  NS_SCRIPTABLE NS_IMETHOD GetParamsForMailto(nsIURI *aURI, nsIMsgComposeParams **_retval NS_OUTPARAM) { return _to GetParamsForMailto(aURI, _retval); } \
  NS_SCRIPTABLE NS_IMETHOD ForwardMessage(const nsAString & forwardTo, nsIMsgDBHdr *msgHdr, nsIMsgWindow *msgWindow, nsIMsgIncomingServer *server, PRUint32 aForwardType) { return _to ForwardMessage(forwardTo, msgHdr, msgWindow, server, aForwardType); } \
  NS_SCRIPTABLE NS_IMETHOD ReplyWithTemplate(nsIMsgDBHdr *msgHdr, const char *templateUri, nsIMsgWindow *msgWindow, nsIMsgIncomingServer *server) { return _to ReplyWithTemplate(msgHdr, templateUri, msgWindow, server); } \
  NS_SCRIPTABLE NS_IMETHOD RegisterComposeDocShell(nsIDocShell *aDocShell, nsIMsgCompose *aMsgCompose) { return _to RegisterComposeDocShell(aDocShell, aMsgCompose); } \
  NS_SCRIPTABLE NS_IMETHOD UnregisterComposeDocShell(nsIDocShell *aDocShell) { return _to UnregisterComposeDocShell(aDocShell); } \
  NS_SCRIPTABLE NS_IMETHOD GetMsgComposeForDocShell(nsIDocShell *aDocShell, nsIMsgCompose **_retval NS_OUTPARAM) { return _to GetMsgComposeForDocShell(aDocShell, _retval); } 

/* Use this macro to declare functions that forward the behavior of this interface to another object in a safe way. */
#define NS_FORWARD_SAFE_NSIMSGCOMPOSESERVICE(_to) \
  NS_SCRIPTABLE NS_IMETHOD OpenComposeWindow(const char *msgComposeWindowURL, nsIMsgDBHdr *msgHdr, const char *originalMsgURI, MSG_ComposeType type, MSG_ComposeFormat format, nsIMsgIdentity *identity, nsIMsgWindow *aMsgWindow) { return !_to ? NS_ERROR_NULL_POINTER : _to->OpenComposeWindow(msgComposeWindowURL, msgHdr, originalMsgURI, type, format, identity, aMsgWindow); } \
  NS_SCRIPTABLE NS_IMETHOD OpenComposeWindowWithURI(const char *msgComposeWindowURL, nsIURI *aURI) { return !_to ? NS_ERROR_NULL_POINTER : _to->OpenComposeWindowWithURI(msgComposeWindowURL, aURI); } \
  NS_SCRIPTABLE NS_IMETHOD OpenComposeWindowWithParams(const char *msgComposeWindowURL, nsIMsgComposeParams *params) { return !_to ? NS_ERROR_NULL_POINTER : _to->OpenComposeWindowWithParams(msgComposeWindowURL, params); } \
  NS_SCRIPTABLE NS_IMETHOD InitCompose(nsIMsgComposeParams *aParams, nsIDOMWindowInternal *aWindow, nsIDocShell *aDocShell, nsIMsgCompose **_retval NS_OUTPARAM) { return !_to ? NS_ERROR_NULL_POINTER : _to->InitCompose(aParams, aWindow, aDocShell, _retval); } \
  NS_SCRIPTABLE NS_IMETHOD GetDefaultIdentity(nsIMsgIdentity **aDefaultIdentity) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetDefaultIdentity(aDefaultIdentity); } \
  NS_SCRIPTABLE NS_IMETHOD TimeStamp(const char *label, PRBool resetTime) { return !_to ? NS_ERROR_NULL_POINTER : _to->TimeStamp(label, resetTime); } \
  NS_SCRIPTABLE NS_IMETHOD GetLogComposePerformance(PRBool *aLogComposePerformance) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetLogComposePerformance(aLogComposePerformance); } \
  NS_IMETHOD DetermineComposeHTML(nsIMsgIdentity *aIdentity, MSG_ComposeFormat aFormat, PRBool *_retval NS_OUTPARAM) { return !_to ? NS_ERROR_NULL_POINTER : _to->DetermineComposeHTML(aIdentity, aFormat, _retval); } \
  NS_IMETHOD CacheWindow(nsIDOMWindowInternal *aWindow, PRBool aComposeHTML, nsIMsgComposeRecyclingListener *listener) { return !_to ? NS_ERROR_NULL_POINTER : _to->CacheWindow(aWindow, aComposeHTML, listener); } \
  NS_SCRIPTABLE NS_IMETHOD IsCachedWindow(nsIDOMWindowInternal *aWindow, PRBool *_retval NS_OUTPARAM) { return !_to ? NS_ERROR_NULL_POINTER : _to->IsCachedWindow(aWindow, _retval); } \
  NS_SCRIPTABLE NS_IMETHOD GetParamsForMailto(nsIURI *aURI, nsIMsgComposeParams **_retval NS_OUTPARAM) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetParamsForMailto(aURI, _retval); } \
  NS_SCRIPTABLE NS_IMETHOD ForwardMessage(const nsAString & forwardTo, nsIMsgDBHdr *msgHdr, nsIMsgWindow *msgWindow, nsIMsgIncomingServer *server, PRUint32 aForwardType) { return !_to ? NS_ERROR_NULL_POINTER : _to->ForwardMessage(forwardTo, msgHdr, msgWindow, server, aForwardType); } \
  NS_SCRIPTABLE NS_IMETHOD ReplyWithTemplate(nsIMsgDBHdr *msgHdr, const char *templateUri, nsIMsgWindow *msgWindow, nsIMsgIncomingServer *server) { return !_to ? NS_ERROR_NULL_POINTER : _to->ReplyWithTemplate(msgHdr, templateUri, msgWindow, server); } \
  NS_SCRIPTABLE NS_IMETHOD RegisterComposeDocShell(nsIDocShell *aDocShell, nsIMsgCompose *aMsgCompose) { return !_to ? NS_ERROR_NULL_POINTER : _to->RegisterComposeDocShell(aDocShell, aMsgCompose); } \
  NS_SCRIPTABLE NS_IMETHOD UnregisterComposeDocShell(nsIDocShell *aDocShell) { return !_to ? NS_ERROR_NULL_POINTER : _to->UnregisterComposeDocShell(aDocShell); } \
  NS_SCRIPTABLE NS_IMETHOD GetMsgComposeForDocShell(nsIDocShell *aDocShell, nsIMsgCompose **_retval NS_OUTPARAM) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetMsgComposeForDocShell(aDocShell, _retval); } 

#if 0
/* Use the code below as a template for the implementation class for this interface. */

/* Header file */
class nsMsgComposeService : public nsIMsgComposeService
{
public:
  NS_DECL_ISUPPORTS
  NS_DECL_NSIMSGCOMPOSESERVICE

  nsMsgComposeService();

private:
  ~nsMsgComposeService();

protected:
  /* additional members */
};

/* Implementation file */
NS_IMPL_ISUPPORTS1(nsMsgComposeService, nsIMsgComposeService)

nsMsgComposeService::nsMsgComposeService()
{
  /* member initializers and constructor code */
}

nsMsgComposeService::~nsMsgComposeService()
{
  /* destructor code */
}

/* void OpenComposeWindow (in string msgComposeWindowURL, in nsIMsgDBHdr msgHdr, in string originalMsgURI, in MSG_ComposeType type, in MSG_ComposeFormat format, in nsIMsgIdentity identity, in nsIMsgWindow aMsgWindow); */
NS_IMETHODIMP nsMsgComposeService::OpenComposeWindow(const char *msgComposeWindowURL, nsIMsgDBHdr *msgHdr, const char *originalMsgURI, MSG_ComposeType type, MSG_ComposeFormat format, nsIMsgIdentity *identity, nsIMsgWindow *aMsgWindow)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void OpenComposeWindowWithURI (in string msgComposeWindowURL, in nsIURI aURI); */
NS_IMETHODIMP nsMsgComposeService::OpenComposeWindowWithURI(const char *msgComposeWindowURL, nsIURI *aURI)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void OpenComposeWindowWithParams (in string msgComposeWindowURL, in nsIMsgComposeParams params); */
NS_IMETHODIMP nsMsgComposeService::OpenComposeWindowWithParams(const char *msgComposeWindowURL, nsIMsgComposeParams *params)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* nsIMsgCompose initCompose (in nsIMsgComposeParams aParams, [optional] in nsIDOMWindowInternal aWindow, [optional] in nsIDocShell aDocShell); */
NS_IMETHODIMP nsMsgComposeService::InitCompose(nsIMsgComposeParams *aParams, nsIDOMWindowInternal *aWindow, nsIDocShell *aDocShell, nsIMsgCompose **_retval NS_OUTPARAM)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* readonly attribute nsIMsgIdentity defaultIdentity; */
NS_IMETHODIMP nsMsgComposeService::GetDefaultIdentity(nsIMsgIdentity **aDefaultIdentity)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void TimeStamp (in string label, in boolean resetTime); */
NS_IMETHODIMP nsMsgComposeService::TimeStamp(const char *label, PRBool resetTime)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* readonly attribute boolean logComposePerformance; */
NS_IMETHODIMP nsMsgComposeService::GetLogComposePerformance(PRBool *aLogComposePerformance)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* [noscript] boolean determineComposeHTML (in nsIMsgIdentity aIdentity, in MSG_ComposeFormat aFormat); */
NS_IMETHODIMP nsMsgComposeService::DetermineComposeHTML(nsIMsgIdentity *aIdentity, MSG_ComposeFormat aFormat, PRBool *_retval NS_OUTPARAM)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* [noscript] void cacheWindow (in nsIDOMWindowInternal aWindow, in boolean aComposeHTML, in nsIMsgComposeRecyclingListener listener); */
NS_IMETHODIMP nsMsgComposeService::CacheWindow(nsIDOMWindowInternal *aWindow, PRBool aComposeHTML, nsIMsgComposeRecyclingListener *listener)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* boolean isCachedWindow (in nsIDOMWindowInternal aWindow); */
NS_IMETHODIMP nsMsgComposeService::IsCachedWindow(nsIDOMWindowInternal *aWindow, PRBool *_retval NS_OUTPARAM)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* nsIMsgComposeParams getParamsForMailto (in nsIURI aURI); */
NS_IMETHODIMP nsMsgComposeService::GetParamsForMailto(nsIURI *aURI, nsIMsgComposeParams **_retval NS_OUTPARAM)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void forwardMessage (in AString forwardTo, in nsIMsgDBHdr msgHdr, in nsIMsgWindow msgWindow, in nsIMsgIncomingServer server, in unsigned long aForwardType); */
NS_IMETHODIMP nsMsgComposeService::ForwardMessage(const nsAString & forwardTo, nsIMsgDBHdr *msgHdr, nsIMsgWindow *msgWindow, nsIMsgIncomingServer *server, PRUint32 aForwardType)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void replyWithTemplate (in nsIMsgDBHdr msgHdr, in string templateUri, in nsIMsgWindow msgWindow, in nsIMsgIncomingServer server); */
NS_IMETHODIMP nsMsgComposeService::ReplyWithTemplate(nsIMsgDBHdr *msgHdr, const char *templateUri, nsIMsgWindow *msgWindow, nsIMsgIncomingServer *server)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void registerComposeDocShell (in nsIDocShell aDocShell, in nsIMsgCompose aMsgCompose); */
NS_IMETHODIMP nsMsgComposeService::RegisterComposeDocShell(nsIDocShell *aDocShell, nsIMsgCompose *aMsgCompose)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void unregisterComposeDocShell (in nsIDocShell aDocShell); */
NS_IMETHODIMP nsMsgComposeService::UnregisterComposeDocShell(nsIDocShell *aDocShell)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* nsIMsgCompose getMsgComposeForDocShell (in nsIDocShell aDocShell); */
NS_IMETHODIMP nsMsgComposeService::GetMsgComposeForDocShell(nsIDocShell *aDocShell, nsIMsgCompose **_retval NS_OUTPARAM)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* End of implementation class template. */
#endif


#endif /* __gen_nsIMsgComposeService_h__ */
