/*
 * DO NOT EDIT.  THIS FILE IS GENERATED FROM nsIImapServerSink.idl
 */

#ifndef __gen_nsIImapServerSink_h__
#define __gen_nsIImapServerSink_h__


#ifndef __gen_nsISupports_h__
#include "nsISupports.h"
#endif

#ifndef __gen_MailNewsTypes2_h__
#include "MailNewsTypes2.h"
#endif

/* For IDL files that don't want to include root IDL files. */
#ifndef NS_NO_VTABLE
#define NS_NO_VTABLE
#endif
class nsIMsgWindow; /* forward declaration */

class nsIMsgMailNewsUrl; /* forward declaration */

class nsIImapProtocol; /* forward declaration */

class nsIImapUrl; /* forward declaration */

class nsIImapMockChannel; /* forward declaration */


/* starting interface:    nsIImapServerSink */
#define NS_IIMAPSERVERSINK_IID_STR "1c90d58b-a41b-480d-983f-9d8e83efed0a"

#define NS_IIMAPSERVERSINK_IID \
  {0x1c90d58b, 0xa41b, 0x480d, \
    { 0x98, 0x3f, 0x9d, 0x8e, 0x83, 0xef, 0xed, 0x0a }}

/**
 * nsIImapServerSink is designed to be used as a proxy to the application's UI
 * thread from the running IMAP threads.
 */
class NS_NO_VTABLE NS_SCRIPTABLE nsIImapServerSink : public nsISupports {
 public: 

  NS_DECLARE_STATIC_IID_ACCESSOR(NS_IIMAPSERVERSINK_IID)

  /**
   * Check if the given folder path is a possible IMAP mailbox.
   * @param folderPath folder path to check
   * @param hierarchyDelimiter IMAP hierarchy delimiter in canonical format,
   *                           i.e., hierarchy delimiter has been replaced
   *                           with '/'
   * @param boxFlags IMAP folder flags (for subscription, namespaces etc.)
   * @return true if it's a new mailbox
   */
  /* boolean possibleImapMailbox (in ACString folderPath, in char hierarchyDelimiter, in long boxFlags); */
  NS_SCRIPTABLE NS_IMETHOD PossibleImapMailbox(const nsACString & folderPath, char hierarchyDelimiter, PRInt32 boxFlags, PRBool *_retval NS_OUTPARAM) = 0;

  /* boolean folderNeedsACLInitialized (in ACString folderPath); */
  NS_SCRIPTABLE NS_IMETHOD FolderNeedsACLInitialized(const nsACString & folderPath, PRBool *_retval NS_OUTPARAM) = 0;

  /* void addFolderRights (in ACString folderPath, in ACString userName, in ACString rights); */
  NS_SCRIPTABLE NS_IMETHOD AddFolderRights(const nsACString & folderPath, const nsACString & userName, const nsACString & rights) = 0;

  /* void refreshFolderRights (in ACString folderPath); */
  NS_SCRIPTABLE NS_IMETHOD RefreshFolderRights(const nsACString & folderPath) = 0;

  /* void discoveryDone (); */
  NS_SCRIPTABLE NS_IMETHOD DiscoveryDone(void) = 0;

  /* void onlineFolderDelete (in ACString folderName); */
  NS_SCRIPTABLE NS_IMETHOD OnlineFolderDelete(const nsACString & folderName) = 0;

  /* void onlineFolderCreateFailed (in ACString aFolderName); */
  NS_SCRIPTABLE NS_IMETHOD OnlineFolderCreateFailed(const nsACString & aFolderName) = 0;

  /* void onlineFolderRename (in nsIMsgWindow msgWindow, in ACString oldName, in ACString newName); */
  NS_SCRIPTABLE NS_IMETHOD OnlineFolderRename(nsIMsgWindow *msgWindow, const nsACString & oldName, const nsACString & newName) = 0;

  /* boolean folderIsNoSelect (in ACString folderName); */
  NS_SCRIPTABLE NS_IMETHOD FolderIsNoSelect(const nsACString & folderName, PRBool *_retval NS_OUTPARAM) = 0;

  /* void setFolderAdminURL (in ACString folderName, in ACString adminUrl); */
  NS_SCRIPTABLE NS_IMETHOD SetFolderAdminURL(const nsACString & folderName, const nsACString & adminUrl) = 0;

  /* boolean folderVerifiedOnline (in ACString folderName); */
  NS_SCRIPTABLE NS_IMETHOD FolderVerifiedOnline(const nsACString & folderName, PRBool *_retval NS_OUTPARAM) = 0;

  /* void setCapability (in unsigned long capability); */
  NS_SCRIPTABLE NS_IMETHOD SetCapability(PRUint32 capability) = 0;

  /* boolean loadNextQueuedUrl (in nsIImapProtocol protocol); */
  NS_SCRIPTABLE NS_IMETHOD LoadNextQueuedUrl(nsIImapProtocol *protocol, PRBool *_retval NS_OUTPARAM) = 0;

  /**
   * Prepare to retry the given URL.
   * @param imapUrl the url we're going to retry
   * @return channel to associate with the url. We return this because access
   *         to the channel should only happen on the ui thread.
   */
  /* nsIImapMockChannel prepareToRetryUrl (in nsIImapUrl imapUrl); */
  NS_SCRIPTABLE NS_IMETHOD PrepareToRetryUrl(nsIImapUrl *imapUrl, nsIImapMockChannel **_retval NS_OUTPARAM) = 0;

  /**
   * Retry the given URL.
   * @param imapUrl url to retry
   * @param channel the channel to associate with the url
   */
  /* void retryUrl (in nsIImapUrl imapUrl, in nsIImapMockChannel channel); */
  NS_SCRIPTABLE NS_IMETHOD RetryUrl(nsIImapUrl *imapUrl, nsIImapMockChannel *channel) = 0;

  /**
   * If previous URL failed, this gives server chance to abort URLs with same
   * mock channel.
   */
  /* void abortQueuedUrls (); */
  NS_SCRIPTABLE NS_IMETHOD AbortQueuedUrls(void) = 0;

  /* AString getImapStringByID (in long msgId); */
  NS_SCRIPTABLE NS_IMETHOD GetImapStringByID(PRInt32 msgId, nsAString & _retval NS_OUTPARAM) = 0;

  /**
   * Alerts the user that the login to the IMAP server failed. Asks whether the
   * connection should: retry, cancel, or request a new password.
   *
   * @param aMsgWindow The message window associated with this action (cannot
   *                   be null).
   * @return           The button pressed. 0 for retry, 1 for cancel,
   *                   2 for enter a new password.
   */
  /* PRInt32 promptLoginFailed (in nsIMsgWindow aMsgWindow); */
  NS_SCRIPTABLE NS_IMETHOD PromptLoginFailed(nsIMsgWindow *aMsgWindow, PRInt32 *_retval NS_OUTPARAM) = 0;

  /**
   * Alerts the user with the given string (FE = 'Front End').
   *
   * @param aAlertSring  The string to alert the user with.
   * @param aUrl         The running url.
   */
  /* void fEAlert (in AString aAlertSring, in nsIMsgMailNewsUrl aUrl); */
  NS_SCRIPTABLE NS_IMETHOD FEAlert(const nsAString & aAlertSring, nsIMsgMailNewsUrl *aUrl) = 0;

  /**
   * Alerts the user with a localized string. It will attempt to fill in
   * the hostname into the string if necessary.
   *
   * @param aMsgId  The id of the string to present to the user..
   * @param aUrl    The running url.
   */
  /* void fEAlertWithID (in long aMsgId, in nsIMsgMailNewsUrl aUrl); */
  NS_SCRIPTABLE NS_IMETHOD FEAlertWithID(PRInt32 aMsgId, nsIMsgMailNewsUrl *aUrl) = 0;

  /**
   * Takes a response from the server and prepends it with IMAP_SERVER_SAID 
   *
   * @param aServerString  The string to alert the user with.
   * @param url            The running url.
   */
  /* void fEAlertFromServer (in ACString aServerString, in nsIMsgMailNewsUrl aUrl); */
  NS_SCRIPTABLE NS_IMETHOD FEAlertFromServer(const nsACString & aServerString, nsIMsgMailNewsUrl *aUrl) = 0;

  /* void commitNamespaces (); */
  NS_SCRIPTABLE NS_IMETHOD CommitNamespaces(void) = 0;

  /**
   * Returns a password via the out param, if we were able to prompt for one,
   * or had one stored.
   * If there is already a password prompt up, we return false, but we
   * ask the async prompt service to notify us when we can put up a prompt.
   * When that notification is received, we prompt the user and set the
   * password on the protocol object, and signal a monitor that the imap
   * thread should be waiting on.
   *
   * rv is NS_MSG_PASSWORD_PROMPT_CANCELLED if the user cancels the
   * password prompt. That's not an exception, however.
   *
   * @param aProtocol imap protocol object requesting the password.
   * @param aNewPasswordRequested Forces password prompt immediately
   * @param aPassword returns the password, unless we had to prompt or use the,
   *                  login manager and there was already a prompt up.
   */
  /* void asyncGetPassword (in nsIImapProtocol aProtocol, in boolean aNewPasswordRequested, out ACString aPassword); */
  NS_SCRIPTABLE NS_IMETHOD AsyncGetPassword(nsIImapProtocol *aProtocol, PRBool aNewPasswordRequested, nsACString & aPassword NS_OUTPARAM) = 0;

  /* attribute boolean userAuthenticated; */
  NS_SCRIPTABLE NS_IMETHOD GetUserAuthenticated(PRBool *aUserAuthenticated) = 0;
  NS_SCRIPTABLE NS_IMETHOD SetUserAuthenticated(PRBool aUserAuthenticated) = 0;

  /* void setMailServerUrls (in ACString manageMailAccount, in ACString manageLists, in ACString manageFilters); */
  NS_SCRIPTABLE NS_IMETHOD SetMailServerUrls(const nsACString & manageMailAccount, const nsACString & manageLists, const nsACString & manageFilters) = 0;

  /* readonly attribute ACString arbitraryHeaders; */
  NS_SCRIPTABLE NS_IMETHOD GetArbitraryHeaders(nsACString & aArbitraryHeaders) = 0;

  /* void forgetPassword (); */
  NS_SCRIPTABLE NS_IMETHOD ForgetPassword(void) = 0;

  /* readonly attribute boolean showAttachmentsInline; */
  NS_SCRIPTABLE NS_IMETHOD GetShowAttachmentsInline(PRBool *aShowAttachmentsInline) = 0;

  /* string cramMD5Hash (in string decodedChallenge, in string key); */
  NS_SCRIPTABLE NS_IMETHOD CramMD5Hash(const char *decodedChallenge, const char *key, char **_retval NS_OUTPARAM) = 0;

  /* readonly attribute ACString loginUsername; */
  NS_SCRIPTABLE NS_IMETHOD GetLoginUsername(nsACString & aLoginUsername) = 0;

};

  NS_DEFINE_STATIC_IID_ACCESSOR(nsIImapServerSink, NS_IIMAPSERVERSINK_IID)

/* Use this macro when declaring classes that implement this interface. */
#define NS_DECL_NSIIMAPSERVERSINK \
  NS_SCRIPTABLE NS_IMETHOD PossibleImapMailbox(const nsACString & folderPath, char hierarchyDelimiter, PRInt32 boxFlags, PRBool *_retval NS_OUTPARAM); \
  NS_SCRIPTABLE NS_IMETHOD FolderNeedsACLInitialized(const nsACString & folderPath, PRBool *_retval NS_OUTPARAM); \
  NS_SCRIPTABLE NS_IMETHOD AddFolderRights(const nsACString & folderPath, const nsACString & userName, const nsACString & rights); \
  NS_SCRIPTABLE NS_IMETHOD RefreshFolderRights(const nsACString & folderPath); \
  NS_SCRIPTABLE NS_IMETHOD DiscoveryDone(void); \
  NS_SCRIPTABLE NS_IMETHOD OnlineFolderDelete(const nsACString & folderName); \
  NS_SCRIPTABLE NS_IMETHOD OnlineFolderCreateFailed(const nsACString & aFolderName); \
  NS_SCRIPTABLE NS_IMETHOD OnlineFolderRename(nsIMsgWindow *msgWindow, const nsACString & oldName, const nsACString & newName); \
  NS_SCRIPTABLE NS_IMETHOD FolderIsNoSelect(const nsACString & folderName, PRBool *_retval NS_OUTPARAM); \
  NS_SCRIPTABLE NS_IMETHOD SetFolderAdminURL(const nsACString & folderName, const nsACString & adminUrl); \
  NS_SCRIPTABLE NS_IMETHOD FolderVerifiedOnline(const nsACString & folderName, PRBool *_retval NS_OUTPARAM); \
  NS_SCRIPTABLE NS_IMETHOD SetCapability(PRUint32 capability); \
  NS_SCRIPTABLE NS_IMETHOD LoadNextQueuedUrl(nsIImapProtocol *protocol, PRBool *_retval NS_OUTPARAM); \
  NS_SCRIPTABLE NS_IMETHOD PrepareToRetryUrl(nsIImapUrl *imapUrl, nsIImapMockChannel **_retval NS_OUTPARAM); \
  NS_SCRIPTABLE NS_IMETHOD RetryUrl(nsIImapUrl *imapUrl, nsIImapMockChannel *channel); \
  NS_SCRIPTABLE NS_IMETHOD AbortQueuedUrls(void); \
  NS_SCRIPTABLE NS_IMETHOD GetImapStringByID(PRInt32 msgId, nsAString & _retval NS_OUTPARAM); \
  NS_SCRIPTABLE NS_IMETHOD PromptLoginFailed(nsIMsgWindow *aMsgWindow, PRInt32 *_retval NS_OUTPARAM); \
  NS_SCRIPTABLE NS_IMETHOD FEAlert(const nsAString & aAlertSring, nsIMsgMailNewsUrl *aUrl); \
  NS_SCRIPTABLE NS_IMETHOD FEAlertWithID(PRInt32 aMsgId, nsIMsgMailNewsUrl *aUrl); \
  NS_SCRIPTABLE NS_IMETHOD FEAlertFromServer(const nsACString & aServerString, nsIMsgMailNewsUrl *aUrl); \
  NS_SCRIPTABLE NS_IMETHOD CommitNamespaces(void); \
  NS_SCRIPTABLE NS_IMETHOD AsyncGetPassword(nsIImapProtocol *aProtocol, PRBool aNewPasswordRequested, nsACString & aPassword NS_OUTPARAM); \
  NS_SCRIPTABLE NS_IMETHOD GetUserAuthenticated(PRBool *aUserAuthenticated); \
  NS_SCRIPTABLE NS_IMETHOD SetUserAuthenticated(PRBool aUserAuthenticated); \
  NS_SCRIPTABLE NS_IMETHOD SetMailServerUrls(const nsACString & manageMailAccount, const nsACString & manageLists, const nsACString & manageFilters); \
  NS_SCRIPTABLE NS_IMETHOD GetArbitraryHeaders(nsACString & aArbitraryHeaders); \
  NS_SCRIPTABLE NS_IMETHOD ForgetPassword(void); \
  NS_SCRIPTABLE NS_IMETHOD GetShowAttachmentsInline(PRBool *aShowAttachmentsInline); \
  NS_SCRIPTABLE NS_IMETHOD CramMD5Hash(const char *decodedChallenge, const char *key, char **_retval NS_OUTPARAM); \
  NS_SCRIPTABLE NS_IMETHOD GetLoginUsername(nsACString & aLoginUsername); 

/* Use this macro to declare functions that forward the behavior of this interface to another object. */
#define NS_FORWARD_NSIIMAPSERVERSINK(_to) \
  NS_SCRIPTABLE NS_IMETHOD PossibleImapMailbox(const nsACString & folderPath, char hierarchyDelimiter, PRInt32 boxFlags, PRBool *_retval NS_OUTPARAM) { return _to PossibleImapMailbox(folderPath, hierarchyDelimiter, boxFlags, _retval); } \
  NS_SCRIPTABLE NS_IMETHOD FolderNeedsACLInitialized(const nsACString & folderPath, PRBool *_retval NS_OUTPARAM) { return _to FolderNeedsACLInitialized(folderPath, _retval); } \
  NS_SCRIPTABLE NS_IMETHOD AddFolderRights(const nsACString & folderPath, const nsACString & userName, const nsACString & rights) { return _to AddFolderRights(folderPath, userName, rights); } \
  NS_SCRIPTABLE NS_IMETHOD RefreshFolderRights(const nsACString & folderPath) { return _to RefreshFolderRights(folderPath); } \
  NS_SCRIPTABLE NS_IMETHOD DiscoveryDone(void) { return _to DiscoveryDone(); } \
  NS_SCRIPTABLE NS_IMETHOD OnlineFolderDelete(const nsACString & folderName) { return _to OnlineFolderDelete(folderName); } \
  NS_SCRIPTABLE NS_IMETHOD OnlineFolderCreateFailed(const nsACString & aFolderName) { return _to OnlineFolderCreateFailed(aFolderName); } \
  NS_SCRIPTABLE NS_IMETHOD OnlineFolderRename(nsIMsgWindow *msgWindow, const nsACString & oldName, const nsACString & newName) { return _to OnlineFolderRename(msgWindow, oldName, newName); } \
  NS_SCRIPTABLE NS_IMETHOD FolderIsNoSelect(const nsACString & folderName, PRBool *_retval NS_OUTPARAM) { return _to FolderIsNoSelect(folderName, _retval); } \
  NS_SCRIPTABLE NS_IMETHOD SetFolderAdminURL(const nsACString & folderName, const nsACString & adminUrl) { return _to SetFolderAdminURL(folderName, adminUrl); } \
  NS_SCRIPTABLE NS_IMETHOD FolderVerifiedOnline(const nsACString & folderName, PRBool *_retval NS_OUTPARAM) { return _to FolderVerifiedOnline(folderName, _retval); } \
  NS_SCRIPTABLE NS_IMETHOD SetCapability(PRUint32 capability) { return _to SetCapability(capability); } \
  NS_SCRIPTABLE NS_IMETHOD LoadNextQueuedUrl(nsIImapProtocol *protocol, PRBool *_retval NS_OUTPARAM) { return _to LoadNextQueuedUrl(protocol, _retval); } \
  NS_SCRIPTABLE NS_IMETHOD PrepareToRetryUrl(nsIImapUrl *imapUrl, nsIImapMockChannel **_retval NS_OUTPARAM) { return _to PrepareToRetryUrl(imapUrl, _retval); } \
  NS_SCRIPTABLE NS_IMETHOD RetryUrl(nsIImapUrl *imapUrl, nsIImapMockChannel *channel) { return _to RetryUrl(imapUrl, channel); } \
  NS_SCRIPTABLE NS_IMETHOD AbortQueuedUrls(void) { return _to AbortQueuedUrls(); } \
  NS_SCRIPTABLE NS_IMETHOD GetImapStringByID(PRInt32 msgId, nsAString & _retval NS_OUTPARAM) { return _to GetImapStringByID(msgId, _retval); } \
  NS_SCRIPTABLE NS_IMETHOD PromptLoginFailed(nsIMsgWindow *aMsgWindow, PRInt32 *_retval NS_OUTPARAM) { return _to PromptLoginFailed(aMsgWindow, _retval); } \
  NS_SCRIPTABLE NS_IMETHOD FEAlert(const nsAString & aAlertSring, nsIMsgMailNewsUrl *aUrl) { return _to FEAlert(aAlertSring, aUrl); } \
  NS_SCRIPTABLE NS_IMETHOD FEAlertWithID(PRInt32 aMsgId, nsIMsgMailNewsUrl *aUrl) { return _to FEAlertWithID(aMsgId, aUrl); } \
  NS_SCRIPTABLE NS_IMETHOD FEAlertFromServer(const nsACString & aServerString, nsIMsgMailNewsUrl *aUrl) { return _to FEAlertFromServer(aServerString, aUrl); } \
  NS_SCRIPTABLE NS_IMETHOD CommitNamespaces(void) { return _to CommitNamespaces(); } \
  NS_SCRIPTABLE NS_IMETHOD AsyncGetPassword(nsIImapProtocol *aProtocol, PRBool aNewPasswordRequested, nsACString & aPassword NS_OUTPARAM) { return _to AsyncGetPassword(aProtocol, aNewPasswordRequested, aPassword); } \
  NS_SCRIPTABLE NS_IMETHOD GetUserAuthenticated(PRBool *aUserAuthenticated) { return _to GetUserAuthenticated(aUserAuthenticated); } \
  NS_SCRIPTABLE NS_IMETHOD SetUserAuthenticated(PRBool aUserAuthenticated) { return _to SetUserAuthenticated(aUserAuthenticated); } \
  NS_SCRIPTABLE NS_IMETHOD SetMailServerUrls(const nsACString & manageMailAccount, const nsACString & manageLists, const nsACString & manageFilters) { return _to SetMailServerUrls(manageMailAccount, manageLists, manageFilters); } \
  NS_SCRIPTABLE NS_IMETHOD GetArbitraryHeaders(nsACString & aArbitraryHeaders) { return _to GetArbitraryHeaders(aArbitraryHeaders); } \
  NS_SCRIPTABLE NS_IMETHOD ForgetPassword(void) { return _to ForgetPassword(); } \
  NS_SCRIPTABLE NS_IMETHOD GetShowAttachmentsInline(PRBool *aShowAttachmentsInline) { return _to GetShowAttachmentsInline(aShowAttachmentsInline); } \
  NS_SCRIPTABLE NS_IMETHOD CramMD5Hash(const char *decodedChallenge, const char *key, char **_retval NS_OUTPARAM) { return _to CramMD5Hash(decodedChallenge, key, _retval); } \
  NS_SCRIPTABLE NS_IMETHOD GetLoginUsername(nsACString & aLoginUsername) { return _to GetLoginUsername(aLoginUsername); } 

/* Use this macro to declare functions that forward the behavior of this interface to another object in a safe way. */
#define NS_FORWARD_SAFE_NSIIMAPSERVERSINK(_to) \
  NS_SCRIPTABLE NS_IMETHOD PossibleImapMailbox(const nsACString & folderPath, char hierarchyDelimiter, PRInt32 boxFlags, PRBool *_retval NS_OUTPARAM) { return !_to ? NS_ERROR_NULL_POINTER : _to->PossibleImapMailbox(folderPath, hierarchyDelimiter, boxFlags, _retval); } \
  NS_SCRIPTABLE NS_IMETHOD FolderNeedsACLInitialized(const nsACString & folderPath, PRBool *_retval NS_OUTPARAM) { return !_to ? NS_ERROR_NULL_POINTER : _to->FolderNeedsACLInitialized(folderPath, _retval); } \
  NS_SCRIPTABLE NS_IMETHOD AddFolderRights(const nsACString & folderPath, const nsACString & userName, const nsACString & rights) { return !_to ? NS_ERROR_NULL_POINTER : _to->AddFolderRights(folderPath, userName, rights); } \
  NS_SCRIPTABLE NS_IMETHOD RefreshFolderRights(const nsACString & folderPath) { return !_to ? NS_ERROR_NULL_POINTER : _to->RefreshFolderRights(folderPath); } \
  NS_SCRIPTABLE NS_IMETHOD DiscoveryDone(void) { return !_to ? NS_ERROR_NULL_POINTER : _to->DiscoveryDone(); } \
  NS_SCRIPTABLE NS_IMETHOD OnlineFolderDelete(const nsACString & folderName) { return !_to ? NS_ERROR_NULL_POINTER : _to->OnlineFolderDelete(folderName); } \
  NS_SCRIPTABLE NS_IMETHOD OnlineFolderCreateFailed(const nsACString & aFolderName) { return !_to ? NS_ERROR_NULL_POINTER : _to->OnlineFolderCreateFailed(aFolderName); } \
  NS_SCRIPTABLE NS_IMETHOD OnlineFolderRename(nsIMsgWindow *msgWindow, const nsACString & oldName, const nsACString & newName) { return !_to ? NS_ERROR_NULL_POINTER : _to->OnlineFolderRename(msgWindow, oldName, newName); } \
  NS_SCRIPTABLE NS_IMETHOD FolderIsNoSelect(const nsACString & folderName, PRBool *_retval NS_OUTPARAM) { return !_to ? NS_ERROR_NULL_POINTER : _to->FolderIsNoSelect(folderName, _retval); } \
  NS_SCRIPTABLE NS_IMETHOD SetFolderAdminURL(const nsACString & folderName, const nsACString & adminUrl) { return !_to ? NS_ERROR_NULL_POINTER : _to->SetFolderAdminURL(folderName, adminUrl); } \
  NS_SCRIPTABLE NS_IMETHOD FolderVerifiedOnline(const nsACString & folderName, PRBool *_retval NS_OUTPARAM) { return !_to ? NS_ERROR_NULL_POINTER : _to->FolderVerifiedOnline(folderName, _retval); } \
  NS_SCRIPTABLE NS_IMETHOD SetCapability(PRUint32 capability) { return !_to ? NS_ERROR_NULL_POINTER : _to->SetCapability(capability); } \
  NS_SCRIPTABLE NS_IMETHOD LoadNextQueuedUrl(nsIImapProtocol *protocol, PRBool *_retval NS_OUTPARAM) { return !_to ? NS_ERROR_NULL_POINTER : _to->LoadNextQueuedUrl(protocol, _retval); } \
  NS_SCRIPTABLE NS_IMETHOD PrepareToRetryUrl(nsIImapUrl *imapUrl, nsIImapMockChannel **_retval NS_OUTPARAM) { return !_to ? NS_ERROR_NULL_POINTER : _to->PrepareToRetryUrl(imapUrl, _retval); } \
  NS_SCRIPTABLE NS_IMETHOD RetryUrl(nsIImapUrl *imapUrl, nsIImapMockChannel *channel) { return !_to ? NS_ERROR_NULL_POINTER : _to->RetryUrl(imapUrl, channel); } \
  NS_SCRIPTABLE NS_IMETHOD AbortQueuedUrls(void) { return !_to ? NS_ERROR_NULL_POINTER : _to->AbortQueuedUrls(); } \
  NS_SCRIPTABLE NS_IMETHOD GetImapStringByID(PRInt32 msgId, nsAString & _retval NS_OUTPARAM) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetImapStringByID(msgId, _retval); } \
  NS_SCRIPTABLE NS_IMETHOD PromptLoginFailed(nsIMsgWindow *aMsgWindow, PRInt32 *_retval NS_OUTPARAM) { return !_to ? NS_ERROR_NULL_POINTER : _to->PromptLoginFailed(aMsgWindow, _retval); } \
  NS_SCRIPTABLE NS_IMETHOD FEAlert(const nsAString & aAlertSring, nsIMsgMailNewsUrl *aUrl) { return !_to ? NS_ERROR_NULL_POINTER : _to->FEAlert(aAlertSring, aUrl); } \
  NS_SCRIPTABLE NS_IMETHOD FEAlertWithID(PRInt32 aMsgId, nsIMsgMailNewsUrl *aUrl) { return !_to ? NS_ERROR_NULL_POINTER : _to->FEAlertWithID(aMsgId, aUrl); } \
  NS_SCRIPTABLE NS_IMETHOD FEAlertFromServer(const nsACString & aServerString, nsIMsgMailNewsUrl *aUrl) { return !_to ? NS_ERROR_NULL_POINTER : _to->FEAlertFromServer(aServerString, aUrl); } \
  NS_SCRIPTABLE NS_IMETHOD CommitNamespaces(void) { return !_to ? NS_ERROR_NULL_POINTER : _to->CommitNamespaces(); } \
  NS_SCRIPTABLE NS_IMETHOD AsyncGetPassword(nsIImapProtocol *aProtocol, PRBool aNewPasswordRequested, nsACString & aPassword NS_OUTPARAM) { return !_to ? NS_ERROR_NULL_POINTER : _to->AsyncGetPassword(aProtocol, aNewPasswordRequested, aPassword); } \
  NS_SCRIPTABLE NS_IMETHOD GetUserAuthenticated(PRBool *aUserAuthenticated) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetUserAuthenticated(aUserAuthenticated); } \
  NS_SCRIPTABLE NS_IMETHOD SetUserAuthenticated(PRBool aUserAuthenticated) { return !_to ? NS_ERROR_NULL_POINTER : _to->SetUserAuthenticated(aUserAuthenticated); } \
  NS_SCRIPTABLE NS_IMETHOD SetMailServerUrls(const nsACString & manageMailAccount, const nsACString & manageLists, const nsACString & manageFilters) { return !_to ? NS_ERROR_NULL_POINTER : _to->SetMailServerUrls(manageMailAccount, manageLists, manageFilters); } \
  NS_SCRIPTABLE NS_IMETHOD GetArbitraryHeaders(nsACString & aArbitraryHeaders) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetArbitraryHeaders(aArbitraryHeaders); } \
  NS_SCRIPTABLE NS_IMETHOD ForgetPassword(void) { return !_to ? NS_ERROR_NULL_POINTER : _to->ForgetPassword(); } \
  NS_SCRIPTABLE NS_IMETHOD GetShowAttachmentsInline(PRBool *aShowAttachmentsInline) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetShowAttachmentsInline(aShowAttachmentsInline); } \
  NS_SCRIPTABLE NS_IMETHOD CramMD5Hash(const char *decodedChallenge, const char *key, char **_retval NS_OUTPARAM) { return !_to ? NS_ERROR_NULL_POINTER : _to->CramMD5Hash(decodedChallenge, key, _retval); } \
  NS_SCRIPTABLE NS_IMETHOD GetLoginUsername(nsACString & aLoginUsername) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetLoginUsername(aLoginUsername); } 

#if 0
/* Use the code below as a template for the implementation class for this interface. */

/* Header file */
class nsImapServerSink : public nsIImapServerSink
{
public:
  NS_DECL_ISUPPORTS
  NS_DECL_NSIIMAPSERVERSINK

  nsImapServerSink();

private:
  ~nsImapServerSink();

protected:
  /* additional members */
};

/* Implementation file */
NS_IMPL_ISUPPORTS1(nsImapServerSink, nsIImapServerSink)

nsImapServerSink::nsImapServerSink()
{
  /* member initializers and constructor code */
}

nsImapServerSink::~nsImapServerSink()
{
  /* destructor code */
}

/* boolean possibleImapMailbox (in ACString folderPath, in char hierarchyDelimiter, in long boxFlags); */
NS_IMETHODIMP nsImapServerSink::PossibleImapMailbox(const nsACString & folderPath, char hierarchyDelimiter, PRInt32 boxFlags, PRBool *_retval NS_OUTPARAM)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* boolean folderNeedsACLInitialized (in ACString folderPath); */
NS_IMETHODIMP nsImapServerSink::FolderNeedsACLInitialized(const nsACString & folderPath, PRBool *_retval NS_OUTPARAM)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void addFolderRights (in ACString folderPath, in ACString userName, in ACString rights); */
NS_IMETHODIMP nsImapServerSink::AddFolderRights(const nsACString & folderPath, const nsACString & userName, const nsACString & rights)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void refreshFolderRights (in ACString folderPath); */
NS_IMETHODIMP nsImapServerSink::RefreshFolderRights(const nsACString & folderPath)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void discoveryDone (); */
NS_IMETHODIMP nsImapServerSink::DiscoveryDone()
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void onlineFolderDelete (in ACString folderName); */
NS_IMETHODIMP nsImapServerSink::OnlineFolderDelete(const nsACString & folderName)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void onlineFolderCreateFailed (in ACString aFolderName); */
NS_IMETHODIMP nsImapServerSink::OnlineFolderCreateFailed(const nsACString & aFolderName)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void onlineFolderRename (in nsIMsgWindow msgWindow, in ACString oldName, in ACString newName); */
NS_IMETHODIMP nsImapServerSink::OnlineFolderRename(nsIMsgWindow *msgWindow, const nsACString & oldName, const nsACString & newName)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* boolean folderIsNoSelect (in ACString folderName); */
NS_IMETHODIMP nsImapServerSink::FolderIsNoSelect(const nsACString & folderName, PRBool *_retval NS_OUTPARAM)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void setFolderAdminURL (in ACString folderName, in ACString adminUrl); */
NS_IMETHODIMP nsImapServerSink::SetFolderAdminURL(const nsACString & folderName, const nsACString & adminUrl)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* boolean folderVerifiedOnline (in ACString folderName); */
NS_IMETHODIMP nsImapServerSink::FolderVerifiedOnline(const nsACString & folderName, PRBool *_retval NS_OUTPARAM)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void setCapability (in unsigned long capability); */
NS_IMETHODIMP nsImapServerSink::SetCapability(PRUint32 capability)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* boolean loadNextQueuedUrl (in nsIImapProtocol protocol); */
NS_IMETHODIMP nsImapServerSink::LoadNextQueuedUrl(nsIImapProtocol *protocol, PRBool *_retval NS_OUTPARAM)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* nsIImapMockChannel prepareToRetryUrl (in nsIImapUrl imapUrl); */
NS_IMETHODIMP nsImapServerSink::PrepareToRetryUrl(nsIImapUrl *imapUrl, nsIImapMockChannel **_retval NS_OUTPARAM)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void retryUrl (in nsIImapUrl imapUrl, in nsIImapMockChannel channel); */
NS_IMETHODIMP nsImapServerSink::RetryUrl(nsIImapUrl *imapUrl, nsIImapMockChannel *channel)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void abortQueuedUrls (); */
NS_IMETHODIMP nsImapServerSink::AbortQueuedUrls()
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* AString getImapStringByID (in long msgId); */
NS_IMETHODIMP nsImapServerSink::GetImapStringByID(PRInt32 msgId, nsAString & _retval NS_OUTPARAM)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* PRInt32 promptLoginFailed (in nsIMsgWindow aMsgWindow); */
NS_IMETHODIMP nsImapServerSink::PromptLoginFailed(nsIMsgWindow *aMsgWindow, PRInt32 *_retval NS_OUTPARAM)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void fEAlert (in AString aAlertSring, in nsIMsgMailNewsUrl aUrl); */
NS_IMETHODIMP nsImapServerSink::FEAlert(const nsAString & aAlertSring, nsIMsgMailNewsUrl *aUrl)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void fEAlertWithID (in long aMsgId, in nsIMsgMailNewsUrl aUrl); */
NS_IMETHODIMP nsImapServerSink::FEAlertWithID(PRInt32 aMsgId, nsIMsgMailNewsUrl *aUrl)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void fEAlertFromServer (in ACString aServerString, in nsIMsgMailNewsUrl aUrl); */
NS_IMETHODIMP nsImapServerSink::FEAlertFromServer(const nsACString & aServerString, nsIMsgMailNewsUrl *aUrl)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void commitNamespaces (); */
NS_IMETHODIMP nsImapServerSink::CommitNamespaces()
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void asyncGetPassword (in nsIImapProtocol aProtocol, in boolean aNewPasswordRequested, out ACString aPassword); */
NS_IMETHODIMP nsImapServerSink::AsyncGetPassword(nsIImapProtocol *aProtocol, PRBool aNewPasswordRequested, nsACString & aPassword NS_OUTPARAM)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* attribute boolean userAuthenticated; */
NS_IMETHODIMP nsImapServerSink::GetUserAuthenticated(PRBool *aUserAuthenticated)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}
NS_IMETHODIMP nsImapServerSink::SetUserAuthenticated(PRBool aUserAuthenticated)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void setMailServerUrls (in ACString manageMailAccount, in ACString manageLists, in ACString manageFilters); */
NS_IMETHODIMP nsImapServerSink::SetMailServerUrls(const nsACString & manageMailAccount, const nsACString & manageLists, const nsACString & manageFilters)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* readonly attribute ACString arbitraryHeaders; */
NS_IMETHODIMP nsImapServerSink::GetArbitraryHeaders(nsACString & aArbitraryHeaders)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void forgetPassword (); */
NS_IMETHODIMP nsImapServerSink::ForgetPassword()
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* readonly attribute boolean showAttachmentsInline; */
NS_IMETHODIMP nsImapServerSink::GetShowAttachmentsInline(PRBool *aShowAttachmentsInline)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* string cramMD5Hash (in string decodedChallenge, in string key); */
NS_IMETHODIMP nsImapServerSink::CramMD5Hash(const char *decodedChallenge, const char *key, char **_retval NS_OUTPARAM)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* readonly attribute ACString loginUsername; */
NS_IMETHODIMP nsImapServerSink::GetLoginUsername(nsACString & aLoginUsername)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* End of implementation class template. */
#endif


#endif /* __gen_nsIImapServerSink_h__ */
