/*
 * DO NOT EDIT.  THIS FILE IS GENERATED FROM nsIAutoSyncManager.idl
 */

#ifndef __gen_nsIAutoSyncManager_h__
#define __gen_nsIAutoSyncManager_h__


#ifndef __gen_nsISupports_h__
#include "nsISupports.h"
#endif

/* For IDL files that don't want to include root IDL files. */
#ifndef NS_NO_VTABLE
#define NS_NO_VTABLE
#endif
class nsIAutoSyncMsgStrategy; /* forward declaration */

class nsIAutoSyncFolderStrategy; /* forward declaration */

class nsIMsgDBHdr; /* forward declaration */

class nsIAutoSyncState; /* forward declaration */

class nsIAutoSyncMgrListener; /* forward declaration */

class nsIMsgFolder; /* forward declaration */

class nsIMsgAccount; /* forward declaration */


/* starting interface:    nsIAutoSyncMgrListener */
#define NS_IAUTOSYNCMGRLISTENER_IID_STR "41ec36a7-1a53-4ca3-b698-dca6452a8761"

#define NS_IAUTOSYNCMGRLISTENER_IID \
  {0x41ec36a7, 0x1a53, 0x4ca3, \
    { 0xb6, 0x98, 0xdc, 0xa6, 0x45, 0x2a, 0x87, 0x61 }}

class NS_NO_VTABLE NS_SCRIPTABLE nsIAutoSyncMgrListener : public nsISupports {
 public: 

  NS_DECLARE_STATIC_IID_ACCESSOR(NS_IAUTOSYNCMGRLISTENER_IID)

  /**
   * Queue types
   */
  enum { PriorityQueue = 1 };

  enum { UpdateQueue = 2 };

  enum { DiscoveryQueue = 3 };

  /**
   * It is called on the listener when a new folder is added into
   * the queue
   *
   * @param aQType type of the queue
   * @param aFolder folder that is added into the queue
   */
  /* void onFolderAddedIntoQ (in long aQType, in nsIMsgFolder aFolder); */
  NS_SCRIPTABLE NS_IMETHOD OnFolderAddedIntoQ(PRInt32 aQType, nsIMsgFolder *aFolder) = 0;

  /**
   * It is called on the listener when a folder is removed from
   * the queue
   *
   * @param aQType type of the queue
   * @param aFolder folder that is removed from the queue
   */
  /* void onFolderRemovedFromQ (in long aQType, in nsIMsgFolder aFolder); */
  NS_SCRIPTABLE NS_IMETHOD OnFolderRemovedFromQ(PRInt32 aQType, nsIMsgFolder *aFolder) = 0;

  /**
   * It is called on the listener when a message download is successfully started
   *
   * @param aFolder folder in which the download is started 
   * @param aNumberOfMessages number of the messages that will be downloaded 
   * @param aTotalPending  total number of messages waiting to be downloaded 
   */
  /* void onDownloadStarted (in nsIMsgFolder aFolder, in unsigned long aNumberOfMessages, in unsigned long aTotalPending); */
  NS_SCRIPTABLE NS_IMETHOD OnDownloadStarted(nsIMsgFolder *aFolder, PRUint32 aNumberOfMessages, PRUint32 aTotalPending) = 0;

  /**
   * It is called on the listener when a message download on the given folder 
   * is completed
   */
  /* void onDownloadCompleted (in nsIMsgFolder aFolder); */
  NS_SCRIPTABLE NS_IMETHOD OnDownloadCompleted(nsIMsgFolder *aFolder) = 0;

  /**
   * It is called on the listener when an error occurs during the message download
   */
  /* void onDownloadError (in nsIMsgFolder aFolder); */
  NS_SCRIPTABLE NS_IMETHOD OnDownloadError(nsIMsgFolder *aFolder) = 0;

  /* void onStateChanged (in boolean aRunning); */
  NS_SCRIPTABLE NS_IMETHOD OnStateChanged(PRBool aRunning) = 0;

  /**
   * It is called on the listener after the auto-sync manager starts to process 
   * existing headers of the given folder to find missing message bodies
   * (mostly for debugging purposes)
   */
  /* void onDiscoveryQProcessed (in nsIMsgFolder aFolder, in unsigned long aNumberOfHdrsProcessed, in unsigned long aLeftToProcess); */
  NS_SCRIPTABLE NS_IMETHOD OnDiscoveryQProcessed(nsIMsgFolder *aFolder, PRUint32 aNumberOfHdrsProcessed, PRUint32 aLeftToProcess) = 0;

  /**
   * It is called on the listener after the auto-sync manager updates the given folder 
   * (mostly for debugging purposes)
   */
  /* void onAutoSyncInitiated (in nsIMsgFolder aFolder); */
  NS_SCRIPTABLE NS_IMETHOD OnAutoSyncInitiated(nsIMsgFolder *aFolder) = 0;

};

  NS_DEFINE_STATIC_IID_ACCESSOR(nsIAutoSyncMgrListener, NS_IAUTOSYNCMGRLISTENER_IID)

/* Use this macro when declaring classes that implement this interface. */
#define NS_DECL_NSIAUTOSYNCMGRLISTENER \
  NS_SCRIPTABLE NS_IMETHOD OnFolderAddedIntoQ(PRInt32 aQType, nsIMsgFolder *aFolder); \
  NS_SCRIPTABLE NS_IMETHOD OnFolderRemovedFromQ(PRInt32 aQType, nsIMsgFolder *aFolder); \
  NS_SCRIPTABLE NS_IMETHOD OnDownloadStarted(nsIMsgFolder *aFolder, PRUint32 aNumberOfMessages, PRUint32 aTotalPending); \
  NS_SCRIPTABLE NS_IMETHOD OnDownloadCompleted(nsIMsgFolder *aFolder); \
  NS_SCRIPTABLE NS_IMETHOD OnDownloadError(nsIMsgFolder *aFolder); \
  NS_SCRIPTABLE NS_IMETHOD OnStateChanged(PRBool aRunning); \
  NS_SCRIPTABLE NS_IMETHOD OnDiscoveryQProcessed(nsIMsgFolder *aFolder, PRUint32 aNumberOfHdrsProcessed, PRUint32 aLeftToProcess); \
  NS_SCRIPTABLE NS_IMETHOD OnAutoSyncInitiated(nsIMsgFolder *aFolder); 

/* Use this macro to declare functions that forward the behavior of this interface to another object. */
#define NS_FORWARD_NSIAUTOSYNCMGRLISTENER(_to) \
  NS_SCRIPTABLE NS_IMETHOD OnFolderAddedIntoQ(PRInt32 aQType, nsIMsgFolder *aFolder) { return _to OnFolderAddedIntoQ(aQType, aFolder); } \
  NS_SCRIPTABLE NS_IMETHOD OnFolderRemovedFromQ(PRInt32 aQType, nsIMsgFolder *aFolder) { return _to OnFolderRemovedFromQ(aQType, aFolder); } \
  NS_SCRIPTABLE NS_IMETHOD OnDownloadStarted(nsIMsgFolder *aFolder, PRUint32 aNumberOfMessages, PRUint32 aTotalPending) { return _to OnDownloadStarted(aFolder, aNumberOfMessages, aTotalPending); } \
  NS_SCRIPTABLE NS_IMETHOD OnDownloadCompleted(nsIMsgFolder *aFolder) { return _to OnDownloadCompleted(aFolder); } \
  NS_SCRIPTABLE NS_IMETHOD OnDownloadError(nsIMsgFolder *aFolder) { return _to OnDownloadError(aFolder); } \
  NS_SCRIPTABLE NS_IMETHOD OnStateChanged(PRBool aRunning) { return _to OnStateChanged(aRunning); } \
  NS_SCRIPTABLE NS_IMETHOD OnDiscoveryQProcessed(nsIMsgFolder *aFolder, PRUint32 aNumberOfHdrsProcessed, PRUint32 aLeftToProcess) { return _to OnDiscoveryQProcessed(aFolder, aNumberOfHdrsProcessed, aLeftToProcess); } \
  NS_SCRIPTABLE NS_IMETHOD OnAutoSyncInitiated(nsIMsgFolder *aFolder) { return _to OnAutoSyncInitiated(aFolder); } 

/* Use this macro to declare functions that forward the behavior of this interface to another object in a safe way. */
#define NS_FORWARD_SAFE_NSIAUTOSYNCMGRLISTENER(_to) \
  NS_SCRIPTABLE NS_IMETHOD OnFolderAddedIntoQ(PRInt32 aQType, nsIMsgFolder *aFolder) { return !_to ? NS_ERROR_NULL_POINTER : _to->OnFolderAddedIntoQ(aQType, aFolder); } \
  NS_SCRIPTABLE NS_IMETHOD OnFolderRemovedFromQ(PRInt32 aQType, nsIMsgFolder *aFolder) { return !_to ? NS_ERROR_NULL_POINTER : _to->OnFolderRemovedFromQ(aQType, aFolder); } \
  NS_SCRIPTABLE NS_IMETHOD OnDownloadStarted(nsIMsgFolder *aFolder, PRUint32 aNumberOfMessages, PRUint32 aTotalPending) { return !_to ? NS_ERROR_NULL_POINTER : _to->OnDownloadStarted(aFolder, aNumberOfMessages, aTotalPending); } \
  NS_SCRIPTABLE NS_IMETHOD OnDownloadCompleted(nsIMsgFolder *aFolder) { return !_to ? NS_ERROR_NULL_POINTER : _to->OnDownloadCompleted(aFolder); } \
  NS_SCRIPTABLE NS_IMETHOD OnDownloadError(nsIMsgFolder *aFolder) { return !_to ? NS_ERROR_NULL_POINTER : _to->OnDownloadError(aFolder); } \
  NS_SCRIPTABLE NS_IMETHOD OnStateChanged(PRBool aRunning) { return !_to ? NS_ERROR_NULL_POINTER : _to->OnStateChanged(aRunning); } \
  NS_SCRIPTABLE NS_IMETHOD OnDiscoveryQProcessed(nsIMsgFolder *aFolder, PRUint32 aNumberOfHdrsProcessed, PRUint32 aLeftToProcess) { return !_to ? NS_ERROR_NULL_POINTER : _to->OnDiscoveryQProcessed(aFolder, aNumberOfHdrsProcessed, aLeftToProcess); } \
  NS_SCRIPTABLE NS_IMETHOD OnAutoSyncInitiated(nsIMsgFolder *aFolder) { return !_to ? NS_ERROR_NULL_POINTER : _to->OnAutoSyncInitiated(aFolder); } 

#if 0
/* Use the code below as a template for the implementation class for this interface. */

/* Header file */
class nsAutoSyncMgrListener : public nsIAutoSyncMgrListener
{
public:
  NS_DECL_ISUPPORTS
  NS_DECL_NSIAUTOSYNCMGRLISTENER

  nsAutoSyncMgrListener();

private:
  ~nsAutoSyncMgrListener();

protected:
  /* additional members */
};

/* Implementation file */
NS_IMPL_ISUPPORTS1(nsAutoSyncMgrListener, nsIAutoSyncMgrListener)

nsAutoSyncMgrListener::nsAutoSyncMgrListener()
{
  /* member initializers and constructor code */
}

nsAutoSyncMgrListener::~nsAutoSyncMgrListener()
{
  /* destructor code */
}

/* void onFolderAddedIntoQ (in long aQType, in nsIMsgFolder aFolder); */
NS_IMETHODIMP nsAutoSyncMgrListener::OnFolderAddedIntoQ(PRInt32 aQType, nsIMsgFolder *aFolder)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void onFolderRemovedFromQ (in long aQType, in nsIMsgFolder aFolder); */
NS_IMETHODIMP nsAutoSyncMgrListener::OnFolderRemovedFromQ(PRInt32 aQType, nsIMsgFolder *aFolder)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void onDownloadStarted (in nsIMsgFolder aFolder, in unsigned long aNumberOfMessages, in unsigned long aTotalPending); */
NS_IMETHODIMP nsAutoSyncMgrListener::OnDownloadStarted(nsIMsgFolder *aFolder, PRUint32 aNumberOfMessages, PRUint32 aTotalPending)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void onDownloadCompleted (in nsIMsgFolder aFolder); */
NS_IMETHODIMP nsAutoSyncMgrListener::OnDownloadCompleted(nsIMsgFolder *aFolder)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void onDownloadError (in nsIMsgFolder aFolder); */
NS_IMETHODIMP nsAutoSyncMgrListener::OnDownloadError(nsIMsgFolder *aFolder)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void onStateChanged (in boolean aRunning); */
NS_IMETHODIMP nsAutoSyncMgrListener::OnStateChanged(PRBool aRunning)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void onDiscoveryQProcessed (in nsIMsgFolder aFolder, in unsigned long aNumberOfHdrsProcessed, in unsigned long aLeftToProcess); */
NS_IMETHODIMP nsAutoSyncMgrListener::OnDiscoveryQProcessed(nsIMsgFolder *aFolder, PRUint32 aNumberOfHdrsProcessed, PRUint32 aLeftToProcess)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void onAutoSyncInitiated (in nsIMsgFolder aFolder); */
NS_IMETHODIMP nsAutoSyncMgrListener::OnAutoSyncInitiated(nsIMsgFolder *aFolder)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* End of implementation class template. */
#endif


/* starting interface:    nsIAutoSyncManager */
#define NS_IAUTOSYNCMANAGER_IID_STR "7fe0b48e-f5d8-4747-beb7-888c9cced3a5"

#define NS_IAUTOSYNCMANAGER_IID \
  {0x7fe0b48e, 0xf5d8, 0x4747, \
    { 0xbe, 0xb7, 0x88, 0x8c, 0x9c, 0xce, 0xd3, 0xa5 }}

class NS_NO_VTABLE NS_SCRIPTABLE nsIAutoSyncManager : public nsISupports {
 public: 

  NS_DECLARE_STATIC_IID_ACCESSOR(NS_IAUTOSYNCMANAGER_IID)

  /** 
   * Download models
   */
  enum { dmParallel = 0 };

  enum { dmChained = 1 };

  /**
   * Suggested minimum grouping size in bytes for message downloads.
   * Setting this attribute to 0 resets its value to the 
   * hardcoded default.
   */
  /* attribute unsigned long groupSize; */
  NS_SCRIPTABLE NS_IMETHOD GetGroupSize(PRUint32 *aGroupSize) = 0;
  NS_SCRIPTABLE NS_IMETHOD SetGroupSize(PRUint32 aGroupSize) = 0;

  /**
   * Active strategy function to prioritize
   * messages in the download queue
   */
  /* attribute nsIAutoSyncMsgStrategy msgStrategy; */
  NS_SCRIPTABLE NS_IMETHOD GetMsgStrategy(nsIAutoSyncMsgStrategy **aMsgStrategy) = 0;
  NS_SCRIPTABLE NS_IMETHOD SetMsgStrategy(nsIAutoSyncMsgStrategy *aMsgStrategy) = 0;

  /**
   * Active strategy function to prioritize
   * folders in the download queue
   */
  /* attribute nsIAutoSyncFolderStrategy folderStrategy; */
  NS_SCRIPTABLE NS_IMETHOD GetFolderStrategy(nsIAutoSyncFolderStrategy **aFolderStrategy) = 0;
  NS_SCRIPTABLE NS_IMETHOD SetFolderStrategy(nsIAutoSyncFolderStrategy *aFolderStrategy) = 0;

  /**
   * Adds a listener to notify about auto-sync events
   */
  /* void addListener (in nsIAutoSyncMgrListener aListener); */
  NS_SCRIPTABLE NS_IMETHOD AddListener(nsIAutoSyncMgrListener *aListener) = 0;

  /**
   * Removes the listener from notification list
   */
  /* void removeListener (in nsIAutoSyncMgrListener aListener); */
  NS_SCRIPTABLE NS_IMETHOD RemoveListener(nsIAutoSyncMgrListener *aListener) = 0;

  /**
   * Tests the given message to make sure that whether 
   * it fits the download criteria or not
   */
  /* boolean doesMsgFitDownloadCriteria (in nsIMsgDBHdr aMsgHdr); */
  NS_SCRIPTABLE NS_IMETHOD DoesMsgFitDownloadCriteria(nsIMsgDBHdr *aMsgHdr, PRBool *_retval NS_OUTPARAM) = 0;

  /**
   * Called by the nsAutoSyncState object when the download
   * queue is changed. Given interface is already addref'd.
   */
  /* void onDownloadQChanged (in nsIAutoSyncState aAutoSyncStateObj); */
  NS_SCRIPTABLE NS_IMETHOD OnDownloadQChanged(nsIAutoSyncState *aAutoSyncStateObj) = 0;

  /**
   * Called by the nsAutoSyncState object when the download
   * is started. Given interface is already addref'd.
   */
  /* void onDownloadStarted (in nsIAutoSyncState aAutoSyncStateObj, in nsresult aStartCode); */
  NS_SCRIPTABLE NS_IMETHOD OnDownloadStarted(nsIAutoSyncState *aAutoSyncStateObj, nsresult aStartCode) = 0;

  /**
   * Called by the nsAutoSyncState object when the download
   * completed. Given interface is already addref'd.
   */
  /* void onDownloadCompleted (in nsIAutoSyncState aAutoSyncStateObj, in nsresult aExitCode); */
  NS_SCRIPTABLE NS_IMETHOD OnDownloadCompleted(nsIAutoSyncState *aAutoSyncStateObj, nsresult aExitCode) = 0;

  /**
   * Number of elements in the discovery queue.
   * @see nsAutoSyncManager.h for details
   */
  /* readonly attribute unsigned long discoveryQLength; */
  NS_SCRIPTABLE NS_IMETHOD GetDiscoveryQLength(PRUint32 *aDiscoveryQLength) = 0;

  /**
   * Number of elements in the update queue.
   * @see nsAutoSyncManager.h for details
   */
  /* readonly attribute unsigned long updateQLength; */
  NS_SCRIPTABLE NS_IMETHOD GetUpdateQLength(PRUint32 *aUpdateQLength) = 0;

  /**
   * Number of elements in the download queue (a.k.a priority queue).
   * @see nsAutoSyncManager.h for details
   */
  /* readonly attribute unsigned long downloadQLength; */
  NS_SCRIPTABLE NS_IMETHOD GetDownloadQLength(PRUint32 *aDownloadQLength) = 0;

  /**
   * Active download model; Chained (serial), or Parallel
   */
  /* attribute long downloadModel; */
  NS_SCRIPTABLE NS_IMETHOD GetDownloadModel(PRInt32 *aDownloadModel) = 0;
  NS_SCRIPTABLE NS_IMETHOD SetDownloadModel(PRInt32 aDownloadModel) = 0;

  /**
   * The imap folder corresponding to aAutoSyncState has had a message
   * added to it. Autosync may want to add this folder to the update q.
   *
   * @param aAutoSyncState state obj for folder needing updating
   */
  /* void onFolderHasPendingMsgs (in nsIAutoSyncState aAutoSyncState); */
  NS_SCRIPTABLE NS_IMETHOD OnFolderHasPendingMsgs(nsIAutoSyncState *aAutoSyncState) = 0;

  /* void pause (); */
  NS_SCRIPTABLE NS_IMETHOD Pause(void) = 0;

  /* void resume (); */
  NS_SCRIPTABLE NS_IMETHOD Resume(void) = 0;

};

  NS_DEFINE_STATIC_IID_ACCESSOR(nsIAutoSyncManager, NS_IAUTOSYNCMANAGER_IID)

/* Use this macro when declaring classes that implement this interface. */
#define NS_DECL_NSIAUTOSYNCMANAGER \
  NS_SCRIPTABLE NS_IMETHOD GetGroupSize(PRUint32 *aGroupSize); \
  NS_SCRIPTABLE NS_IMETHOD SetGroupSize(PRUint32 aGroupSize); \
  NS_SCRIPTABLE NS_IMETHOD GetMsgStrategy(nsIAutoSyncMsgStrategy **aMsgStrategy); \
  NS_SCRIPTABLE NS_IMETHOD SetMsgStrategy(nsIAutoSyncMsgStrategy *aMsgStrategy); \
  NS_SCRIPTABLE NS_IMETHOD GetFolderStrategy(nsIAutoSyncFolderStrategy **aFolderStrategy); \
  NS_SCRIPTABLE NS_IMETHOD SetFolderStrategy(nsIAutoSyncFolderStrategy *aFolderStrategy); \
  NS_SCRIPTABLE NS_IMETHOD AddListener(nsIAutoSyncMgrListener *aListener); \
  NS_SCRIPTABLE NS_IMETHOD RemoveListener(nsIAutoSyncMgrListener *aListener); \
  NS_SCRIPTABLE NS_IMETHOD DoesMsgFitDownloadCriteria(nsIMsgDBHdr *aMsgHdr, PRBool *_retval NS_OUTPARAM); \
  NS_SCRIPTABLE NS_IMETHOD OnDownloadQChanged(nsIAutoSyncState *aAutoSyncStateObj); \
  NS_SCRIPTABLE NS_IMETHOD OnDownloadStarted(nsIAutoSyncState *aAutoSyncStateObj, nsresult aStartCode); \
  NS_SCRIPTABLE NS_IMETHOD OnDownloadCompleted(nsIAutoSyncState *aAutoSyncStateObj, nsresult aExitCode); \
  NS_SCRIPTABLE NS_IMETHOD GetDiscoveryQLength(PRUint32 *aDiscoveryQLength); \
  NS_SCRIPTABLE NS_IMETHOD GetUpdateQLength(PRUint32 *aUpdateQLength); \
  NS_SCRIPTABLE NS_IMETHOD GetDownloadQLength(PRUint32 *aDownloadQLength); \
  NS_SCRIPTABLE NS_IMETHOD GetDownloadModel(PRInt32 *aDownloadModel); \
  NS_SCRIPTABLE NS_IMETHOD SetDownloadModel(PRInt32 aDownloadModel); \
  NS_SCRIPTABLE NS_IMETHOD OnFolderHasPendingMsgs(nsIAutoSyncState *aAutoSyncState); \
  NS_SCRIPTABLE NS_IMETHOD Pause(void); \
  NS_SCRIPTABLE NS_IMETHOD Resume(void); 

/* Use this macro to declare functions that forward the behavior of this interface to another object. */
#define NS_FORWARD_NSIAUTOSYNCMANAGER(_to) \
  NS_SCRIPTABLE NS_IMETHOD GetGroupSize(PRUint32 *aGroupSize) { return _to GetGroupSize(aGroupSize); } \
  NS_SCRIPTABLE NS_IMETHOD SetGroupSize(PRUint32 aGroupSize) { return _to SetGroupSize(aGroupSize); } \
  NS_SCRIPTABLE NS_IMETHOD GetMsgStrategy(nsIAutoSyncMsgStrategy **aMsgStrategy) { return _to GetMsgStrategy(aMsgStrategy); } \
  NS_SCRIPTABLE NS_IMETHOD SetMsgStrategy(nsIAutoSyncMsgStrategy *aMsgStrategy) { return _to SetMsgStrategy(aMsgStrategy); } \
  NS_SCRIPTABLE NS_IMETHOD GetFolderStrategy(nsIAutoSyncFolderStrategy **aFolderStrategy) { return _to GetFolderStrategy(aFolderStrategy); } \
  NS_SCRIPTABLE NS_IMETHOD SetFolderStrategy(nsIAutoSyncFolderStrategy *aFolderStrategy) { return _to SetFolderStrategy(aFolderStrategy); } \
  NS_SCRIPTABLE NS_IMETHOD AddListener(nsIAutoSyncMgrListener *aListener) { return _to AddListener(aListener); } \
  NS_SCRIPTABLE NS_IMETHOD RemoveListener(nsIAutoSyncMgrListener *aListener) { return _to RemoveListener(aListener); } \
  NS_SCRIPTABLE NS_IMETHOD DoesMsgFitDownloadCriteria(nsIMsgDBHdr *aMsgHdr, PRBool *_retval NS_OUTPARAM) { return _to DoesMsgFitDownloadCriteria(aMsgHdr, _retval); } \
  NS_SCRIPTABLE NS_IMETHOD OnDownloadQChanged(nsIAutoSyncState *aAutoSyncStateObj) { return _to OnDownloadQChanged(aAutoSyncStateObj); } \
  NS_SCRIPTABLE NS_IMETHOD OnDownloadStarted(nsIAutoSyncState *aAutoSyncStateObj, nsresult aStartCode) { return _to OnDownloadStarted(aAutoSyncStateObj, aStartCode); } \
  NS_SCRIPTABLE NS_IMETHOD OnDownloadCompleted(nsIAutoSyncState *aAutoSyncStateObj, nsresult aExitCode) { return _to OnDownloadCompleted(aAutoSyncStateObj, aExitCode); } \
  NS_SCRIPTABLE NS_IMETHOD GetDiscoveryQLength(PRUint32 *aDiscoveryQLength) { return _to GetDiscoveryQLength(aDiscoveryQLength); } \
  NS_SCRIPTABLE NS_IMETHOD GetUpdateQLength(PRUint32 *aUpdateQLength) { return _to GetUpdateQLength(aUpdateQLength); } \
  NS_SCRIPTABLE NS_IMETHOD GetDownloadQLength(PRUint32 *aDownloadQLength) { return _to GetDownloadQLength(aDownloadQLength); } \
  NS_SCRIPTABLE NS_IMETHOD GetDownloadModel(PRInt32 *aDownloadModel) { return _to GetDownloadModel(aDownloadModel); } \
  NS_SCRIPTABLE NS_IMETHOD SetDownloadModel(PRInt32 aDownloadModel) { return _to SetDownloadModel(aDownloadModel); } \
  NS_SCRIPTABLE NS_IMETHOD OnFolderHasPendingMsgs(nsIAutoSyncState *aAutoSyncState) { return _to OnFolderHasPendingMsgs(aAutoSyncState); } \
  NS_SCRIPTABLE NS_IMETHOD Pause(void) { return _to Pause(); } \
  NS_SCRIPTABLE NS_IMETHOD Resume(void) { return _to Resume(); } 

/* Use this macro to declare functions that forward the behavior of this interface to another object in a safe way. */
#define NS_FORWARD_SAFE_NSIAUTOSYNCMANAGER(_to) \
  NS_SCRIPTABLE NS_IMETHOD GetGroupSize(PRUint32 *aGroupSize) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetGroupSize(aGroupSize); } \
  NS_SCRIPTABLE NS_IMETHOD SetGroupSize(PRUint32 aGroupSize) { return !_to ? NS_ERROR_NULL_POINTER : _to->SetGroupSize(aGroupSize); } \
  NS_SCRIPTABLE NS_IMETHOD GetMsgStrategy(nsIAutoSyncMsgStrategy **aMsgStrategy) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetMsgStrategy(aMsgStrategy); } \
  NS_SCRIPTABLE NS_IMETHOD SetMsgStrategy(nsIAutoSyncMsgStrategy *aMsgStrategy) { return !_to ? NS_ERROR_NULL_POINTER : _to->SetMsgStrategy(aMsgStrategy); } \
  NS_SCRIPTABLE NS_IMETHOD GetFolderStrategy(nsIAutoSyncFolderStrategy **aFolderStrategy) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetFolderStrategy(aFolderStrategy); } \
  NS_SCRIPTABLE NS_IMETHOD SetFolderStrategy(nsIAutoSyncFolderStrategy *aFolderStrategy) { return !_to ? NS_ERROR_NULL_POINTER : _to->SetFolderStrategy(aFolderStrategy); } \
  NS_SCRIPTABLE NS_IMETHOD AddListener(nsIAutoSyncMgrListener *aListener) { return !_to ? NS_ERROR_NULL_POINTER : _to->AddListener(aListener); } \
  NS_SCRIPTABLE NS_IMETHOD RemoveListener(nsIAutoSyncMgrListener *aListener) { return !_to ? NS_ERROR_NULL_POINTER : _to->RemoveListener(aListener); } \
  NS_SCRIPTABLE NS_IMETHOD DoesMsgFitDownloadCriteria(nsIMsgDBHdr *aMsgHdr, PRBool *_retval NS_OUTPARAM) { return !_to ? NS_ERROR_NULL_POINTER : _to->DoesMsgFitDownloadCriteria(aMsgHdr, _retval); } \
  NS_SCRIPTABLE NS_IMETHOD OnDownloadQChanged(nsIAutoSyncState *aAutoSyncStateObj) { return !_to ? NS_ERROR_NULL_POINTER : _to->OnDownloadQChanged(aAutoSyncStateObj); } \
  NS_SCRIPTABLE NS_IMETHOD OnDownloadStarted(nsIAutoSyncState *aAutoSyncStateObj, nsresult aStartCode) { return !_to ? NS_ERROR_NULL_POINTER : _to->OnDownloadStarted(aAutoSyncStateObj, aStartCode); } \
  NS_SCRIPTABLE NS_IMETHOD OnDownloadCompleted(nsIAutoSyncState *aAutoSyncStateObj, nsresult aExitCode) { return !_to ? NS_ERROR_NULL_POINTER : _to->OnDownloadCompleted(aAutoSyncStateObj, aExitCode); } \
  NS_SCRIPTABLE NS_IMETHOD GetDiscoveryQLength(PRUint32 *aDiscoveryQLength) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetDiscoveryQLength(aDiscoveryQLength); } \
  NS_SCRIPTABLE NS_IMETHOD GetUpdateQLength(PRUint32 *aUpdateQLength) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetUpdateQLength(aUpdateQLength); } \
  NS_SCRIPTABLE NS_IMETHOD GetDownloadQLength(PRUint32 *aDownloadQLength) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetDownloadQLength(aDownloadQLength); } \
  NS_SCRIPTABLE NS_IMETHOD GetDownloadModel(PRInt32 *aDownloadModel) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetDownloadModel(aDownloadModel); } \
  NS_SCRIPTABLE NS_IMETHOD SetDownloadModel(PRInt32 aDownloadModel) { return !_to ? NS_ERROR_NULL_POINTER : _to->SetDownloadModel(aDownloadModel); } \
  NS_SCRIPTABLE NS_IMETHOD OnFolderHasPendingMsgs(nsIAutoSyncState *aAutoSyncState) { return !_to ? NS_ERROR_NULL_POINTER : _to->OnFolderHasPendingMsgs(aAutoSyncState); } \
  NS_SCRIPTABLE NS_IMETHOD Pause(void) { return !_to ? NS_ERROR_NULL_POINTER : _to->Pause(); } \
  NS_SCRIPTABLE NS_IMETHOD Resume(void) { return !_to ? NS_ERROR_NULL_POINTER : _to->Resume(); } 

#if 0
/* Use the code below as a template for the implementation class for this interface. */

/* Header file */
class nsAutoSyncManager : public nsIAutoSyncManager
{
public:
  NS_DECL_ISUPPORTS
  NS_DECL_NSIAUTOSYNCMANAGER

  nsAutoSyncManager();

private:
  ~nsAutoSyncManager();

protected:
  /* additional members */
};

/* Implementation file */
NS_IMPL_ISUPPORTS1(nsAutoSyncManager, nsIAutoSyncManager)

nsAutoSyncManager::nsAutoSyncManager()
{
  /* member initializers and constructor code */
}

nsAutoSyncManager::~nsAutoSyncManager()
{
  /* destructor code */
}

/* attribute unsigned long groupSize; */
NS_IMETHODIMP nsAutoSyncManager::GetGroupSize(PRUint32 *aGroupSize)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}
NS_IMETHODIMP nsAutoSyncManager::SetGroupSize(PRUint32 aGroupSize)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* attribute nsIAutoSyncMsgStrategy msgStrategy; */
NS_IMETHODIMP nsAutoSyncManager::GetMsgStrategy(nsIAutoSyncMsgStrategy **aMsgStrategy)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}
NS_IMETHODIMP nsAutoSyncManager::SetMsgStrategy(nsIAutoSyncMsgStrategy *aMsgStrategy)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* attribute nsIAutoSyncFolderStrategy folderStrategy; */
NS_IMETHODIMP nsAutoSyncManager::GetFolderStrategy(nsIAutoSyncFolderStrategy **aFolderStrategy)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}
NS_IMETHODIMP nsAutoSyncManager::SetFolderStrategy(nsIAutoSyncFolderStrategy *aFolderStrategy)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void addListener (in nsIAutoSyncMgrListener aListener); */
NS_IMETHODIMP nsAutoSyncManager::AddListener(nsIAutoSyncMgrListener *aListener)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void removeListener (in nsIAutoSyncMgrListener aListener); */
NS_IMETHODIMP nsAutoSyncManager::RemoveListener(nsIAutoSyncMgrListener *aListener)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* boolean doesMsgFitDownloadCriteria (in nsIMsgDBHdr aMsgHdr); */
NS_IMETHODIMP nsAutoSyncManager::DoesMsgFitDownloadCriteria(nsIMsgDBHdr *aMsgHdr, PRBool *_retval NS_OUTPARAM)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void onDownloadQChanged (in nsIAutoSyncState aAutoSyncStateObj); */
NS_IMETHODIMP nsAutoSyncManager::OnDownloadQChanged(nsIAutoSyncState *aAutoSyncStateObj)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void onDownloadStarted (in nsIAutoSyncState aAutoSyncStateObj, in nsresult aStartCode); */
NS_IMETHODIMP nsAutoSyncManager::OnDownloadStarted(nsIAutoSyncState *aAutoSyncStateObj, nsresult aStartCode)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void onDownloadCompleted (in nsIAutoSyncState aAutoSyncStateObj, in nsresult aExitCode); */
NS_IMETHODIMP nsAutoSyncManager::OnDownloadCompleted(nsIAutoSyncState *aAutoSyncStateObj, nsresult aExitCode)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* readonly attribute unsigned long discoveryQLength; */
NS_IMETHODIMP nsAutoSyncManager::GetDiscoveryQLength(PRUint32 *aDiscoveryQLength)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* readonly attribute unsigned long updateQLength; */
NS_IMETHODIMP nsAutoSyncManager::GetUpdateQLength(PRUint32 *aUpdateQLength)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* readonly attribute unsigned long downloadQLength; */
NS_IMETHODIMP nsAutoSyncManager::GetDownloadQLength(PRUint32 *aDownloadQLength)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* attribute long downloadModel; */
NS_IMETHODIMP nsAutoSyncManager::GetDownloadModel(PRInt32 *aDownloadModel)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}
NS_IMETHODIMP nsAutoSyncManager::SetDownloadModel(PRInt32 aDownloadModel)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void onFolderHasPendingMsgs (in nsIAutoSyncState aAutoSyncState); */
NS_IMETHODIMP nsAutoSyncManager::OnFolderHasPendingMsgs(nsIAutoSyncState *aAutoSyncState)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void pause (); */
NS_IMETHODIMP nsAutoSyncManager::Pause()
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void resume (); */
NS_IMETHODIMP nsAutoSyncManager::Resume()
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* End of implementation class template. */
#endif

#define NS_AUTOSYNCMANAGER_CID  \
{ /* C358C568-47B2-42b2-8146-3C0F8D1FAD6E */  \
  0xc358c568, 0x47b2, 0x42b2,                 \
  { 0x81, 0x46, 0x3c, 0xf, 0x8d, 0x1f, 0xad, 0x6e }}
#define NS_AUTOSYNCMANAGER_CLASSNAME \
  "Auto-Sync Manager"
#define NS_AUTOSYNCMANAGER_CONTRACTID \
  "@mozilla.org/imap/autosyncmgr;1"

#endif /* __gen_nsIAutoSyncManager_h__ */
