/*
 * DO NOT EDIT.  THIS FILE IS GENERATED FROM nsIAbDirectory.idl
 */

#ifndef __gen_nsIAbDirectory_h__
#define __gen_nsIAbDirectory_h__


#ifndef __gen_nsIAbCollection_h__
#include "nsIAbCollection.h"
#endif

#ifndef __gen_nsIAbCard_h__
#include "nsIAbCard.h"
#endif

/* For IDL files that don't want to include root IDL files. */
#ifndef NS_NO_VTABLE
#define NS_NO_VTABLE
#endif
class nsISimpleEnumerator; /* forward declaration */

class nsIArray; /* forward declaration */

class nsIMutableArray; /* forward declaration */

/* RDF root for all types of address books */
/* use this to get all directories, create new directory*/
#define kAllDirectoryRoot          "moz-abdirectory://" 
#define kPersonalAddressbook       "abook.mab"
#define kPersonalAddressbookUri    "moz-abmdbdirectory://abook.mab"
#define kCollectedAddressbook      "history.mab"
#define kCollectedAddressbookUri   "moz-abmdbdirectory://history.mab"
#define kABFileName_PreviousSuffix ".na2" /* final v2 address book format */
#define kABFileName_PreviousSuffixLen 4
#define kABFileName_CurrentSuffix ".mab"  /* v3 address book extension */

/* starting interface:    nsIAbDirectory */
#define NS_IABDIRECTORY_IID_STR "1f11f37e-7009-4a51-bbb1-041e9f75120a"

#define NS_IABDIRECTORY_IID \
  {0x1f11f37e, 0x7009, 0x4a51, \
    { 0xbb, 0xb1, 0x04, 0x1e, 0x9f, 0x75, 0x12, 0x0a }}

/**
 * A top-level address book directory.
 *
 * The UUID of an nsIAbDirectory is its preference ID and its name, concatenated
 * together.
 */
class NS_NO_VTABLE NS_SCRIPTABLE nsIAbDirectory : public nsIAbCollection {
 public: 

  NS_DECLARE_STATIC_IID_ACCESSOR(NS_IABDIRECTORY_IID)

  /**
   * The chrome URI to use for bringing up a dialog to edit this directory.
   * When opening the dialog, use a JS argument of
   * {selectedDirectory: thisdir} where thisdir is this directory that you just
   * got the chrome URI from.
   */
  /* readonly attribute ACString propertiesChromeURI; */
  NS_SCRIPTABLE NS_IMETHOD GetPropertiesChromeURI(nsACString & aPropertiesChromeURI) = 0;

  /**
   * The description of the directory. If this directory is not a mailing list,
   * then setting this attribute will send round a "DirName" update via
   * nsIAddrBookSession.
   */
  /* attribute AString dirName; */
  NS_SCRIPTABLE NS_IMETHOD GetDirName(nsAString & aDirName) = 0;
  NS_SCRIPTABLE NS_IMETHOD SetDirName(const nsAString & aDirName) = 0;

  /* readonly attribute long dirType; */
  NS_SCRIPTABLE NS_IMETHOD GetDirType(PRInt32 *aDirType) = 0;

  /* readonly attribute ACString fileName; */
  NS_SCRIPTABLE NS_IMETHOD GetFileName(nsACString & aFileName) = 0;

  /* readonly attribute ACString URI; */
  NS_SCRIPTABLE NS_IMETHOD GetURI(nsACString & aURI) = 0;

  /* readonly attribute long position; */
  NS_SCRIPTABLE NS_IMETHOD GetPosition(PRInt32 *aPosition) = 0;

  /* attribute unsigned long lastModifiedDate; */
  NS_SCRIPTABLE NS_IMETHOD GetLastModifiedDate(PRUint32 *aLastModifiedDate) = 0;
  NS_SCRIPTABLE NS_IMETHOD SetLastModifiedDate(PRUint32 aLastModifiedDate) = 0;

  /* attribute PRBool isMailList; */
  NS_SCRIPTABLE NS_IMETHOD GetIsMailList(PRBool *aIsMailList) = 0;
  NS_SCRIPTABLE NS_IMETHOD SetIsMailList(PRBool aIsMailList) = 0;

  /* readonly attribute nsISimpleEnumerator childNodes; */
  NS_SCRIPTABLE NS_IMETHOD GetChildNodes(nsISimpleEnumerator **aChildNodes) = 0;

  /**
   * Get the cards associated with the directory. This will return the cards
   * associated with the mailing lists too.
   */
  /* readonly attribute nsISimpleEnumerator childCards; */
  NS_SCRIPTABLE NS_IMETHOD GetChildCards(nsISimpleEnumerator **aChildCards) = 0;

  /**
   * Returns true if this directory represents a query - i.e. the rdf resource
   * was something like moz-abmdbdirectory://abook.mab?....
   */
  /* readonly attribute boolean isQuery; */
  NS_SCRIPTABLE NS_IMETHOD GetIsQuery(PRBool *aIsQuery) = 0;

  /* void deleteDirectory (in nsIAbDirectory directory); */
  NS_SCRIPTABLE NS_IMETHOD DeleteDirectory(nsIAbDirectory *directory) = 0;

  /* boolean hasCard (in nsIAbCard cards); */
  NS_SCRIPTABLE NS_IMETHOD HasCard(nsIAbCard *cards, PRBool *_retval NS_OUTPARAM) = 0;

  /* boolean hasDirectory (in nsIAbDirectory dir); */
  NS_SCRIPTABLE NS_IMETHOD HasDirectory(nsIAbDirectory *dir, PRBool *_retval NS_OUTPARAM) = 0;

  /**
   * Adds a card to the database.
   *
   * This card does not need to be of the same type as the database, e.g., one
   * can add an nsIAbLDAPCard to an nsIAbMDBDirectory.
   *
   * @return "Real" card (eg nsIAbLDAPCard) that can be used for some
   *         extra functions.
   */
  /* nsIAbCard addCard (in nsIAbCard card); */
  NS_SCRIPTABLE NS_IMETHOD AddCard(nsIAbCard *card, nsIAbCard **_retval NS_OUTPARAM) = 0;

  /**
   * Modifies a card in the database to match that supplied.
   */
  /* void modifyCard (in nsIAbCard modifiedCard); */
  NS_SCRIPTABLE NS_IMETHOD ModifyCard(nsIAbCard *modifiedCard) = 0;

  /**
   * Deletes the array of cards from the database.
   *
   * @param  aCards  The cards to delete from the database.
   */
  /* void deleteCards (in nsIArray aCards); */
  NS_SCRIPTABLE NS_IMETHOD DeleteCards(nsIArray *aCards) = 0;

  /* void dropCard (in nsIAbCard card, in boolean needToCopyCard); */
  NS_SCRIPTABLE NS_IMETHOD DropCard(nsIAbCard *card, PRBool needToCopyCard) = 0;

  /**
   * Whether or not the directory should be searched when doing autocomplete,
   * (currently by using GetChildCards); LDAP does not support this in online
   * mode, so that should return false; additionally any other directory types
   * that also do not support GetChildCards should return false.
   *
   * @param aIdentity  An optional parameter detailing the identity key (see
   *                   nsIMsgAccountManager) that this autocomplete is being
   *                   run against.
   * @return           True if this directory should/can be used during
   *                   local autocomplete.
   */
  /* boolean useForAutocomplete (in ACString aIdentityKey); */
  NS_SCRIPTABLE NS_IMETHOD UseForAutocomplete(const nsACString & aIdentityKey, PRBool *_retval NS_OUTPARAM) = 0;

  /** 
   * Does this directory support mailing lists? Note that in the case
   * this directory is a mailing list and nested mailing lists are not
   * supported, this will return false rather than true which the parent
   * directory might.
   */
  /* readonly attribute boolean supportsMailingLists; */
  NS_SCRIPTABLE NS_IMETHOD GetSupportsMailingLists(PRBool *aSupportsMailingLists) = 0;

  /**
   * This attribute serves two purposes
   *  1. If this directory is not a mail list, directories are stored here
   *  2. If it is a mail list card entries are stored here
   *
   * @note This is a *live* array and not a static copy
   */
  /* attribute nsIMutableArray addressLists; */
  NS_SCRIPTABLE NS_IMETHOD GetAddressLists(nsIMutableArray **aAddressLists) = 0;
  NS_SCRIPTABLE NS_IMETHOD SetAddressLists(nsIMutableArray *aAddressLists) = 0;

  /**
   * Creates a new mailing list in the directory. Currently only supported 
   * for top-level directories.
   *
   * @param  list  The new mailing list to add.
   */
  /* void addMailList (in nsIAbDirectory list); */
  NS_SCRIPTABLE NS_IMETHOD AddMailList(nsIAbDirectory *list) = 0;

  /**
   * Nick Name of the mailing list. This attribute is only really used when
   * the nsIAbDirectory represents a mailing list.
   */
  /* attribute AString listNickName; */
  NS_SCRIPTABLE NS_IMETHOD GetListNickName(nsAString & aListNickName) = 0;
  NS_SCRIPTABLE NS_IMETHOD SetListNickName(const nsAString & aListNickName) = 0;

  /**
   * Description of the mailing list. This attribute is only really used when
   * the nsIAbDirectory represents a mailing list.
   */
  /* attribute AString description; */
  NS_SCRIPTABLE NS_IMETHOD GetDescription(nsAString & aDescription) = 0;
  NS_SCRIPTABLE NS_IMETHOD SetDescription(const nsAString & aDescription) = 0;

  /**
   * Edits an existing mailing list (specified as listCard) into its parent
   * directory. You should call this function on the resource with the same
   * uri as the listCard.
   *
   * @param  listCard  A nsIAbCard version of the mailing list with the new
   *                   values.
   */
  /* void editMailListToDatabase (in nsIAbCard listCard); */
  NS_SCRIPTABLE NS_IMETHOD EditMailListToDatabase(nsIAbCard *listCard) = 0;

  /* void copyMailList (in nsIAbDirectory srcList); */
  NS_SCRIPTABLE NS_IMETHOD CopyMailList(nsIAbDirectory *srcList) = 0;

  /**
   * Only creates a top level address book
   * which is stored in the preferences
   *
   * Need to change to factory based approach
   * to create new address books
   *
   * This method should become redundant or 
   * be only associated with card folders
   *
   * The parameters are the same as for
   * nsIAbManager::newAddressBook
   */
  /* ACString createNewDirectory (in AString aDirName, in ACString aURI, in unsigned long aType, in ACString aPrefName); */
  NS_SCRIPTABLE NS_IMETHOD CreateNewDirectory(const nsAString & aDirName, const nsACString & aURI, PRUint32 aType, const nsACString & aPrefName, nsACString & _retval NS_OUTPARAM) = 0;

  /* void createDirectoryByURI (in AString displayName, in ACString aURI); */
  NS_SCRIPTABLE NS_IMETHOD CreateDirectoryByURI(const nsAString & displayName, const nsACString & aURI) = 0;

  /**
   * The id of the directory used in prefs e.g. "ldap_2.servers.pab"
   * Setting this will cause directoryPrefs to be updated.
   */
  /* attribute ACString dirPrefId; */
  NS_SCRIPTABLE NS_IMETHOD GetDirPrefId(nsACString & aDirPrefId) = 0;
  NS_SCRIPTABLE NS_IMETHOD SetDirPrefId(const nsACString & aDirPrefId) = 0;

  /**
   * @name  getXXXValue
   *
   * Helper functions to get different types of pref, but return a default
   * value if a pref value was not obtained.
   *
   * @param aName         The name of the pref within the branch dirPrefId to
   *                      get a value from.
   *
   * @param aDefaultValue The default value to return if getting the pref fails
   *                      or the pref is not present.
   *
   * @return              The value of the pref or the default value.
   *
   * @exception           NS_ERROR_NOT_INITIALIZED if the pref branch couldn't
   *                      be obtained (e.g. dirPrefId isn't set).
   */
  /* long getIntValue (in string aName, in long aDefaultValue); */
  NS_SCRIPTABLE NS_IMETHOD GetIntValue(const char *aName, PRInt32 aDefaultValue, PRInt32 *_retval NS_OUTPARAM) = 0;

  /* boolean getBoolValue (in string aName, in boolean aDefaultValue); */
  NS_SCRIPTABLE NS_IMETHOD GetBoolValue(const char *aName, PRBool aDefaultValue, PRBool *_retval NS_OUTPARAM) = 0;

  /* ACString getStringValue (in string aName, in ACString aDefaultValue); */
  NS_SCRIPTABLE NS_IMETHOD GetStringValue(const char *aName, const nsACString & aDefaultValue, nsACString & _retval NS_OUTPARAM) = 0;

  /* AUTF8String getLocalizedStringValue (in string aName, in AUTF8String aDefaultValue); */
  NS_SCRIPTABLE NS_IMETHOD GetLocalizedStringValue(const char *aName, const nsACString & aDefaultValue, nsACString & _retval NS_OUTPARAM) = 0;

  /**
   * @name  setXXXValue
   *
   * Helper functions to set different types of pref values.
   *
   * @param aName         The name of the pref within the branch dirPrefId to
   *                      get a value from.
   *
   * @param aValue        The value to set the pref to.
   *
   * @exception           NS_ERROR_NOT_INITIALIZED if the pref branch couldn't
   *                      be obtained (e.g. dirPrefId isn't set).
   */
  /* void setIntValue (in string aName, in long aValue); */
  NS_SCRIPTABLE NS_IMETHOD SetIntValue(const char *aName, PRInt32 aValue) = 0;

  /* void setBoolValue (in string aName, in boolean aValue); */
  NS_SCRIPTABLE NS_IMETHOD SetBoolValue(const char *aName, PRBool aValue) = 0;

  /* void setStringValue (in string aName, in ACString aValue); */
  NS_SCRIPTABLE NS_IMETHOD SetStringValue(const char *aName, const nsACString & aValue) = 0;

  /* void setLocalizedStringValue (in string aName, in AUTF8String aValue); */
  NS_SCRIPTABLE NS_IMETHOD SetLocalizedStringValue(const char *aName, const nsACString & aValue) = 0;

};

  NS_DEFINE_STATIC_IID_ACCESSOR(nsIAbDirectory, NS_IABDIRECTORY_IID)

/* Use this macro when declaring classes that implement this interface. */
#define NS_DECL_NSIABDIRECTORY \
  NS_SCRIPTABLE NS_IMETHOD GetPropertiesChromeURI(nsACString & aPropertiesChromeURI); \
  NS_SCRIPTABLE NS_IMETHOD GetDirName(nsAString & aDirName); \
  NS_SCRIPTABLE NS_IMETHOD SetDirName(const nsAString & aDirName); \
  NS_SCRIPTABLE NS_IMETHOD GetDirType(PRInt32 *aDirType); \
  NS_SCRIPTABLE NS_IMETHOD GetFileName(nsACString & aFileName); \
  NS_SCRIPTABLE NS_IMETHOD GetURI(nsACString & aURI); \
  NS_SCRIPTABLE NS_IMETHOD GetPosition(PRInt32 *aPosition); \
  NS_SCRIPTABLE NS_IMETHOD GetLastModifiedDate(PRUint32 *aLastModifiedDate); \
  NS_SCRIPTABLE NS_IMETHOD SetLastModifiedDate(PRUint32 aLastModifiedDate); \
  NS_SCRIPTABLE NS_IMETHOD GetIsMailList(PRBool *aIsMailList); \
  NS_SCRIPTABLE NS_IMETHOD SetIsMailList(PRBool aIsMailList); \
  NS_SCRIPTABLE NS_IMETHOD GetChildNodes(nsISimpleEnumerator **aChildNodes); \
  NS_SCRIPTABLE NS_IMETHOD GetChildCards(nsISimpleEnumerator **aChildCards); \
  NS_SCRIPTABLE NS_IMETHOD GetIsQuery(PRBool *aIsQuery); \
  NS_SCRIPTABLE NS_IMETHOD DeleteDirectory(nsIAbDirectory *directory); \
  NS_SCRIPTABLE NS_IMETHOD HasCard(nsIAbCard *cards, PRBool *_retval NS_OUTPARAM); \
  NS_SCRIPTABLE NS_IMETHOD HasDirectory(nsIAbDirectory *dir, PRBool *_retval NS_OUTPARAM); \
  NS_SCRIPTABLE NS_IMETHOD AddCard(nsIAbCard *card, nsIAbCard **_retval NS_OUTPARAM); \
  NS_SCRIPTABLE NS_IMETHOD ModifyCard(nsIAbCard *modifiedCard); \
  NS_SCRIPTABLE NS_IMETHOD DeleteCards(nsIArray *aCards); \
  NS_SCRIPTABLE NS_IMETHOD DropCard(nsIAbCard *card, PRBool needToCopyCard); \
  NS_SCRIPTABLE NS_IMETHOD UseForAutocomplete(const nsACString & aIdentityKey, PRBool *_retval NS_OUTPARAM); \
  NS_SCRIPTABLE NS_IMETHOD GetSupportsMailingLists(PRBool *aSupportsMailingLists); \
  NS_SCRIPTABLE NS_IMETHOD GetAddressLists(nsIMutableArray **aAddressLists); \
  NS_SCRIPTABLE NS_IMETHOD SetAddressLists(nsIMutableArray *aAddressLists); \
  NS_SCRIPTABLE NS_IMETHOD AddMailList(nsIAbDirectory *list); \
  NS_SCRIPTABLE NS_IMETHOD GetListNickName(nsAString & aListNickName); \
  NS_SCRIPTABLE NS_IMETHOD SetListNickName(const nsAString & aListNickName); \
  NS_SCRIPTABLE NS_IMETHOD GetDescription(nsAString & aDescription); \
  NS_SCRIPTABLE NS_IMETHOD SetDescription(const nsAString & aDescription); \
  NS_SCRIPTABLE NS_IMETHOD EditMailListToDatabase(nsIAbCard *listCard); \
  NS_SCRIPTABLE NS_IMETHOD CopyMailList(nsIAbDirectory *srcList); \
  NS_SCRIPTABLE NS_IMETHOD CreateNewDirectory(const nsAString & aDirName, const nsACString & aURI, PRUint32 aType, const nsACString & aPrefName, nsACString & _retval NS_OUTPARAM); \
  NS_SCRIPTABLE NS_IMETHOD CreateDirectoryByURI(const nsAString & displayName, const nsACString & aURI); \
  NS_SCRIPTABLE NS_IMETHOD GetDirPrefId(nsACString & aDirPrefId); \
  NS_SCRIPTABLE NS_IMETHOD SetDirPrefId(const nsACString & aDirPrefId); \
  NS_SCRIPTABLE NS_IMETHOD GetIntValue(const char *aName, PRInt32 aDefaultValue, PRInt32 *_retval NS_OUTPARAM); \
  NS_SCRIPTABLE NS_IMETHOD GetBoolValue(const char *aName, PRBool aDefaultValue, PRBool *_retval NS_OUTPARAM); \
  NS_SCRIPTABLE NS_IMETHOD GetStringValue(const char *aName, const nsACString & aDefaultValue, nsACString & _retval NS_OUTPARAM); \
  NS_SCRIPTABLE NS_IMETHOD GetLocalizedStringValue(const char *aName, const nsACString & aDefaultValue, nsACString & _retval NS_OUTPARAM); \
  NS_SCRIPTABLE NS_IMETHOD SetIntValue(const char *aName, PRInt32 aValue); \
  NS_SCRIPTABLE NS_IMETHOD SetBoolValue(const char *aName, PRBool aValue); \
  NS_SCRIPTABLE NS_IMETHOD SetStringValue(const char *aName, const nsACString & aValue); \
  NS_SCRIPTABLE NS_IMETHOD SetLocalizedStringValue(const char *aName, const nsACString & aValue); 

/* Use this macro to declare functions that forward the behavior of this interface to another object. */
#define NS_FORWARD_NSIABDIRECTORY(_to) \
  NS_SCRIPTABLE NS_IMETHOD GetPropertiesChromeURI(nsACString & aPropertiesChromeURI) { return _to GetPropertiesChromeURI(aPropertiesChromeURI); } \
  NS_SCRIPTABLE NS_IMETHOD GetDirName(nsAString & aDirName) { return _to GetDirName(aDirName); } \
  NS_SCRIPTABLE NS_IMETHOD SetDirName(const nsAString & aDirName) { return _to SetDirName(aDirName); } \
  NS_SCRIPTABLE NS_IMETHOD GetDirType(PRInt32 *aDirType) { return _to GetDirType(aDirType); } \
  NS_SCRIPTABLE NS_IMETHOD GetFileName(nsACString & aFileName) { return _to GetFileName(aFileName); } \
  NS_SCRIPTABLE NS_IMETHOD GetURI(nsACString & aURI) { return _to GetURI(aURI); } \
  NS_SCRIPTABLE NS_IMETHOD GetPosition(PRInt32 *aPosition) { return _to GetPosition(aPosition); } \
  NS_SCRIPTABLE NS_IMETHOD GetLastModifiedDate(PRUint32 *aLastModifiedDate) { return _to GetLastModifiedDate(aLastModifiedDate); } \
  NS_SCRIPTABLE NS_IMETHOD SetLastModifiedDate(PRUint32 aLastModifiedDate) { return _to SetLastModifiedDate(aLastModifiedDate); } \
  NS_SCRIPTABLE NS_IMETHOD GetIsMailList(PRBool *aIsMailList) { return _to GetIsMailList(aIsMailList); } \
  NS_SCRIPTABLE NS_IMETHOD SetIsMailList(PRBool aIsMailList) { return _to SetIsMailList(aIsMailList); } \
  NS_SCRIPTABLE NS_IMETHOD GetChildNodes(nsISimpleEnumerator **aChildNodes) { return _to GetChildNodes(aChildNodes); } \
  NS_SCRIPTABLE NS_IMETHOD GetChildCards(nsISimpleEnumerator **aChildCards) { return _to GetChildCards(aChildCards); } \
  NS_SCRIPTABLE NS_IMETHOD GetIsQuery(PRBool *aIsQuery) { return _to GetIsQuery(aIsQuery); } \
  NS_SCRIPTABLE NS_IMETHOD DeleteDirectory(nsIAbDirectory *directory) { return _to DeleteDirectory(directory); } \
  NS_SCRIPTABLE NS_IMETHOD HasCard(nsIAbCard *cards, PRBool *_retval NS_OUTPARAM) { return _to HasCard(cards, _retval); } \
  NS_SCRIPTABLE NS_IMETHOD HasDirectory(nsIAbDirectory *dir, PRBool *_retval NS_OUTPARAM) { return _to HasDirectory(dir, _retval); } \
  NS_SCRIPTABLE NS_IMETHOD AddCard(nsIAbCard *card, nsIAbCard **_retval NS_OUTPARAM) { return _to AddCard(card, _retval); } \
  NS_SCRIPTABLE NS_IMETHOD ModifyCard(nsIAbCard *modifiedCard) { return _to ModifyCard(modifiedCard); } \
  NS_SCRIPTABLE NS_IMETHOD DeleteCards(nsIArray *aCards) { return _to DeleteCards(aCards); } \
  NS_SCRIPTABLE NS_IMETHOD DropCard(nsIAbCard *card, PRBool needToCopyCard) { return _to DropCard(card, needToCopyCard); } \
  NS_SCRIPTABLE NS_IMETHOD UseForAutocomplete(const nsACString & aIdentityKey, PRBool *_retval NS_OUTPARAM) { return _to UseForAutocomplete(aIdentityKey, _retval); } \
  NS_SCRIPTABLE NS_IMETHOD GetSupportsMailingLists(PRBool *aSupportsMailingLists) { return _to GetSupportsMailingLists(aSupportsMailingLists); } \
  NS_SCRIPTABLE NS_IMETHOD GetAddressLists(nsIMutableArray **aAddressLists) { return _to GetAddressLists(aAddressLists); } \
  NS_SCRIPTABLE NS_IMETHOD SetAddressLists(nsIMutableArray *aAddressLists) { return _to SetAddressLists(aAddressLists); } \
  NS_SCRIPTABLE NS_IMETHOD AddMailList(nsIAbDirectory *list) { return _to AddMailList(list); } \
  NS_SCRIPTABLE NS_IMETHOD GetListNickName(nsAString & aListNickName) { return _to GetListNickName(aListNickName); } \
  NS_SCRIPTABLE NS_IMETHOD SetListNickName(const nsAString & aListNickName) { return _to SetListNickName(aListNickName); } \
  NS_SCRIPTABLE NS_IMETHOD GetDescription(nsAString & aDescription) { return _to GetDescription(aDescription); } \
  NS_SCRIPTABLE NS_IMETHOD SetDescription(const nsAString & aDescription) { return _to SetDescription(aDescription); } \
  NS_SCRIPTABLE NS_IMETHOD EditMailListToDatabase(nsIAbCard *listCard) { return _to EditMailListToDatabase(listCard); } \
  NS_SCRIPTABLE NS_IMETHOD CopyMailList(nsIAbDirectory *srcList) { return _to CopyMailList(srcList); } \
  NS_SCRIPTABLE NS_IMETHOD CreateNewDirectory(const nsAString & aDirName, const nsACString & aURI, PRUint32 aType, const nsACString & aPrefName, nsACString & _retval NS_OUTPARAM) { return _to CreateNewDirectory(aDirName, aURI, aType, aPrefName, _retval); } \
  NS_SCRIPTABLE NS_IMETHOD CreateDirectoryByURI(const nsAString & displayName, const nsACString & aURI) { return _to CreateDirectoryByURI(displayName, aURI); } \
  NS_SCRIPTABLE NS_IMETHOD GetDirPrefId(nsACString & aDirPrefId) { return _to GetDirPrefId(aDirPrefId); } \
  NS_SCRIPTABLE NS_IMETHOD SetDirPrefId(const nsACString & aDirPrefId) { return _to SetDirPrefId(aDirPrefId); } \
  NS_SCRIPTABLE NS_IMETHOD GetIntValue(const char *aName, PRInt32 aDefaultValue, PRInt32 *_retval NS_OUTPARAM) { return _to GetIntValue(aName, aDefaultValue, _retval); } \
  NS_SCRIPTABLE NS_IMETHOD GetBoolValue(const char *aName, PRBool aDefaultValue, PRBool *_retval NS_OUTPARAM) { return _to GetBoolValue(aName, aDefaultValue, _retval); } \
  NS_SCRIPTABLE NS_IMETHOD GetStringValue(const char *aName, const nsACString & aDefaultValue, nsACString & _retval NS_OUTPARAM) { return _to GetStringValue(aName, aDefaultValue, _retval); } \
  NS_SCRIPTABLE NS_IMETHOD GetLocalizedStringValue(const char *aName, const nsACString & aDefaultValue, nsACString & _retval NS_OUTPARAM) { return _to GetLocalizedStringValue(aName, aDefaultValue, _retval); } \
  NS_SCRIPTABLE NS_IMETHOD SetIntValue(const char *aName, PRInt32 aValue) { return _to SetIntValue(aName, aValue); } \
  NS_SCRIPTABLE NS_IMETHOD SetBoolValue(const char *aName, PRBool aValue) { return _to SetBoolValue(aName, aValue); } \
  NS_SCRIPTABLE NS_IMETHOD SetStringValue(const char *aName, const nsACString & aValue) { return _to SetStringValue(aName, aValue); } \
  NS_SCRIPTABLE NS_IMETHOD SetLocalizedStringValue(const char *aName, const nsACString & aValue) { return _to SetLocalizedStringValue(aName, aValue); } 

/* Use this macro to declare functions that forward the behavior of this interface to another object in a safe way. */
#define NS_FORWARD_SAFE_NSIABDIRECTORY(_to) \
  NS_SCRIPTABLE NS_IMETHOD GetPropertiesChromeURI(nsACString & aPropertiesChromeURI) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetPropertiesChromeURI(aPropertiesChromeURI); } \
  NS_SCRIPTABLE NS_IMETHOD GetDirName(nsAString & aDirName) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetDirName(aDirName); } \
  NS_SCRIPTABLE NS_IMETHOD SetDirName(const nsAString & aDirName) { return !_to ? NS_ERROR_NULL_POINTER : _to->SetDirName(aDirName); } \
  NS_SCRIPTABLE NS_IMETHOD GetDirType(PRInt32 *aDirType) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetDirType(aDirType); } \
  NS_SCRIPTABLE NS_IMETHOD GetFileName(nsACString & aFileName) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetFileName(aFileName); } \
  NS_SCRIPTABLE NS_IMETHOD GetURI(nsACString & aURI) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetURI(aURI); } \
  NS_SCRIPTABLE NS_IMETHOD GetPosition(PRInt32 *aPosition) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetPosition(aPosition); } \
  NS_SCRIPTABLE NS_IMETHOD GetLastModifiedDate(PRUint32 *aLastModifiedDate) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetLastModifiedDate(aLastModifiedDate); } \
  NS_SCRIPTABLE NS_IMETHOD SetLastModifiedDate(PRUint32 aLastModifiedDate) { return !_to ? NS_ERROR_NULL_POINTER : _to->SetLastModifiedDate(aLastModifiedDate); } \
  NS_SCRIPTABLE NS_IMETHOD GetIsMailList(PRBool *aIsMailList) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetIsMailList(aIsMailList); } \
  NS_SCRIPTABLE NS_IMETHOD SetIsMailList(PRBool aIsMailList) { return !_to ? NS_ERROR_NULL_POINTER : _to->SetIsMailList(aIsMailList); } \
  NS_SCRIPTABLE NS_IMETHOD GetChildNodes(nsISimpleEnumerator **aChildNodes) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetChildNodes(aChildNodes); } \
  NS_SCRIPTABLE NS_IMETHOD GetChildCards(nsISimpleEnumerator **aChildCards) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetChildCards(aChildCards); } \
  NS_SCRIPTABLE NS_IMETHOD GetIsQuery(PRBool *aIsQuery) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetIsQuery(aIsQuery); } \
  NS_SCRIPTABLE NS_IMETHOD DeleteDirectory(nsIAbDirectory *directory) { return !_to ? NS_ERROR_NULL_POINTER : _to->DeleteDirectory(directory); } \
  NS_SCRIPTABLE NS_IMETHOD HasCard(nsIAbCard *cards, PRBool *_retval NS_OUTPARAM) { return !_to ? NS_ERROR_NULL_POINTER : _to->HasCard(cards, _retval); } \
  NS_SCRIPTABLE NS_IMETHOD HasDirectory(nsIAbDirectory *dir, PRBool *_retval NS_OUTPARAM) { return !_to ? NS_ERROR_NULL_POINTER : _to->HasDirectory(dir, _retval); } \
  NS_SCRIPTABLE NS_IMETHOD AddCard(nsIAbCard *card, nsIAbCard **_retval NS_OUTPARAM) { return !_to ? NS_ERROR_NULL_POINTER : _to->AddCard(card, _retval); } \
  NS_SCRIPTABLE NS_IMETHOD ModifyCard(nsIAbCard *modifiedCard) { return !_to ? NS_ERROR_NULL_POINTER : _to->ModifyCard(modifiedCard); } \
  NS_SCRIPTABLE NS_IMETHOD DeleteCards(nsIArray *aCards) { return !_to ? NS_ERROR_NULL_POINTER : _to->DeleteCards(aCards); } \
  NS_SCRIPTABLE NS_IMETHOD DropCard(nsIAbCard *card, PRBool needToCopyCard) { return !_to ? NS_ERROR_NULL_POINTER : _to->DropCard(card, needToCopyCard); } \
  NS_SCRIPTABLE NS_IMETHOD UseForAutocomplete(const nsACString & aIdentityKey, PRBool *_retval NS_OUTPARAM) { return !_to ? NS_ERROR_NULL_POINTER : _to->UseForAutocomplete(aIdentityKey, _retval); } \
  NS_SCRIPTABLE NS_IMETHOD GetSupportsMailingLists(PRBool *aSupportsMailingLists) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetSupportsMailingLists(aSupportsMailingLists); } \
  NS_SCRIPTABLE NS_IMETHOD GetAddressLists(nsIMutableArray **aAddressLists) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetAddressLists(aAddressLists); } \
  NS_SCRIPTABLE NS_IMETHOD SetAddressLists(nsIMutableArray *aAddressLists) { return !_to ? NS_ERROR_NULL_POINTER : _to->SetAddressLists(aAddressLists); } \
  NS_SCRIPTABLE NS_IMETHOD AddMailList(nsIAbDirectory *list) { return !_to ? NS_ERROR_NULL_POINTER : _to->AddMailList(list); } \
  NS_SCRIPTABLE NS_IMETHOD GetListNickName(nsAString & aListNickName) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetListNickName(aListNickName); } \
  NS_SCRIPTABLE NS_IMETHOD SetListNickName(const nsAString & aListNickName) { return !_to ? NS_ERROR_NULL_POINTER : _to->SetListNickName(aListNickName); } \
  NS_SCRIPTABLE NS_IMETHOD GetDescription(nsAString & aDescription) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetDescription(aDescription); } \
  NS_SCRIPTABLE NS_IMETHOD SetDescription(const nsAString & aDescription) { return !_to ? NS_ERROR_NULL_POINTER : _to->SetDescription(aDescription); } \
  NS_SCRIPTABLE NS_IMETHOD EditMailListToDatabase(nsIAbCard *listCard) { return !_to ? NS_ERROR_NULL_POINTER : _to->EditMailListToDatabase(listCard); } \
  NS_SCRIPTABLE NS_IMETHOD CopyMailList(nsIAbDirectory *srcList) { return !_to ? NS_ERROR_NULL_POINTER : _to->CopyMailList(srcList); } \
  NS_SCRIPTABLE NS_IMETHOD CreateNewDirectory(const nsAString & aDirName, const nsACString & aURI, PRUint32 aType, const nsACString & aPrefName, nsACString & _retval NS_OUTPARAM) { return !_to ? NS_ERROR_NULL_POINTER : _to->CreateNewDirectory(aDirName, aURI, aType, aPrefName, _retval); } \
  NS_SCRIPTABLE NS_IMETHOD CreateDirectoryByURI(const nsAString & displayName, const nsACString & aURI) { return !_to ? NS_ERROR_NULL_POINTER : _to->CreateDirectoryByURI(displayName, aURI); } \
  NS_SCRIPTABLE NS_IMETHOD GetDirPrefId(nsACString & aDirPrefId) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetDirPrefId(aDirPrefId); } \
  NS_SCRIPTABLE NS_IMETHOD SetDirPrefId(const nsACString & aDirPrefId) { return !_to ? NS_ERROR_NULL_POINTER : _to->SetDirPrefId(aDirPrefId); } \
  NS_SCRIPTABLE NS_IMETHOD GetIntValue(const char *aName, PRInt32 aDefaultValue, PRInt32 *_retval NS_OUTPARAM) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetIntValue(aName, aDefaultValue, _retval); } \
  NS_SCRIPTABLE NS_IMETHOD GetBoolValue(const char *aName, PRBool aDefaultValue, PRBool *_retval NS_OUTPARAM) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetBoolValue(aName, aDefaultValue, _retval); } \
  NS_SCRIPTABLE NS_IMETHOD GetStringValue(const char *aName, const nsACString & aDefaultValue, nsACString & _retval NS_OUTPARAM) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetStringValue(aName, aDefaultValue, _retval); } \
  NS_SCRIPTABLE NS_IMETHOD GetLocalizedStringValue(const char *aName, const nsACString & aDefaultValue, nsACString & _retval NS_OUTPARAM) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetLocalizedStringValue(aName, aDefaultValue, _retval); } \
  NS_SCRIPTABLE NS_IMETHOD SetIntValue(const char *aName, PRInt32 aValue) { return !_to ? NS_ERROR_NULL_POINTER : _to->SetIntValue(aName, aValue); } \
  NS_SCRIPTABLE NS_IMETHOD SetBoolValue(const char *aName, PRBool aValue) { return !_to ? NS_ERROR_NULL_POINTER : _to->SetBoolValue(aName, aValue); } \
  NS_SCRIPTABLE NS_IMETHOD SetStringValue(const char *aName, const nsACString & aValue) { return !_to ? NS_ERROR_NULL_POINTER : _to->SetStringValue(aName, aValue); } \
  NS_SCRIPTABLE NS_IMETHOD SetLocalizedStringValue(const char *aName, const nsACString & aValue) { return !_to ? NS_ERROR_NULL_POINTER : _to->SetLocalizedStringValue(aName, aValue); } 

#if 0
/* Use the code below as a template for the implementation class for this interface. */

/* Header file */
class nsAbDirectory : public nsIAbDirectory
{
public:
  NS_DECL_ISUPPORTS
  NS_DECL_NSIABDIRECTORY

  nsAbDirectory();

private:
  ~nsAbDirectory();

protected:
  /* additional members */
};

/* Implementation file */
NS_IMPL_ISUPPORTS1(nsAbDirectory, nsIAbDirectory)

nsAbDirectory::nsAbDirectory()
{
  /* member initializers and constructor code */
}

nsAbDirectory::~nsAbDirectory()
{
  /* destructor code */
}

/* readonly attribute ACString propertiesChromeURI; */
NS_IMETHODIMP nsAbDirectory::GetPropertiesChromeURI(nsACString & aPropertiesChromeURI)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* attribute AString dirName; */
NS_IMETHODIMP nsAbDirectory::GetDirName(nsAString & aDirName)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}
NS_IMETHODIMP nsAbDirectory::SetDirName(const nsAString & aDirName)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* readonly attribute long dirType; */
NS_IMETHODIMP nsAbDirectory::GetDirType(PRInt32 *aDirType)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* readonly attribute ACString fileName; */
NS_IMETHODIMP nsAbDirectory::GetFileName(nsACString & aFileName)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* readonly attribute ACString URI; */
NS_IMETHODIMP nsAbDirectory::GetURI(nsACString & aURI)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* readonly attribute long position; */
NS_IMETHODIMP nsAbDirectory::GetPosition(PRInt32 *aPosition)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* attribute unsigned long lastModifiedDate; */
NS_IMETHODIMP nsAbDirectory::GetLastModifiedDate(PRUint32 *aLastModifiedDate)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}
NS_IMETHODIMP nsAbDirectory::SetLastModifiedDate(PRUint32 aLastModifiedDate)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* attribute PRBool isMailList; */
NS_IMETHODIMP nsAbDirectory::GetIsMailList(PRBool *aIsMailList)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}
NS_IMETHODIMP nsAbDirectory::SetIsMailList(PRBool aIsMailList)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* readonly attribute nsISimpleEnumerator childNodes; */
NS_IMETHODIMP nsAbDirectory::GetChildNodes(nsISimpleEnumerator **aChildNodes)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* readonly attribute nsISimpleEnumerator childCards; */
NS_IMETHODIMP nsAbDirectory::GetChildCards(nsISimpleEnumerator **aChildCards)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* readonly attribute boolean isQuery; */
NS_IMETHODIMP nsAbDirectory::GetIsQuery(PRBool *aIsQuery)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void deleteDirectory (in nsIAbDirectory directory); */
NS_IMETHODIMP nsAbDirectory::DeleteDirectory(nsIAbDirectory *directory)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* boolean hasCard (in nsIAbCard cards); */
NS_IMETHODIMP nsAbDirectory::HasCard(nsIAbCard *cards, PRBool *_retval NS_OUTPARAM)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* boolean hasDirectory (in nsIAbDirectory dir); */
NS_IMETHODIMP nsAbDirectory::HasDirectory(nsIAbDirectory *dir, PRBool *_retval NS_OUTPARAM)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* nsIAbCard addCard (in nsIAbCard card); */
NS_IMETHODIMP nsAbDirectory::AddCard(nsIAbCard *card, nsIAbCard **_retval NS_OUTPARAM)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void modifyCard (in nsIAbCard modifiedCard); */
NS_IMETHODIMP nsAbDirectory::ModifyCard(nsIAbCard *modifiedCard)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void deleteCards (in nsIArray aCards); */
NS_IMETHODIMP nsAbDirectory::DeleteCards(nsIArray *aCards)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void dropCard (in nsIAbCard card, in boolean needToCopyCard); */
NS_IMETHODIMP nsAbDirectory::DropCard(nsIAbCard *card, PRBool needToCopyCard)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* boolean useForAutocomplete (in ACString aIdentityKey); */
NS_IMETHODIMP nsAbDirectory::UseForAutocomplete(const nsACString & aIdentityKey, PRBool *_retval NS_OUTPARAM)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* readonly attribute boolean supportsMailingLists; */
NS_IMETHODIMP nsAbDirectory::GetSupportsMailingLists(PRBool *aSupportsMailingLists)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* attribute nsIMutableArray addressLists; */
NS_IMETHODIMP nsAbDirectory::GetAddressLists(nsIMutableArray **aAddressLists)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}
NS_IMETHODIMP nsAbDirectory::SetAddressLists(nsIMutableArray *aAddressLists)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void addMailList (in nsIAbDirectory list); */
NS_IMETHODIMP nsAbDirectory::AddMailList(nsIAbDirectory *list)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* attribute AString listNickName; */
NS_IMETHODIMP nsAbDirectory::GetListNickName(nsAString & aListNickName)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}
NS_IMETHODIMP nsAbDirectory::SetListNickName(const nsAString & aListNickName)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* attribute AString description; */
NS_IMETHODIMP nsAbDirectory::GetDescription(nsAString & aDescription)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}
NS_IMETHODIMP nsAbDirectory::SetDescription(const nsAString & aDescription)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void editMailListToDatabase (in nsIAbCard listCard); */
NS_IMETHODIMP nsAbDirectory::EditMailListToDatabase(nsIAbCard *listCard)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void copyMailList (in nsIAbDirectory srcList); */
NS_IMETHODIMP nsAbDirectory::CopyMailList(nsIAbDirectory *srcList)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* ACString createNewDirectory (in AString aDirName, in ACString aURI, in unsigned long aType, in ACString aPrefName); */
NS_IMETHODIMP nsAbDirectory::CreateNewDirectory(const nsAString & aDirName, const nsACString & aURI, PRUint32 aType, const nsACString & aPrefName, nsACString & _retval NS_OUTPARAM)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void createDirectoryByURI (in AString displayName, in ACString aURI); */
NS_IMETHODIMP nsAbDirectory::CreateDirectoryByURI(const nsAString & displayName, const nsACString & aURI)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* attribute ACString dirPrefId; */
NS_IMETHODIMP nsAbDirectory::GetDirPrefId(nsACString & aDirPrefId)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}
NS_IMETHODIMP nsAbDirectory::SetDirPrefId(const nsACString & aDirPrefId)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* long getIntValue (in string aName, in long aDefaultValue); */
NS_IMETHODIMP nsAbDirectory::GetIntValue(const char *aName, PRInt32 aDefaultValue, PRInt32 *_retval NS_OUTPARAM)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* boolean getBoolValue (in string aName, in boolean aDefaultValue); */
NS_IMETHODIMP nsAbDirectory::GetBoolValue(const char *aName, PRBool aDefaultValue, PRBool *_retval NS_OUTPARAM)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* ACString getStringValue (in string aName, in ACString aDefaultValue); */
NS_IMETHODIMP nsAbDirectory::GetStringValue(const char *aName, const nsACString & aDefaultValue, nsACString & _retval NS_OUTPARAM)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* AUTF8String getLocalizedStringValue (in string aName, in AUTF8String aDefaultValue); */
NS_IMETHODIMP nsAbDirectory::GetLocalizedStringValue(const char *aName, const nsACString & aDefaultValue, nsACString & _retval NS_OUTPARAM)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void setIntValue (in string aName, in long aValue); */
NS_IMETHODIMP nsAbDirectory::SetIntValue(const char *aName, PRInt32 aValue)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void setBoolValue (in string aName, in boolean aValue); */
NS_IMETHODIMP nsAbDirectory::SetBoolValue(const char *aName, PRBool aValue)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void setStringValue (in string aName, in ACString aValue); */
NS_IMETHODIMP nsAbDirectory::SetStringValue(const char *aName, const nsACString & aValue)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void setLocalizedStringValue (in string aName, in AUTF8String aValue); */
NS_IMETHODIMP nsAbDirectory::SetLocalizedStringValue(const char *aName, const nsACString & aValue)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* End of implementation class template. */
#endif


#endif /* __gen_nsIAbDirectory_h__ */
