/*
 * DO NOT EDIT.  THIS FILE IS GENERATED FROM nsIAbCard.idl
 */

#ifndef __gen_nsIAbCard_h__
#define __gen_nsIAbCard_h__


#ifndef __gen_nsISupports_h__
#include "nsISupports.h"
#endif

#ifndef __gen_nsIAbItem_h__
#include "nsIAbItem.h"
#endif

/* For IDL files that don't want to include root IDL files. */
#ifndef NS_NO_VTABLE
#define NS_NO_VTABLE
#endif
class nsISimpleEnumerator; /* forward declaration */

class nsIVariant; /* forward declaration */


/* starting interface:    nsIAbPreferMailFormat */
#define NS_IABPREFERMAILFORMAT_IID_STR "97448252-f189-11d4-a422-001083003d0c"

#define NS_IABPREFERMAILFORMAT_IID \
  {0x97448252, 0xf189, 0x11d4, \
    { 0xa4, 0x22, 0x00, 0x10, 0x83, 0x00, 0x3d, 0x0c }}

class NS_NO_VTABLE NS_SCRIPTABLE nsIAbPreferMailFormat {
 public: 

  NS_DECLARE_STATIC_IID_ACCESSOR(NS_IABPREFERMAILFORMAT_IID)

  enum { unknown = 0U };

  enum { plaintext = 1U };

  enum { html = 2U };

};

  NS_DEFINE_STATIC_IID_ACCESSOR(nsIAbPreferMailFormat, NS_IABPREFERMAILFORMAT_IID)

/* Use this macro when declaring classes that implement this interface. */
#define NS_DECL_NSIABPREFERMAILFORMAT \

/* Use this macro to declare functions that forward the behavior of this interface to another object. */
#define NS_FORWARD_NSIABPREFERMAILFORMAT(_to) \

/* Use this macro to declare functions that forward the behavior of this interface to another object in a safe way. */
#define NS_FORWARD_SAFE_NSIABPREFERMAILFORMAT(_to) \

#if 0
/* Use the code below as a template for the implementation class for this interface. */

/* Header file */
class nsAbPreferMailFormat : public nsIAbPreferMailFormat
{
public:
  NS_DECL_ISUPPORTS
  NS_DECL_NSIABPREFERMAILFORMAT

  nsAbPreferMailFormat();

private:
  ~nsAbPreferMailFormat();

protected:
  /* additional members */
};

/* Implementation file */
NS_IMPL_ISUPPORTS1(nsAbPreferMailFormat, nsIAbPreferMailFormat)

nsAbPreferMailFormat::nsAbPreferMailFormat()
{
  /* member initializers and constructor code */
}

nsAbPreferMailFormat::~nsAbPreferMailFormat()
{
  /* destructor code */
}

/* End of implementation class template. */
#endif


/* starting interface:    nsIAbCard */
#define NS_IABCARD_IID_STR "21c4308b-e1e2-4ab2-abdc-e1f4431c7055"

#define NS_IABCARD_IID \
  {0x21c4308b, 0xe1e2, 0x4ab2, \
    { 0xab, 0xdc, 0xe1, 0xf4, 0x43, 0x1c, 0x70, 0x55 }}

/**
 * An interface representing an address book card.
 *
 * The UUID of a card is a composition of a directory ID and a per-directory ID.
 * The per-directory ID is reflected in the localId property. If either of these
 * properties change, the UUID will change correspondingly.
 *
 * None of these IDs will be reflected in the property collection. Neither
 * nsIAbCard::properties, nsIAbCard::deleteProperty, nor any of the property
 * getters and setters are able to interact with these properties.
 *
 * Fundamentally, a card is a collection of properties. Modifying a property in
 * some way on a card does not change the backend used to store the card; the
 * directory is required to do make the changes here.
 *
 * The following are the core properties that are used:
 * - Names:
 *   - FirstName, LastName
 *   - PhoneticFirstName, PhoneticLastName
 *   - DisplayName, NickName
 *   - SpouseName, FamilyName
 * - PrimaryEmail, SecondEmail
 * - Home Contact:
 *   - HomeAddress, HomeAddress2, HomeCity, HomeState, HomeZipCode, HomeCountry
 *   - HomePhone, HomePhoneType
 * - Work contact. Same as home, but with `Work' instead of `Home'
 * - Other Contact:
 *   - FaxNumber, FaxNumberType
 *   - PagerNumber, PagerNumberType
 *   - CellularNumber, CellularNumberType
 * - JobTitle, Department, Company
 * - _AimScreenName
 * - Dates:
 *   - AnniversaryYear, AnniversaryMonth, AnniversaryDay
 *   - BirthYear, BirthMonth, BirthDay
 * - WebPage1 (work), WebPage2 (home)
 * - Custom1, Custom2, Custom3, Custom4
 * - Notes
 * - Integral properties:
 *   - LastModifiedDate
 *   - PopularityIndex
 *   - PreferMailFormat (see nsIAbPreferMailFormat)
 * - Boolean properties:
 *   - AllowRemoteContent
 * - Photo properties:
 *   - PhotoName
 *   - PhotoType
 *   - PhotoURI
 *
 * The contract id for the standard implementation is
 * <tt>\@mozilla.org/addressbook/cardproperty;1</tt>.
 */
class NS_NO_VTABLE NS_SCRIPTABLE nsIAbCard : public nsIAbItem {
 public: 

  NS_DECLARE_STATIC_IID_ACCESSOR(NS_IABCARD_IID)

  /**
   * The UUID for the nsIAbDirectory containing this card.
   *
   * The directory considered to contain this card is the directory which
   * produced this card (e.g., through nsIAbDirectory::getCardForProperty) or
   * the last directory to modify this card, if another directory did so. If the
   * last directory to modify this card deleted it, then this card is considered
   * unassociated.
   *
   * If this card is not associated with a directory, this string will be empty.
   *
   * There is no standardized way to associate a card with multiple directories.
   *
   * Consumers of this interface outside of directory implementations SHOULD
   * NOT, in general, modify this property.
   */
  /* attribute AUTF8String directoryId; */
  NS_SCRIPTABLE NS_IMETHOD GetDirectoryId(nsACString & aDirectoryId) = 0;
  NS_SCRIPTABLE NS_IMETHOD SetDirectoryId(const nsACString & aDirectoryId) = 0;

  /**
   * The per-directory ID of this card.
   *
   * This property is the second part of the tuple logically representing a card
   * UUID. It shares many requirements with that of nsIAbItem::uuid. In
   * particular:
   * - It MUST be unique (within the scope of its directory).
   * - The empty string MUST only be used to indicate that it has not yet been
   *   assigned a localId.
   * - It is STRONGLY RECOMMENDED that this id is consistent across sessions and
   *   that, should the card be deleted, its ids will not be reused.
   * - The format of localId is left undefined.
   *
   * As long as directoryId is not changed, this property SHOULD NOT be changed.
   * If directoryId is changed, the new directory MAY choose to reuse the same
   * localId if reasonable. However, consumers MUST NOT assume that two cards
   * with different directoryIds but the same localId are logically the same
   * card.
   *
   * Similar to directoryId, consumers of cards outside of directory
   * implementations SHOULD NOT, in general, modify this property.
   */
  /* attribute AUTF8String localId; */
  NS_SCRIPTABLE NS_IMETHOD GetLocalId(nsACString & aLocalId) = 0;
  NS_SCRIPTABLE NS_IMETHOD SetLocalId(const nsACString & aLocalId) = 0;

  /**
   * A list of all the properties that this card has as an enumerator, whose
   * members are all nsIProperty objects.
   */
  /* readonly attribute nsISimpleEnumerator properties; */
  NS_SCRIPTABLE NS_IMETHOD GetProperties(nsISimpleEnumerator **aProperties) = 0;

  /**
   * Returns a property for the given name.
   *
   * @param name             The case-sensitive name of the property to get.
   * @param defaultValue     The value to return if the property does not exist.
   * @exception NS_ERROR_NOT_AVAILABLE if the named property does not exist.
   * @exception NS_ERROR_CANNOT_CONVERT_DATA if the property cannot be converted
   *                                         to the desired type.
   */
  /* nsIVariant getProperty (in AUTF8String name, in nsIVariant defaultValue); */
  NS_SCRIPTABLE NS_IMETHOD GetProperty(const nsACString & name, nsIVariant *defaultValue, nsIVariant **_retval NS_OUTPARAM) = 0;

  /**
   * @{
   * Returns a property for the given name.
   *
   * These functions convert values in the same manner as the default
   * implementation of nsIVariant. Of particular note is that boolean variables
   * are converted to integers as in C/C++ (true is a non-zero value), so that
   * false will be converted to a string of "0" and not "false."
   *
   * These functions are marked [noscript] since xpconnect performs automatic
   * type conversion on nsIVariants such that they are not needed for scripts,
   * only for C++ callers.
   *
   * @param name             The case-sensitive name of the property to get.
   * @exception NS_ERROR_NOT_AVAILABLE if the named property does not exist.
   * @exception NS_ERROR_CANNOT_CONVERT_DATA if the property cannot be converted
   *                                         to the desired type.
   */
  /* [noscript] AString getPropertyAsAString (in string name); */
  NS_IMETHOD GetPropertyAsAString(const char *name, nsAString & _retval NS_OUTPARAM) = 0;

  /* [noscript] AUTF8String getPropertyAsAUTF8String (in string name); */
  NS_IMETHOD GetPropertyAsAUTF8String(const char *name, nsACString & _retval NS_OUTPARAM) = 0;

  /* [noscript] PRUint32 getPropertyAsUint32 (in string name); */
  NS_IMETHOD GetPropertyAsUint32(const char *name, PRUint32 *_retval NS_OUTPARAM) = 0;

  /* [noscript] boolean getPropertyAsBool (in string name); */
  NS_IMETHOD GetPropertyAsBool(const char *name, PRBool *_retval NS_OUTPARAM) = 0;

  /** @} */
/**
   * @{
   * Assigns the given to value to the property of the given name.
   *
   * Should the property exist, its value will be overwritten. An
   * implementation may impose additional semantic constraints for certain
   * properties. However, such constraints might not be checked by this method.
   *
   * These functions convert values in the same manner as the default
   * implementation of nsIVariant.
   * 
   * @warning A value MUST be convertible to a string; if this convention is not
   * followed, consumers of cards may fail unpredictably or return incorrect
   * results.
   *
   * The non-variant functions are marked [noscript] since xpconnect uses
   * magic with nsIVariant such that the other functions are not needed,
   * although C++ does need them.
   *
   * @param name             The case-sensitive name of the property to set.
   * @param value            The new value of the property.
   */
  /* void setProperty (in AUTF8String name, in nsIVariant value); */
  NS_SCRIPTABLE NS_IMETHOD SetProperty(const nsACString & name, nsIVariant *value) = 0;

  /* [noscript] void setPropertyAsAString (in string name, in AString value); */
  NS_IMETHOD SetPropertyAsAString(const char *name, const nsAString & value) = 0;

  /* [noscript] void setPropertyAsAUTF8String (in string name, in AUTF8String value); */
  NS_IMETHOD SetPropertyAsAUTF8String(const char *name, const nsACString & value) = 0;

  /* [noscript] void setPropertyAsUint32 (in string name, in PRUint32 value); */
  NS_IMETHOD SetPropertyAsUint32(const char *name, PRUint32 value) = 0;

  /* [noscript] void setPropertyAsBool (in string name, in boolean value); */
  NS_IMETHOD SetPropertyAsBool(const char *name, PRBool value) = 0;

  /** @} */
/**
   * Deletes the property with the given name.
   *
   * Some properties may not be deleted. However, the implementation will not
   * check this constraint at this method. If such a property is deleted, an
   * error may be thrown when the card is modified at the database level.
   *
   * @param name             The case-sensitive name of the property to set.
   */
  /* void deleteProperty (in AUTF8String name); */
  NS_SCRIPTABLE NS_IMETHOD DeleteProperty(const nsACString & name) = 0;

  /**
   * @{
   * These properties are shorthand for getProperty and setProperty.
   */
  /* attribute AString firstName; */
  NS_SCRIPTABLE NS_IMETHOD GetFirstName(nsAString & aFirstName) = 0;
  NS_SCRIPTABLE NS_IMETHOD SetFirstName(const nsAString & aFirstName) = 0;

  /* attribute AString lastName; */
  NS_SCRIPTABLE NS_IMETHOD GetLastName(nsAString & aLastName) = 0;
  NS_SCRIPTABLE NS_IMETHOD SetLastName(const nsAString & aLastName) = 0;

  /* attribute AString displayName; */
  NS_SCRIPTABLE NS_IMETHOD GetDisplayName(nsAString & aDisplayName) = 0;
  NS_SCRIPTABLE NS_IMETHOD SetDisplayName(const nsAString & aDisplayName) = 0;

  /* attribute AString primaryEmail; */
  NS_SCRIPTABLE NS_IMETHOD GetPrimaryEmail(nsAString & aPrimaryEmail) = 0;
  NS_SCRIPTABLE NS_IMETHOD SetPrimaryEmail(const nsAString & aPrimaryEmail) = 0;

  /** @} */
/**
   * Determines whether or not a card has the supplied email address in either
   * of its PrimaryEmail or SecondEmail attributes.
   *
   * Note: This function is likely to be temporary whilst we work out proper
   * APIs for multi-valued attributes in bug 118665.
   *
   * @param  aEmailAddress The email address to attempt to match against.
   * @return               True if aEmailAddress matches any of the email
   *                       addresses stored in the card.
   */
  /* boolean hasEmailAddress (in AUTF8String aEmailAddress); */
  NS_SCRIPTABLE NS_IMETHOD HasEmailAddress(const nsACString & aEmailAddress, PRBool *_retval NS_OUTPARAM) = 0;

  /**
   * Translates a card into a specific format.
   * The following types are supported:
   * - base64xml
   * - xml
   * - vcard
   *
   * @param  aType          The type of item to translate the card into.
   * @return                A string containing the translated card.
   * @exception NS_ERROR_ILLEGAL_VALUE if we do not recognize the type.
   */
  /* AUTF8String translateTo (in AUTF8String aType); */
  NS_SCRIPTABLE NS_IMETHOD TranslateTo(const nsACString & aType, nsACString & _retval NS_OUTPARAM) = 0;

  /**
   * Translates a card from the specified format
   */
/** 
   * Generate a phonetic name from the card, using the firstName and lastName
   * values.
   *
   * @param  aLastNameFirst  Set to True to put the last name before the first.
   * @return                 A string containing the generated phonetic name.
   */
  /* AString generatePhoneticName (in boolean aLastNameFirst); */
  NS_SCRIPTABLE NS_IMETHOD GeneratePhoneticName(PRBool aLastNameFirst, nsAString & _retval NS_OUTPARAM) = 0;

  /**
   * This function will copy all values from one card to another.
   *
   * @param  srcCard         The source card to copy values from.
   */
  /* void copy (in nsIAbCard aSrcCard); */
  NS_SCRIPTABLE NS_IMETHOD Copy(nsIAbCard *aSrcCard) = 0;

  /**
   * Returns true if this card is equal to the other card.
   *
   * The default implementation defines equal as this card pointing to the
   * same object as @arg aCard; another implementation defines it as equality of
   * properties and values.
   *
   * @warning The exact nature of equality is still undefined, and actual
   *          results may not match theoretical results. Most notably, the code
   *          <tt>a.equals(b) == b.equals(a)</tt> might not return true. In
   *          particular, calling equals on cards from different address books
   *          may return inaccurate results.
   *          
   *
   * @return                 Equality, as defined above.
   * @param  aCard           The card to compare against.
   */
  /* boolean equals (in nsIAbCard aCard); */
  NS_SCRIPTABLE NS_IMETHOD Equals(nsIAbCard *aCard, PRBool *_retval NS_OUTPARAM) = 0;

  /* attribute boolean isMailList; */
  NS_SCRIPTABLE NS_IMETHOD GetIsMailList(PRBool *aIsMailList) = 0;
  NS_SCRIPTABLE NS_IMETHOD SetIsMailList(PRBool aIsMailList) = 0;

  /**
   * If isMailList is true then mailListURI
   * will contain the URI of the associated
   * mail list
   */
  /* attribute string mailListURI; */
  NS_SCRIPTABLE NS_IMETHOD GetMailListURI(char **aMailListURI) = 0;
  NS_SCRIPTABLE NS_IMETHOD SetMailListURI(const char *aMailListURI) = 0;

};

  NS_DEFINE_STATIC_IID_ACCESSOR(nsIAbCard, NS_IABCARD_IID)

/* Use this macro when declaring classes that implement this interface. */
#define NS_DECL_NSIABCARD \
  NS_SCRIPTABLE NS_IMETHOD GetDirectoryId(nsACString & aDirectoryId); \
  NS_SCRIPTABLE NS_IMETHOD SetDirectoryId(const nsACString & aDirectoryId); \
  NS_SCRIPTABLE NS_IMETHOD GetLocalId(nsACString & aLocalId); \
  NS_SCRIPTABLE NS_IMETHOD SetLocalId(const nsACString & aLocalId); \
  NS_SCRIPTABLE NS_IMETHOD GetProperties(nsISimpleEnumerator **aProperties); \
  NS_SCRIPTABLE NS_IMETHOD GetProperty(const nsACString & name, nsIVariant *defaultValue, nsIVariant **_retval NS_OUTPARAM); \
  NS_IMETHOD GetPropertyAsAString(const char *name, nsAString & _retval NS_OUTPARAM); \
  NS_IMETHOD GetPropertyAsAUTF8String(const char *name, nsACString & _retval NS_OUTPARAM); \
  NS_IMETHOD GetPropertyAsUint32(const char *name, PRUint32 *_retval NS_OUTPARAM); \
  NS_IMETHOD GetPropertyAsBool(const char *name, PRBool *_retval NS_OUTPARAM); \
  NS_SCRIPTABLE NS_IMETHOD SetProperty(const nsACString & name, nsIVariant *value); \
  NS_IMETHOD SetPropertyAsAString(const char *name, const nsAString & value); \
  NS_IMETHOD SetPropertyAsAUTF8String(const char *name, const nsACString & value); \
  NS_IMETHOD SetPropertyAsUint32(const char *name, PRUint32 value); \
  NS_IMETHOD SetPropertyAsBool(const char *name, PRBool value); \
  NS_SCRIPTABLE NS_IMETHOD DeleteProperty(const nsACString & name); \
  NS_SCRIPTABLE NS_IMETHOD GetFirstName(nsAString & aFirstName); \
  NS_SCRIPTABLE NS_IMETHOD SetFirstName(const nsAString & aFirstName); \
  NS_SCRIPTABLE NS_IMETHOD GetLastName(nsAString & aLastName); \
  NS_SCRIPTABLE NS_IMETHOD SetLastName(const nsAString & aLastName); \
  NS_SCRIPTABLE NS_IMETHOD GetDisplayName(nsAString & aDisplayName); \
  NS_SCRIPTABLE NS_IMETHOD SetDisplayName(const nsAString & aDisplayName); \
  NS_SCRIPTABLE NS_IMETHOD GetPrimaryEmail(nsAString & aPrimaryEmail); \
  NS_SCRIPTABLE NS_IMETHOD SetPrimaryEmail(const nsAString & aPrimaryEmail); \
  NS_SCRIPTABLE NS_IMETHOD HasEmailAddress(const nsACString & aEmailAddress, PRBool *_retval NS_OUTPARAM); \
  NS_SCRIPTABLE NS_IMETHOD TranslateTo(const nsACString & aType, nsACString & _retval NS_OUTPARAM); \
  NS_SCRIPTABLE NS_IMETHOD GeneratePhoneticName(PRBool aLastNameFirst, nsAString & _retval NS_OUTPARAM); \
  NS_SCRIPTABLE NS_IMETHOD Copy(nsIAbCard *aSrcCard); \
  NS_SCRIPTABLE NS_IMETHOD Equals(nsIAbCard *aCard, PRBool *_retval NS_OUTPARAM); \
  NS_SCRIPTABLE NS_IMETHOD GetIsMailList(PRBool *aIsMailList); \
  NS_SCRIPTABLE NS_IMETHOD SetIsMailList(PRBool aIsMailList); \
  NS_SCRIPTABLE NS_IMETHOD GetMailListURI(char **aMailListURI); \
  NS_SCRIPTABLE NS_IMETHOD SetMailListURI(const char *aMailListURI); 

/* Use this macro to declare functions that forward the behavior of this interface to another object. */
#define NS_FORWARD_NSIABCARD(_to) \
  NS_SCRIPTABLE NS_IMETHOD GetDirectoryId(nsACString & aDirectoryId) { return _to GetDirectoryId(aDirectoryId); } \
  NS_SCRIPTABLE NS_IMETHOD SetDirectoryId(const nsACString & aDirectoryId) { return _to SetDirectoryId(aDirectoryId); } \
  NS_SCRIPTABLE NS_IMETHOD GetLocalId(nsACString & aLocalId) { return _to GetLocalId(aLocalId); } \
  NS_SCRIPTABLE NS_IMETHOD SetLocalId(const nsACString & aLocalId) { return _to SetLocalId(aLocalId); } \
  NS_SCRIPTABLE NS_IMETHOD GetProperties(nsISimpleEnumerator **aProperties) { return _to GetProperties(aProperties); } \
  NS_SCRIPTABLE NS_IMETHOD GetProperty(const nsACString & name, nsIVariant *defaultValue, nsIVariant **_retval NS_OUTPARAM) { return _to GetProperty(name, defaultValue, _retval); } \
  NS_IMETHOD GetPropertyAsAString(const char *name, nsAString & _retval NS_OUTPARAM) { return _to GetPropertyAsAString(name, _retval); } \
  NS_IMETHOD GetPropertyAsAUTF8String(const char *name, nsACString & _retval NS_OUTPARAM) { return _to GetPropertyAsAUTF8String(name, _retval); } \
  NS_IMETHOD GetPropertyAsUint32(const char *name, PRUint32 *_retval NS_OUTPARAM) { return _to GetPropertyAsUint32(name, _retval); } \
  NS_IMETHOD GetPropertyAsBool(const char *name, PRBool *_retval NS_OUTPARAM) { return _to GetPropertyAsBool(name, _retval); } \
  NS_SCRIPTABLE NS_IMETHOD SetProperty(const nsACString & name, nsIVariant *value) { return _to SetProperty(name, value); } \
  NS_IMETHOD SetPropertyAsAString(const char *name, const nsAString & value) { return _to SetPropertyAsAString(name, value); } \
  NS_IMETHOD SetPropertyAsAUTF8String(const char *name, const nsACString & value) { return _to SetPropertyAsAUTF8String(name, value); } \
  NS_IMETHOD SetPropertyAsUint32(const char *name, PRUint32 value) { return _to SetPropertyAsUint32(name, value); } \
  NS_IMETHOD SetPropertyAsBool(const char *name, PRBool value) { return _to SetPropertyAsBool(name, value); } \
  NS_SCRIPTABLE NS_IMETHOD DeleteProperty(const nsACString & name) { return _to DeleteProperty(name); } \
  NS_SCRIPTABLE NS_IMETHOD GetFirstName(nsAString & aFirstName) { return _to GetFirstName(aFirstName); } \
  NS_SCRIPTABLE NS_IMETHOD SetFirstName(const nsAString & aFirstName) { return _to SetFirstName(aFirstName); } \
  NS_SCRIPTABLE NS_IMETHOD GetLastName(nsAString & aLastName) { return _to GetLastName(aLastName); } \
  NS_SCRIPTABLE NS_IMETHOD SetLastName(const nsAString & aLastName) { return _to SetLastName(aLastName); } \
  NS_SCRIPTABLE NS_IMETHOD GetDisplayName(nsAString & aDisplayName) { return _to GetDisplayName(aDisplayName); } \
  NS_SCRIPTABLE NS_IMETHOD SetDisplayName(const nsAString & aDisplayName) { return _to SetDisplayName(aDisplayName); } \
  NS_SCRIPTABLE NS_IMETHOD GetPrimaryEmail(nsAString & aPrimaryEmail) { return _to GetPrimaryEmail(aPrimaryEmail); } \
  NS_SCRIPTABLE NS_IMETHOD SetPrimaryEmail(const nsAString & aPrimaryEmail) { return _to SetPrimaryEmail(aPrimaryEmail); } \
  NS_SCRIPTABLE NS_IMETHOD HasEmailAddress(const nsACString & aEmailAddress, PRBool *_retval NS_OUTPARAM) { return _to HasEmailAddress(aEmailAddress, _retval); } \
  NS_SCRIPTABLE NS_IMETHOD TranslateTo(const nsACString & aType, nsACString & _retval NS_OUTPARAM) { return _to TranslateTo(aType, _retval); } \
  NS_SCRIPTABLE NS_IMETHOD GeneratePhoneticName(PRBool aLastNameFirst, nsAString & _retval NS_OUTPARAM) { return _to GeneratePhoneticName(aLastNameFirst, _retval); } \
  NS_SCRIPTABLE NS_IMETHOD Copy(nsIAbCard *aSrcCard) { return _to Copy(aSrcCard); } \
  NS_SCRIPTABLE NS_IMETHOD Equals(nsIAbCard *aCard, PRBool *_retval NS_OUTPARAM) { return _to Equals(aCard, _retval); } \
  NS_SCRIPTABLE NS_IMETHOD GetIsMailList(PRBool *aIsMailList) { return _to GetIsMailList(aIsMailList); } \
  NS_SCRIPTABLE NS_IMETHOD SetIsMailList(PRBool aIsMailList) { return _to SetIsMailList(aIsMailList); } \
  NS_SCRIPTABLE NS_IMETHOD GetMailListURI(char **aMailListURI) { return _to GetMailListURI(aMailListURI); } \
  NS_SCRIPTABLE NS_IMETHOD SetMailListURI(const char *aMailListURI) { return _to SetMailListURI(aMailListURI); } 

/* Use this macro to declare functions that forward the behavior of this interface to another object in a safe way. */
#define NS_FORWARD_SAFE_NSIABCARD(_to) \
  NS_SCRIPTABLE NS_IMETHOD GetDirectoryId(nsACString & aDirectoryId) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetDirectoryId(aDirectoryId); } \
  NS_SCRIPTABLE NS_IMETHOD SetDirectoryId(const nsACString & aDirectoryId) { return !_to ? NS_ERROR_NULL_POINTER : _to->SetDirectoryId(aDirectoryId); } \
  NS_SCRIPTABLE NS_IMETHOD GetLocalId(nsACString & aLocalId) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetLocalId(aLocalId); } \
  NS_SCRIPTABLE NS_IMETHOD SetLocalId(const nsACString & aLocalId) { return !_to ? NS_ERROR_NULL_POINTER : _to->SetLocalId(aLocalId); } \
  NS_SCRIPTABLE NS_IMETHOD GetProperties(nsISimpleEnumerator **aProperties) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetProperties(aProperties); } \
  NS_SCRIPTABLE NS_IMETHOD GetProperty(const nsACString & name, nsIVariant *defaultValue, nsIVariant **_retval NS_OUTPARAM) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetProperty(name, defaultValue, _retval); } \
  NS_IMETHOD GetPropertyAsAString(const char *name, nsAString & _retval NS_OUTPARAM) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetPropertyAsAString(name, _retval); } \
  NS_IMETHOD GetPropertyAsAUTF8String(const char *name, nsACString & _retval NS_OUTPARAM) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetPropertyAsAUTF8String(name, _retval); } \
  NS_IMETHOD GetPropertyAsUint32(const char *name, PRUint32 *_retval NS_OUTPARAM) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetPropertyAsUint32(name, _retval); } \
  NS_IMETHOD GetPropertyAsBool(const char *name, PRBool *_retval NS_OUTPARAM) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetPropertyAsBool(name, _retval); } \
  NS_SCRIPTABLE NS_IMETHOD SetProperty(const nsACString & name, nsIVariant *value) { return !_to ? NS_ERROR_NULL_POINTER : _to->SetProperty(name, value); } \
  NS_IMETHOD SetPropertyAsAString(const char *name, const nsAString & value) { return !_to ? NS_ERROR_NULL_POINTER : _to->SetPropertyAsAString(name, value); } \
  NS_IMETHOD SetPropertyAsAUTF8String(const char *name, const nsACString & value) { return !_to ? NS_ERROR_NULL_POINTER : _to->SetPropertyAsAUTF8String(name, value); } \
  NS_IMETHOD SetPropertyAsUint32(const char *name, PRUint32 value) { return !_to ? NS_ERROR_NULL_POINTER : _to->SetPropertyAsUint32(name, value); } \
  NS_IMETHOD SetPropertyAsBool(const char *name, PRBool value) { return !_to ? NS_ERROR_NULL_POINTER : _to->SetPropertyAsBool(name, value); } \
  NS_SCRIPTABLE NS_IMETHOD DeleteProperty(const nsACString & name) { return !_to ? NS_ERROR_NULL_POINTER : _to->DeleteProperty(name); } \
  NS_SCRIPTABLE NS_IMETHOD GetFirstName(nsAString & aFirstName) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetFirstName(aFirstName); } \
  NS_SCRIPTABLE NS_IMETHOD SetFirstName(const nsAString & aFirstName) { return !_to ? NS_ERROR_NULL_POINTER : _to->SetFirstName(aFirstName); } \
  NS_SCRIPTABLE NS_IMETHOD GetLastName(nsAString & aLastName) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetLastName(aLastName); } \
  NS_SCRIPTABLE NS_IMETHOD SetLastName(const nsAString & aLastName) { return !_to ? NS_ERROR_NULL_POINTER : _to->SetLastName(aLastName); } \
  NS_SCRIPTABLE NS_IMETHOD GetDisplayName(nsAString & aDisplayName) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetDisplayName(aDisplayName); } \
  NS_SCRIPTABLE NS_IMETHOD SetDisplayName(const nsAString & aDisplayName) { return !_to ? NS_ERROR_NULL_POINTER : _to->SetDisplayName(aDisplayName); } \
  NS_SCRIPTABLE NS_IMETHOD GetPrimaryEmail(nsAString & aPrimaryEmail) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetPrimaryEmail(aPrimaryEmail); } \
  NS_SCRIPTABLE NS_IMETHOD SetPrimaryEmail(const nsAString & aPrimaryEmail) { return !_to ? NS_ERROR_NULL_POINTER : _to->SetPrimaryEmail(aPrimaryEmail); } \
  NS_SCRIPTABLE NS_IMETHOD HasEmailAddress(const nsACString & aEmailAddress, PRBool *_retval NS_OUTPARAM) { return !_to ? NS_ERROR_NULL_POINTER : _to->HasEmailAddress(aEmailAddress, _retval); } \
  NS_SCRIPTABLE NS_IMETHOD TranslateTo(const nsACString & aType, nsACString & _retval NS_OUTPARAM) { return !_to ? NS_ERROR_NULL_POINTER : _to->TranslateTo(aType, _retval); } \
  NS_SCRIPTABLE NS_IMETHOD GeneratePhoneticName(PRBool aLastNameFirst, nsAString & _retval NS_OUTPARAM) { return !_to ? NS_ERROR_NULL_POINTER : _to->GeneratePhoneticName(aLastNameFirst, _retval); } \
  NS_SCRIPTABLE NS_IMETHOD Copy(nsIAbCard *aSrcCard) { return !_to ? NS_ERROR_NULL_POINTER : _to->Copy(aSrcCard); } \
  NS_SCRIPTABLE NS_IMETHOD Equals(nsIAbCard *aCard, PRBool *_retval NS_OUTPARAM) { return !_to ? NS_ERROR_NULL_POINTER : _to->Equals(aCard, _retval); } \
  NS_SCRIPTABLE NS_IMETHOD GetIsMailList(PRBool *aIsMailList) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetIsMailList(aIsMailList); } \
  NS_SCRIPTABLE NS_IMETHOD SetIsMailList(PRBool aIsMailList) { return !_to ? NS_ERROR_NULL_POINTER : _to->SetIsMailList(aIsMailList); } \
  NS_SCRIPTABLE NS_IMETHOD GetMailListURI(char **aMailListURI) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetMailListURI(aMailListURI); } \
  NS_SCRIPTABLE NS_IMETHOD SetMailListURI(const char *aMailListURI) { return !_to ? NS_ERROR_NULL_POINTER : _to->SetMailListURI(aMailListURI); } 

#if 0
/* Use the code below as a template for the implementation class for this interface. */

/* Header file */
class nsAbCard : public nsIAbCard
{
public:
  NS_DECL_ISUPPORTS
  NS_DECL_NSIABCARD

  nsAbCard();

private:
  ~nsAbCard();

protected:
  /* additional members */
};

/* Implementation file */
NS_IMPL_ISUPPORTS1(nsAbCard, nsIAbCard)

nsAbCard::nsAbCard()
{
  /* member initializers and constructor code */
}

nsAbCard::~nsAbCard()
{
  /* destructor code */
}

/* attribute AUTF8String directoryId; */
NS_IMETHODIMP nsAbCard::GetDirectoryId(nsACString & aDirectoryId)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}
NS_IMETHODIMP nsAbCard::SetDirectoryId(const nsACString & aDirectoryId)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* attribute AUTF8String localId; */
NS_IMETHODIMP nsAbCard::GetLocalId(nsACString & aLocalId)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}
NS_IMETHODIMP nsAbCard::SetLocalId(const nsACString & aLocalId)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* readonly attribute nsISimpleEnumerator properties; */
NS_IMETHODIMP nsAbCard::GetProperties(nsISimpleEnumerator **aProperties)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* nsIVariant getProperty (in AUTF8String name, in nsIVariant defaultValue); */
NS_IMETHODIMP nsAbCard::GetProperty(const nsACString & name, nsIVariant *defaultValue, nsIVariant **_retval NS_OUTPARAM)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* [noscript] AString getPropertyAsAString (in string name); */
NS_IMETHODIMP nsAbCard::GetPropertyAsAString(const char *name, nsAString & _retval NS_OUTPARAM)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* [noscript] AUTF8String getPropertyAsAUTF8String (in string name); */
NS_IMETHODIMP nsAbCard::GetPropertyAsAUTF8String(const char *name, nsACString & _retval NS_OUTPARAM)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* [noscript] PRUint32 getPropertyAsUint32 (in string name); */
NS_IMETHODIMP nsAbCard::GetPropertyAsUint32(const char *name, PRUint32 *_retval NS_OUTPARAM)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* [noscript] boolean getPropertyAsBool (in string name); */
NS_IMETHODIMP nsAbCard::GetPropertyAsBool(const char *name, PRBool *_retval NS_OUTPARAM)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void setProperty (in AUTF8String name, in nsIVariant value); */
NS_IMETHODIMP nsAbCard::SetProperty(const nsACString & name, nsIVariant *value)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* [noscript] void setPropertyAsAString (in string name, in AString value); */
NS_IMETHODIMP nsAbCard::SetPropertyAsAString(const char *name, const nsAString & value)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* [noscript] void setPropertyAsAUTF8String (in string name, in AUTF8String value); */
NS_IMETHODIMP nsAbCard::SetPropertyAsAUTF8String(const char *name, const nsACString & value)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* [noscript] void setPropertyAsUint32 (in string name, in PRUint32 value); */
NS_IMETHODIMP nsAbCard::SetPropertyAsUint32(const char *name, PRUint32 value)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* [noscript] void setPropertyAsBool (in string name, in boolean value); */
NS_IMETHODIMP nsAbCard::SetPropertyAsBool(const char *name, PRBool value)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void deleteProperty (in AUTF8String name); */
NS_IMETHODIMP nsAbCard::DeleteProperty(const nsACString & name)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* attribute AString firstName; */
NS_IMETHODIMP nsAbCard::GetFirstName(nsAString & aFirstName)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}
NS_IMETHODIMP nsAbCard::SetFirstName(const nsAString & aFirstName)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* attribute AString lastName; */
NS_IMETHODIMP nsAbCard::GetLastName(nsAString & aLastName)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}
NS_IMETHODIMP nsAbCard::SetLastName(const nsAString & aLastName)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* attribute AString displayName; */
NS_IMETHODIMP nsAbCard::GetDisplayName(nsAString & aDisplayName)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}
NS_IMETHODIMP nsAbCard::SetDisplayName(const nsAString & aDisplayName)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* attribute AString primaryEmail; */
NS_IMETHODIMP nsAbCard::GetPrimaryEmail(nsAString & aPrimaryEmail)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}
NS_IMETHODIMP nsAbCard::SetPrimaryEmail(const nsAString & aPrimaryEmail)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* boolean hasEmailAddress (in AUTF8String aEmailAddress); */
NS_IMETHODIMP nsAbCard::HasEmailAddress(const nsACString & aEmailAddress, PRBool *_retval NS_OUTPARAM)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* AUTF8String translateTo (in AUTF8String aType); */
NS_IMETHODIMP nsAbCard::TranslateTo(const nsACString & aType, nsACString & _retval NS_OUTPARAM)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* AString generatePhoneticName (in boolean aLastNameFirst); */
NS_IMETHODIMP nsAbCard::GeneratePhoneticName(PRBool aLastNameFirst, nsAString & _retval NS_OUTPARAM)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void copy (in nsIAbCard aSrcCard); */
NS_IMETHODIMP nsAbCard::Copy(nsIAbCard *aSrcCard)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* boolean equals (in nsIAbCard aCard); */
NS_IMETHODIMP nsAbCard::Equals(nsIAbCard *aCard, PRBool *_retval NS_OUTPARAM)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* attribute boolean isMailList; */
NS_IMETHODIMP nsAbCard::GetIsMailList(PRBool *aIsMailList)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}
NS_IMETHODIMP nsAbCard::SetIsMailList(PRBool aIsMailList)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* attribute string mailListURI; */
NS_IMETHODIMP nsAbCard::GetMailListURI(char **aMailListURI)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}
NS_IMETHODIMP nsAbCard::SetMailListURI(const char *aMailListURI)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* End of implementation class template. */
#endif

// A nice list of properties for the benefit of C++ clients
#define kFirstNameProperty          "FirstName"
#define kLastNameProperty           "LastName"
#define kDisplayNameProperty        "DisplayName"
#define kNicknameProperty           "NickName"
#define kPriEmailProperty           "PrimaryEmail"
#define kPreferMailFormatProperty   "PreferMailFormat"
#define kLastModifiedDateProperty   "LastModifiedDate"
#define kPopularityIndexProperty    "PopularityIndex"
#define kAllowRemoteContentProperty "AllowRemoteContent"
#define kPhoneticFirstNameProperty  "PhoneticFirstName"
#define kPhoneticLastNameProperty   "PhoneticLastName"
#define kSpouseNameProperty         "SpouseName"
#define kFamilyNameProperty         "FamilyName"
#define k2ndEmailProperty           "SecondEmail"
#define kHomeAddressProperty        "HomeAddress"
#define kHomeAddress2Property       "HomeAddress2"
#define kHomeCityProperty           "HomeCity"
#define kHomeStateProperty          "HomeState"
#define kHomeZipCodeProperty        "HomeZipCode"
#define kHomeCountryProperty        "HomeCountry"
#define kHomeWebPageProperty        "WebPage2"
#define kWorkAddressProperty        "WorkAddress"
#define kWorkAddress2Property       "WorkAddress2"
#define kWorkCityProperty           "WorkCity"
#define kWorkStateProperty          "WorkState"
#define kWorkZipCodeProperty        "WorkZipCode"
#define kWorkCountryProperty        "WorkCountry"
#define kWorkWebPageProperty        "WebPage1"
#define kHomePhoneProperty          "HomePhone"
#define kHomePhoneTypeProperty      "HomePhoneType"
#define kWorkPhoneProperty          "WorkPhone"
#define kWorkPhoneTypeProperty      "WorkPhoneType"
#define kFaxProperty                "FaxNumber"
#define kFaxTypeProperty            "FaxNumberType"
#define kPagerTypeProperty          "PagerNumberType"
#define kPagerProperty              "PagerNumber"
#define kCellularProperty           "CellularNumber"
#define kCellularTypeProperty       "CellularNumberType"
#define kJobTitleProperty           "JobTitle"
#define kDepartmentProperty         "Department"
#define kCompanyProperty            "Company"
#define kScreenNameProperty         "_AimScreenName"
#define kCustom1Property            "Custom1"
#define kCustom2Property            "Custom2"
#define kCustom3Property            "Custom3"
#define kCustom4Property            "Custom4"
#define kNotesProperty              "Notes"
#define kAnniversaryYearProperty    "AnniversaryYear"
#define kAnniversaryMonthProperty   "AnniversaryMonth"
#define kAnniversaryDayProperty     "AnniversaryDay"
#define kBirthYearProperty          "BirthYear"
#define kBirthMonthProperty         "BirthMonth"
#define kBirthDayProperty           "BirthDay"

#endif /* __gen_nsIAbCard_h__ */
