/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text;

import gnu.java.lang.CPStringBuilder;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import javax.swing.Action;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.DefaultCaret;
import javax.swing.text.Document;
import javax.swing.text.EditorKit;
import javax.swing.text.JTextComponent;
import javax.swing.text.PlainDocument;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.TextAction;
import javax.swing.text.Utilities;
import javax.swing.text.ViewFactory;

public class DefaultEditorKit
extends EditorKit {
    private static final long serialVersionUID = 9017245433028523428L;
    public static final String backwardAction = "caret-backward";
    public static final String beepAction = "beep";
    public static final String beginAction = "caret-begin";
    public static final String beginLineAction = "caret-begin-line";
    public static final String beginParagraphAction = "caret-begin-paragraph";
    public static final String beginWordAction = "caret-begin-word";
    public static final String copyAction = "copy-to-clipboard";
    public static final String cutAction = "cut-to-clipboard";
    public static final String defaultKeyTypedAction = "default-typed";
    public static final String deleteNextCharAction = "delete-next";
    public static final String deletePrevCharAction = "delete-previous";
    public static final String downAction = "caret-down";
    public static final String endAction = "caret-end";
    public static final String endLineAction = "caret-end-line";
    public static final String EndOfLineStringProperty = "__EndOfLine__";
    public static final String endParagraphAction = "caret-end-paragraph";
    public static final String endWordAction = "caret-end-word";
    public static final String forwardAction = "caret-forward";
    public static final String insertBreakAction = "insert-break";
    public static final String insertContentAction = "insert-content";
    public static final String insertTabAction = "insert-tab";
    public static final String nextWordAction = "caret-next-word";
    public static final String pageDownAction = "page-down";
    public static final String pageUpAction = "page-up";
    public static final String pasteAction = "paste-from-clipboard";
    public static final String previousWordAction = "caret-previous-word";
    public static final String readOnlyAction = "set-read-only";
    public static final String selectAllAction = "select-all";
    public static final String selectionBackwardAction = "selection-backward";
    public static final String selectionBeginAction = "selection-begin";
    public static final String selectionBeginLineAction = "selection-begin-line";
    public static final String selectionBeginParagraphAction = "selection-begin-paragraph";
    public static final String selectionBeginWordAction = "selection-begin-word";
    public static final String selectionDownAction = "selection-down";
    public static final String selectionEndAction = "selection-end";
    public static final String selectionEndLineAction = "selection-end-line";
    public static final String selectionEndParagraphAction = "selection-end-paragraph";
    public static final String selectionEndWordAction = "selection-end-word";
    public static final String selectionForwardAction = "selection-forward";
    public static final String selectionNextWordAction = "selection-next-word";
    public static final String selectionPreviousWordAction = "selection-previous-word";
    public static final String selectionUpAction = "selection-up";
    public static final String selectLineAction = "select-line";
    public static final String selectParagraphAction = "select-paragraph";
    public static final String selectWordAction = "select-word";
    public static final String upAction = "caret-up";
    public static final String writableAction = "set-writable";
    private static Action[] defaultActions = new Action[]{new BeepAction(), new CopyAction(), new CutAction(), new DefaultKeyTypedAction(), new InsertBreakAction(), new InsertContentAction(), new InsertTabAction(), new PasteAction(), new DeleteNextCharAction(), new DeletePrevCharAction(), new BeginLineAction(), new SelectionBeginLineAction(), new EndLineAction(), new SelectionEndLineAction(), new BackwardAction(), new SelectionBackwardAction(), new ForwardAction(), new SelectionForwardAction(), new UpAction(), new SelectionUpAction(), new DownAction(), new SelectionDownAction(), new NextWordAction(), new SelectionNextWordAction(), new PreviousWordAction(), new SelectionPreviousWordAction(), new BeginAction(), new SelectionBeginAction(), new EndAction(), new SelectionEndAction(), new BeginWordAction(), new SelectionBeginWordAction(), new EndWordAction(), new SelectionEndWordAction(), new SelectAllAction(), new SelectLineAction(), new SelectWordAction()};

    public Caret createCaret() {
        return new DefaultCaret();
    }

    public Document createDefaultDocument() {
        return new PlainDocument();
    }

    public Action[] getActions() {
        return defaultActions;
    }

    public String getContentType() {
        return "text/plain";
    }

    public ViewFactory getViewFactory() {
        return null;
    }

    public void read(InputStream in, Document document, int offset) throws BadLocationException, IOException {
        this.read(new InputStreamReader(in), document, offset);
    }

    public void read(Reader in, Document document, int offset) throws BadLocationException, IOException {
        String line;
        BufferedReader reader = new BufferedReader(in);
        CPStringBuilder content = new CPStringBuilder();
        while ((line = reader.readLine()) != null) {
            content.append(line);
            content.append("\n");
        }
        document.insertString(offset, content.substring(0, content.length() - 1), SimpleAttributeSet.EMPTY);
    }

    public void write(OutputStream out, Document document, int offset, int len) throws BadLocationException, IOException {
        this.write(new OutputStreamWriter(out), document, offset, len);
    }

    public void write(Writer out, Document document, int offset, int len) throws BadLocationException, IOException {
        if (offset < 0 || offset > document.getLength()) {
            throw new BadLocationException("Tried to write to invalid location", offset);
        }
        if (offset + len > document.getLength()) {
            len = document.getLength() - offset;
        }
        out.write(document.getText(offset, len));
    }

    static class BackwardAction
    extends TextAction.HorizontalMovementAction {
        BackwardAction() {
            super(DefaultEditorKit.backwardAction, 7);
        }

        protected void actionPerformedImpl(Caret c, int offs) {
            c.setDot(offs);
        }
    }

    public static class BeepAction
    extends TextAction {
        public BeepAction() {
            super(DefaultEditorKit.beepAction);
        }

        public void actionPerformed(ActionEvent event) {
            Toolkit.getDefaultToolkit().beep();
        }
    }

    static class BeginAction
    extends TextAction {
        BeginAction() {
            super(DefaultEditorKit.beginAction);
        }

        public void actionPerformed(ActionEvent event) {
            JTextComponent t = this.getTextComponent(event);
            if (t != null) {
                Caret c = t.getCaret();
                c.setDot(0);
                try {
                    c.setMagicCaretPosition(t.modelToView(0).getLocation());
                }
                catch (BadLocationException badLocationException) {}
            }
        }
    }

    static class BeginLineAction
    extends TextAction {
        BeginLineAction() {
            super(DefaultEditorKit.beginLineAction);
        }

        public void actionPerformed(ActionEvent event) {
            JTextComponent t = this.getTextComponent(event);
            if (t != null) {
                try {
                    int offs = Utilities.getRowStart(t, t.getCaretPosition());
                    if (offs > -1) {
                        Caret c = t.getCaret();
                        c.setDot(offs);
                        c.setMagicCaretPosition(t.modelToView(offs).getLocation());
                    }
                }
                catch (BadLocationException badLocationException) {}
            }
        }
    }

    static class BeginWordAction
    extends TextAction {
        BeginWordAction() {
            super(DefaultEditorKit.beginWordAction);
        }

        public void actionPerformed(ActionEvent event) {
            try {
                JTextComponent t = this.getTextComponent(event);
                if (t != null) {
                    int offs = Utilities.getWordStart(t, t.getCaretPosition());
                    Caret c = t.getCaret();
                    c.setDot(offs);
                    c.setMagicCaretPosition(t.modelToView(offs).getLocation());
                }
            }
            catch (BadLocationException badLocationException) {}
        }
    }

    public static class CopyAction
    extends TextAction {
        public CopyAction() {
            super(DefaultEditorKit.copyAction);
        }

        public void actionPerformed(ActionEvent event) {
            JTextComponent target = this.getTextComponent(event);
            if (target != null) {
                target.copy();
            }
        }
    }

    public static class CutAction
    extends TextAction {
        public CutAction() {
            super(DefaultEditorKit.cutAction);
        }

        public void actionPerformed(ActionEvent event) {
            JTextComponent target = this.getTextComponent(event);
            if (target != null) {
                target.cut();
            }
        }
    }

    public static class DefaultKeyTypedAction
    extends TextAction {
        public DefaultKeyTypedAction() {
            super(DefaultEditorKit.defaultKeyTypedAction);
        }

        public void actionPerformed(ActionEvent event) {
            JTextComponent target = this.getTextComponent(event);
            if (target != null && event != null && target.isEditable() && target.isEnabled()) {
                char c;
                String content = event.getActionCommand();
                int mod = event.getModifiers();
                if (content != null && content.length() > 0 && (mod & 8) == 0 && (mod & 2) == 0 && (c = content.charAt(0)) >= ' ' && c != '\u007f') {
                    target.replaceSelection(content);
                }
            }
        }
    }

    static class DeleteNextCharAction
    extends TextAction {
        DeleteNextCharAction() {
            super(DefaultEditorKit.deleteNextCharAction);
        }

        public void actionPerformed(ActionEvent event) {
            JTextComponent t = this.getTextComponent(event);
            if (t != null) {
                try {
                    int pos = t.getSelectionStart();
                    int len = t.getSelectionEnd() - pos;
                    if (len > 0) {
                        t.getDocument().remove(pos, len);
                    } else if (pos < t.getDocument().getLength()) {
                        t.getDocument().remove(pos, 1);
                    }
                    Caret c = t.getCaret();
                    c.setDot(pos);
                    c.setMagicCaretPosition(t.modelToView(pos).getLocation());
                }
                catch (BadLocationException badLocationException) {}
            }
        }
    }

    static class DeletePrevCharAction
    extends TextAction {
        DeletePrevCharAction() {
            super(DefaultEditorKit.deletePrevCharAction);
        }

        public void actionPerformed(ActionEvent event) {
            JTextComponent t = this.getTextComponent(event);
            if (t != null) {
                try {
                    int pos = t.getSelectionStart();
                    int len = t.getSelectionEnd() - pos;
                    if (len > 0) {
                        t.getDocument().remove(pos, len);
                    } else if (pos > 0) {
                        t.getDocument().remove(--pos, 1);
                        Caret c = t.getCaret();
                        c.setDot(pos);
                        c.setMagicCaretPosition(t.modelToView(pos).getLocation());
                    }
                }
                catch (BadLocationException badLocationException) {}
            }
        }
    }

    static class DownAction
    extends TextAction.VerticalMovementAction {
        DownAction() {
            super(DefaultEditorKit.downAction, 5);
        }

        protected void actionPerformedImpl(Caret c, int offs) {
            c.setDot(offs);
        }
    }

    static class EndAction
    extends TextAction {
        EndAction() {
            super(DefaultEditorKit.endAction);
        }

        public void actionPerformed(ActionEvent event) {
            JTextComponent t = this.getTextComponent(event);
            if (t != null) {
                int offs = t.getDocument().getLength();
                Caret c = t.getCaret();
                c.setDot(offs);
                try {
                    c.setMagicCaretPosition(t.modelToView(offs).getLocation());
                }
                catch (BadLocationException badLocationException) {}
            }
        }
    }

    static class EndLineAction
    extends TextAction {
        EndLineAction() {
            super(DefaultEditorKit.endLineAction);
        }

        public void actionPerformed(ActionEvent event) {
            JTextComponent t = this.getTextComponent(event);
            if (t != null) {
                try {
                    int offs = Utilities.getRowEnd(t, t.getCaretPosition());
                    if (offs > -1) {
                        Caret c = t.getCaret();
                        c.setDot(offs);
                        c.setMagicCaretPosition(t.modelToView(offs).getLocation());
                    }
                }
                catch (BadLocationException badLocationException) {}
            }
        }
    }

    static class EndWordAction
    extends TextAction {
        EndWordAction() {
            super(DefaultEditorKit.endWordAction);
        }

        public void actionPerformed(ActionEvent event) {
            try {
                JTextComponent t = this.getTextComponent(event);
                if (t != null) {
                    int offs = Utilities.getWordEnd(t, t.getCaretPosition());
                    Caret c = t.getCaret();
                    c.setDot(offs);
                    c.setMagicCaretPosition(t.modelToView(offs).getLocation());
                }
            }
            catch (BadLocationException badLocationException) {}
        }
    }

    static class ForwardAction
    extends TextAction.HorizontalMovementAction {
        ForwardAction() {
            super(DefaultEditorKit.forwardAction, 3);
        }

        protected void actionPerformedImpl(Caret c, int offs) {
            c.setDot(offs);
        }
    }

    public static class InsertBreakAction
    extends TextAction {
        public InsertBreakAction() {
            super(DefaultEditorKit.insertBreakAction);
        }

        public void actionPerformed(ActionEvent event) {
            JTextComponent t = this.getTextComponent(event);
            if (t != null) {
                t.replaceSelection("\n");
            }
        }
    }

    public static class InsertContentAction
    extends TextAction {
        public InsertContentAction() {
            super(DefaultEditorKit.insertContentAction);
        }

        public void actionPerformed(ActionEvent event) {
        }
    }

    public static class InsertTabAction
    extends TextAction {
        public InsertTabAction() {
            super(DefaultEditorKit.insertTabAction);
        }

        public void actionPerformed(ActionEvent event) {
            JTextComponent t = this.getTextComponent(event);
            if (t != null) {
                t.replaceSelection("\t");
            }
        }
    }

    static class NextWordAction
    extends TextAction {
        NextWordAction() {
            super(DefaultEditorKit.nextWordAction);
        }

        public void actionPerformed(ActionEvent event) {
            try {
                JTextComponent t = this.getTextComponent(event);
                if (t != null) {
                    int offs = Utilities.getNextWord(t, t.getCaretPosition());
                    Caret c = t.getCaret();
                    c.setDot(offs);
                    c.setMagicCaretPosition(t.modelToView(offs).getLocation());
                }
            }
            catch (BadLocationException badLocationException) {}
        }
    }

    public static class PasteAction
    extends TextAction {
        public PasteAction() {
            super(DefaultEditorKit.pasteAction);
        }

        public void actionPerformed(ActionEvent event) {
            JTextComponent target = this.getTextComponent(event);
            if (target != null) {
                target.paste();
            }
        }
    }

    static class PreviousWordAction
    extends TextAction {
        PreviousWordAction() {
            super(DefaultEditorKit.previousWordAction);
        }

        public void actionPerformed(ActionEvent event) {
            try {
                JTextComponent t = this.getTextComponent(event);
                if (t != null) {
                    int offs = Utilities.getPreviousWord(t, t.getCaretPosition());
                    Caret c = t.getCaret();
                    c.setDot(offs);
                    c.setMagicCaretPosition(t.modelToView(offs).getLocation());
                }
            }
            catch (BadLocationException badLocationException) {}
        }
    }

    static class SelectAllAction
    extends TextAction {
        SelectAllAction() {
            super(DefaultEditorKit.selectAllAction);
        }

        public void actionPerformed(ActionEvent event) {
            JTextComponent t = this.getTextComponent(event);
            if (t != null) {
                int offs = t.getDocument().getLength();
                Caret c = t.getCaret();
                c.setDot(0);
                c.moveDot(offs);
                try {
                    c.setMagicCaretPosition(t.modelToView(offs).getLocation());
                }
                catch (BadLocationException badLocationException) {}
            }
        }
    }

    static class SelectLineAction
    extends TextAction {
        SelectLineAction() {
            super(DefaultEditorKit.selectLineAction);
        }

        public void actionPerformed(ActionEvent event) {
            JTextComponent t = this.getTextComponent(event);
            if (t != null) {
                Caret c = t.getCaret();
                try {
                    int offs1 = Utilities.getRowStart(t, c.getDot());
                    int offs2 = Utilities.getRowEnd(t, c.getDot());
                    c.setDot(offs2);
                    c.moveDot(offs1);
                    c.setMagicCaretPosition(t.modelToView(offs2).getLocation());
                }
                catch (BadLocationException badLocationException) {}
            }
        }
    }

    static class SelectWordAction
    extends TextAction {
        SelectWordAction() {
            super(DefaultEditorKit.selectWordAction);
        }

        public void actionPerformed(ActionEvent event) {
            JTextComponent t = this.getTextComponent(event);
            if (t != null) {
                Caret c = t.getCaret();
                int dot = c.getDot();
                try {
                    int wordStart = Utilities.getWordStart(t, dot);
                    if (dot == wordStart) {
                        c.setDot(wordStart);
                        c.moveDot(Utilities.getWordEnd(t, wordStart));
                    } else {
                        int nextWord = Utilities.getNextWord(t, dot);
                        int previousWord = Utilities.getPreviousWord(t, dot);
                        int previousWordEnd = Utilities.getWordEnd(t, previousWord);
                        if (dot >= previousWordEnd && dot <= nextWord) {
                            c.setDot(previousWordEnd);
                            c.moveDot(nextWord);
                        } else {
                            c.setDot(previousWord);
                            c.moveDot(previousWordEnd);
                        }
                    }
                    if (c.getDot() != dot) {
                        c.setMagicCaretPosition(t.modelToView(c.getDot()).getLocation());
                    }
                }
                catch (BadLocationException badLocationException) {}
            }
        }
    }

    static class SelectionBackwardAction
    extends TextAction.HorizontalMovementAction {
        SelectionBackwardAction() {
            super(DefaultEditorKit.selectionBackwardAction, 7);
        }

        protected void actionPerformedImpl(Caret c, int offs) {
            c.moveDot(offs);
        }
    }

    static class SelectionBeginAction
    extends TextAction {
        SelectionBeginAction() {
            super(DefaultEditorKit.selectionBeginAction);
        }

        public void actionPerformed(ActionEvent event) {
            JTextComponent t = this.getTextComponent(event);
            if (t != null) {
                Caret c = t.getCaret();
                c.moveDot(0);
                try {
                    c.setMagicCaretPosition(t.modelToView(0).getLocation());
                }
                catch (BadLocationException badLocationException) {}
            }
        }
    }

    static class SelectionBeginLineAction
    extends TextAction {
        SelectionBeginLineAction() {
            super(DefaultEditorKit.selectionBeginLineAction);
        }

        public void actionPerformed(ActionEvent event) {
            JTextComponent t = this.getTextComponent(event);
            if (t != null) {
                Caret c = t.getCaret();
                try {
                    int offs = Utilities.getRowStart(t, c.getDot());
                    c.setMagicCaretPosition(t.modelToView(offs).getLocation());
                }
                catch (BadLocationException badLocationException) {}
            }
        }
    }

    static class SelectionBeginWordAction
    extends TextAction {
        SelectionBeginWordAction() {
            super(DefaultEditorKit.selectionBeginWordAction);
        }

        public void actionPerformed(ActionEvent event) {
            try {
                JTextComponent t = this.getTextComponent(event);
                if (t != null) {
                    int offs = Utilities.getWordStart(t, t.getCaretPosition());
                    Caret c = t.getCaret();
                    c.moveDot(offs);
                    c.setMagicCaretPosition(t.modelToView(offs).getLocation());
                }
            }
            catch (BadLocationException badLocationException) {}
        }
    }

    static class SelectionDownAction
    extends TextAction.VerticalMovementAction {
        SelectionDownAction() {
            super(DefaultEditorKit.selectionDownAction, 5);
        }

        protected void actionPerformedImpl(Caret c, int offs) {
            c.moveDot(offs);
        }
    }

    static class SelectionEndAction
    extends TextAction {
        SelectionEndAction() {
            super(DefaultEditorKit.selectionEndAction);
        }

        public void actionPerformed(ActionEvent event) {
            JTextComponent t = this.getTextComponent(event);
            if (t != null) {
                int offs = t.getDocument().getLength();
                Caret c = t.getCaret();
                c.moveDot(offs);
                try {
                    c.setMagicCaretPosition(t.modelToView(offs).getLocation());
                }
                catch (BadLocationException badLocationException) {}
            }
        }
    }

    static class SelectionEndLineAction
    extends TextAction {
        SelectionEndLineAction() {
            super(DefaultEditorKit.selectionEndLineAction);
        }

        public void actionPerformed(ActionEvent event) {
            JTextComponent t = this.getTextComponent(event);
            if (t != null) {
                Caret c = t.getCaret();
                try {
                    int offs = Utilities.getRowEnd(t, c.getDot());
                    c.setMagicCaretPosition(t.modelToView(offs).getLocation());
                }
                catch (BadLocationException badLocationException) {}
            }
        }
    }

    static class SelectionEndWordAction
    extends TextAction {
        SelectionEndWordAction() {
            super(DefaultEditorKit.selectionEndWordAction);
        }

        public void actionPerformed(ActionEvent event) {
            try {
                JTextComponent t = this.getTextComponent(event);
                if (t != null) {
                    int offs = Utilities.getWordEnd(t, t.getCaretPosition());
                    Caret c = t.getCaret();
                    c.moveDot(offs);
                    c.setMagicCaretPosition(t.modelToView(offs).getLocation());
                }
            }
            catch (BadLocationException badLocationException) {}
        }
    }

    static class SelectionForwardAction
    extends TextAction.HorizontalMovementAction {
        SelectionForwardAction() {
            super(DefaultEditorKit.selectionForwardAction, 3);
        }

        protected void actionPerformedImpl(Caret c, int offs) {
            c.moveDot(offs);
        }
    }

    static class SelectionNextWordAction
    extends TextAction {
        SelectionNextWordAction() {
            super(DefaultEditorKit.selectionNextWordAction);
        }

        public void actionPerformed(ActionEvent event) {
            try {
                JTextComponent t = this.getTextComponent(event);
                if (t != null) {
                    int offs = Utilities.getNextWord(t, t.getCaretPosition());
                    Caret c = t.getCaret();
                    c.moveDot(offs);
                    c.setMagicCaretPosition(t.modelToView(offs).getLocation());
                }
            }
            catch (BadLocationException badLocationException) {}
        }
    }

    static class SelectionPreviousWordAction
    extends TextAction {
        SelectionPreviousWordAction() {
            super(DefaultEditorKit.selectionPreviousWordAction);
        }

        public void actionPerformed(ActionEvent event) {
            try {
                JTextComponent t = this.getTextComponent(event);
                if (t != null) {
                    int offs = Utilities.getPreviousWord(t, t.getCaretPosition());
                    Caret c = t.getCaret();
                    c.moveDot(offs);
                    c.setMagicCaretPosition(t.modelToView(offs).getLocation());
                }
            }
            catch (BadLocationException badLocationException) {}
        }
    }

    static class SelectionUpAction
    extends TextAction.VerticalMovementAction {
        SelectionUpAction() {
            super(DefaultEditorKit.selectionUpAction, 1);
        }

        protected void actionPerformedImpl(Caret c, int offs) {
            c.moveDot(offs);
        }
    }

    static class UpAction
    extends TextAction.VerticalMovementAction {
        UpAction() {
            super(DefaultEditorKit.upAction, 1);
        }

        protected void actionPerformedImpl(Caret c, int offs) {
            c.setDot(offs);
        }
    }
}

