/*
 * Decompiled with CFR 0.152.
 */
package javax.net.ssl;

import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.security.KeyStore;
import java.security.Security;
import javax.net.ServerSocketFactory;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;

public abstract class SSLServerSocketFactory
extends ServerSocketFactory {
    private static SSLContext context;

    protected SSLServerSocketFactory() {
    }

    public static synchronized ServerSocketFactory getDefault() {
        try {
            String s = Security.getProperty("ssl.ServerSocketFactory.provider");
            ClassLoader cl = ClassLoader.getSystemClassLoader();
            if (s != null && cl != null) {
                return (ServerSocketFactory)cl.loadClass(s).newInstance();
            }
        }
        catch (Exception exception) {}
        if (context == null) {
            KeyManager[] km = null;
            TrustManager[] tm = null;
            String kmAlg = KeyManagerFactory.getDefaultAlgorithm();
            String tmAlg = TrustManagerFactory.getDefaultAlgorithm();
            try {
                KeyManagerFactory kmf = KeyManagerFactory.getInstance(kmAlg);
                kmf.init(null, null);
                km = kmf.getKeyManagers();
            }
            catch (Exception exception) {}
            try {
                TrustManagerFactory tmf = TrustManagerFactory.getInstance(tmAlg);
                tmf.init((KeyStore)null);
                tm = tmf.getTrustManagers();
            }
            catch (Exception exception) {}
            try {
                context = SSLContext.getInstance("SSLv3");
                context.init(km, tm, null);
            }
            catch (Exception ex) {
                return new ErrorServerSocketFactory(new RuntimeException("error instantiating default server socket factory: " + ex.toString(), ex));
            }
        }
        try {
            return context.getServerSocketFactory();
        }
        catch (Exception exception) {
            return new ErrorServerSocketFactory(new RuntimeException("no SSLSocketFactory implementation available"));
        }
    }

    public abstract String[] getDefaultCipherSuites();

    public abstract String[] getSupportedCipherSuites();

    private static final class ErrorServerSocketFactory
    extends SSLServerSocketFactory {
        private RuntimeException x;

        ErrorServerSocketFactory(RuntimeException x) {
            this.x = x;
        }

        public ServerSocket createServerSocket() throws IOException {
            throw (IOException)new IOException().initCause(this.x);
        }

        public ServerSocket createServerSocket(int port) throws IOException {
            throw (IOException)new IOException().initCause(this.x);
        }

        public ServerSocket createServerSocket(int port, int backlog) throws IOException {
            throw (IOException)new IOException().initCause(this.x);
        }

        public ServerSocket createServerSocket(int port, int backlog, InetAddress ifAddress) throws IOException {
            throw (IOException)new IOException().initCause(this.x);
        }

        public String[] getDefaultCipherSuites() {
            throw new RuntimeException(this.x);
        }

        public String[] getSupportedCipherSuites() {
            throw new RuntimeException(this.x);
        }
    }
}

