/*
 * Decompiled with CFR 0.152.
 */
package java.math;

import gnu.java.lang.CPStringBuilder;
import java.math.BigInteger;
import java.math.MathContext;
import java.math.RoundingMode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BigDecimal
extends Number
implements Comparable<BigDecimal> {
    private BigInteger intVal;
    private int scale;
    private int precision = 0;
    private static final long serialVersionUID = 6108874887143696463L;
    public static final BigDecimal ZERO = new BigDecimal(BigInteger.ZERO, 0);
    public static final BigDecimal ONE = new BigDecimal(BigInteger.ONE, 0);
    public static final BigDecimal TEN = new BigDecimal(BigInteger.TEN, 0);
    public static final int ROUND_UP = 0;
    public static final int ROUND_DOWN = 1;
    public static final int ROUND_CEILING = 2;
    public static final int ROUND_FLOOR = 3;
    public static final int ROUND_HALF_UP = 4;
    public static final int ROUND_HALF_DOWN = 5;
    public static final int ROUND_HALF_EVEN = 6;
    public static final int ROUND_UNNECESSARY = 7;

    public BigDecimal(int val) {
        this.intVal = BigInteger.valueOf(val);
        this.scale = 0;
    }

    public BigDecimal(int val, MathContext mc) {
        this(val);
        if (mc.getPrecision() != 0) {
            BigDecimal result = this.round(mc);
            this.intVal = result.intVal;
            this.scale = result.scale;
            this.precision = result.precision;
        }
    }

    public BigDecimal(long val) {
        this.intVal = BigInteger.valueOf(val);
        this.scale = 0;
    }

    public BigDecimal(long val, MathContext mc) {
        this(val);
        if (mc.getPrecision() != 0) {
            BigDecimal result = this.round(mc);
            this.intVal = result.intVal;
            this.scale = result.scale;
            this.precision = result.precision;
        }
    }

    public BigDecimal(BigInteger num, MathContext mc) {
        this(num, 0);
        if (mc.getPrecision() != 0) {
            BigDecimal result = this.round(mc);
            this.intVal = result.intVal;
            this.scale = result.scale;
            this.precision = result.precision;
        }
    }

    public BigDecimal(String val, MathContext mc) {
        this(val);
        if (mc.getPrecision() != 0) {
            BigDecimal result = this.round(mc);
            this.intVal = result.intVal;
            this.scale = result.scale;
            this.precision = result.precision;
        }
    }

    public BigDecimal(BigInteger num) {
        this(num, 0);
    }

    public BigDecimal(BigInteger num, int scale) {
        this.intVal = num;
        this.scale = scale;
    }

    public BigDecimal(BigInteger num, int scale, MathContext mc) {
        this(num, scale);
        if (mc.getPrecision() != 0) {
            BigDecimal result = this.round(mc);
            this.intVal = result.intVal;
            this.scale = result.scale;
            this.precision = result.precision;
        }
    }

    public BigDecimal(double num, MathContext mc) {
        this(num);
        if (mc.getPrecision() != 0) {
            BigDecimal result = this.round(mc);
            this.intVal = result.intVal;
            this.scale = result.scale;
            this.precision = result.precision;
        }
    }

    public BigDecimal(double num) throws NumberFormatException {
        if (Double.isInfinite(num) || Double.isNaN(num)) {
            throw new NumberFormatException("invalid argument: " + num);
        }
        long bits = Double.doubleToLongBits(num);
        long mantissa = bits & 0xFFFFFFFFFFFFFL;
        long exponent = bits >>> 52 & 0x7FFL;
        boolean denormal = exponent == 0L;
        exponent -= (long)(denormal ? 1022 : 1023);
        exponent -= 52L;
        if (!denormal) {
            mantissa |= 0x10000000000000L;
        }
        while (exponent < 0L && (mantissa & 1L) == 0L) {
            ++exponent;
            mantissa >>= 1;
        }
        this.intVal = BigInteger.valueOf(bits < 0L ? -mantissa : mantissa);
        if (exponent < 0L) {
            this.scale = (int)(-exponent);
            BigInteger mult = BigInteger.valueOf(5L).pow(this.scale);
            this.intVal = this.intVal.multiply(mult);
        } else {
            this.intVal = this.intVal.shiftLeft((int)exponent);
            this.scale = 0;
        }
    }

    public BigDecimal(char[] in, int offset, int len, MathContext mc) {
        this(in, offset, len);
        if (mc.getPrecision() != 0) {
            BigDecimal temp = this.round(mc);
            this.intVal = temp.intVal;
            this.scale = temp.scale;
            this.precision = temp.precision;
        }
    }

    public BigDecimal(char[] in, MathContext mc) {
        this(in, 0, in.length);
        if (mc.getPrecision() != 0) {
            BigDecimal temp = this.round(mc);
            this.intVal = temp.intVal;
            this.scale = temp.scale;
            this.precision = temp.precision;
        }
    }

    public BigDecimal(char[] in) {
        this(in, 0, in.length);
    }

    public BigDecimal(char[] in, int offset, int len) {
        int start = offset;
        int end = offset + len;
        int point = offset;
        int dot = -1;
        boolean negative = false;
        if (in[offset] == '+') {
            ++start;
            ++point;
        } else if (in[offset] == '-') {
            ++start;
            ++point;
            negative = true;
        }
        while (point < end) {
            char c = in[point];
            if (c == '.') {
                if (dot != -1) {
                    throw new NumberFormatException("multiple `.'s in number");
                }
                dot = point;
            } else {
                if (c == 'e' || c == 'E') break;
                if (!Character.isDigit(c)) {
                    throw new NumberFormatException("unrecognized character at " + point + ": " + c);
                }
            }
            ++point;
        }
        CPStringBuilder val = new CPStringBuilder(point - start - 1);
        if (dot != -1) {
            val.append(in, start, dot - start);
            val.append(in, dot + 1, point - dot - 1);
            this.scale = point - 1 - dot;
        } else {
            val.append(in, start, point - start);
            this.scale = 0;
        }
        if (val.length() == 0) {
            throw new NumberFormatException("no digits seen");
        }
        if (negative) {
            val.insert(0, '-');
        }
        this.intVal = new BigInteger(val.toString());
        if (point < end) {
            if (in[++point] == '+') {
                ++point;
            }
            if (point >= end) {
                throw new NumberFormatException("no exponent following e or E");
            }
            try {
                this.scale -= Integer.parseInt(new String(in, point, end - point));
            }
            catch (NumberFormatException numberFormatException) {
                throw new NumberFormatException("malformed exponent");
            }
        }
    }

    public BigDecimal(String num) throws NumberFormatException {
        String val;
        int len = num.length();
        int start = 0;
        int point = 0;
        int dot = -1;
        boolean negative = false;
        if (num.charAt(0) == '+') {
            ++start;
            ++point;
        } else if (num.charAt(0) == '-') {
            ++start;
            ++point;
            negative = true;
        }
        while (point < len) {
            char c = num.charAt(point);
            if (c == '.') {
                if (dot >= 0) {
                    throw new NumberFormatException("multiple `.'s in number");
                }
                dot = point;
            } else {
                if (c == 'e' || c == 'E') break;
                if (Character.digit(c, 10) < 0) {
                    throw new NumberFormatException("unrecognized character: " + c);
                }
            }
            ++point;
        }
        if (dot >= 0) {
            val = String.valueOf(num.substring(start, dot)) + num.substring(dot + 1, point);
            this.scale = point - 1 - dot;
        } else {
            val = num.substring(start, point);
            this.scale = 0;
        }
        if (val.length() == 0) {
            throw new NumberFormatException("no digits seen");
        }
        if (negative) {
            val = "-" + val;
        }
        this.intVal = new BigInteger(val);
        if (point < len) {
            if (num.charAt(++point) == '+') {
                ++point;
            }
            if (point >= len) {
                throw new NumberFormatException("no exponent following e or E");
            }
            try {
                this.scale -= Integer.parseInt(num.substring(point));
            }
            catch (NumberFormatException numberFormatException) {
                throw new NumberFormatException("malformed exponent");
            }
        }
    }

    public static BigDecimal valueOf(long val) {
        return BigDecimal.valueOf(val, 0);
    }

    public static BigDecimal valueOf(long val, int scale) throws NumberFormatException {
        if (scale == 0 && (long)((int)val) == val) {
            switch ((int)val) {
                case 0: {
                    return ZERO;
                }
                case 1: {
                    return ONE;
                }
            }
        }
        return new BigDecimal(BigInteger.valueOf(val), scale);
    }

    public BigDecimal add(BigDecimal val) {
        BigInteger op1 = this.intVal;
        BigInteger op2 = val.intVal;
        if (this.scale < val.scale) {
            op1 = op1.multiply(BigInteger.TEN.pow(val.scale - this.scale));
        } else if (this.scale > val.scale) {
            op2 = op2.multiply(BigInteger.TEN.pow(this.scale - val.scale));
        }
        return new BigDecimal(op1.add(op2), Math.max(this.scale, val.scale));
    }

    public BigDecimal add(BigDecimal val, MathContext mc) {
        return this.add(val).round(mc);
    }

    public BigDecimal subtract(BigDecimal val) {
        return this.add(val.negate());
    }

    public BigDecimal subtract(BigDecimal val, MathContext mc) {
        return this.subtract(val).round(mc);
    }

    public BigDecimal multiply(BigDecimal val) {
        return new BigDecimal(this.intVal.multiply(val.intVal), this.scale + val.scale);
    }

    public BigDecimal multiply(BigDecimal val, MathContext mc) {
        return this.multiply(val).round(mc);
    }

    public BigDecimal divide(BigDecimal val, int roundingMode) throws ArithmeticException, IllegalArgumentException {
        return this.divide(val, this.scale, roundingMode);
    }

    public BigDecimal divide(BigDecimal val, int scale, RoundingMode roundingMode) {
        return this.divide(val, scale, roundingMode.ordinal());
    }

    public BigDecimal divide(BigDecimal val, RoundingMode roundingMode) {
        return this.divide(val, this.scale, roundingMode.ordinal());
    }

    public BigDecimal divide(BigDecimal val, int newScale, int roundingMode) throws ArithmeticException, IllegalArgumentException {
        if (roundingMode < 0 || roundingMode > 7) {
            throw new IllegalArgumentException("illegal rounding mode: " + roundingMode);
        }
        if (this.intVal.signum() == 0) {
            return newScale == 0 ? ZERO : new BigDecimal(BigDecimal.ZERO.intVal, newScale);
        }
        BigInteger valIntVal = val.intVal;
        int power = newScale - (this.scale - val.scale);
        if (power < 0) {
            valIntVal = valIntVal.multiply(BigInteger.TEN.pow(-power));
            power = 0;
        }
        BigInteger dividend = this.intVal.multiply(BigInteger.TEN.pow(power));
        BigInteger[] parts = dividend.divideAndRemainder(valIntVal);
        BigInteger unrounded = parts[0];
        if (parts[1].signum() == 0) {
            return new BigDecimal(unrounded, newScale);
        }
        if (roundingMode == 7) {
            throw new ArithmeticException("Rounding necessary");
        }
        int sign = this.intVal.signum() * valIntVal.signum();
        if (roundingMode == 2) {
            roundingMode = sign > 0 ? 0 : 1;
        } else if (roundingMode == 3) {
            roundingMode = sign < 0 ? 0 : 1;
        } else {
            BigInteger posRemainder = parts[1].signum() < 0 ? parts[1].negate() : parts[1];
            valIntVal = valIntVal.signum() < 0 ? valIntVal.negate() : valIntVal;
            int half = posRemainder.shiftLeft(1).compareTo(valIntVal);
            switch (roundingMode) {
                case 4: {
                    roundingMode = half < 0 ? 1 : 0;
                    break;
                }
                case 5: {
                    roundingMode = half > 0 ? 0 : 1;
                    break;
                }
                case 6: {
                    roundingMode = half < 0 ? 1 : (half > 0 ? 0 : (unrounded.testBit(0) ? 0 : 1));
                }
            }
        }
        if (roundingMode == 0) {
            unrounded = unrounded.add(BigInteger.valueOf(sign > 0 ? 1 : -1));
        }
        return new BigDecimal(unrounded, newScale);
    }

    public BigDecimal divide(BigDecimal divisor) throws ArithmeticException, IllegalArgumentException {
        return this.divide(divisor, this.scale, 7);
    }

    public BigDecimal remainder(BigDecimal val) {
        return this.subtract(this.divideToIntegralValue(val).multiply(val));
    }

    public BigDecimal[] divideAndRemainder(BigDecimal val) {
        BigDecimal[] result;
        result = new BigDecimal[]{this.divideToIntegralValue(val), this.subtract(result[0].multiply(val))};
        return result;
    }

    public BigDecimal divideToIntegralValue(BigDecimal val) {
        return this.divide(val, 1).floor().setScale(this.scale - val.scale, 1);
    }

    private BigDecimal floor() {
        if (this.scale <= 0) {
            return this;
        }
        String intValStr = this.intVal.toString();
        intValStr = intValStr.substring(0, intValStr.length() - this.scale);
        this.intVal = new BigInteger(intValStr).multiply(BigInteger.TEN.pow(this.scale));
        return this;
    }

    @Override
    public int compareTo(BigDecimal val) {
        BigInteger[] valParts;
        if (this.scale == val.scale) {
            return this.intVal.compareTo(val.intVal);
        }
        BigInteger[] thisParts = this.intVal.divideAndRemainder(BigInteger.TEN.pow(this.scale));
        int compare = thisParts[0].compareTo((valParts = val.intVal.divideAndRemainder(BigInteger.TEN.pow(val.scale)))[0]);
        if (compare != 0) {
            return compare;
        }
        if (this.scale < val.scale) {
            thisParts[1] = thisParts[1].multiply(BigInteger.valueOf(10L).pow(val.scale - this.scale));
        } else if (this.scale > val.scale) {
            valParts[1] = valParts[1].multiply(BigInteger.valueOf(10L).pow(this.scale - val.scale));
        }
        return thisParts[1].compareTo(valParts[1]);
    }

    public boolean equals(Object o) {
        return o instanceof BigDecimal && this.scale == ((BigDecimal)o).scale && this.compareTo((BigDecimal)o) == 0;
    }

    public int hashCode() {
        return this.intValue() ^ this.scale;
    }

    public BigDecimal max(BigDecimal val) {
        switch (this.compareTo(val)) {
            case 1: {
                return this;
            }
        }
        return val;
    }

    public BigDecimal min(BigDecimal val) {
        switch (this.compareTo(val)) {
            case -1: {
                return this;
            }
        }
        return val;
    }

    public BigDecimal movePointLeft(int n) {
        return n < 0 ? this.movePointRight(-n) : new BigDecimal(this.intVal, this.scale + n);
    }

    public BigDecimal movePointRight(int n) {
        if (n < 0) {
            return this.movePointLeft(-n);
        }
        if (this.scale >= n) {
            return new BigDecimal(this.intVal, this.scale - n);
        }
        return new BigDecimal(this.intVal.multiply(BigInteger.TEN.pow(n - this.scale)), 0);
    }

    public int signum() {
        return this.intVal.signum();
    }

    public int scale() {
        return this.scale;
    }

    public BigInteger unscaledValue() {
        return this.intVal;
    }

    public BigDecimal abs() {
        return new BigDecimal(this.intVal.abs(), this.scale);
    }

    public BigDecimal negate() {
        return new BigDecimal(this.intVal.negate(), this.scale);
    }

    public BigDecimal negate(MathContext mc) {
        BigDecimal result = this.negate();
        if (mc.getPrecision() != 0) {
            result = result.round(mc);
        }
        return result;
    }

    public BigDecimal plus() {
        return this;
    }

    public BigDecimal plus(MathContext mc) {
        return this.round(mc);
    }

    public BigDecimal round(MathContext mc) {
        int mcPrecision = mc.getPrecision();
        int numToChop = this.precision() - mcPrecision;
        if (mcPrecision == 0 || numToChop <= 0) {
            return this;
        }
        BigDecimal div = new BigDecimal(BigInteger.TEN.pow(numToChop));
        BigDecimal rounded = this.divide(div, this.scale, mc.getRoundingMode().ordinal());
        rounded.scale -= numToChop;
        rounded.precision = mcPrecision;
        return rounded;
    }

    public int precision() {
        if (this.precision == 0) {
            String s = this.intVal.toString();
            this.precision = s.length() - (s.charAt(0) == '-' ? 1 : 0);
        }
        return this.precision;
    }

    public String toString() {
        String bigStr = this.intVal.toString();
        if (this.scale == 0) {
            return bigStr;
        }
        boolean negative = bigStr.charAt(0) == '-';
        int point = bigStr.length() - this.scale - (negative ? 1 : 0);
        CPStringBuilder val = new CPStringBuilder();
        if (this.scale >= 0 && point - 1 >= -6) {
            if (point <= 0) {
                if (negative) {
                    val.append('-');
                }
                val.append('0').append('.');
                while (point < 0) {
                    val.append('0');
                    ++point;
                }
                val.append(bigStr.substring(negative ? 1 : 0));
            } else {
                val.append(bigStr);
                val.insert(point + (negative ? 1 : 0), '.');
            }
        } else {
            val.append(bigStr);
            if (bigStr.length() > 1) {
                val.insert(negative ? 2 : 1, '.');
            }
            val.append('E');
            if (point - 1 >= 0) {
                val.append('+');
            }
            val.append(point - 1);
        }
        return val.toString();
    }

    public String toEngineeringString() {
        String bigStr = this.intVal.toString();
        if (this.scale == 0) {
            return bigStr;
        }
        boolean negative = bigStr.charAt(0) == '-';
        int point = bigStr.length() - this.scale - (negative ? 1 : 0);
        int adjExp = point - 1;
        CPStringBuilder val = new CPStringBuilder();
        if (this.scale >= 0 && adjExp >= -6) {
            if (point <= 0) {
                if (negative) {
                    val.append('-');
                }
                val.append('0').append('.');
                while (point < 0) {
                    val.append('0');
                    ++point;
                }
                val.append(bigStr.substring(negative ? 1 : 0));
            } else {
                val.append(bigStr);
                val.insert(point + (negative ? 1 : 0), '.');
            }
        } else {
            val.append(bigStr);
            int zeros = adjExp % 3;
            int dot = 1;
            if (adjExp > 0) {
                dot += zeros;
                adjExp -= zeros;
            } else if (zeros == -2) {
                ++dot;
                --adjExp;
            } else if (zeros == -1) {
                dot += 2;
                adjExp -= 2;
            }
            if (dot > val.length()) {
                while (dot > val.length()) {
                    val.append('0');
                }
            } else if (bigStr.length() > dot) {
                val.insert(dot + (negative ? 1 : 0), '.');
            }
            val.append('E');
            if (adjExp >= 0) {
                val.append('+');
            }
            val.append(adjExp);
        }
        return val.toString();
    }

    public String toPlainString() {
        String bigStr = this.intVal.toString();
        if (this.scale == 0) {
            return bigStr;
        }
        boolean negative = bigStr.charAt(0) == '-';
        int point = bigStr.length() - this.scale - (negative ? 1 : 0);
        CPStringBuilder sb = new CPStringBuilder(bigStr.length() + 2 + (point <= 0 ? -point + 1 : 0));
        if (point <= 0) {
            if (negative) {
                sb.append('-');
            }
            sb.append('0').append('.');
            while (point < 0) {
                sb.append('0');
                ++point;
            }
            sb.append(bigStr.substring(negative ? 1 : 0));
        } else if (point < bigStr.length()) {
            sb.append(bigStr);
            sb.insert(point + (negative ? 1 : 0), '.');
        } else {
            sb.append(bigStr);
            int i = bigStr.length();
            while (i < point) {
                sb.append('0');
                ++i;
            }
        }
        return sb.toString();
    }

    public BigInteger toBigInteger() {
        if (this.scale > 0) {
            return this.intVal.divide(BigInteger.TEN.pow(this.scale));
        }
        if (this.scale < 0) {
            return this.intVal.multiply(BigInteger.TEN.pow(-this.scale));
        }
        return this.intVal;
    }

    public BigInteger toBigIntegerExact() {
        if (this.scale > 0) {
            BigInteger[] result = this.intVal.divideAndRemainder(BigInteger.TEN.pow(this.scale));
            if (result[1].equals(BigInteger.ZERO)) {
                return result[0];
            }
            throw new ArithmeticException("No exact BigInteger representation");
        }
        if (this.scale < 0) {
            return this.intVal.multiply(BigInteger.TEN.pow(-this.scale));
        }
        return this.intVal;
    }

    @Override
    public int intValue() {
        return this.toBigInteger().intValue();
    }

    public BigDecimal stripTrailingZeros() {
        String intValStr = this.intVal.toString();
        int newScale = this.scale;
        int pointer = intValStr.length() - 1;
        while (intValStr.charAt(pointer) == '0') {
            --pointer;
            --newScale;
        }
        BigDecimal result = new BigDecimal(intValStr.substring(0, pointer + 1));
        result.scale = newScale;
        return result;
    }

    @Override
    public long longValue() {
        return this.toBigInteger().longValue();
    }

    @Override
    public float floatValue() {
        return Float.valueOf(this.toString()).floatValue();
    }

    @Override
    public double doubleValue() {
        return Double.valueOf(this.toString());
    }

    public BigDecimal setScale(int scale) throws ArithmeticException {
        return this.setScale(scale, 7);
    }

    public BigDecimal setScale(int scale, int roundingMode) throws ArithmeticException, IllegalArgumentException {
        if (scale < 0) {
            throw new ArithmeticException("Scale parameter < 0.");
        }
        return this.divide(ONE, scale, roundingMode);
    }

    public BigDecimal setScale(int newScale, RoundingMode roundingMode) {
        return this.setScale(newScale, roundingMode.ordinal());
    }

    public static BigDecimal valueOf(double val) {
        if (Double.isInfinite(val) || Double.isNaN(val)) {
            throw new NumberFormatException("argument cannot be NaN or infinite.");
        }
        return new BigDecimal(Double.toString(val));
    }

    public BigDecimal scaleByPowerOfTen(int n) {
        BigDecimal result = new BigDecimal(this.intVal, this.scale - n);
        result.precision = this.precision;
        return result;
    }

    public BigDecimal pow(int n) {
        if (n < 0 || n > 999999999) {
            throw new ArithmeticException("n must be between 0 and 999999999");
        }
        BigDecimal result = new BigDecimal(this.intVal.pow(n), this.scale * n);
        return result;
    }

    public BigDecimal pow(int n, MathContext mc) {
        return this.pow(n).round(mc);
    }

    public BigDecimal abs(MathContext mc) {
        BigDecimal result = this.abs();
        result = result.round(mc);
        return result;
    }

    public BigDecimal ulp() {
        return new BigDecimal(BigInteger.ONE, this.scale);
    }

    public long longValueExact() {
        BigDecimal temp = this.setScale(0, 7);
        BigInteger tempVal = temp.intVal;
        long result = this.intVal.longValue();
        if (tempVal.compareTo(BigInteger.valueOf(Long.MAX_VALUE)) > 1 || result < 0L && this.signum() == 1 || result > 0L && this.signum() == -1) {
            throw new ArithmeticException("this BigDecimal is too large to fit into the return type");
        }
        return this.intVal.longValue();
    }

    public int intValueExact() {
        long temp = this.longValueExact();
        int result = (int)temp;
        if ((long)result != temp) {
            throw new ArithmeticException("this BigDecimal cannot fit into an int");
        }
        return result;
    }

    public byte byteValueExact() {
        long temp = this.longValueExact();
        byte result = (byte)temp;
        if ((long)result != temp) {
            throw new ArithmeticException("this BigDecimal cannot fit into a byte");
        }
        return result;
    }

    public short shortValueExact() {
        long temp = this.longValueExact();
        short result = (short)temp;
        if ((long)result != temp) {
            throw new ArithmeticException("this BigDecimal cannot fit into a short");
        }
        return result;
    }
}

