/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.AWTKeyStroke;
import java.awt.Dimension;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.TextComponent;
import java.awt.peer.TextAreaPeer;
import java.io.Serializable;
import java.util.HashSet;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleStateSet;

public class TextArea
extends TextComponent
implements Serializable {
    public static final int SCROLLBARS_BOTH = 0;
    public static final int SCROLLBARS_VERTICAL_ONLY = 1;
    public static final int SCROLLBARS_HORIZONTAL_ONLY = 2;
    public static final int SCROLLBARS_NONE = 3;
    private static final long serialVersionUID = 3692302836626095722L;
    private int columns;
    private int rows;
    private int scrollbarVisibility;
    private static transient long next_text_number;

    public TextArea() {
        this("", 0, 0, 0);
    }

    public TextArea(String text) {
        this(text, 0, 0, 0);
    }

    public TextArea(int rows, int columns) {
        this("", rows, columns, 0);
    }

    public TextArea(String text, int rows, int columns) {
        this(text, rows, columns, 0);
    }

    public TextArea(String text, int rows, int columns, int scrollbarVisibility) {
        super(text);
        if (GraphicsEnvironment.isHeadless()) {
            throw new HeadlessException();
        }
        this.rows = rows < 0 ? 0 : rows;
        this.columns = columns < 0 ? 0 : columns;
        this.scrollbarVisibility = scrollbarVisibility < 0 || scrollbarVisibility > 4 ? 0 : scrollbarVisibility;
        HashSet s = new HashSet();
        s.add(AWTKeyStroke.getAWTKeyStroke(9, 128));
        this.setFocusTraversalKeys(0, s);
        s = new HashSet();
        s.add(AWTKeyStroke.getAWTKeyStroke(9, 192));
        this.setFocusTraversalKeys(1, s);
    }

    public int getColumns() {
        return this.columns;
    }

    public synchronized void setColumns(int columns) {
        if (columns < 0) {
            throw new IllegalArgumentException("Value is less than zero: " + columns);
        }
        this.columns = columns;
    }

    public int getRows() {
        return this.rows;
    }

    public synchronized void setRows(int rows) {
        if (rows < 1) {
            throw new IllegalArgumentException("Value is less than one: " + rows);
        }
        this.rows = rows;
    }

    public Dimension getMinimumSize() {
        return this.getMinimumSize(this.getRows(), this.getColumns());
    }

    public Dimension getMinimumSize(int rows, int columns) {
        return this.minimumSize(rows, columns);
    }

    public Dimension minimumSize() {
        return this.minimumSize(this.getRows(), this.getColumns());
    }

    public Dimension minimumSize(int rows, int columns) {
        if (this.isMinimumSizeSet()) {
            return new Dimension(this.minSize);
        }
        TextAreaPeer peer = (TextAreaPeer)this.getPeer();
        if (peer == null) {
            return new Dimension(this.getWidth(), this.getHeight());
        }
        return peer.getMinimumSize(rows, columns);
    }

    public Dimension getPreferredSize() {
        return this.getPreferredSize(this.getRows(), this.getColumns());
    }

    public Dimension getPreferredSize(int rows, int columns) {
        return this.preferredSize(rows, columns);
    }

    public Dimension preferredSize() {
        return this.preferredSize(this.getRows(), this.getColumns());
    }

    public Dimension preferredSize(int rows, int columns) {
        if (this.isPreferredSizeSet()) {
            return new Dimension(this.prefSize);
        }
        TextAreaPeer peer = (TextAreaPeer)this.getPeer();
        if (peer == null) {
            return new Dimension(this.getWidth(), this.getHeight());
        }
        return peer.getPreferredSize(rows, columns);
    }

    public int getScrollbarVisibility() {
        return this.scrollbarVisibility;
    }

    public void addNotify() {
        if (this.getPeer() == null) {
            this.setPeer(this.getToolkit().createTextArea(this));
        }
    }

    public void append(String str) {
        this.appendText(str);
    }

    public void appendText(String str) {
        TextAreaPeer peer = (TextAreaPeer)this.getPeer();
        if (peer != null) {
            peer.insert(str, peer.getText().length());
        } else {
            this.setText(String.valueOf(this.getText()) + str);
        }
    }

    public void insert(String str, int pos) {
        this.insertText(str, pos);
    }

    public void insertText(String str, int pos) {
        String tmp1 = null;
        String tmp2 = null;
        TextAreaPeer peer = (TextAreaPeer)this.getPeer();
        if (peer != null) {
            peer.insert(str, pos);
        } else {
            tmp1 = this.getText().substring(0, pos);
            tmp2 = this.getText().substring(pos, this.getText().length());
            this.setText(String.valueOf(tmp1) + str + tmp2);
        }
    }

    public void replaceRange(String str, int start, int end) {
        this.replaceText(str, start, end);
    }

    public void replaceText(String str, int start, int end) {
        String tmp1 = null;
        String tmp2 = null;
        TextAreaPeer peer = (TextAreaPeer)this.getPeer();
        if (peer != null) {
            peer.replaceRange(str, start, end);
        } else {
            tmp1 = this.getText().substring(0, start);
            tmp2 = this.getText().substring(end, this.getText().length());
            this.setText(String.valueOf(tmp1) + str + tmp2);
        }
    }

    protected String paramString() {
        String sbVisibility = "";
        switch (this.scrollbarVisibility) {
            case 0: {
                sbVisibility = "both";
                break;
            }
            case 1: {
                sbVisibility = "vertical-only";
                break;
            }
            case 2: {
                sbVisibility = "horizontal-only";
                break;
            }
            case 3: {
                sbVisibility = "none";
            }
        }
        String editable = "";
        if (this.isEditable()) {
            editable = "editable,";
        }
        return String.valueOf(this.getName()) + "," + this.getX() + "," + this.getY() + "," + this.getWidth() + "x" + this.getHeight() + "," + "text=" + this.getText() + "," + editable + "selection=" + this.getSelectionStart() + "-" + this.getSelectionEnd() + ",rows=" + this.rows + ",columns=" + this.columns + ",scrollbarVisibility=" + sbVisibility;
    }

    String generateName() {
        return "text" + TextArea.getUniqueLong();
    }

    private static synchronized long getUniqueLong() {
        return next_text_number++;
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleAWTTextArea();
        }
        return this.accessibleContext;
    }

    protected class AccessibleAWTTextArea
    extends TextComponent.AccessibleAWTTextComponent {
        private static final long serialVersionUID = 3472827823632144419L;

        protected AccessibleAWTTextArea() {
        }

        public AccessibleStateSet getAccessibleStateSet() {
            return super.getAccessibleStateSet();
        }
    }
}

