/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.security.x509;

import gnu.java.security.OID;
import gnu.java.security.der.BitString;
import gnu.java.security.der.DERReader;
import gnu.java.security.der.DERValue;
import gnu.java.security.x509.GnuPKIExtension;
import gnu.java.security.x509.X500DistinguishedName;
import gnu.java.security.x509.X509CRLEntry;
import gnu.java.security.x509.ext.Extension;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Principal;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.CRLException;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Logger;
import javax.security.auth.x500.X500Principal;

public class X509CRL
extends java.security.cert.X509CRL
implements GnuPKIExtension {
    private static final Logger log = Logger.getLogger(X509CRL.class.getName());
    private static final OID ID_DSA = new OID("1.2.840.10040.4.1");
    private static final OID ID_DSA_WITH_SHA1 = new OID("1.2.840.10040.4.3");
    private static final OID ID_RSA = new OID("1.2.840.113549.1.1.1");
    private static final OID ID_RSA_WITH_MD2 = new OID("1.2.840.113549.1.1.2");
    private static final OID ID_RSA_WITH_MD5 = new OID("1.2.840.113549.1.1.4");
    private static final OID ID_RSA_WITH_SHA1 = new OID("1.2.840.113549.1.1.5");
    private byte[] encoded;
    private byte[] tbsCRLBytes;
    private int version;
    private OID algId;
    private byte[] algParams;
    private Date thisUpdate;
    private Date nextUpdate;
    private X500DistinguishedName issuerDN;
    private HashMap revokedCerts = new HashMap();
    private HashMap extensions = new HashMap();
    private OID sigAlg;
    private byte[] sigAlgParams;
    private byte[] rawSig;
    private byte[] signature;

    public X509CRL(InputStream encoded) throws CRLException, IOException {
        try {
            this.parse(encoded);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            throw ioe;
        }
        catch (Exception x) {
            x.printStackTrace();
            throw new CRLException(x.toString());
        }
    }

    public boolean equals(Object o) {
        if (!(o instanceof X509CRL)) {
            return false;
        }
        return ((X509CRL)o).getRevokedCertificates().equals(this.revokedCerts.values());
    }

    public int hashCode() {
        return this.revokedCerts.hashCode();
    }

    public byte[] getEncoded() throws CRLException {
        return (byte[])this.encoded.clone();
    }

    public void verify(PublicKey key) throws CRLException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException {
        Signature sig = Signature.getInstance(this.sigAlg.toString());
        this.doVerify(sig, key);
    }

    public void verify(PublicKey key, String provider) throws CRLException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException {
        Signature sig = Signature.getInstance(this.sigAlg.toString(), provider);
        this.doVerify(sig, key);
    }

    public int getVersion() {
        return this.version;
    }

    public Principal getIssuerDN() {
        return this.issuerDN;
    }

    public X500Principal getIssuerX500Principal() {
        return new X500Principal(this.issuerDN.getDer());
    }

    public Date getThisUpdate() {
        return (Date)this.thisUpdate.clone();
    }

    public Date getNextUpdate() {
        if (this.nextUpdate != null) {
            return (Date)this.nextUpdate.clone();
        }
        return null;
    }

    public java.security.cert.X509CRLEntry getRevokedCertificate(BigInteger serialNo) {
        return (java.security.cert.X509CRLEntry)this.revokedCerts.get(serialNo);
    }

    public Set getRevokedCertificates() {
        return Collections.unmodifiableSet(new HashSet(this.revokedCerts.values()));
    }

    public byte[] getTBSCertList() throws CRLException {
        return (byte[])this.tbsCRLBytes.clone();
    }

    public byte[] getSignature() {
        return (byte[])this.rawSig.clone();
    }

    public String getSigAlgName() {
        if (this.sigAlg.equals(ID_DSA_WITH_SHA1)) {
            return "SHA1withDSA";
        }
        if (this.sigAlg.equals(ID_RSA_WITH_MD2)) {
            return "MD2withRSA";
        }
        if (this.sigAlg.equals(ID_RSA_WITH_MD5)) {
            return "MD5withRSA";
        }
        if (this.sigAlg.equals(ID_RSA_WITH_SHA1)) {
            return "SHA1withRSA";
        }
        return "unknown";
    }

    public String getSigAlgOID() {
        return this.sigAlg.toString();
    }

    public byte[] getSigAlgParams() {
        if (this.sigAlgParams != null) {
            return (byte[])this.sigAlgParams.clone();
        }
        return null;
    }

    public boolean hasUnsupportedCriticalExtension() {
        for (Extension e : this.extensions.values()) {
            if (!e.isCritical() || e.isSupported()) continue;
            return true;
        }
        return false;
    }

    public Set getCriticalExtensionOIDs() {
        HashSet<String> s = new HashSet<String>();
        for (Extension e : this.extensions.values()) {
            if (!e.isCritical()) continue;
            s.add(e.getOid().toString());
        }
        return Collections.unmodifiableSet(s);
    }

    public Set getNonCriticalExtensionOIDs() {
        HashSet<String> s = new HashSet<String>();
        for (Extension e : this.extensions.values()) {
            if (e.isCritical()) continue;
            s.add(e.getOid().toString());
        }
        return Collections.unmodifiableSet(s);
    }

    public byte[] getExtensionValue(String oid) {
        Extension e = this.getExtension(new OID(oid));
        if (e != null) {
            return e.getValue().getEncoded();
        }
        return null;
    }

    public Extension getExtension(OID oid) {
        return (Extension)this.extensions.get(oid);
    }

    public Collection getExtensions() {
        return this.extensions.values();
    }

    public String toString() {
        return X509CRL.class.getName();
    }

    public boolean isRevoked(Certificate cert) {
        if (!(cert instanceof X509Certificate)) {
            throw new IllegalArgumentException("not a X.509 certificate");
        }
        BigInteger certSerial = ((X509Certificate)cert).getSerialNumber();
        X509CRLEntry ent = (X509CRLEntry)this.revokedCerts.get(certSerial);
        if (ent == null) {
            return false;
        }
        return ent.getRevocationDate().compareTo(new Date()) < 0;
    }

    private void doVerify(Signature sig, PublicKey key) throws CRLException, InvalidKeyException, SignatureException {
        sig.initVerify(key);
        sig.update(this.tbsCRLBytes);
        if (!sig.verify(this.signature)) {
            throw new CRLException("signature not verified");
        }
    }

    private void parse(InputStream in) throws Exception {
        DERReader der = new DERReader(in);
        DERValue val = der.read();
        if (!val.isConstructed()) {
            throw new IOException("malformed CertificateList");
        }
        this.encoded = val.getEncoded();
        val = der.read();
        if (!val.isConstructed()) {
            throw new IOException("malformed TBSCertList");
        }
        this.tbsCRLBytes = val.getEncoded();
        val = der.read();
        if (val.getValue() instanceof BigInteger) {
            this.version = ((BigInteger)val.getValue()).intValue() + 1;
            val = der.read();
        } else {
            this.version = 1;
        }
        if (!val.isConstructed()) {
            throw new IOException("malformed AlgorithmIdentifier");
        }
        DERValue algIdVal = der.read();
        this.algId = (OID)algIdVal.getValue();
        if (val.getLength() > algIdVal.getEncodedLength()) {
            val = der.read();
            this.algParams = val.getEncoded();
            if (val.isConstructed()) {
                in.skip(val.getLength());
            }
        }
        val = der.read();
        this.issuerDN = new X500DistinguishedName(val.getEncoded());
        der.skip(val.getLength());
        this.thisUpdate = (Date)der.read().getValue();
        val = der.read();
        if (val.getValue() instanceof Date) {
            this.nextUpdate = (Date)val.getValue();
            val = der.read();
        }
        if (val.getTag() != 0) {
            int len = 0;
            while (len < val.getLength()) {
                X509CRLEntry entry = new X509CRLEntry(this.version, der);
                this.revokedCerts.put(entry.getSerialNumber(), entry);
                len += entry.getEncoded().length;
            }
            val = der.read();
        }
        if (val.getTagClass() != 0 && val.getTag() == 0) {
            if (this.version < 2) {
                throw new IOException("extra data in CRL");
            }
            DERValue exts = der.read();
            if (!exts.isConstructed()) {
                throw new IOException("malformed Extensions");
            }
            int len = 0;
            while (len < exts.getLength()) {
                DERValue ext = der.read();
                if (!ext.isConstructed()) {
                    throw new IOException("malformed Extension");
                }
                Extension e = new Extension(ext.getEncoded());
                this.extensions.put(e.getOid(), e);
                der.skip(ext.getLength());
                len += ext.getEncodedLength();
            }
            val = der.read();
        }
        if (!val.isConstructed()) {
            throw new IOException("malformed AlgorithmIdentifier");
        }
        DERValue sigAlgVal = der.read();
        if (sigAlgVal.getTag() != 6) {
            throw new IOException("malformed AlgorithmIdentifier");
        }
        this.sigAlg = (OID)sigAlgVal.getValue();
        if (val.getLength() > sigAlgVal.getEncodedLength()) {
            val = der.read();
            this.sigAlgParams = val.getEncoded();
            if (val.isConstructed()) {
                in.skip(val.getLength());
            }
        }
        val = der.read();
        this.rawSig = val.getEncoded();
        this.signature = ((BitString)val.getValue()).toByteArray();
    }
}

