/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.awt.font;

import gnu.java.awt.font.FontDelegate;
import gnu.java.awt.font.FontFactory;
import gnu.java.awt.peer.ClasspathFontPeer;
import gnu.java.lang.CPStringBuilder;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.font.LineMetrics;
import java.awt.font.TextAttribute;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.text.CharacterIterator;
import java.text.StringCharacterIterator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OpenTypeFontPeer
extends ClasspathFontPeer {
    private static Properties fontProperties = new Properties();
    private static Set<String> availableFontNames;
    private static Map<String, Map<String, String>> fontToFileMap;
    private static final AffineTransform IDENDITY;
    private FontDelegate fontDelegate;

    static {
        InputStream in = OpenTypeFontPeer.class.getResourceAsStream("fonts.properties");
        try {
            fontProperties.load(in);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        IDENDITY = new AffineTransform();
    }

    public OpenTypeFontPeer(String name, int style, int size) {
        super(name, style, size);
        try {
            String fontSpec = OpenTypeFontPeer.encodeFont(name, style);
            String filename = this.mapFontToFilename(fontSpec);
            File fontfile = new File(filename);
            FileInputStream in = new FileInputStream(fontfile);
            FileChannel ch = in.getChannel();
            MappedByteBuffer buffer = ch.map(FileChannel.MapMode.READ_ONLY, 0L, fontfile.length());
            this.fontDelegate = FontFactory.createFonts(buffer)[0];
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public OpenTypeFontPeer(String name, Map atts) {
        super(name, atts);
        try {
            String fontSpec = OpenTypeFontPeer.encodeFont(name, atts);
            String filename = this.mapFontToFilename(fontSpec);
            File fontfile = new File(filename);
            FileInputStream in = new FileInputStream(fontfile);
            FileChannel ch = in.getChannel();
            MappedByteBuffer buffer = ch.map(FileChannel.MapMode.READ_ONLY, 0L, fontfile.length());
            this.fontDelegate = FontFactory.createFonts(buffer)[0];
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public boolean canDisplay(Font font, int c) {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    @Override
    public int canDisplayUpTo(Font font, CharacterIterator i, int start, int limit) {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    @Override
    public String getSubFamilyName(Font font, Locale locale) {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    @Override
    public String getPostScriptName(Font font) {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    @Override
    public int getNumGlyphs(Font font) {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    @Override
    public int getMissingGlyphCode(Font font) {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    @Override
    public byte getBaselineFor(Font font, char c) {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    @Override
    public String getGlyphName(Font font, int glyphIndex) {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    @Override
    public GlyphVector createGlyphVector(Font font, FontRenderContext frc, CharacterIterator ci) {
        return this.fontDelegate.createGlyphVector(font, frc, ci);
    }

    @Override
    public GlyphVector createGlyphVector(Font font, FontRenderContext ctx, int[] glyphCodes) {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    @Override
    public GlyphVector layoutGlyphVector(Font font, FontRenderContext frc, char[] chars, int start, int limit, int flags) {
        StringCharacterIterator i = new StringCharacterIterator(new String(chars), start, limit, 0);
        return this.fontDelegate.createGlyphVector(font, frc, i);
    }

    @Override
    public FontMetrics getFontMetrics(Font font) {
        return new XFontMetrics(font);
    }

    @Override
    public boolean hasUniformLineMetrics(Font font) {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    @Override
    public LineMetrics getLineMetrics(Font font, CharacterIterator ci, int begin, int limit, FontRenderContext rc) {
        return new XLineMetrics(font, ci, begin, limit, rc);
    }

    @Override
    public Rectangle2D getMaxCharBounds(Font font, FontRenderContext rc) {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    public static String encodeFont(String name, Map atts) {
        Float weight;
        String family = name;
        if (family == null || family.equals("")) {
            family = (String)atts.get(TextAttribute.FAMILY);
        }
        if (family == null) {
            family = "SansSerif";
        }
        int style = 0;
        Float posture = (Float)atts.get(TextAttribute.POSTURE);
        if (posture != null && !posture.equals(TextAttribute.POSTURE_REGULAR)) {
            style |= 2;
        }
        if ((weight = (Float)atts.get(TextAttribute.WEIGHT)) != null && weight.compareTo(TextAttribute.WEIGHT_REGULAR) > 0) {
            style |= 1;
        }
        return OpenTypeFontPeer.encodeFont(name, style);
    }

    static String encodeFont(String name, int style) {
        CPStringBuilder key = new CPStringBuilder();
        key.append(OpenTypeFontPeer.validName(name));
        key.append('/');
        switch (style) {
            case 1: {
                key.append("b");
                break;
            }
            case 2: {
                key.append("i");
                break;
            }
            case 3: {
                key.append("bi");
                break;
            }
            default: {
                key.append("p");
            }
        }
        return key.toString();
    }

    static String validName(String name) {
        Set<String> fontNames = OpenTypeFontPeer.getFontNames();
        String retVal = fontNames.contains(name) ? name : "SansSerif";
        return retVal;
    }

    public static String[] getAvailableFontFamilyNames(Locale l) {
        Set<String> fontNames = OpenTypeFontPeer.getFontNames();
        int numNames = fontNames.size();
        String[] ret = fontNames.toArray(new String[numNames]);
        return ret;
    }

    private static synchronized Set<String> getFontNames() {
        if (availableFontNames == null) {
            HashSet<String> familyNames = new HashSet<String>();
            for (Object o : fontProperties.keySet()) {
                if (!(o instanceof String)) continue;
                String key = (String)o;
                int slashIndex = key.indexOf(47);
                String name = key.substring(0, slashIndex);
                familyNames.add(name);
            }
            availableFontNames = familyNames;
        }
        return availableFontNames;
    }

    private synchronized String mapFontToFilename(String fontSpec) {
        if (fontToFileMap == null) {
            String spec;
            String name;
            int slashIndex;
            String key;
            fontToFileMap = new HashMap<String, Map<String, String>>();
            for (Object o : fontProperties.keySet()) {
                if (!(o instanceof String)) continue;
                key = (String)o;
                slashIndex = key.indexOf(47);
                name = key.substring(0, slashIndex);
                spec = key.substring(slashIndex + 1);
                if (spec.equals("a")) continue;
                Map<String, String> specToFileMap = fontToFileMap.get(name);
                if (specToFileMap == null) {
                    specToFileMap = new HashMap<String, String>();
                    fontToFileMap.put(name, specToFileMap);
                }
                specToFileMap.put(spec, fontProperties.getProperty(key));
            }
            for (Object o : fontProperties.keySet()) {
                if (!(o instanceof String)) continue;
                key = (String)o;
                slashIndex = key.indexOf(47);
                name = key.substring(0, slashIndex);
                spec = key.substring(slashIndex + 1);
                if (!spec.equals("a")) continue;
                String alias = fontProperties.getProperty(key);
                Map<String, String> specToFileMap = fontToFileMap.get(alias);
                fontToFileMap.put(name, specToFileMap);
            }
        }
        int slashIndex = fontSpec.indexOf(47);
        String name = fontSpec.substring(0, slashIndex);
        String spec = fontSpec.substring(slashIndex + 1);
        return fontToFileMap.get(name).get(spec);
    }

    private class XFontMetrics
    extends FontMetrics {
        private Point2D cachedPoint;

        XFontMetrics(Font f) {
            super(f);
            this.cachedPoint = new Point2D.Double();
        }

        public int getAscent() {
            return (int)OpenTypeFontPeer.this.fontDelegate.getAscent(this.getFont().getSize(), IDENDITY, false, false, false);
        }

        public int getDescent() {
            return (int)OpenTypeFontPeer.this.fontDelegate.getDescent(this.getFont().getSize(), IDENDITY, false, false, false);
        }

        public int getHeight() {
            GlyphVector gv = OpenTypeFontPeer.this.fontDelegate.createGlyphVector(this.getFont(), new FontRenderContext(IDENDITY, false, false), new StringCharacterIterator("m"));
            Rectangle2D b = gv.getVisualBounds();
            return (int)b.getHeight();
        }

        public int charWidth(char c) {
            int code = OpenTypeFontPeer.this.fontDelegate.getGlyphIndex(c);
            Point2D advance = this.cachedPoint;
            OpenTypeFontPeer.this.fontDelegate.getAdvance(code, this.font.getSize2D(), IDENDITY, false, false, true, advance);
            return (int)advance.getX();
        }

        public int charsWidth(char[] chars, int offs, int len) {
            return this.stringWidth(new String(chars, offs, len));
        }

        public int stringWidth(String s) {
            GlyphVector gv = OpenTypeFontPeer.this.fontDelegate.createGlyphVector(this.getFont(), new FontRenderContext(IDENDITY, false, false), new StringCharacterIterator(s));
            Rectangle2D b = gv.getVisualBounds();
            return (int)b.getWidth();
        }
    }

    private class XLineMetrics
    extends LineMetrics {
        private Font font;
        private GlyphVector glyphVector;
        private FontRenderContext fontRenderContext;

        XLineMetrics(Font f, CharacterIterator ci, int b, int l, FontRenderContext rc) {
            this.font = f;
            this.fontRenderContext = rc;
            this.glyphVector = OpenTypeFontPeer.this.fontDelegate.createGlyphVector(this.font, this.fontRenderContext, ci);
        }

        public float getAscent() {
            return OpenTypeFontPeer.this.fontDelegate.getAscent(this.font.getSize(), this.fontRenderContext.getTransform(), this.fontRenderContext.isAntiAliased(), this.fontRenderContext.usesFractionalMetrics(), true);
        }

        public int getBaselineIndex() {
            throw new UnsupportedOperationException("Not yet implemented");
        }

        public float[] getBaselineOffsets() {
            throw new UnsupportedOperationException("Not yet implemented");
        }

        public float getDescent() {
            return (int)OpenTypeFontPeer.this.fontDelegate.getDescent(this.font.getSize(), IDENDITY, false, false, false);
        }

        public float getHeight() {
            return (float)this.glyphVector.getLogicalBounds().getHeight();
        }

        public float getLeading() {
            return this.getHeight() - this.getAscent() - this.getDescent();
        }

        public int getNumChars() {
            throw new UnsupportedOperationException("Not yet implemented");
        }

        public float getStrikethroughOffset() {
            return 0.0f;
        }

        public float getStrikethroughThickness() {
            return 0.0f;
        }

        public float getUnderlineOffset() {
            return 0.0f;
        }

        public float getUnderlineThickness() {
            return 0.0f;
        }
    }
}

