/*
 * Decompiled with CFR 0.152.
 */
package gnu.awt.xlib;

import gnu.awt.j2d.DirectRasterGraphics;
import gnu.awt.j2d.MappedRaster;
import gnu.awt.xlib.XFontMetrics;
import gnu.awt.xlib.XGraphicsConfiguration;
import gnu.awt.xlib.XOffScreenImage;
import gnu.gcj.xlib.Drawable;
import gnu.gcj.xlib.GC;
import gnu.gcj.xlib.Pixmap;
import gnu.gcj.xlib.Visual;
import gnu.gcj.xlib.XImage;
import java.awt.AWTError;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DataBuffer;
import java.awt.image.ImageObserver;
import java.awt.image.WritableRaster;

public class XGraphics
implements Cloneable,
DirectRasterGraphics {
    GC context;
    XGraphicsConfiguration config;
    Rectangle clipBounds;
    XFontMetrics metrics;

    public Object clone() {
        try {
            XGraphics gfxCopy = (XGraphics)super.clone();
            gfxCopy.context = this.context.create();
            return gfxCopy;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public void dispose() {
        GC lContext = this.context;
        this.context = null;
        this.config = null;
        this.clipBounds = null;
        this.metrics = null;
        if (lContext != null) {
            lContext.dispose();
        }
    }

    public XGraphics(Drawable drawable, XGraphicsConfiguration config) {
        this.context = GC.create(drawable);
        this.config = config;
    }

    public void setColor(Color color) {
        if (color != null) {
            this.context.setForeground(this.config.getPixel(color));
        }
    }

    public void setPaintMode() {
        throw new UnsupportedOperationException("not implemented");
    }

    public void setXORMode(Color c1) {
        throw new UnsupportedOperationException("not implemented");
    }

    public void setFont(Font font) {
        if (font == null) {
            return;
        }
        if (this.metrics != null && font.equals(this.metrics.getFont())) {
            return;
        }
        this.metrics = this.config.getXFontMetrics(font);
        if (this.metrics != null) {
            this.context.setFont(this.metrics.xfont);
        }
    }

    public FontMetrics getFontMetrics(Font font) {
        if (this.metrics != null && font.equals(this.metrics.getFont())) {
            return this.metrics;
        }
        return this.config.getXFontMetrics(font);
    }

    public void setClip(int x, int y, int width, int height) {
        Rectangle[] rects = new Rectangle[]{new Rectangle(x, y, width, height)};
        this.context.setClipRectangles(rects);
    }

    public void setClip(Shape clip) {
        Rectangle newClipBounds;
        this.clipBounds = newClipBounds = clip.getBounds();
        Rectangle[] rects = new Rectangle[]{this.clipBounds};
        this.context.setClipRectangles(rects);
    }

    public void copyArea(int x, int y, int width, int height, int dx, int dy) {
        throw new UnsupportedOperationException("not implemented");
    }

    public void drawLine(int x1, int y1, int x2, int y2) {
        this.context.drawLine(x1, y1, x2, y2);
    }

    public void drawRect(int x, int y, int width, int height) {
        throw new UnsupportedOperationException("not implemented yet");
    }

    public void fillRect(int x, int y, int width, int height) {
        this.context.fillRectangle(x, y, width, height);
    }

    public void drawArc(int x, int y, int width, int height, int startAngle, int arcAngle) {
        this.context.drawArc(x, y, width, height, startAngle, arcAngle);
    }

    public void fillArc(int x, int y, int width, int height, int startAngle, int arcAngle) {
        this.context.fillArc(x, y, width, height, startAngle, arcAngle);
    }

    public void drawPolyline(int[] xPoints, int[] yPoints, int nPoints) {
        throw new UnsupportedOperationException("not implemented");
    }

    public void drawPolygon(int[] xPoints, int[] yPoints, int nPoints) {
        throw new UnsupportedOperationException("not implemented");
    }

    public void fillPolygon(int[] xPoints, int[] yPoints, int nPoints, int translateX, int translateY) {
        this.context.fillPolygon(xPoints, yPoints, nPoints, translateX, translateY);
    }

    public void drawString(String str, int x, int y) {
        this.context.drawString(str, x, y);
    }

    public boolean drawImage(Image img, int x, int y, ImageObserver observer) {
        if (img instanceof XOffScreenImage) {
            XOffScreenImage offScreenImage = (XOffScreenImage)img;
            Pixmap pixmap = offScreenImage.getPixmap();
            this.context.copyArea(pixmap, 0, 0, x, y, offScreenImage.getWidth(), offScreenImage.getHeight());
            return true;
        }
        if (this.clipBounds == null) {
            return false;
        }
        if (!(img instanceof BufferedImage)) {
            throw new AWTError("unknown image class");
        }
        BufferedImage bimg = (BufferedImage)img;
        XImage ximg = (XImage)bimg.getProperty("gnu.gcj.xlib.XImage");
        if (ximg == null) {
            System.err.println("FIXME: skipping null XImage, should really do on the spot conversion");
            return false;
        }
        int iLeft = Math.max(x, this.clipBounds.x);
        int iTop = Math.max(y, this.clipBounds.y);
        int iRight = Math.min(x + bimg.getWidth(), this.clipBounds.x + this.clipBounds.width);
        int iBottom = Math.min(y + bimg.getHeight(), this.clipBounds.y + this.clipBounds.height);
        int srcX = iLeft - x;
        int srcY = iTop - y;
        int width = iRight - iLeft;
        int height = iBottom - iTop;
        if (width > 0 && height > 0) {
            this.context.putImage(ximg, srcX, srcY, iLeft, iTop, width, height);
        }
        return true;
    }

    public MappedRaster mapRaster(Rectangle bounds) {
        Visual visual = this.config.getVisual();
        XImage ximage = new XImage(visual, bounds.width, bounds.height, false);
        WritableRaster raster = this.config.createRasterForXImage(ximage, new Point(bounds.x, bounds.y));
        DataBuffer dataB = raster.getDataBuffer();
        XGraphicsConfiguration.attachData(ximage, dataB, 0);
        Drawable drawable = this.context.getDrawable();
        drawable.copyIntoXImage(ximage, bounds, 0, 0);
        return new XRaster(raster, ximage, this.config.imageCM);
    }

    public void unmapRaster(MappedRaster mappedRaster) {
        XRaster xraster = (XRaster)mappedRaster;
        XImage ximage = xraster.ximage;
        WritableRaster raster = xraster.getRaster();
        int x = raster.getMinX();
        int y = raster.getMinY();
        int width = raster.getWidth();
        int height = raster.getHeight();
        this.context.putImage(ximage, 0, 0, x, y, width, height);
    }

    static class XRaster
    extends MappedRaster {
        XImage ximage;

        public XRaster(WritableRaster raster, XImage ximage, ColorModel cm) {
            super(raster, cm);
            this.ximage = ximage;
        }
    }
}

