/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.asm.attrs;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.objectweb.asm.Attribute;
import org.objectweb.asm.ByteVector;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Label;
import org.objectweb.asm.attrs.StackMapFrame;
import org.objectweb.asm.attrs.StackMapType;

public class StackMapAttribute
extends Attribute {
    static final int MAX_SIZE = 65535;
    public List frames = new ArrayList();

    public StackMapAttribute() {
        super("StackMap");
    }

    public StackMapAttribute(List frames) {
        this();
        this.frames = frames;
    }

    public List getFrames() {
        return this.frames;
    }

    public StackMapFrame getFrame(Label label) {
        int i = 0;
        while (i < this.frames.size()) {
            StackMapFrame frame = (StackMapFrame)this.frames.get(i);
            if (frame.label == label) {
                return frame;
            }
            ++i;
        }
        return null;
    }

    public boolean isUnknown() {
        return false;
    }

    public boolean isCodeAttribute() {
        return true;
    }

    protected Attribute read(ClassReader cr, int off, int len, char[] buf, int codeOff, Label[] labels) {
        StackMapAttribute attr = new StackMapAttribute();
        boolean isExtCodeSize = cr.readInt(codeOff + 4) > 65535;
        boolean isExtLocals = cr.readUnsignedShort(codeOff + 2) > 65535;
        boolean isExtStack = cr.readUnsignedShort(codeOff) > 65535;
        int size = 0;
        if (isExtCodeSize) {
            size = cr.readInt(off);
            off += 4;
        } else {
            size = cr.readUnsignedShort(off);
            off += 2;
        }
        int i = 0;
        while (i < size) {
            int offset;
            if (isExtCodeSize) {
                offset = cr.readInt(off);
                off += 4;
            } else {
                offset = cr.readUnsignedShort(off);
                off += 2;
            }
            Label label = this.getLabel(offset, labels);
            ArrayList locals = new ArrayList();
            ArrayList stack = new ArrayList();
            off = this.readTypeInfo(cr, off, locals, labels, buf, isExtLocals, isExtCodeSize);
            off = this.readTypeInfo(cr, off, stack, labels, buf, isExtStack, isExtCodeSize);
            attr.frames.add(new StackMapFrame(label, locals, stack));
            ++i;
        }
        return attr;
    }

    private int readTypeInfo(ClassReader cr, int off, List info, Label[] labels, char[] buf, boolean isExt, boolean isExtCode) {
        int n = 0;
        if (isExt) {
            n = cr.readInt(off);
            off += 4;
        } else {
            n = cr.readUnsignedShort(off);
            off += 2;
        }
        int j = 0;
        while (j < n) {
            int itemType = cr.readByte(off++);
            StackMapType typeInfo = StackMapType.getTypeInfo(itemType);
            info.add(typeInfo);
            switch (itemType) {
                case 7: {
                    typeInfo.setObject(cr.readClass(off, buf));
                    off += 2;
                    break;
                }
                case 8: {
                    int offset;
                    if (isExtCode) {
                        offset = cr.readInt(off);
                        off += 4;
                    } else {
                        offset = cr.readUnsignedShort(off);
                        off += 2;
                    }
                    typeInfo.setLabel(this.getLabel(offset, labels));
                }
            }
            ++j;
        }
        return off;
    }

    private void writeTypeInfo(ByteVector bv, ClassWriter cw, List info, int max) {
        if (max > 65535) {
            bv.putInt(info.size());
        } else {
            bv.putShort(info.size());
        }
        int j = 0;
        while (j < info.size()) {
            StackMapType typeInfo = (StackMapType)info.get(j);
            bv.putByte(typeInfo.getType());
            switch (typeInfo.getType()) {
                case 7: {
                    bv.putShort(cw.newClass(typeInfo.getObject()));
                    break;
                }
                case 8: {
                    bv.putShort(typeInfo.getLabel().getOffset());
                }
            }
            ++j;
        }
    }

    private Label getLabel(int offset, Label[] labels) {
        Label l = labels[offset];
        if (l != null) {
            return l;
        }
        labels[offset] = new Label();
        return labels[offset];
    }

    protected ByteVector write(ClassWriter cw, byte[] code, int len, int maxStack, int maxLocals) {
        ByteVector bv = new ByteVector();
        if (code != null && code.length > 65535) {
            bv.putInt(this.frames.size());
        } else {
            bv.putShort(this.frames.size());
        }
        int i = 0;
        while (i < this.frames.size()) {
            this.writeFrame((StackMapFrame)this.frames.get(i), cw, maxStack, maxLocals, bv);
            ++i;
        }
        return bv;
    }

    protected Label[] getLabels() {
        HashSet labels = new HashSet();
        int i = 0;
        while (i < this.frames.size()) {
            this.getFrameLabels((StackMapFrame)this.frames.get(i), labels);
            ++i;
        }
        return labels.toArray(new Label[labels.size()]);
    }

    private void writeFrame(StackMapFrame frame, ClassWriter cw, int maxStack, int maxLocals, ByteVector bv) {
        bv.putShort(frame.label.getOffset());
        this.writeTypeInfo(bv, cw, frame.locals, maxLocals);
        this.writeTypeInfo(bv, cw, frame.stack, maxStack);
    }

    private void getFrameLabels(StackMapFrame frame, Set labels) {
        labels.add(frame.label);
        this.getTypeInfoLabels(labels, frame.locals);
        this.getTypeInfoLabels(labels, frame.stack);
    }

    private void getTypeInfoLabels(Set labels, List info) {
        for (StackMapType typeInfo : info) {
            if (typeInfo.getType() != 8) continue;
            labels.add(typeInfo.getLabel());
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("StackMap[");
        int i = 0;
        while (i < this.frames.size()) {
            sb.append('\n').append('[').append(this.frames.get(i)).append(']');
            ++i;
        }
        sb.append("\n]");
        return sb.toString();
    }
}

