#!/bin/sh
config() {
  NEW="$1"
  OLD="$(dirname $NEW)/$(basename $NEW .new)"
  # If there's no config file by that name, mv it over:
  if [ ! -r $OLD ]; then
    mv $NEW $OLD
  elif [ "$(cat $OLD | md5sum)" = "$(cat $NEW | md5sum)" ]; then # toss the redundant copy
    rm $NEW
  fi
  # Otherwise, we leave the .new copy for the admin to consider...
}
config etc/sensors3.conf.new
( cd usr/man/man5 ; rm -rf sensors3.conf.5.gz )
( cd usr/man/man5 ; ln -sf sensors.conf.5.gz sensors3.conf.5.gz )
( cd usr/lib ; rm -rf libsensors.so.4 )
( cd usr/lib ; ln -sf libsensors.so.4.2.1 libsensors.so.4 )
( cd usr/lib ; rm -rf libsensors.so )
( cd usr/lib ; ln -sf libsensors.so.4 libsensors.so )
