#!/bin/sh
config() {
  NEW="$1"
  OLD="`dirname $NEW`/`basename $NEW .new`"
  # If there's no config file by that name, mv it over:
  if [ ! -r $OLD ]; then
    mv $NEW $OLD
  elif [ "`cat $OLD | md5sum`" = "`cat $NEW | md5sum`" ]; then # toss the redundant copy
    rm $NEW
  fi
  # Otherwise, we leave the .new copy for the admin to consider...
}
config etc/rc.d/rc.samba.new
# This won't be needed.  The point here is to preserve the permissions of the existing
# file, if there is one.  I don't see major new development happening in rc.samba...  ;-)
rm -f etc/rc.d/rc.samba.new
( cd sbin ; rm -rf mount.cifs )
( cd sbin ; ln -sf /usr/sbin/mount.cifs mount.cifs )
( cd usr/lib ; rm -rf libsmbsharemodes.so )
( cd usr/lib ; ln -sf libsmbsharemodes.so.0 libsmbsharemodes.so )
( cd usr/lib ; rm -rf libtalloc.so )
( cd usr/lib ; ln -sf libtalloc.so.2 libtalloc.so )
( cd usr/lib ; rm -rf libsmbclient.so )
( cd usr/lib ; ln -sf libsmbclient.so.0 libsmbclient.so )
( cd usr/lib ; rm -rf libnetapi.so )
( cd usr/lib ; ln -sf libnetapi.so.0 libnetapi.so )
( cd usr/lib ; rm -rf libtdb.so )
( cd usr/lib ; ln -sf libtdb.so.1 libtdb.so )
( cd usr/lib ; rm -rf libwbclient.so )
( cd usr/lib ; ln -sf libwbclient.so.0 libwbclient.so )
( cd usr/doc/samba-3.5.2/docs ; rm -rf htmldocs )
( cd usr/doc/samba-3.5.2/docs ; ln -sf /usr/share/swat/help htmldocs )
( cd usr/bin ; rm -rf smbmount )
( cd usr/bin ; ln -sf /sbin/mount.smbfs smbmount )
( cd lib ; rm -rf libnss_wins.so )
( cd lib ; ln -sf libnss_wins.so.2 libnss_wins.so )
( cd lib ; rm -rf libnss_winbind.so )
( cd lib ; ln -sf libnss_winbind.so.2 libnss_winbind.so )
