#!/bin/sh
config() {
  NEW="$1"
  OLD="`dirname $NEW`/`basename $NEW .new`"
  # If there's no config file by that name, mv it over:
  if [ ! -r $OLD ]; then
    mv $NEW $OLD
  elif [ "`cat $OLD | md5sum`" = "`cat $NEW | md5sum`" ]; then # toss the redundant copy
    rm $NEW
  fi
  # Otherwise, we leave the .new copy for the admin to consider...
}
config etc/nail.rc.new
# Make symlinks:
( cd usr/man/man1 ; rm -rf mail.1.gz.gz )
( cd usr/man/man1 ; ln -sf mailx.1.gz.gz mail.1.gz.gz )
( cd usr/man/man1 ; rm -rf nail.1.gz.gz )
( cd usr/man/man1 ; ln -sf mailx.1.gz.gz nail.1.gz.gz )
( cd usr/man/man1 ; rm -rf Mail.1.gz.gz )
( cd usr/man/man1 ; ln -sf mailx.1.gz.gz Mail.1.gz.gz )
( cd usr/bin ; rm -rf nail )
( cd usr/bin ; ln -sf mailx nail )
( cd usr/bin ; rm -rf mail )
( cd usr/bin ; ln -sf mailx mail )
( cd usr/bin ; rm -rf Mail )
( cd usr/bin ; ln -sf mailx Mail )
( cd bin ; rm -rf nail )
( cd bin ; ln -sf ../usr/bin/mailx nail )
( cd bin ; rm -rf mail )
( cd bin ; ln -sf ../usr/bin/mailx mail )
( cd bin ; rm -rf Mail )
( cd bin ; ln -sf ../usr/bin/mailx Mail )
