#!/bin/sh
config() {
  NEW="$1"
  OLD="`dirname $NEW`/`basename $NEW .new`"
  # If there's no config file by that name, mv it over:
  if [ ! -r $OLD ]; then
    mv $NEW $OLD
  elif [ "`cat $OLD | md5sum`" = "`cat $NEW | md5sum`" ]; then # toss the redundant copy
    rm $NEW
  fi
  # Otherwise, we leave the .new copy for the admin to consider...
}
config etc/X11/xdm/xdm-config.new
config etc/X11/xdm/Xservers.new
config etc/X11/xdm/Xsession.new
#config etc/fonts/local.conf.new

# Determine which architecture we're being installed on
# in order to install the correct xorg config file.
# by Stuart Winter <stuart@armedslack.org>
# 22-Nov-2004

# This is the list of currently supported architectures in ARMedslack.
# More will be added (Netwinder perhaps) if I get my hands on any other
# kit!
#
# I suppose I could automate this entirely to save on maintenance by simply having
# the files named xorg.conf.{RiscPC,Iyonix,NetWinder} but I prefer it this way
# incase I have to do something other than just making a symlink to the correct
# files.  For example, on the RiscPC I want to determine the amount of VRAM available
# and update the VideoRam directive appropriately.  Atm I don't know how to determine
# the amount of VRAM so this is not currently being done.
#
grep Acorn-RiscPC    /proc/cpuinfo 2>&1 >/dev/null && TYPE=riscpc
grep Iyonix          /proc/cpuinfo 2>&1 >/dev/null && TYPE=iyonix
grep Rebel-NetWinder /proc/cpuinfo 2>&1 >/dev/null && TYPE=netwinder
grep ARM-Versatile   /proc/cpuinfo 2>&1 >/dev/null && TYPE=versatile

# Make the symlink. One of the great things about "stock" type ARM stuff
# is that it has a static graphics chip, so we can make a pretty good
# stab at providing an appropriate X11 configuration:
# (This long drawn out way is to make the Slackware package tools happy)
if [ ! -z $TYPE ]; then
( cd etc/X11 ; rm -f xorg.conf )
( cd etc/X11 ; ln -fs xorg.conf.$TYPE xorg.conf )
fi
( cd usr/lib ; rm -rf libGL.so )
( cd usr/lib ; ln -sf /usr/X11R6/lib/libGL.so libGL.so )
( cd usr/lib ; rm -rf libGL.so.1 )
( cd usr/lib ; ln -sf /usr/X11R6/lib/libGL.so.1 libGL.so.1 )
( cd usr/X11R6/lib/X11 ; rm -rf app-defaults )
( cd usr/X11R6/lib/X11 ; ln -sf ../../../../etc/X11/app-defaults app-defaults )
( cd usr/X11R6/lib/X11 ; rm -rf proxymngr )
( cd usr/X11R6/lib/X11 ; ln -sf ../../../../etc/X11/proxymngr proxymngr )
( cd usr/X11R6/lib/X11 ; rm -rf rstart )
( cd usr/X11R6/lib/X11 ; ln -sf ../../../../etc/X11/rstart rstart )
( cd usr/X11R6/lib/X11 ; rm -rf twm )
( cd usr/X11R6/lib/X11 ; ln -sf ../../../../etc/X11/twm twm )
( cd usr/X11R6/lib/X11 ; rm -rf xdm )
( cd usr/X11R6/lib/X11 ; ln -sf ../../../../etc/X11/xdm xdm )
( cd usr/X11R6/lib/X11 ; rm -rf fs )
( cd usr/X11R6/lib/X11 ; ln -sf ../../../../etc/X11/fs fs )
( cd usr/X11R6/lib/X11 ; rm -rf xinit )
( cd usr/X11R6/lib/X11 ; ln -sf ../../../../etc/X11/xinit xinit )
( cd usr/X11R6/lib/X11 ; rm -rf xkb )
( cd usr/X11R6/lib/X11 ; ln -sf ../../../../etc/X11/xkb xkb )
( cd usr/X11R6/lib/X11 ; rm -rf xsm )
( cd usr/X11R6/lib/X11 ; ln -sf ../../../../etc/X11/xsm xsm )
( cd usr/X11R6/lib/X11 ; rm -rf xserver )
( cd usr/X11R6/lib/X11 ; ln -sf ../../../../etc/X11/xserver xserver )
( cd usr/X11R6/lib/X11 ; rm -rf lbxproxy )
( cd usr/X11R6/lib/X11 ; ln -sf ../../../../etc/X11/lbxproxy lbxproxy )
( cd usr/X11R6/lib/X11/icons/redglass/cursors ; rm -rf arrow )
( cd usr/X11R6/lib/X11/icons/redglass/cursors ; ln -sf right_ptr arrow )
( cd usr/X11R6/lib/X11/icons/redglass/cursors ; rm -rf cross_reverse )
( cd usr/X11R6/lib/X11/icons/redglass/cursors ; ln -sf cross cross_reverse )
( cd usr/X11R6/lib/X11/icons/redglass/cursors ; rm -rf crosshair )
( cd usr/X11R6/lib/X11/icons/redglass/cursors ; ln -sf cross crosshair )
( cd usr/X11R6/lib/X11/icons/redglass/cursors ; rm -rf draft_large )
( cd usr/X11R6/lib/X11/icons/redglass/cursors ; ln -sf right_ptr draft_large )
( cd usr/X11R6/lib/X11/icons/redglass/cursors ; rm -rf draft_small )
( cd usr/X11R6/lib/X11/icons/redglass/cursors ; ln -sf right_ptr draft_small )
( cd usr/X11R6/lib/X11/icons/redglass/cursors ; rm -rf plus )
( cd usr/X11R6/lib/X11/icons/redglass/cursors ; ln -sf cross plus )
( cd usr/X11R6/lib/X11/icons/redglass/cursors ; rm -rf tcross )
( cd usr/X11R6/lib/X11/icons/redglass/cursors ; ln -sf cross tcross )
( cd usr/X11R6/lib/X11/icons/redglass/cursors ; rm -rf top_left_arrow )
( cd usr/X11R6/lib/X11/icons/redglass/cursors ; ln -sf left_ptr top_left_arrow )
( cd usr/X11R6/lib/X11/icons/redglass/cursors ; rm -rf 08e8e1c95fe2fc01f976f1e063a24ccd )
( cd usr/X11R6/lib/X11/icons/redglass/cursors ; ln -sf left_ptr_watch 08e8e1c95fe2fc01f976f1e063a24ccd )
( cd usr/X11R6/lib/X11/icons/whiteglass/cursors ; rm -rf arrow )
( cd usr/X11R6/lib/X11/icons/whiteglass/cursors ; ln -sf right_ptr arrow )
( cd usr/X11R6/lib/X11/icons/whiteglass/cursors ; rm -rf cross_reverse )
( cd usr/X11R6/lib/X11/icons/whiteglass/cursors ; ln -sf cross cross_reverse )
( cd usr/X11R6/lib/X11/icons/whiteglass/cursors ; rm -rf crosshair )
( cd usr/X11R6/lib/X11/icons/whiteglass/cursors ; ln -sf cross crosshair )
( cd usr/X11R6/lib/X11/icons/whiteglass/cursors ; rm -rf draft_large )
( cd usr/X11R6/lib/X11/icons/whiteglass/cursors ; ln -sf right_ptr draft_large )
( cd usr/X11R6/lib/X11/icons/whiteglass/cursors ; rm -rf draft_small )
( cd usr/X11R6/lib/X11/icons/whiteglass/cursors ; ln -sf right_ptr draft_small )
( cd usr/X11R6/lib/X11/icons/whiteglass/cursors ; rm -rf plus )
( cd usr/X11R6/lib/X11/icons/whiteglass/cursors ; ln -sf cross plus )
( cd usr/X11R6/lib/X11/icons/whiteglass/cursors ; rm -rf tcross )
( cd usr/X11R6/lib/X11/icons/whiteglass/cursors ; ln -sf cross tcross )
( cd usr/X11R6/lib/X11/icons/whiteglass/cursors ; rm -rf top_left_arrow )
( cd usr/X11R6/lib/X11/icons/whiteglass/cursors ; ln -sf left_ptr top_left_arrow )
( cd usr/X11R6/lib/X11/icons/whiteglass/cursors ; rm -rf 08e8e1c95fe2fc01f976f1e063a24ccd )
( cd usr/X11R6/lib/X11/icons/whiteglass/cursors ; ln -sf left_ptr_watch 08e8e1c95fe2fc01f976f1e063a24ccd )
( cd usr/X11R6/lib/X11/icons/handhelds/cursors ; rm -rf arrow )
( cd usr/X11R6/lib/X11/icons/handhelds/cursors ; ln -sf right_ptr arrow )
( cd usr/X11R6/lib/X11/icons/handhelds/cursors ; rm -rf cross_reverse )
( cd usr/X11R6/lib/X11/icons/handhelds/cursors ; ln -sf cross cross_reverse )
( cd usr/X11R6/lib/X11/icons/handhelds/cursors ; rm -rf crosshair )
( cd usr/X11R6/lib/X11/icons/handhelds/cursors ; ln -sf cross crosshair )
( cd usr/X11R6/lib/X11/icons/handhelds/cursors ; rm -rf draft_large )
( cd usr/X11R6/lib/X11/icons/handhelds/cursors ; ln -sf right_ptr draft_large )
( cd usr/X11R6/lib/X11/icons/handhelds/cursors ; rm -rf draft_small )
( cd usr/X11R6/lib/X11/icons/handhelds/cursors ; ln -sf right_ptr draft_small )
( cd usr/X11R6/lib/X11/icons/handhelds/cursors ; rm -rf plus )
( cd usr/X11R6/lib/X11/icons/handhelds/cursors ; ln -sf cross plus )
( cd usr/X11R6/lib/X11/icons/handhelds/cursors ; rm -rf tcross )
( cd usr/X11R6/lib/X11/icons/handhelds/cursors ; ln -sf cross tcross )
( cd usr/X11R6/lib/X11/icons/handhelds/cursors ; rm -rf top_left_arrow )
( cd usr/X11R6/lib/X11/icons/handhelds/cursors ; ln -sf left_ptr top_left_arrow )
( cd usr/X11R6/lib/X11/icons/handhelds/cursors ; rm -rf 08e8e1c95fe2fc01f976f1e063a24ccd )
( cd usr/X11R6/lib/X11/icons/handhelds/cursors ; ln -sf left_ptr_watch 08e8e1c95fe2fc01f976f1e063a24ccd )
( cd usr/X11R6/lib ; rm -rf libXau.so.6 )
( cd usr/X11R6/lib ; ln -sf libXau.so.6.0 libXau.so.6 )
( cd usr/X11R6/lib ; rm -rf libXau.so )
( cd usr/X11R6/lib ; ln -sf libXau.so.6.0 libXau.so )
( cd usr/X11R6/lib ; rm -rf libXdmcp.so.6 )
( cd usr/X11R6/lib ; ln -sf libXdmcp.so.6.0 libXdmcp.so.6 )
( cd usr/X11R6/lib ; rm -rf libXdmcp.so )
( cd usr/X11R6/lib ; ln -sf libXdmcp.so.6.0 libXdmcp.so )
( cd usr/X11R6/lib ; rm -rf libX11.so.6 )
( cd usr/X11R6/lib ; ln -sf libX11.so.6.2 libX11.so.6 )
( cd usr/X11R6/lib ; rm -rf libX11.so )
( cd usr/X11R6/lib ; ln -sf libX11.so.6.2 libX11.so )
( cd usr/X11R6/lib ; rm -rf libICE.so.6 )
( cd usr/X11R6/lib ; ln -sf libICE.so.6.4 libICE.so.6 )
( cd usr/X11R6/lib ; rm -rf libICE.so )
( cd usr/X11R6/lib ; ln -sf libICE.so.6.4 libICE.so )
( cd usr/X11R6/lib ; rm -rf libSM.so.6 )
( cd usr/X11R6/lib ; ln -sf libSM.so.6.0 libSM.so.6 )
( cd usr/X11R6/lib ; rm -rf libSM.so )
( cd usr/X11R6/lib ; ln -sf libSM.so.6.0 libSM.so )
( cd usr/X11R6/lib ; rm -rf libXext.so.6 )
( cd usr/X11R6/lib ; ln -sf libXext.so.6.4 libXext.so.6 )
( cd usr/X11R6/lib ; rm -rf libXext.so )
( cd usr/X11R6/lib ; ln -sf libXext.so.6.4 libXext.so )
( cd usr/X11R6/lib ; rm -rf libXt.so.6 )
( cd usr/X11R6/lib ; ln -sf libXt.so.6.0 libXt.so.6 )
( cd usr/X11R6/lib ; rm -rf libXt.so )
( cd usr/X11R6/lib ; ln -sf libXt.so.6.0 libXt.so )
( cd usr/X11R6/lib ; rm -rf libXss.so.1 )
( cd usr/X11R6/lib ; ln -sf libXss.so.1.0 libXss.so.1 )
( cd usr/X11R6/lib ; rm -rf libXss.so )
( cd usr/X11R6/lib ; ln -sf libXss.so.1.0 libXss.so )
( cd usr/X11R6/lib ; rm -rf libXxf86misc.so.1 )
( cd usr/X11R6/lib ; ln -sf libXxf86misc.so.1.1 libXxf86misc.so.1 )
( cd usr/X11R6/lib ; rm -rf libXxf86misc.so )
( cd usr/X11R6/lib ; ln -sf libXxf86misc.so.1.1 libXxf86misc.so )
( cd usr/X11R6/lib ; rm -rf libXxf86vm.so.1 )
( cd usr/X11R6/lib ; ln -sf libXxf86vm.so.1.0 libXxf86vm.so.1 )
( cd usr/X11R6/lib ; rm -rf libXxf86vm.so )
( cd usr/X11R6/lib ; ln -sf libXxf86vm.so.1.0 libXxf86vm.so )
( cd usr/X11R6/lib ; rm -rf libXxf86dga.so.1 )
( cd usr/X11R6/lib ; ln -sf libXxf86dga.so.1.0 libXxf86dga.so.1 )
( cd usr/X11R6/lib ; rm -rf libXxf86dga.so )
( cd usr/X11R6/lib ; ln -sf libXxf86dga.so.1.0 libXxf86dga.so )
( cd usr/X11R6/lib ; rm -rf libXxf86rush.so.1 )
( cd usr/X11R6/lib ; ln -sf libXxf86rush.so.1.0 libXxf86rush.so.1 )
( cd usr/X11R6/lib ; rm -rf libXxf86rush.so )
( cd usr/X11R6/lib ; ln -sf libXxf86rush.so.1.0 libXxf86rush.so )
( cd usr/X11R6/lib ; rm -rf libXmu.so.6 )
( cd usr/X11R6/lib ; ln -sf libXmu.so.6.2 libXmu.so.6 )
( cd usr/X11R6/lib ; rm -rf libXmu.so )
( cd usr/X11R6/lib ; ln -sf libXmu.so.6.2 libXmu.so )
( cd usr/X11R6/lib ; rm -rf libXmuu.so.1 )
( cd usr/X11R6/lib ; ln -sf libXmuu.so.1.0 libXmuu.so.1 )
( cd usr/X11R6/lib ; rm -rf libXmuu.so )
( cd usr/X11R6/lib ; ln -sf libXmuu.so.1.0 libXmuu.so )
( cd usr/X11R6/lib ; rm -rf libXpm.so.4 )
( cd usr/X11R6/lib ; ln -sf libXpm.so.4.11 libXpm.so.4 )
( cd usr/X11R6/lib ; rm -rf libXpm.so )
( cd usr/X11R6/lib ; ln -sf libXpm.so.4.11 libXpm.so )
( cd usr/X11R6/lib ; rm -rf libXp.so.6 )
( cd usr/X11R6/lib ; ln -sf libXp.so.6.2 libXp.so.6 )
( cd usr/X11R6/lib ; rm -rf libXp.so )
( cd usr/X11R6/lib ; ln -sf libXp.so.6.2 libXp.so )
( cd usr/X11R6/lib ; rm -rf libXaw.so.6 )
( cd usr/X11R6/lib ; ln -sf libXaw.so.6.1 libXaw.so.6 )
( cd usr/X11R6/lib ; rm -rf libXaw.so.7 )
( cd usr/X11R6/lib ; ln -sf libXaw.so.7.0 libXaw.so.7 )
( cd usr/X11R6/lib ; rm -rf libXaw.so.8 )
( cd usr/X11R6/lib ; ln -sf libXaw.so.8.0 libXaw.so.8 )
( cd usr/X11R6/lib ; rm -rf libXaw.so )
( cd usr/X11R6/lib ; ln -sf libXaw.so.8.0 libXaw.so )
( cd usr/X11R6/lib ; rm -rf libXi.so.6 )
( cd usr/X11R6/lib ; ln -sf libXi.so.6.0 libXi.so.6 )
( cd usr/X11R6/lib ; rm -rf libXi.so )
( cd usr/X11R6/lib ; ln -sf libXi.so.6.0 libXi.so )
( cd usr/X11R6/lib ; rm -rf libXtst.so.6 )
( cd usr/X11R6/lib ; ln -sf libXtst.so.6.1 libXtst.so.6 )
( cd usr/X11R6/lib ; rm -rf libXtst.so )
( cd usr/X11R6/lib ; ln -sf libXtst.so.6.1 libXtst.so )
( cd usr/X11R6/lib ; rm -rf libFS.so.6 )
( cd usr/X11R6/lib ; ln -sf libFS.so.6.0 libFS.so.6 )
( cd usr/X11R6/lib ; rm -rf libFS.so )
( cd usr/X11R6/lib ; ln -sf libFS.so.6.0 libFS.so )
( cd usr/X11R6/lib ; rm -rf libxkbfile.so.1 )
( cd usr/X11R6/lib ; ln -sf libxkbfile.so.1.0 libxkbfile.so.1 )
( cd usr/X11R6/lib ; rm -rf libxkbfile.so )
( cd usr/X11R6/lib ; ln -sf libxkbfile.so.1.0 libxkbfile.so )
( cd usr/X11R6/lib ; rm -rf libxkbui.so.1 )
( cd usr/X11R6/lib ; ln -sf libxkbui.so.1.0 libxkbui.so.1 )
( cd usr/X11R6/lib ; rm -rf libxkbui.so )
( cd usr/X11R6/lib ; ln -sf libxkbui.so.1.0 libxkbui.so )
( cd usr/X11R6/lib ; rm -rf libXv.so.1 )
( cd usr/X11R6/lib ; ln -sf libXv.so.1.0 libXv.so.1 )
( cd usr/X11R6/lib ; rm -rf libXv.so )
( cd usr/X11R6/lib ; ln -sf libXv.so.1.0 libXv.so )
( cd usr/X11R6/lib ; rm -rf libGL.so.1 )
( cd usr/X11R6/lib ; ln -sf libGL.so.1.2 libGL.so.1 )
( cd usr/X11R6/lib ; rm -rf libGL.so )
( cd usr/X11R6/lib ; ln -sf libGL.so.1.2 libGL.so )
( cd usr/X11R6/lib ; rm -rf libOSMesa.so.4 )
( cd usr/X11R6/lib ; ln -sf libOSMesa.so.4.0 libOSMesa.so.4 )
( cd usr/X11R6/lib ; rm -rf libOSMesa.so )
( cd usr/X11R6/lib ; ln -sf libOSMesa.so.4.0 libOSMesa.so )
( cd usr/X11R6/lib ; rm -rf libGLU.so.1 )
( cd usr/X11R6/lib ; ln -sf libGLU.so.1.3 libGLU.so.1 )
( cd usr/X11R6/lib ; rm -rf libGLU.so )
( cd usr/X11R6/lib ; ln -sf libGLU.so.1.3 libGLU.so )
( cd usr/X11R6/lib ; rm -rf libGLw.so.1 )
( cd usr/X11R6/lib ; ln -sf libGLw.so.1.0 libGLw.so.1 )
( cd usr/X11R6/lib ; rm -rf libGLw.so )
( cd usr/X11R6/lib ; ln -sf libGLw.so.1.0 libGLw.so )
( cd usr/X11R6/lib ; rm -rf libXinerama.so.1 )
( cd usr/X11R6/lib ; ln -sf libXinerama.so.1.0 libXinerama.so.1 )
( cd usr/X11R6/lib ; rm -rf libXinerama.so )
( cd usr/X11R6/lib ; ln -sf libXinerama.so.1.0 libXinerama.so )
( cd usr/X11R6/lib ; rm -rf libXrender.so.1 )
( cd usr/X11R6/lib ; ln -sf libXrender.so.1.2.2 libXrender.so.1 )
( cd usr/X11R6/lib ; rm -rf libXrender.so )
( cd usr/X11R6/lib ; ln -sf libXrender.so.1.2.2 libXrender.so )
( cd usr/X11R6/lib ; rm -rf libXft.so.1 )
( cd usr/X11R6/lib ; ln -sf libXft.so.1.1 libXft.so.1 )
( cd usr/X11R6/lib ; rm -rf libXft.so.2 )
( cd usr/X11R6/lib ; ln -sf libXft.so.2.1.2 libXft.so.2 )
( cd usr/X11R6/lib ; rm -rf libXft.so )
( cd usr/X11R6/lib ; ln -sf libXft.so.2.1.2 libXft.so )
( cd usr/X11R6/lib ; rm -rf libXvMC.so.1 )
( cd usr/X11R6/lib ; ln -sf libXvMC.so.1.0 libXvMC.so.1 )
( cd usr/X11R6/lib ; rm -rf libXvMC.so )
( cd usr/X11R6/lib ; ln -sf libXvMC.so.1.0 libXvMC.so )
( cd usr/X11R6/lib ; rm -rf libXrandr.so.2 )
( cd usr/X11R6/lib ; ln -sf libXrandr.so.2.0 libXrandr.so.2 )
( cd usr/X11R6/lib ; rm -rf libXrandr.so )
( cd usr/X11R6/lib ; ln -sf libXrandr.so.2.0 libXrandr.so )
( cd usr/X11R6/lib ; rm -rf libXTrap.so.6 )
( cd usr/X11R6/lib ; ln -sf libXTrap.so.6.4 libXTrap.so.6 )
( cd usr/X11R6/lib ; rm -rf libXTrap.so )
( cd usr/X11R6/lib ; ln -sf libXTrap.so.6.4 libXTrap.so )
( cd usr/X11R6/lib ; rm -rf libXRes.so.1 )
( cd usr/X11R6/lib ; ln -sf libXRes.so.1.0 libXRes.so.1 )
( cd usr/X11R6/lib ; rm -rf libXRes.so )
( cd usr/X11R6/lib ; ln -sf libXRes.so.1.0 libXRes.so )
( cd usr/X11R6/lib ; rm -rf libXevie.so.1 )
( cd usr/X11R6/lib ; ln -sf libXevie.so.1.0 libXevie.so.1 )
( cd usr/X11R6/lib ; rm -rf libXevie.so )
( cd usr/X11R6/lib ; ln -sf libXevie.so.1.0 libXevie.so )
( cd usr/X11R6/lib ; rm -rf libXfixes.so.3 )
( cd usr/X11R6/lib ; ln -sf libXfixes.so.3.0 libXfixes.so.3 )
( cd usr/X11R6/lib ; rm -rf libXfixes.so )
( cd usr/X11R6/lib ; ln -sf libXfixes.so.3.0 libXfixes.so )
( cd usr/X11R6/lib ; rm -rf libXdamage.so.1 )
( cd usr/X11R6/lib ; ln -sf libXdamage.so.1.0 libXdamage.so.1 )
( cd usr/X11R6/lib ; rm -rf libXdamage.so )
( cd usr/X11R6/lib ; ln -sf libXdamage.so.1.0 libXdamage.so )
( cd usr/X11R6/lib ; rm -rf libXcursor.so.1 )
( cd usr/X11R6/lib ; ln -sf libXcursor.so.1.0.2 libXcursor.so.1 )
( cd usr/X11R6/lib ; rm -rf libXcursor.so )
( cd usr/X11R6/lib ; ln -sf libXcursor.so.1.0.2 libXcursor.so )
( cd usr/X11R6/lib ; rm -rf libXcomposite.so.1 )
( cd usr/X11R6/lib ; ln -sf libXcomposite.so.1.0 libXcomposite.so.1 )
( cd usr/X11R6/lib ; rm -rf libXcomposite.so )
( cd usr/X11R6/lib ; ln -sf libXcomposite.so.1.0 libXcomposite.so )
( cd usr/X11R6/lib ; rm -rf libXfont.so.1 )
( cd usr/X11R6/lib ; ln -sf libXfont.so.1.5 libXfont.so.1 )
( cd usr/X11R6/lib ; rm -rf libXfont.so )
( cd usr/X11R6/lib ; ln -sf libXfont.so.1.5 libXfont.so )
( cd usr/X11R6/lib ; rm -rf libfontenc.so.1 )
( cd usr/X11R6/lib ; ln -sf libfontenc.so.1.0 libfontenc.so.1 )
( cd usr/X11R6/lib ; rm -rf libfontenc.so )
( cd usr/X11R6/lib ; ln -sf libfontenc.so.1.0 libfontenc.so )
( cd usr/X11R6/lib ; rm -rf libxrx.so.6 )
( cd usr/X11R6/lib ; ln -sf libxrx.so.6.8 libxrx.so.6 )
( cd usr/X11R6/lib ; rm -rf libxrx.so )
( cd usr/X11R6/lib ; ln -sf libxrx.so.6.8 libxrx.so )
( cd usr/X11R6/lib ; rm -rf libxrxnest.so.6 )
( cd usr/X11R6/lib ; ln -sf libxrxnest.so.6.8 libxrxnest.so.6 )
( cd usr/X11R6/lib ; rm -rf libxrxnest.so )
( cd usr/X11R6/lib ; ln -sf libxrxnest.so.6.8 libxrxnest.so )
( cd usr/X11R6/bin ; rm -rf X )
( cd usr/X11R6/bin ; ln -sf Xorg X )
( cd etc/X11/rstart/commands ; rm -rf x11 )
( cd etc/X11/rstart/commands ; ln -sf x11r6 x11 )
( cd etc/X11/rstart/commands ; rm -rf x )
( cd etc/X11/rstart/commands ; ln -sf x11r6 x )
( cd etc/X11/rstart/contexts ; rm -rf x11 )
( cd etc/X11/rstart/contexts ; ln -sf x11r6 x11 )
( cd etc/X11/rstart/contexts ; rm -rf x )
( cd etc/X11/rstart/contexts ; ln -sf x11r6 x )
( cd etc/X11/xdm ; rm -rf authdir )
( cd etc/X11/xdm ; ln -sf ../../../var/lib/xdm authdir )
( cd etc/X11/xkb ; rm -rf compiled )
( cd etc/X11/xkb ; ln -sf ../../../var/lib/xkb compiled )
( cd etc/X11/xkb/rules ; rm -rf xfree86 )
( cd etc/X11/xkb/rules ; ln -sf xorg xfree86 )
( cd etc/X11/xkb/rules ; rm -rf xfree86.lst )
( cd etc/X11/xkb/rules ; ln -sf xorg.lst xfree86.lst )
( cd etc/X11/xkb/rules ; rm -rf xfree86-it.lst )
( cd etc/X11/xkb/rules ; ln -sf xorg-it.lst xfree86-it.lst )
( cd etc/X11/xkb/rules ; rm -rf xfree86.xml )
( cd etc/X11/xkb/rules ; ln -sf xorg.xml xfree86.xml )
( cd etc/X11 ; rm -rf xorg.conf )
( cd etc/X11 ; ln -sf xorg.conf.riscpc xorg.conf )
