/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.LookAndFeel;
import javax.swing.UIDefaults;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.border.Border;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.metal.MetalLookAndFeel;

public class UIManager
implements Serializable {
    private static final long serialVersionUID = -5547433830339189365L;
    static LookAndFeelInfo[] installed = new LookAndFeelInfo[]{new LookAndFeelInfo("Metal", "javax.swing.plaf.metal.MetalLookAndFeel")};
    static LookAndFeel[] aux_installed;
    static LookAndFeel look_and_feel;

    public static void addPropertyChangeListener(PropertyChangeListener listener) {
    }

    public static void removePropertyChangeListener(PropertyChangeListener listener) {
    }

    public static PropertyChangeListener[] getPropertyChangeListeners() {
        throw new Error("Not implemented");
    }

    public static void addAuxiliaryLookAndFeel(LookAndFeel l) {
        if (aux_installed == null) {
            aux_installed = new LookAndFeel[1];
            UIManager.aux_installed[0] = l;
            return;
        }
        LookAndFeel[] T = new LookAndFeel[aux_installed.length + 1];
        System.arraycopy(aux_installed, 0, T, 0, aux_installed.length);
        aux_installed = T;
        UIManager.aux_installed[UIManager.aux_installed.length - 1] = l;
    }

    public static boolean removeAuxiliaryLookAndFeel(LookAndFeel laf) {
        if (aux_installed == null) {
            return false;
        }
        for (int i = 0; i < aux_installed.length; ++i) {
            if (aux_installed[i] != laf) continue;
            UIManager.aux_installed[i] = aux_installed[aux_installed.length - 1];
            LookAndFeel[] T = new LookAndFeel[aux_installed.length - 1];
            System.arraycopy(aux_installed, 0, T, 0, aux_installed.length - 1);
            aux_installed = T;
            return true;
        }
        return false;
    }

    public static LookAndFeel[] getAuxiliaryLookAndFeels() {
        return aux_installed;
    }

    public static Object get(Object key) {
        return UIManager.getLookAndFeel().getDefaults().get(key);
    }

    public static Border getBorder(Object key) {
        return (Border)UIManager.getLookAndFeel().getDefaults().get(key);
    }

    public static Color getColor(Object key) {
        return (Color)UIManager.getLookAndFeel().getDefaults().get(key);
    }

    public static String getCrossPlatformLookAndFeelClassName() {
        return "javax.swing.plaf.metal.MetalLookAndFeel";
    }

    public static UIDefaults getDefaults() {
        return UIManager.getLookAndFeel().getDefaults();
    }

    public static Dimension getDimension(Object key) {
        System.out.println("UIManager.getDim");
        return new Dimension(200, 100);
    }

    public static Font getFont(Object key) {
        return (Font)UIManager.getLookAndFeel().getDefaults().get(key);
    }

    public static Icon getIcon(Object key) {
        return (Icon)UIManager.getLookAndFeel().getDefaults().get(key);
    }

    public static Insets getInsets(Object key) {
        return UIManager.getLookAndFeel().getDefaults().getInsets(key);
    }

    public static LookAndFeelInfo[] getInstalledLookAndFeels() {
        return installed;
    }

    public static int getInt(Object key) {
        Integer x = (Integer)UIManager.getLookAndFeel().getDefaults().get(key);
        if (x == null) {
            return 0;
        }
        return x;
    }

    public static LookAndFeel getLookAndFeel() {
        return look_and_feel;
    }

    public static UIDefaults getLookAndFeelDefaults() {
        return UIManager.getLookAndFeel().getDefaults();
    }

    public static String getString(Object key) {
        return (String)UIManager.getLookAndFeel().getDefaults().get(key);
    }

    public static String getSystemLookAndFeelClassName() {
        return UIManager.getCrossPlatformLookAndFeelClassName();
    }

    public static ComponentUI getUI(JComponent target) {
        ComponentUI ui = UIManager.getDefaults().getUI(target);
        return ui;
    }

    public static void installLookAndFeel(String name, String className) {
    }

    public static void installLookAndFeel(LookAndFeelInfo info) {
    }

    public static Object put(Object key, Object value) {
        return UIManager.getLookAndFeel().getDefaults().put(key, value);
    }

    public static void setInstalledLookAndFeels(LookAndFeelInfo[] infos) {
    }

    public static void setLookAndFeel(LookAndFeel newLookAndFeel) {
        if (look_and_feel != null) {
            look_and_feel.uninitialize();
        }
        look_and_feel = newLookAndFeel;
        look_and_feel.initialize();
    }

    public static void setLookAndFeel(String className) throws ClassNotFoundException, InstantiationException, IllegalAccessException, UnsupportedLookAndFeelException {
        Class c = Class.forName(className);
        LookAndFeel a = (LookAndFeel)c.newInstance();
        UIManager.setLookAndFeel(a);
    }

    static {
        look_and_feel = new MetalLookAndFeel();
    }

    public static class LookAndFeelInfo {
        String name;
        String clazz;

        LookAndFeelInfo(String name, String clazz) {
            this.name = name;
            this.clazz = clazz;
        }

        String getName() {
            return this.name;
        }

        String getClassName() {
            return this.clazz;
        }
    }
}

