/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PushbackReader;
import java.io.Reader;

public class StreamTokenizer {
    public static final int TT_EOF = -1;
    public static final int TT_EOL = 10;
    public static final int TT_NUMBER = -2;
    public static final int TT_WORD = -3;
    private static final int TT_NONE = -4;
    public int ttype;
    public String sval;
    public double nval;
    private boolean eolSignificant;
    private boolean lowerCase;
    private boolean slashSlash;
    private boolean slashStar;
    private boolean[] whitespace;
    private boolean[] alphabetic;
    private boolean[] numeric;
    private boolean[] quote;
    private boolean[] comment;
    private PushbackReader in;
    private boolean pushedBack;
    private int lineNumber;

    private /* synthetic */ void finit$() {
        this.ttype = -4;
        this.eolSignificant = false;
        this.lowerCase = false;
        this.slashSlash = false;
        this.slashStar = false;
        this.whitespace = new boolean[256];
        this.alphabetic = new boolean[256];
        this.numeric = new boolean[256];
        this.quote = new boolean[256];
        this.comment = new boolean[256];
        this.pushedBack = false;
        this.lineNumber = 1;
    }

    public StreamTokenizer(InputStream is) {
        this(new InputStreamReader(is));
    }

    public StreamTokenizer(Reader r) {
        this.finit$();
        this.in = new PushbackReader(r);
        this.whitespaceChars(0, 32);
        this.wordChars(65, 90);
        this.wordChars(97, 122);
        this.wordChars(160, 255);
        this.commentChar(47);
        this.quoteChar(39);
        this.quoteChar(34);
        this.parseNumbers();
    }

    public void commentChar(int ch) {
        if (ch >= 0 && ch <= 255) {
            this.comment[ch] = true;
            this.whitespace[ch] = false;
            this.alphabetic[ch] = false;
            this.numeric[ch] = false;
            this.quote[ch] = false;
        }
    }

    public void eolIsSignificant(boolean flag) {
        this.eolSignificant = flag;
    }

    public int lineno() {
        return this.lineNumber;
    }

    public void lowerCaseMode(boolean flag) {
        this.lowerCase = flag;
    }

    private boolean isWhitespace(int ch) {
        return ch >= 0 && ch <= 255 && this.whitespace[ch];
    }

    private boolean isAlphabetic(int ch) {
        return ch > 255 || ch >= 0 && this.alphabetic[ch];
    }

    private boolean isNumeric(int ch) {
        return ch >= 0 && ch <= 255 && this.numeric[ch];
    }

    private boolean isQuote(int ch) {
        return ch >= 0 && ch <= 255 && this.quote[ch];
    }

    private boolean isComment(int ch) {
        return ch >= 0 && ch <= 255 && this.comment[ch];
    }

    public int nextToken() throws IOException {
        int ch;
        if (this.pushedBack) {
            this.pushedBack = false;
            if (this.ttype != -4) {
                return this.ttype;
            }
        }
        this.sval = null;
        while (this.isWhitespace(ch = this.in.read())) {
            if (ch != 10 && ch != 13) continue;
            ++this.lineNumber;
            if (ch == 13 && (ch = this.in.read()) != 10 && ch != -1) {
                this.in.unread(ch);
            }
            if (!this.eolSignificant) continue;
            this.ttype = 10;
            return 10;
        }
        if (ch == 47) {
            ch = this.in.read();
            if (ch == 47 && this.slashSlash) {
                while ((ch = this.in.read()) != 10 && ch != 13 && ch != -1) {
                }
                if (ch != -1) {
                    this.in.unread(ch);
                }
                return this.nextToken();
            }
            if (ch == 42 && this.slashStar) {
                while (true) {
                    if ((ch = this.in.read()) == 42) {
                        ch = this.in.read();
                        if (ch != 47) {
                            if (ch == -1) continue;
                            this.in.unread(ch);
                            continue;
                        }
                        break;
                    }
                    if (ch == 10 || ch == 13) {
                        ++this.lineNumber;
                        if (ch != 13 || (ch = this.in.read()) == 10 || ch == -1) continue;
                        this.in.unread(ch);
                        continue;
                    }
                    if (ch == -1) break;
                }
                return this.nextToken();
            }
            if (ch != -1) {
                this.in.unread(ch);
            }
            ch = 47;
        }
        if (ch == -1) {
            this.ttype = -1;
        } else if (this.isNumeric(ch)) {
            boolean isNegative = false;
            if (ch == 45) {
                ch = this.in.read();
                if (this.isNumeric(ch) && ch != 45) {
                    isNegative = true;
                } else {
                    if (ch != -1) {
                        this.in.unread(ch);
                    }
                    this.ttype = 45;
                    return 45;
                }
            }
            StringBuffer tokbuf = new StringBuffer();
            tokbuf.append((char)ch);
            int decCount = 0;
            while (this.isNumeric(ch = this.in.read()) && ch != 45 && (ch != 46 || decCount++ <= 0)) {
                tokbuf.append((char)ch);
            }
            if (ch != -1) {
                this.in.unread(ch);
            }
            this.ttype = -2;
            try {
                this.nval = Double.valueOf(tokbuf.toString());
            }
            catch (NumberFormatException _) {
                this.nval = 0.0;
            }
            if (isNegative) {
                this.nval = -this.nval;
            }
        } else if (this.isAlphabetic(ch)) {
            StringBuffer tokbuf = new StringBuffer();
            tokbuf.append((char)ch);
            while (this.isAlphabetic(ch = this.in.read()) || this.isNumeric(ch)) {
                tokbuf.append((char)ch);
            }
            if (ch != -1) {
                this.in.unread(ch);
            }
            this.ttype = -3;
            this.sval = tokbuf.toString();
            if (this.lowerCase) {
                this.sval = this.sval.toLowerCase();
            }
        } else {
            if (this.isComment(ch)) {
                while ((ch = this.in.read()) != 10 && ch != 13 && ch != -1) {
                }
                if (ch != -1) {
                    this.in.unread(ch);
                }
                return this.nextToken();
            }
            if (this.isQuote(ch)) {
                this.ttype = ch;
                StringBuffer tokbuf = new StringBuffer();
                while ((ch = this.in.read()) != this.ttype && ch != 10 && ch != 13 && ch != -1) {
                    if (ch == 92) {
                        ch = this.in.read();
                        switch (ch) {
                            case 97: {
                                ch = 7;
                                break;
                            }
                            case 98: {
                                ch = 8;
                                break;
                            }
                            case 102: {
                                ch = 12;
                                break;
                            }
                            case 110: {
                                ch = 10;
                                break;
                            }
                            case 114: {
                                ch = 13;
                                break;
                            }
                            case 116: {
                                ch = 9;
                                break;
                            }
                            case 118: {
                                ch = 11;
                                break;
                            }
                            case 10: {
                                ch = 10;
                                break;
                            }
                            case 13: {
                                ch = 13;
                                break;
                            }
                            case 34: 
                            case 39: 
                            case 92: {
                                break;
                            }
                            default: {
                                int ch1;
                                int nextch = ch1 = ch;
                                if (ch1 >= 48 && ch <= 55) {
                                    ch -= 48;
                                    nextch = this.in.read();
                                    if (nextch >= 48 && nextch <= 55) {
                                        ch = ch * 8 + nextch - 48;
                                        nextch = this.in.read();
                                        if (nextch >= 48 && nextch <= 55 && ch1 >= 48 && ch1 <= 51) {
                                            ch = ch * 8 + nextch - 48;
                                            nextch = this.in.read();
                                        }
                                    }
                                }
                                if (nextch == -1) break;
                                this.in.unread(nextch);
                            }
                        }
                    }
                    tokbuf.append((char)ch);
                }
                if (ch != this.ttype && ch != -1) {
                    this.in.unread(ch);
                }
                this.sval = tokbuf.toString();
            } else {
                this.ttype = ch;
            }
        }
        return this.ttype;
    }

    private void resetChar(int ch) {
        this.comment[ch] = false;
        this.quote[ch] = false;
        this.numeric[ch] = false;
        this.alphabetic[ch] = false;
        this.whitespace[ch] = false;
    }

    public void ordinaryChar(int ch) {
        if (ch >= 0 && ch <= 255) {
            this.resetChar(ch);
        }
    }

    public void ordinaryChars(int low, int hi) {
        if (low < 0) {
            low = 0;
        }
        if (hi > 255) {
            hi = 255;
        }
        for (int i = low; i <= hi; ++i) {
            this.resetChar(i);
        }
    }

    public void parseNumbers() {
        for (int i = 0; i <= 9; ++i) {
            this.numeric[48 + i] = true;
        }
        this.numeric[46] = true;
        this.numeric[45] = true;
    }

    public void pushBack() {
        this.pushedBack = true;
    }

    public void quoteChar(int ch) {
        if (ch >= 0 && ch <= 255) {
            this.quote[ch] = true;
            this.comment[ch] = false;
            this.whitespace[ch] = false;
            this.alphabetic[ch] = false;
            this.numeric[ch] = false;
        }
    }

    public void resetSyntax() {
        this.ordinaryChars(0, 255);
    }

    public void slashSlashComments(boolean flag) {
        this.slashSlash = flag;
    }

    public void slashStarComments(boolean flag) {
        this.slashStar = flag;
    }

    public String toString() {
        String tempstr = this.ttype == -1 ? "EOF" : (this.ttype == 10 ? "EOL" : (this.ttype == -3 ? this.sval : (this.ttype == -2 ? "n=" + this.nval : (this.ttype == -4 ? "NOTHING" : "'" + (char)this.ttype + "'"))));
        return "Token[" + tempstr + "], line " + this.lineno();
    }

    public void whitespaceChars(int low, int hi) {
        if (low < 0) {
            low = 0;
        }
        if (hi > 255) {
            hi = 255;
        }
        for (int i = low; i <= hi; ++i) {
            this.resetChar(i);
            this.whitespace[i] = true;
        }
    }

    public void wordChars(int low, int hi) {
        if (low < 0) {
            low = 0;
        }
        if (hi > 255) {
            hi = 255;
        }
        for (int i = low; i <= hi; ++i) {
            this.alphabetic[i] = true;
        }
    }
}

