/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import gnu.gcj.convert.UnicodeToBytes;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.io.Writer;

public class OutputStreamWriter
extends Writer {
    BufferedOutputStream out;
    UnicodeToBytes converter;
    private char[] work;
    private int wcount;

    private OutputStreamWriter(OutputStream out, UnicodeToBytes encoder) {
        this.out = out instanceof BufferedOutputStream ? (BufferedOutputStream)out : new BufferedOutputStream(out, 250);
        this.lock = out;
        this.converter = encoder;
    }

    public OutputStreamWriter(OutputStream out, String encoding_scheme) throws UnsupportedEncodingException {
        this(out, UnicodeToBytes.getEncoder(encoding_scheme));
    }

    public OutputStreamWriter(OutputStream out) {
        this(out, UnicodeToBytes.getDefaultEncoder());
    }

    public void close() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            try {
                if (this.out != null) {
                    this.flush();
                    this.out.close();
                    this.out = null;
                }
                this.work = null;
            }
            finally {
                Object var2_2 = null;
            }
            return;
        }
    }

    public String getEncoding() {
        if (this.out != null) {
            return this.converter.getName();
        }
        return null;
    }

    public void flush() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            try {
                if (this.out == null) {
                    throw new IOException("Stream closed");
                }
                if (this.wcount > 0) {
                    this.writeChars(this.work, 0, this.wcount);
                    this.wcount = 0;
                }
                this.out.flush();
            }
            finally {
                Object var2_2 = null;
            }
            return;
        }
    }

    public void write(char[] buf, int offset, int count) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            try {
                if (this.out == null) {
                    throw new IOException("Stream closed");
                }
                if (this.wcount > 0) {
                    this.writeChars(this.work, 0, this.wcount);
                    this.wcount = 0;
                }
                this.writeChars(buf, offset, count);
            }
            finally {
                Object var5_5 = null;
            }
            return;
        }
    }

    private void writeChars(char[] buf, int offset, int count) throws IOException {
        while (count > 0 || this.converter.havePendingBytes()) {
            if (this.out.count + count >= this.out.buf.length) {
                this.out.flush();
                if (this.out.count != 0) {
                    throw new IOException("unable to flush output byte buffer");
                }
            }
            this.converter.setOutput(this.out.buf, this.out.count);
            int converted = this.converter.write(buf, offset, count);
            if (converted == 0 && this.out.count == this.converter.count) {
                this.out.flush();
                if (this.out.count != 0) {
                    throw new IOException("unable to flush output byte buffer");
                }
            }
            offset += converted;
            count -= converted;
            this.out.count = this.converter.count;
        }
    }

    public void write(String str, int offset, int count) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            try {
                if (this.out == null) {
                    throw new IOException("Stream closed");
                }
                if (this.work == null) {
                    this.work = new char[100];
                }
                int wlength = this.work.length;
                while (count > 0) {
                    int size = count;
                    if (this.wcount + size > wlength) {
                        if (2 * this.wcount > wlength) {
                            this.writeChars(this.work, 0, this.wcount);
                            this.wcount = 0;
                        }
                        if (this.wcount + size > wlength) {
                            size = wlength - this.wcount;
                        }
                    }
                    str.getChars(offset, offset + size, this.work, this.wcount);
                    offset += size;
                    count -= size;
                    this.wcount += size;
                }
                Object var5_6 = null;
            }
            catch (Throwable throwable) {
                Object var5_7 = null;
                throw throwable;
            }
        }
    }

    public void write(int ch) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            try {
                if (this.out == null) {
                    throw new IOException("Stream closed");
                }
                if (this.work == null) {
                    this.work = new char[100];
                }
                if (this.wcount >= this.work.length) {
                    this.writeChars(this.work, 0, this.wcount);
                    this.wcount = 0;
                }
                this.work[this.wcount++] = (char)ch;
            }
            finally {
                Object var3_3 = null;
            }
            return;
        }
    }
}

