#include "../librpc/gen_ndr/ndr_winreg.h"
#ifndef __CLI_WINREG__
#define __CLI_WINREG__
struct tevent_req *rpccli_winreg_OpenHKCR_send(TALLOC_CTX *mem_ctx,
					       struct tevent_context *ev,
					       struct rpc_pipe_client *cli,
					       uint16_t *_system_name /* [in] [unique] */,
					       uint32_t _access_mask /* [in]  */,
					       struct policy_handle *_handle /* [out] [ref] */);
NTSTATUS rpccli_winreg_OpenHKCR_recv(struct tevent_req *req,
				     TALLOC_CTX *mem_ctx,
				     WERROR *result);
NTSTATUS rpccli_winreg_OpenHKCR(struct rpc_pipe_client *cli,
				TALLOC_CTX *mem_ctx,
				uint16_t *system_name /* [in] [unique] */,
				uint32_t access_mask /* [in]  */,
				struct policy_handle *handle /* [out] [ref] */,
				WERROR *werror);
struct tevent_req *rpccli_winreg_OpenHKCU_send(TALLOC_CTX *mem_ctx,
					       struct tevent_context *ev,
					       struct rpc_pipe_client *cli,
					       uint16_t *_system_name /* [in] [unique] */,
					       uint32_t _access_mask /* [in]  */,
					       struct policy_handle *_handle /* [out] [ref] */);
NTSTATUS rpccli_winreg_OpenHKCU_recv(struct tevent_req *req,
				     TALLOC_CTX *mem_ctx,
				     WERROR *result);
NTSTATUS rpccli_winreg_OpenHKCU(struct rpc_pipe_client *cli,
				TALLOC_CTX *mem_ctx,
				uint16_t *system_name /* [in] [unique] */,
				uint32_t access_mask /* [in]  */,
				struct policy_handle *handle /* [out] [ref] */,
				WERROR *werror);
struct tevent_req *rpccli_winreg_OpenHKLM_send(TALLOC_CTX *mem_ctx,
					       struct tevent_context *ev,
					       struct rpc_pipe_client *cli,
					       uint16_t *_system_name /* [in] [unique] */,
					       uint32_t _access_mask /* [in]  */,
					       struct policy_handle *_handle /* [out] [ref] */);
NTSTATUS rpccli_winreg_OpenHKLM_recv(struct tevent_req *req,
				     TALLOC_CTX *mem_ctx,
				     WERROR *result);
NTSTATUS rpccli_winreg_OpenHKLM(struct rpc_pipe_client *cli,
				TALLOC_CTX *mem_ctx,
				uint16_t *system_name /* [in] [unique] */,
				uint32_t access_mask /* [in]  */,
				struct policy_handle *handle /* [out] [ref] */,
				WERROR *werror);
struct tevent_req *rpccli_winreg_OpenHKPD_send(TALLOC_CTX *mem_ctx,
					       struct tevent_context *ev,
					       struct rpc_pipe_client *cli,
					       uint16_t *_system_name /* [in] [unique] */,
					       uint32_t _access_mask /* [in]  */,
					       struct policy_handle *_handle /* [out] [ref] */);
NTSTATUS rpccli_winreg_OpenHKPD_recv(struct tevent_req *req,
				     TALLOC_CTX *mem_ctx,
				     WERROR *result);
NTSTATUS rpccli_winreg_OpenHKPD(struct rpc_pipe_client *cli,
				TALLOC_CTX *mem_ctx,
				uint16_t *system_name /* [in] [unique] */,
				uint32_t access_mask /* [in]  */,
				struct policy_handle *handle /* [out] [ref] */,
				WERROR *werror);
struct tevent_req *rpccli_winreg_OpenHKU_send(TALLOC_CTX *mem_ctx,
					      struct tevent_context *ev,
					      struct rpc_pipe_client *cli,
					      uint16_t *_system_name /* [in] [unique] */,
					      uint32_t _access_mask /* [in]  */,
					      struct policy_handle *_handle /* [out] [ref] */);
NTSTATUS rpccli_winreg_OpenHKU_recv(struct tevent_req *req,
				    TALLOC_CTX *mem_ctx,
				    WERROR *result);
NTSTATUS rpccli_winreg_OpenHKU(struct rpc_pipe_client *cli,
			       TALLOC_CTX *mem_ctx,
			       uint16_t *system_name /* [in] [unique] */,
			       uint32_t access_mask /* [in]  */,
			       struct policy_handle *handle /* [out] [ref] */,
			       WERROR *werror);
struct tevent_req *rpccli_winreg_CloseKey_send(TALLOC_CTX *mem_ctx,
					       struct tevent_context *ev,
					       struct rpc_pipe_client *cli,
					       struct policy_handle *_handle /* [in,out] [ref] */);
NTSTATUS rpccli_winreg_CloseKey_recv(struct tevent_req *req,
				     TALLOC_CTX *mem_ctx,
				     WERROR *result);
NTSTATUS rpccli_winreg_CloseKey(struct rpc_pipe_client *cli,
				TALLOC_CTX *mem_ctx,
				struct policy_handle *handle /* [in,out] [ref] */,
				WERROR *werror);
struct tevent_req *rpccli_winreg_CreateKey_send(TALLOC_CTX *mem_ctx,
						struct tevent_context *ev,
						struct rpc_pipe_client *cli,
						struct policy_handle *_handle /* [in] [ref] */,
						struct winreg_String _name /* [in]  */,
						struct winreg_String _keyclass /* [in]  */,
						uint32_t _options /* [in]  */,
						uint32_t _access_mask /* [in]  */,
						struct winreg_SecBuf *_secdesc /* [in] [unique] */,
						struct policy_handle *_new_handle /* [out] [ref] */,
						enum winreg_CreateAction *_action_taken /* [in,out] [unique] */);
NTSTATUS rpccli_winreg_CreateKey_recv(struct tevent_req *req,
				      TALLOC_CTX *mem_ctx,
				      WERROR *result);
NTSTATUS rpccli_winreg_CreateKey(struct rpc_pipe_client *cli,
				 TALLOC_CTX *mem_ctx,
				 struct policy_handle *handle /* [in] [ref] */,
				 struct winreg_String name /* [in]  */,
				 struct winreg_String keyclass /* [in]  */,
				 uint32_t options /* [in]  */,
				 uint32_t access_mask /* [in]  */,
				 struct winreg_SecBuf *secdesc /* [in] [unique] */,
				 struct policy_handle *new_handle /* [out] [ref] */,
				 enum winreg_CreateAction *action_taken /* [in,out] [unique] */,
				 WERROR *werror);
struct tevent_req *rpccli_winreg_DeleteKey_send(TALLOC_CTX *mem_ctx,
						struct tevent_context *ev,
						struct rpc_pipe_client *cli,
						struct policy_handle *_handle /* [in] [ref] */,
						struct winreg_String _key /* [in]  */);
NTSTATUS rpccli_winreg_DeleteKey_recv(struct tevent_req *req,
				      TALLOC_CTX *mem_ctx,
				      WERROR *result);
NTSTATUS rpccli_winreg_DeleteKey(struct rpc_pipe_client *cli,
				 TALLOC_CTX *mem_ctx,
				 struct policy_handle *handle /* [in] [ref] */,
				 struct winreg_String key /* [in]  */,
				 WERROR *werror);
struct tevent_req *rpccli_winreg_DeleteValue_send(TALLOC_CTX *mem_ctx,
						  struct tevent_context *ev,
						  struct rpc_pipe_client *cli,
						  struct policy_handle *_handle /* [in] [ref] */,
						  struct winreg_String _value /* [in]  */);
NTSTATUS rpccli_winreg_DeleteValue_recv(struct tevent_req *req,
					TALLOC_CTX *mem_ctx,
					WERROR *result);
NTSTATUS rpccli_winreg_DeleteValue(struct rpc_pipe_client *cli,
				   TALLOC_CTX *mem_ctx,
				   struct policy_handle *handle /* [in] [ref] */,
				   struct winreg_String value /* [in]  */,
				   WERROR *werror);
struct tevent_req *rpccli_winreg_EnumKey_send(TALLOC_CTX *mem_ctx,
					      struct tevent_context *ev,
					      struct rpc_pipe_client *cli,
					      struct policy_handle *_handle /* [in] [ref] */,
					      uint32_t _enum_index /* [in]  */,
					      struct winreg_StringBuf *_name /* [in,out] [ref] */,
					      struct winreg_StringBuf *_keyclass /* [in,out] [unique] */,
					      NTTIME *_last_changed_time /* [in,out] [unique] */);
NTSTATUS rpccli_winreg_EnumKey_recv(struct tevent_req *req,
				    TALLOC_CTX *mem_ctx,
				    WERROR *result);
NTSTATUS rpccli_winreg_EnumKey(struct rpc_pipe_client *cli,
			       TALLOC_CTX *mem_ctx,
			       struct policy_handle *handle /* [in] [ref] */,
			       uint32_t enum_index /* [in]  */,
			       struct winreg_StringBuf *name /* [in,out] [ref] */,
			       struct winreg_StringBuf *keyclass /* [in,out] [unique] */,
			       NTTIME *last_changed_time /* [in,out] [unique] */,
			       WERROR *werror);
struct tevent_req *rpccli_winreg_EnumValue_send(TALLOC_CTX *mem_ctx,
						struct tevent_context *ev,
						struct rpc_pipe_client *cli,
						struct policy_handle *_handle /* [in] [ref] */,
						uint32_t _enum_index /* [in]  */,
						struct winreg_ValNameBuf *_name /* [in,out] [ref] */,
						enum winreg_Type *_type /* [in,out] [unique] */,
						uint8_t *_value /* [in,out] [unique,length_is(*length),size_is(*size)] */,
						uint32_t *_size /* [in,out] [unique] */,
						uint32_t *_length /* [in,out] [unique] */);
NTSTATUS rpccli_winreg_EnumValue_recv(struct tevent_req *req,
				      TALLOC_CTX *mem_ctx,
				      WERROR *result);
NTSTATUS rpccli_winreg_EnumValue(struct rpc_pipe_client *cli,
				 TALLOC_CTX *mem_ctx,
				 struct policy_handle *handle /* [in] [ref] */,
				 uint32_t enum_index /* [in]  */,
				 struct winreg_ValNameBuf *name /* [in,out] [ref] */,
				 enum winreg_Type *type /* [in,out] [unique] */,
				 uint8_t *value /* [in,out] [unique,length_is(*length),size_is(*size)] */,
				 uint32_t *size /* [in,out] [unique] */,
				 uint32_t *length /* [in,out] [unique] */,
				 WERROR *werror);
struct tevent_req *rpccli_winreg_FlushKey_send(TALLOC_CTX *mem_ctx,
					       struct tevent_context *ev,
					       struct rpc_pipe_client *cli,
					       struct policy_handle *_handle /* [in] [ref] */);
NTSTATUS rpccli_winreg_FlushKey_recv(struct tevent_req *req,
				     TALLOC_CTX *mem_ctx,
				     WERROR *result);
NTSTATUS rpccli_winreg_FlushKey(struct rpc_pipe_client *cli,
				TALLOC_CTX *mem_ctx,
				struct policy_handle *handle /* [in] [ref] */,
				WERROR *werror);
struct tevent_req *rpccli_winreg_GetKeySecurity_send(TALLOC_CTX *mem_ctx,
						     struct tevent_context *ev,
						     struct rpc_pipe_client *cli,
						     struct policy_handle *_handle /* [in] [ref] */,
						     uint32_t _sec_info /* [in]  */,
						     struct KeySecurityData *_sd /* [in,out] [ref] */);
NTSTATUS rpccli_winreg_GetKeySecurity_recv(struct tevent_req *req,
					   TALLOC_CTX *mem_ctx,
					   WERROR *result);
NTSTATUS rpccli_winreg_GetKeySecurity(struct rpc_pipe_client *cli,
				      TALLOC_CTX *mem_ctx,
				      struct policy_handle *handle /* [in] [ref] */,
				      uint32_t sec_info /* [in]  */,
				      struct KeySecurityData *sd /* [in,out] [ref] */,
				      WERROR *werror);
struct tevent_req *rpccli_winreg_LoadKey_send(TALLOC_CTX *mem_ctx,
					      struct tevent_context *ev,
					      struct rpc_pipe_client *cli,
					      struct policy_handle *_handle /* [in] [ref] */,
					      struct winreg_String *_keyname /* [in] [unique] */,
					      struct winreg_String *_filename /* [in] [unique] */);
NTSTATUS rpccli_winreg_LoadKey_recv(struct tevent_req *req,
				    TALLOC_CTX *mem_ctx,
				    WERROR *result);
NTSTATUS rpccli_winreg_LoadKey(struct rpc_pipe_client *cli,
			       TALLOC_CTX *mem_ctx,
			       struct policy_handle *handle /* [in] [ref] */,
			       struct winreg_String *keyname /* [in] [unique] */,
			       struct winreg_String *filename /* [in] [unique] */,
			       WERROR *werror);
struct tevent_req *rpccli_winreg_NotifyChangeKeyValue_send(TALLOC_CTX *mem_ctx,
							   struct tevent_context *ev,
							   struct rpc_pipe_client *cli,
							   struct policy_handle *_handle /* [in] [ref] */,
							   uint8_t _watch_subtree /* [in]  */,
							   uint32_t _notify_filter /* [in]  */,
							   uint32_t _unknown /* [in]  */,
							   struct winreg_String _string1 /* [in]  */,
							   struct winreg_String _string2 /* [in]  */,
							   uint32_t _unknown2 /* [in]  */);
NTSTATUS rpccli_winreg_NotifyChangeKeyValue_recv(struct tevent_req *req,
						 TALLOC_CTX *mem_ctx,
						 WERROR *result);
NTSTATUS rpccli_winreg_NotifyChangeKeyValue(struct rpc_pipe_client *cli,
					    TALLOC_CTX *mem_ctx,
					    struct policy_handle *handle /* [in] [ref] */,
					    uint8_t watch_subtree /* [in]  */,
					    uint32_t notify_filter /* [in]  */,
					    uint32_t unknown /* [in]  */,
					    struct winreg_String string1 /* [in]  */,
					    struct winreg_String string2 /* [in]  */,
					    uint32_t unknown2 /* [in]  */,
					    WERROR *werror);
struct tevent_req *rpccli_winreg_OpenKey_send(TALLOC_CTX *mem_ctx,
					      struct tevent_context *ev,
					      struct rpc_pipe_client *cli,
					      struct policy_handle *_parent_handle /* [in] [ref] */,
					      struct winreg_String _keyname /* [in]  */,
					      uint32_t _unknown /* [in]  */,
					      uint32_t _access_mask /* [in]  */,
					      struct policy_handle *_handle /* [out] [ref] */);
NTSTATUS rpccli_winreg_OpenKey_recv(struct tevent_req *req,
				    TALLOC_CTX *mem_ctx,
				    WERROR *result);
NTSTATUS rpccli_winreg_OpenKey(struct rpc_pipe_client *cli,
			       TALLOC_CTX *mem_ctx,
			       struct policy_handle *parent_handle /* [in] [ref] */,
			       struct winreg_String keyname /* [in]  */,
			       uint32_t unknown /* [in]  */,
			       uint32_t access_mask /* [in]  */,
			       struct policy_handle *handle /* [out] [ref] */,
			       WERROR *werror);
struct tevent_req *rpccli_winreg_QueryInfoKey_send(TALLOC_CTX *mem_ctx,
						   struct tevent_context *ev,
						   struct rpc_pipe_client *cli,
						   struct policy_handle *_handle /* [in] [ref] */,
						   struct winreg_String *_classname /* [in,out] [ref] */,
						   uint32_t *_num_subkeys /* [out] [ref] */,
						   uint32_t *_max_subkeylen /* [out] [ref] */,
						   uint32_t *_max_classlen /* [out] [ref] */,
						   uint32_t *_num_values /* [out] [ref] */,
						   uint32_t *_max_valnamelen /* [out] [ref] */,
						   uint32_t *_max_valbufsize /* [out] [ref] */,
						   uint32_t *_secdescsize /* [out] [ref] */,
						   NTTIME *_last_changed_time /* [out] [ref] */);
NTSTATUS rpccli_winreg_QueryInfoKey_recv(struct tevent_req *req,
					 TALLOC_CTX *mem_ctx,
					 WERROR *result);
NTSTATUS rpccli_winreg_QueryInfoKey(struct rpc_pipe_client *cli,
				    TALLOC_CTX *mem_ctx,
				    struct policy_handle *handle /* [in] [ref] */,
				    struct winreg_String *classname /* [in,out] [ref] */,
				    uint32_t *num_subkeys /* [out] [ref] */,
				    uint32_t *max_subkeylen /* [out] [ref] */,
				    uint32_t *max_classlen /* [out] [ref] */,
				    uint32_t *num_values /* [out] [ref] */,
				    uint32_t *max_valnamelen /* [out] [ref] */,
				    uint32_t *max_valbufsize /* [out] [ref] */,
				    uint32_t *secdescsize /* [out] [ref] */,
				    NTTIME *last_changed_time /* [out] [ref] */,
				    WERROR *werror);
struct tevent_req *rpccli_winreg_QueryValue_send(TALLOC_CTX *mem_ctx,
						 struct tevent_context *ev,
						 struct rpc_pipe_client *cli,
						 struct policy_handle *_handle /* [in] [ref] */,
						 struct winreg_String *_value_name /* [in] [ref] */,
						 enum winreg_Type *_type /* [in,out] [unique] */,
						 uint8_t *_data /* [in,out] [unique,range(0,0x4000000),length_is(data_length?*data_length:0),size_is(data_size?*data_size:0)] */,
						 uint32_t *_data_size /* [in,out] [unique] */,
						 uint32_t *_data_length /* [in,out] [unique] */);
NTSTATUS rpccli_winreg_QueryValue_recv(struct tevent_req *req,
				       TALLOC_CTX *mem_ctx,
				       WERROR *result);
NTSTATUS rpccli_winreg_QueryValue(struct rpc_pipe_client *cli,
				  TALLOC_CTX *mem_ctx,
				  struct policy_handle *handle /* [in] [ref] */,
				  struct winreg_String *value_name /* [in] [ref] */,
				  enum winreg_Type *type /* [in,out] [unique] */,
				  uint8_t *data /* [in,out] [unique,range(0,0x4000000),length_is(data_length?*data_length:0),size_is(data_size?*data_size:0)] */,
				  uint32_t *data_size /* [in,out] [unique] */,
				  uint32_t *data_length /* [in,out] [unique] */,
				  WERROR *werror);
struct tevent_req *rpccli_winreg_ReplaceKey_send(TALLOC_CTX *mem_ctx,
						 struct tevent_context *ev,
						 struct rpc_pipe_client *cli);
NTSTATUS rpccli_winreg_ReplaceKey_recv(struct tevent_req *req,
				       TALLOC_CTX *mem_ctx,
				       WERROR *result);
NTSTATUS rpccli_winreg_ReplaceKey(struct rpc_pipe_client *cli,
				  TALLOC_CTX *mem_ctx,
				  WERROR *werror);
struct tevent_req *rpccli_winreg_RestoreKey_send(TALLOC_CTX *mem_ctx,
						 struct tevent_context *ev,
						 struct rpc_pipe_client *cli,
						 struct policy_handle *_handle /* [in] [ref] */,
						 struct winreg_String *_filename /* [in] [ref] */,
						 uint32_t _flags /* [in]  */);
NTSTATUS rpccli_winreg_RestoreKey_recv(struct tevent_req *req,
				       TALLOC_CTX *mem_ctx,
				       WERROR *result);
NTSTATUS rpccli_winreg_RestoreKey(struct rpc_pipe_client *cli,
				  TALLOC_CTX *mem_ctx,
				  struct policy_handle *handle /* [in] [ref] */,
				  struct winreg_String *filename /* [in] [ref] */,
				  uint32_t flags /* [in]  */,
				  WERROR *werror);
struct tevent_req *rpccli_winreg_SaveKey_send(TALLOC_CTX *mem_ctx,
					      struct tevent_context *ev,
					      struct rpc_pipe_client *cli,
					      struct policy_handle *_handle /* [in] [ref] */,
					      struct winreg_String *_filename /* [in] [ref] */,
					      struct KeySecurityAttribute *_sec_attrib /* [in] [unique] */);
NTSTATUS rpccli_winreg_SaveKey_recv(struct tevent_req *req,
				    TALLOC_CTX *mem_ctx,
				    WERROR *result);
NTSTATUS rpccli_winreg_SaveKey(struct rpc_pipe_client *cli,
			       TALLOC_CTX *mem_ctx,
			       struct policy_handle *handle /* [in] [ref] */,
			       struct winreg_String *filename /* [in] [ref] */,
			       struct KeySecurityAttribute *sec_attrib /* [in] [unique] */,
			       WERROR *werror);
struct tevent_req *rpccli_winreg_SetKeySecurity_send(TALLOC_CTX *mem_ctx,
						     struct tevent_context *ev,
						     struct rpc_pipe_client *cli,
						     struct policy_handle *_handle /* [in] [ref] */,
						     uint32_t _sec_info /* [in]  */,
						     struct KeySecurityData *_sd /* [in] [ref] */);
NTSTATUS rpccli_winreg_SetKeySecurity_recv(struct tevent_req *req,
					   TALLOC_CTX *mem_ctx,
					   WERROR *result);
NTSTATUS rpccli_winreg_SetKeySecurity(struct rpc_pipe_client *cli,
				      TALLOC_CTX *mem_ctx,
				      struct policy_handle *handle /* [in] [ref] */,
				      uint32_t sec_info /* [in]  */,
				      struct KeySecurityData *sd /* [in] [ref] */,
				      WERROR *werror);
struct tevent_req *rpccli_winreg_SetValue_send(TALLOC_CTX *mem_ctx,
					       struct tevent_context *ev,
					       struct rpc_pipe_client *cli,
					       struct policy_handle *_handle /* [in] [ref] */,
					       struct winreg_String _name /* [in]  */,
					       enum winreg_Type _type /* [in]  */,
					       uint8_t *_data /* [in] [ref,size_is(size)] */,
					       uint32_t _size /* [in]  */);
NTSTATUS rpccli_winreg_SetValue_recv(struct tevent_req *req,
				     TALLOC_CTX *mem_ctx,
				     WERROR *result);
NTSTATUS rpccli_winreg_SetValue(struct rpc_pipe_client *cli,
				TALLOC_CTX *mem_ctx,
				struct policy_handle *handle /* [in] [ref] */,
				struct winreg_String name /* [in]  */,
				enum winreg_Type type /* [in]  */,
				uint8_t *data /* [in] [ref,size_is(size)] */,
				uint32_t size /* [in]  */,
				WERROR *werror);
struct tevent_req *rpccli_winreg_UnLoadKey_send(TALLOC_CTX *mem_ctx,
						struct tevent_context *ev,
						struct rpc_pipe_client *cli);
NTSTATUS rpccli_winreg_UnLoadKey_recv(struct tevent_req *req,
				      TALLOC_CTX *mem_ctx,
				      WERROR *result);
NTSTATUS rpccli_winreg_UnLoadKey(struct rpc_pipe_client *cli,
				 TALLOC_CTX *mem_ctx,
				 WERROR *werror);
struct tevent_req *rpccli_winreg_InitiateSystemShutdown_send(TALLOC_CTX *mem_ctx,
							     struct tevent_context *ev,
							     struct rpc_pipe_client *cli,
							     uint16_t *_hostname /* [in] [unique] */,
							     struct lsa_StringLarge *_message /* [in] [unique] */,
							     uint32_t _timeout /* [in]  */,
							     uint8_t _force_apps /* [in]  */,
							     uint8_t _do_reboot /* [in]  */);
NTSTATUS rpccli_winreg_InitiateSystemShutdown_recv(struct tevent_req *req,
						   TALLOC_CTX *mem_ctx,
						   WERROR *result);
NTSTATUS rpccli_winreg_InitiateSystemShutdown(struct rpc_pipe_client *cli,
					      TALLOC_CTX *mem_ctx,
					      uint16_t *hostname /* [in] [unique] */,
					      struct lsa_StringLarge *message /* [in] [unique] */,
					      uint32_t timeout /* [in]  */,
					      uint8_t force_apps /* [in]  */,
					      uint8_t do_reboot /* [in]  */,
					      WERROR *werror);
struct tevent_req *rpccli_winreg_AbortSystemShutdown_send(TALLOC_CTX *mem_ctx,
							  struct tevent_context *ev,
							  struct rpc_pipe_client *cli,
							  uint16_t *_server /* [in] [unique] */);
NTSTATUS rpccli_winreg_AbortSystemShutdown_recv(struct tevent_req *req,
						TALLOC_CTX *mem_ctx,
						WERROR *result);
NTSTATUS rpccli_winreg_AbortSystemShutdown(struct rpc_pipe_client *cli,
					   TALLOC_CTX *mem_ctx,
					   uint16_t *server /* [in] [unique] */,
					   WERROR *werror);
struct tevent_req *rpccli_winreg_GetVersion_send(TALLOC_CTX *mem_ctx,
						 struct tevent_context *ev,
						 struct rpc_pipe_client *cli,
						 struct policy_handle *_handle /* [in] [ref] */,
						 uint32_t *_version /* [out] [ref] */);
NTSTATUS rpccli_winreg_GetVersion_recv(struct tevent_req *req,
				       TALLOC_CTX *mem_ctx,
				       WERROR *result);
NTSTATUS rpccli_winreg_GetVersion(struct rpc_pipe_client *cli,
				  TALLOC_CTX *mem_ctx,
				  struct policy_handle *handle /* [in] [ref] */,
				  uint32_t *version /* [out] [ref] */,
				  WERROR *werror);
struct tevent_req *rpccli_winreg_OpenHKCC_send(TALLOC_CTX *mem_ctx,
					       struct tevent_context *ev,
					       struct rpc_pipe_client *cli,
					       uint16_t *_system_name /* [in] [unique] */,
					       uint32_t _access_mask /* [in]  */,
					       struct policy_handle *_handle /* [out] [ref] */);
NTSTATUS rpccli_winreg_OpenHKCC_recv(struct tevent_req *req,
				     TALLOC_CTX *mem_ctx,
				     WERROR *result);
NTSTATUS rpccli_winreg_OpenHKCC(struct rpc_pipe_client *cli,
				TALLOC_CTX *mem_ctx,
				uint16_t *system_name /* [in] [unique] */,
				uint32_t access_mask /* [in]  */,
				struct policy_handle *handle /* [out] [ref] */,
				WERROR *werror);
struct tevent_req *rpccli_winreg_OpenHKDD_send(TALLOC_CTX *mem_ctx,
					       struct tevent_context *ev,
					       struct rpc_pipe_client *cli,
					       uint16_t *_system_name /* [in] [unique] */,
					       uint32_t _access_mask /* [in]  */,
					       struct policy_handle *_handle /* [out] [ref] */);
NTSTATUS rpccli_winreg_OpenHKDD_recv(struct tevent_req *req,
				     TALLOC_CTX *mem_ctx,
				     WERROR *result);
NTSTATUS rpccli_winreg_OpenHKDD(struct rpc_pipe_client *cli,
				TALLOC_CTX *mem_ctx,
				uint16_t *system_name /* [in] [unique] */,
				uint32_t access_mask /* [in]  */,
				struct policy_handle *handle /* [out] [ref] */,
				WERROR *werror);
struct tevent_req *rpccli_winreg_QueryMultipleValues_send(TALLOC_CTX *mem_ctx,
							  struct tevent_context *ev,
							  struct rpc_pipe_client *cli,
							  struct policy_handle *_key_handle /* [in] [ref] */,
							  struct QueryMultipleValue *_values /* [in,out] [ref,length_is(num_values),size_is(num_values)] */,
							  uint32_t _num_values /* [in]  */,
							  uint8_t *_buffer /* [in,out] [unique,length_is(*buffer_size),size_is(*buffer_size)] */,
							  uint32_t *_buffer_size /* [in,out] [ref] */);
NTSTATUS rpccli_winreg_QueryMultipleValues_recv(struct tevent_req *req,
						TALLOC_CTX *mem_ctx,
						WERROR *result);
NTSTATUS rpccli_winreg_QueryMultipleValues(struct rpc_pipe_client *cli,
					   TALLOC_CTX *mem_ctx,
					   struct policy_handle *key_handle /* [in] [ref] */,
					   struct QueryMultipleValue *values /* [in,out] [ref,length_is(num_values),size_is(num_values)] */,
					   uint32_t num_values /* [in]  */,
					   uint8_t *buffer /* [in,out] [unique,length_is(*buffer_size),size_is(*buffer_size)] */,
					   uint32_t *buffer_size /* [in,out] [ref] */,
					   WERROR *werror);
struct tevent_req *rpccli_winreg_InitiateSystemShutdownEx_send(TALLOC_CTX *mem_ctx,
							       struct tevent_context *ev,
							       struct rpc_pipe_client *cli,
							       uint16_t *_hostname /* [in] [unique] */,
							       struct lsa_StringLarge *_message /* [in] [unique] */,
							       uint32_t _timeout /* [in]  */,
							       uint8_t _force_apps /* [in]  */,
							       uint8_t _do_reboot /* [in]  */,
							       uint32_t _reason /* [in]  */);
NTSTATUS rpccli_winreg_InitiateSystemShutdownEx_recv(struct tevent_req *req,
						     TALLOC_CTX *mem_ctx,
						     WERROR *result);
NTSTATUS rpccli_winreg_InitiateSystemShutdownEx(struct rpc_pipe_client *cli,
						TALLOC_CTX *mem_ctx,
						uint16_t *hostname /* [in] [unique] */,
						struct lsa_StringLarge *message /* [in] [unique] */,
						uint32_t timeout /* [in]  */,
						uint8_t force_apps /* [in]  */,
						uint8_t do_reboot /* [in]  */,
						uint32_t reason /* [in]  */,
						WERROR *werror);
struct tevent_req *rpccli_winreg_SaveKeyEx_send(TALLOC_CTX *mem_ctx,
						struct tevent_context *ev,
						struct rpc_pipe_client *cli);
NTSTATUS rpccli_winreg_SaveKeyEx_recv(struct tevent_req *req,
				      TALLOC_CTX *mem_ctx,
				      WERROR *result);
NTSTATUS rpccli_winreg_SaveKeyEx(struct rpc_pipe_client *cli,
				 TALLOC_CTX *mem_ctx,
				 WERROR *werror);
struct tevent_req *rpccli_winreg_OpenHKPT_send(TALLOC_CTX *mem_ctx,
					       struct tevent_context *ev,
					       struct rpc_pipe_client *cli,
					       uint16_t *_system_name /* [in] [unique] */,
					       uint32_t _access_mask /* [in]  */,
					       struct policy_handle *_handle /* [out] [ref] */);
NTSTATUS rpccli_winreg_OpenHKPT_recv(struct tevent_req *req,
				     TALLOC_CTX *mem_ctx,
				     WERROR *result);
NTSTATUS rpccli_winreg_OpenHKPT(struct rpc_pipe_client *cli,
				TALLOC_CTX *mem_ctx,
				uint16_t *system_name /* [in] [unique] */,
				uint32_t access_mask /* [in]  */,
				struct policy_handle *handle /* [out] [ref] */,
				WERROR *werror);
struct tevent_req *rpccli_winreg_OpenHKPN_send(TALLOC_CTX *mem_ctx,
					       struct tevent_context *ev,
					       struct rpc_pipe_client *cli,
					       uint16_t *_system_name /* [in] [unique] */,
					       uint32_t _access_mask /* [in]  */,
					       struct policy_handle *_handle /* [out] [ref] */);
NTSTATUS rpccli_winreg_OpenHKPN_recv(struct tevent_req *req,
				     TALLOC_CTX *mem_ctx,
				     WERROR *result);
NTSTATUS rpccli_winreg_OpenHKPN(struct rpc_pipe_client *cli,
				TALLOC_CTX *mem_ctx,
				uint16_t *system_name /* [in] [unique] */,
				uint32_t access_mask /* [in]  */,
				struct policy_handle *handle /* [out] [ref] */,
				WERROR *werror);
struct tevent_req *rpccli_winreg_QueryMultipleValues2_send(TALLOC_CTX *mem_ctx,
							   struct tevent_context *ev,
							   struct rpc_pipe_client *cli);
NTSTATUS rpccli_winreg_QueryMultipleValues2_recv(struct tevent_req *req,
						 TALLOC_CTX *mem_ctx,
						 WERROR *result);
NTSTATUS rpccli_winreg_QueryMultipleValues2(struct rpc_pipe_client *cli,
					    TALLOC_CTX *mem_ctx,
					    WERROR *werror);
#endif /* __CLI_WINREG__ */
