/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#include "JSTreeWalker.h"

#include <wtf/GetPtr.h>

#include "JSNode.h"
#include "JSNodeFilter.h"
#include "Node.h"
#include "NodeFilter.h"
#include "TreeWalker.h"

#include <runtime/Error.h>
#include <runtime/JSNumberCell.h>

using namespace JSC;

namespace WebCore {

ASSERT_CLASS_FITS_IN_CELL(JSTreeWalker)

/* Hash table */

static const HashTableValue JSTreeWalkerTableValues[7] =
{
    { "root", DontDelete|ReadOnly, (intptr_t)jsTreeWalkerRoot, (intptr_t)0 },
    { "whatToShow", DontDelete|ReadOnly, (intptr_t)jsTreeWalkerWhatToShow, (intptr_t)0 },
    { "filter", DontDelete|ReadOnly, (intptr_t)jsTreeWalkerFilter, (intptr_t)0 },
    { "expandEntityReferences", DontDelete|ReadOnly, (intptr_t)jsTreeWalkerExpandEntityReferences, (intptr_t)0 },
    { "currentNode", DontDelete, (intptr_t)jsTreeWalkerCurrentNode, (intptr_t)setJSTreeWalkerCurrentNode },
    { "constructor", DontEnum|ReadOnly, (intptr_t)jsTreeWalkerConstructor, (intptr_t)0 },
    { 0, 0, 0, 0 }
};

static const HashTable JSTreeWalkerTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 255, JSTreeWalkerTableValues, 0 };
#else
    { 18, 15, JSTreeWalkerTableValues, 0 };
#endif

/* Hash table for constructor */

static const HashTableValue JSTreeWalkerConstructorTableValues[1] =
{
    { 0, 0, 0, 0 }
};

static const HashTable JSTreeWalkerConstructorTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 0, JSTreeWalkerConstructorTableValues, 0 };
#else
    { 1, 0, JSTreeWalkerConstructorTableValues, 0 };
#endif

class JSTreeWalkerConstructor : public DOMObject {
public:
    JSTreeWalkerConstructor(ExecState* exec)
        : DOMObject(JSTreeWalkerConstructor::createStructure(exec->lexicalGlobalObject()->objectPrototype()))
    {
        putDirect(exec->propertyNames().prototype, JSTreeWalkerPrototype::self(exec), None);
    }
    virtual bool getOwnPropertySlot(ExecState*, const Identifier&, PropertySlot&);
    virtual const ClassInfo* classInfo() const { return &s_info; }
    static const ClassInfo s_info;

    static PassRefPtr<Structure> createStructure(JSValuePtr proto) 
    { 
        return Structure::create(proto, TypeInfo(ObjectType, ImplementsHasInstance)); 
    }
};

const ClassInfo JSTreeWalkerConstructor::s_info = { "TreeWalkerConstructor", 0, &JSTreeWalkerConstructorTable, 0 };

bool JSTreeWalkerConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSTreeWalkerConstructor, DOMObject>(exec, &JSTreeWalkerConstructorTable, this, propertyName, slot);
}

/* Hash table for prototype */

static const HashTableValue JSTreeWalkerPrototypeTableValues[8] =
{
    { "parentNode", DontDelete|Function, (intptr_t)jsTreeWalkerPrototypeFunctionParentNode, (intptr_t)0 },
    { "firstChild", DontDelete|Function, (intptr_t)jsTreeWalkerPrototypeFunctionFirstChild, (intptr_t)0 },
    { "lastChild", DontDelete|Function, (intptr_t)jsTreeWalkerPrototypeFunctionLastChild, (intptr_t)0 },
    { "previousSibling", DontDelete|Function, (intptr_t)jsTreeWalkerPrototypeFunctionPreviousSibling, (intptr_t)0 },
    { "nextSibling", DontDelete|Function, (intptr_t)jsTreeWalkerPrototypeFunctionNextSibling, (intptr_t)0 },
    { "previousNode", DontDelete|Function, (intptr_t)jsTreeWalkerPrototypeFunctionPreviousNode, (intptr_t)0 },
    { "nextNode", DontDelete|Function, (intptr_t)jsTreeWalkerPrototypeFunctionNextNode, (intptr_t)0 },
    { 0, 0, 0, 0 }
};

static const HashTable JSTreeWalkerPrototypeTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 15, JSTreeWalkerPrototypeTableValues, 0 };
#else
    { 16, 15, JSTreeWalkerPrototypeTableValues, 0 };
#endif

const ClassInfo JSTreeWalkerPrototype::s_info = { "TreeWalkerPrototype", 0, &JSTreeWalkerPrototypeTable, 0 };

JSObject* JSTreeWalkerPrototype::self(ExecState* exec)
{
    return getDOMPrototype<JSTreeWalker>(exec);
}

bool JSTreeWalkerPrototype::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticFunctionSlot<JSObject>(exec, &JSTreeWalkerPrototypeTable, this, propertyName, slot);
}

const ClassInfo JSTreeWalker::s_info = { "TreeWalker", 0, &JSTreeWalkerTable, 0 };

JSTreeWalker::JSTreeWalker(PassRefPtr<Structure> structure, PassRefPtr<TreeWalker> impl)
    : DOMObject(structure)
    , m_impl(impl)
{
}

JSTreeWalker::~JSTreeWalker()
{
    forgetDOMObject(*Heap::heap(this)->globalData(), m_impl.get());

}

JSObject* JSTreeWalker::createPrototype(ExecState* exec)
{
    return new (exec) JSTreeWalkerPrototype(JSTreeWalkerPrototype::createStructure(exec->lexicalGlobalObject()->objectPrototype()));
}

bool JSTreeWalker::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSTreeWalker, Base>(exec, &JSTreeWalkerTable, this, propertyName, slot);
}

JSValuePtr jsTreeWalkerRoot(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    TreeWalker* imp = static_cast<TreeWalker*>(static_cast<JSTreeWalker*>(asObject(slot.slotBase()))->impl());
    return toJS(exec, WTF::getPtr(imp->root()));
}

JSValuePtr jsTreeWalkerWhatToShow(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    TreeWalker* imp = static_cast<TreeWalker*>(static_cast<JSTreeWalker*>(asObject(slot.slotBase()))->impl());
    return jsNumber(exec, imp->whatToShow());
}

JSValuePtr jsTreeWalkerFilter(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    TreeWalker* imp = static_cast<TreeWalker*>(static_cast<JSTreeWalker*>(asObject(slot.slotBase()))->impl());
    return toJS(exec, WTF::getPtr(imp->filter()));
}

JSValuePtr jsTreeWalkerExpandEntityReferences(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    TreeWalker* imp = static_cast<TreeWalker*>(static_cast<JSTreeWalker*>(asObject(slot.slotBase()))->impl());
    return jsBoolean(imp->expandEntityReferences());
}

JSValuePtr jsTreeWalkerCurrentNode(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    TreeWalker* imp = static_cast<TreeWalker*>(static_cast<JSTreeWalker*>(asObject(slot.slotBase()))->impl());
    return toJS(exec, WTF::getPtr(imp->currentNode()));
}

JSValuePtr jsTreeWalkerConstructor(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    return static_cast<JSTreeWalker*>(asObject(slot.slotBase()))->getConstructor(exec);
}
void JSTreeWalker::put(ExecState* exec, const Identifier& propertyName, JSValuePtr value, PutPropertySlot& slot)
{
    lookupPut<JSTreeWalker, Base>(exec, propertyName, value, &JSTreeWalkerTable, this, slot);
}

void setJSTreeWalkerCurrentNode(ExecState* exec, JSObject* thisObject, JSValuePtr value)
{
    TreeWalker* imp = static_cast<TreeWalker*>(static_cast<JSTreeWalker*>(thisObject)->impl());
    ExceptionCode ec = 0;
    imp->setCurrentNode(toNode(value), ec);
    setDOMException(exec, ec);
}

JSValuePtr JSTreeWalker::getConstructor(ExecState* exec)
{
    return getDOMConstructor<JSTreeWalkerConstructor>(exec);
}

JSValuePtr jsTreeWalkerPrototypeFunctionParentNode(ExecState* exec, JSObject*, JSValuePtr thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSTreeWalker::s_info))
        return throwError(exec, TypeError);
    JSTreeWalker* castedThisObj = static_cast<JSTreeWalker*>(asObject(thisValue));
    return castedThisObj->parentNode(exec, args);
}

JSValuePtr jsTreeWalkerPrototypeFunctionFirstChild(ExecState* exec, JSObject*, JSValuePtr thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSTreeWalker::s_info))
        return throwError(exec, TypeError);
    JSTreeWalker* castedThisObj = static_cast<JSTreeWalker*>(asObject(thisValue));
    return castedThisObj->firstChild(exec, args);
}

JSValuePtr jsTreeWalkerPrototypeFunctionLastChild(ExecState* exec, JSObject*, JSValuePtr thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSTreeWalker::s_info))
        return throwError(exec, TypeError);
    JSTreeWalker* castedThisObj = static_cast<JSTreeWalker*>(asObject(thisValue));
    return castedThisObj->lastChild(exec, args);
}

JSValuePtr jsTreeWalkerPrototypeFunctionPreviousSibling(ExecState* exec, JSObject*, JSValuePtr thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSTreeWalker::s_info))
        return throwError(exec, TypeError);
    JSTreeWalker* castedThisObj = static_cast<JSTreeWalker*>(asObject(thisValue));
    return castedThisObj->previousSibling(exec, args);
}

JSValuePtr jsTreeWalkerPrototypeFunctionNextSibling(ExecState* exec, JSObject*, JSValuePtr thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSTreeWalker::s_info))
        return throwError(exec, TypeError);
    JSTreeWalker* castedThisObj = static_cast<JSTreeWalker*>(asObject(thisValue));
    return castedThisObj->nextSibling(exec, args);
}

JSValuePtr jsTreeWalkerPrototypeFunctionPreviousNode(ExecState* exec, JSObject*, JSValuePtr thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSTreeWalker::s_info))
        return throwError(exec, TypeError);
    JSTreeWalker* castedThisObj = static_cast<JSTreeWalker*>(asObject(thisValue));
    return castedThisObj->previousNode(exec, args);
}

JSValuePtr jsTreeWalkerPrototypeFunctionNextNode(ExecState* exec, JSObject*, JSValuePtr thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSTreeWalker::s_info))
        return throwError(exec, TypeError);
    JSTreeWalker* castedThisObj = static_cast<JSTreeWalker*>(asObject(thisValue));
    return castedThisObj->nextNode(exec, args);
}

JSC::JSValuePtr toJS(JSC::ExecState* exec, TreeWalker* object)
{
    return getDOMObjectWrapper<JSTreeWalker>(exec, object);
}
TreeWalker* toTreeWalker(JSC::JSValuePtr value)
{
    return value->isObject(&JSTreeWalker::s_info) ? static_cast<JSTreeWalker*>(asObject(value))->impl() : 0;
}

}
