/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <qlayout.h>

#include <klocale.h>
#include <kiconloader.h>

#include <kdebug.h>

#include "ksprefs.moc"
#include "page_general.h"
#include "page_colors.h"
#include "page_startup.h"
#include "page_rmbmenu.h"
#include "page_servchan.h"
#include "page_font.h"


KSPrefs::KSPrefs(QWidget * parent, const char * name):
    KDialogBase(KDialogBase::IconList, i18n("Configure KSirc"),
                KDialogBase::Help | KDialogBase::Ok | KDialogBase::Apply | KDialogBase::Cancel | KDialogBase::Default,
                KDialogBase::Ok, parent, name)
{
    setWFlags( getWFlags() | WDestructiveClose );
    QFrame *itemGeneral  = addPage( i18n( "General" ), i18n( "General KSirc Settings" ), BarIcon( "ksirc", KIcon::SizeMedium ) );
    QFrame *itemStartup  = addPage( i18n( "Startup" ), i18n( "KSirc Startup Settings" ), BarIcon( "gear", KIcon::SizeMedium ) );
    QFrame *itemColors   = addPage( i18n( "Colors" ), i18n( "KSirc Color Settings" ), BarIcon( "colors", KIcon::SizeMedium ) );
    /*
    QFrame *itemRMBMenu  = addPage( i18n( "User Menu" ), i18n( "User menu configuration" ), BarIcon( "", KIcon::SizeMedium ) );
    QFrame *itemServChan = addPage( i18n( "Server/Channel" ), i18n( "Server/channel configuration" ), BarIcon( "", KIcon::SizeMedium ) );
    */


    QFrame *itemFont = addPage( i18n( "Fonts" ), i18n( "Font Settings" ), BarIcon( "fonts", KIcon::SizeMedium ) );
    QVBoxLayout *fontTopLayout  = new QVBoxLayout( itemFont, 0, 6 );



    QVBoxLayout *generalTopLayout  = new QVBoxLayout( itemGeneral, 0, 6 );
    QVBoxLayout *startupTopLayout  = new QVBoxLayout( itemStartup, 0, 6 );
    QVBoxLayout *colorsTopLayout   = new QVBoxLayout( itemColors, 0, 6 );
    /*
    QVBoxLayout *rmbMenuTopLayout  = new QVBoxLayout( itemRMBMenu, 0, 6 );
    QVBoxLayout *servChanTopLayout = new QVBoxLayout( itemServChan, 0, 6 );
    */

    pageGeneral  = new PageGeneral( itemGeneral );
    pageStartup  = new PageStartup( itemStartup );
    pageColors   = new PageColors( itemColors );
    pageFont     = new PageFont(itemFont);

    /*
    pageRMBMenu  = new PageRMBMenu( itemRMBMenu );
    pageServChan = new PageServChan( itemServChan );
    */

    connect(pageGeneral, SIGNAL( modified() ), SLOT( modified() ) );
    connect(pageStartup, SIGNAL( modified() ), SLOT( modified() ) );
    connect(pageColors, SIGNAL( modified() ), SLOT( modified() ) );
    connect(pageFont, SIGNAL( modified() ), SLOT( modified() ) );


    /*
    connect(pageRMBMenu, SIGNAL( modified() ), SLOT( modified() ) );
    connect(pageServChan, SIGNAL( modified() ), SLOT( modified() ) );
    */

    connect(this, SIGNAL( applyClicked() ), this, SLOT( saveConfig() ) );
    connect(this, SIGNAL( okClicked() ), this, SLOT( saveConfig() ) );
    connect(this, SIGNAL( defaultClicked() ), this, SLOT(defaultConfig() ) );

    generalTopLayout->addWidget( pageGeneral );
    startupTopLayout->addWidget( pageStartup );
    colorsTopLayout->addWidget( pageColors );
    fontTopLayout->addWidget( pageFont );

    /*
    rmbMenuTopLayout->addWidget( pageRMBMenu );
    servChanTopLayout->addWidget( pageServChan );
    */

	//enableButtonSeperator( true );

    readConfig();
    enableButtonApply( false );
}

KSPrefs::~KSPrefs()
{
}

void KSPrefs::readConfig()
{
	// apply by calling readConfig in each page

	pageGeneral->readConfig();
	pageColors->readConfig();
	pageStartup->readConfig();
	pageFont->readConfig();

 /*
	pageRMBMenu->readConfig();
	pageServChan->readConfig();
 */

}

void KSPrefs::saveConfig()
{
	// apply by calling saveConfig in each page
	// use setDirty flag for each page and
	// emit update() appropriate

    if ( dirty & KSOptions::General )
        pageGeneral->saveConfig();
    if ( dirty & KSOptions::Startup )
        pageStartup->saveConfig();
    if ( dirty & KSOptions::Colors )
        pageColors->saveConfig();
    if ( dirty & KSOptions::Colors )
        pageFont->saveConfig();
    /*
    if ( dirty & KSOptions::RMBMenu )
        pageRMBMenu->saveConfig();
    if ( dirty & KSOptions::ServChan )
        pageServChan->saveConfig();
        */

    ksopts->save( dirty );
    emit update( dirty );
    enableButtonApply( false );
}


void KSPrefs::defaultConfig()
{
	// apply by calling defaultConfig in current page

    switch (activePageIndex())
    {
        case 0:
            pageGeneral->defaultConfig();
            break;
        case 1:
            pageStartup->defaultConfig();
            break;
        case 2:
            pageColors->defaultConfig();
            break;
        case 3:
            pageFont->defaultConfig();
            break;
            /*
        case 3:
            pageRMBMenu->defaultConfig();
            break;
        case 4:
            pageServChan->defaultConfig();
            break;
            */
    }
}

void KSPrefs::modified()
{
    if ( sender() == pageGeneral )
        dirty |= static_cast<int>( KSOptions::General );
    if ( sender() == pageStartup )
        dirty |= static_cast<int>( KSOptions::Startup );
    if ( sender() == pageColors )
        dirty |= static_cast<int>( KSOptions::Colors );
    if ( sender() == pageFont )
        dirty |= static_cast<int>( KSOptions::Colors );
    /*
    if ( sender() == pageRMBMenu )
        dirty |= static_cast<int>( KSOptions::RMBMenu );
    if ( sender() == pageServChan )
        dirty |= static_cast<int>( KSOptions::ServChan );
        */

    enableButtonApply( dirty );
}
