/*  This file is part of the KDE project
    Copyright (C) 2002 Matthias Kretz <kretz@kde.org>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License version 2
    as published by the Free Software Foundation.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*/

#include "confmodules.h"
#include "kimageviewer/canvas.h"
#include "generalconfigwidget.h"

#include <qlayout.h>
#include <qcheckbox.h>
#include <qframe.h>

#include "kpluginselector.h"
#include <kxmlguiclient.h>
#include <klocale.h>
#include <kdialog.h>
#include <kglobal.h>
#include <kconfig.h>
#include <klistview.h>
#include <knuminput.h>

GeneralConfig::GeneralConfig( KImageViewer::Canvas * canvas, KInstance * instance, QObject * parent )
	: KPreferencesModule( 0, i18n( "General KViewViewer Configuration" ), "kview", parent, "KViewViewer General Config Module" )
	, m_instance( instance )
	, m_pCanvas( canvas )
{
	setGroupName( i18n( "Viewer" ) );
}

GeneralConfig::~GeneralConfig()
{
}

void GeneralConfig::applyChanges()
{
	KConfigGroup cfgGroup( m_instance->config(), "Settings" );
	cfgGroup.writeEntry( "Smooth Scaling", m_pWidget->m_pSmoothScaling->isChecked() );
	cfgGroup.writeEntry( "Keep Aspect Ratio", m_pWidget->m_pKeepRatio->isChecked() );
	cfgGroup.writeEntry( "Center Image", m_pWidget->m_pCenterImage->isChecked() );

	cfgGroup.writeEntry( "Minimum Width" , m_pWidget->m_pMinWidth->value() );
	cfgGroup.writeEntry( "Minimum Height", m_pWidget->m_pMinHeight->value() );
	cfgGroup.writeEntry( "Maximum Width" , m_pWidget->m_pMaxWidth->value() );
	cfgGroup.writeEntry( "Maximum Height", m_pWidget->m_pMaxHeight->value() );

	KConfigGroup cfgGroup2( m_instance->config(), "Blend Effects" );
	QCheckListItem *item = m_items.first();
	for( int i = 1; item; item = m_items.next(), ++i )
		cfgGroup2.writeEntry( QString::number( i ), item->isOn() );
	emit configChanged();
}

void GeneralConfig::reset()
{
	KConfigGroup cfgGroup( m_instance->config(), "Settings" );
	m_pWidget->m_pSmoothScaling->setChecked( cfgGroup.readBoolEntry( "Smooth Scaling", true ) );
	m_pWidget->m_pKeepRatio->setChecked( cfgGroup.readBoolEntry( "Keep Aspect Ratio", true ) );
	m_pWidget->m_pCenterImage->setChecked( cfgGroup.readBoolEntry( "Center Image", true ) );

	m_pWidget->m_pMinWidth ->setValue( cfgGroup.readNumEntry( "Minimum Width" , 1 ) );
	m_pWidget->m_pMinHeight->setValue( cfgGroup.readNumEntry( "Minimum Height", 1 ) );
	m_pWidget->m_pMaxWidth ->setValue( cfgGroup.readNumEntry( "Maximum Width" , 10000 ) );
	m_pWidget->m_pMaxHeight->setValue( cfgGroup.readNumEntry( "Maximum Height", 10000 ) );

	KConfigGroup cfgGroup2( m_instance->config(), "Blend Effects" );
	QCheckListItem * item = m_items.first();
	for( int i = 1; item; item = m_items.next(), ++i )
		item->setOn( cfgGroup2.readBoolEntry( QString::number( i ), false ) );
}

void GeneralConfig::createPage( QFrame * page )
{
	QBoxLayout * layout = new QVBoxLayout( page );
	layout->setAutoAdd( true );

	m_pWidget = new GeneralConfigWidget( page );
	m_pWidget->m_pMinWidth ->setRange( 1, 200 );
	m_pWidget->m_pMinHeight->setRange( 1, 200 );
	m_pWidget->m_pMaxWidth ->setRange( 1, 10000 );
	m_pWidget->m_pMaxHeight->setRange( 1, 10000 );

	// clear m_items
	m_items.clear();

	for( unsigned int i = 1; i <= m_pCanvas->numOfBlendEffects(); ++i )
	{
		QCheckListItem * item = new QCheckListItem( m_pWidget->m_pListView, m_pCanvas->blendEffectDescription( i ), QCheckListItem::CheckBox );
		m_items.append( item );
	}
	reset();
}

// ########### PluginConfig #############

PluginConfig::PluginConfig( KInstance * instance, QObject * parent )
	: KPreferencesModule( i18n( "Plugins" ), i18n( "Select Which Plugins to Use" ), "input_devices_settings", parent, "KViewViewer Plugin Config Module" )
	, m_instance( instance )
	, m_pPluginSelector( 0 )
{
}

PluginConfig::~PluginConfig()
{
}

void PluginConfig::applyChanges()
{
	m_pPluginSelector->save();
	emit configChanged();
}

void PluginConfig::reset()
{
}

void PluginConfig::createPage( QFrame * page )
{
	QBoxLayout * layout = new QVBoxLayout( page );
	layout->setAutoAdd( true );
	m_pPluginSelector = new KPluginSelector( m_instance, page );
}

// vim:sw=4:ts=4

#include "confmodules.moc"
