//-*-C++-*-
/*
**************************************************************************
                                 description
                             --------------------
    copyright            : (C) 2001 by Andreas Zehender
    email                : zehender@kde.org
**************************************************************************

**************************************************************************
*                                                                        *
*  This program is free software; you can redistribute it and/or modify  *
*  it under the terms of the GNU General Public License as published by  *
*  the Free Software Foundation; either version 2 of the License, or     *
*  (at your option) any later version.                                   *
*                                                                        *
**************************************************************************/


#ifndef PMPOVRAYMATRIX_H
#define PMPOVRAYMATRIX_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "pmobject.h"

/**
 * Class for povray matrix transformations.
 */ 

class PMPovrayMatrix : public PMObject
{
   typedef PMObject Base;
public:
   /** Creates an identity matrix */
   PMPovrayMatrix( );
   /** deletes the object */
   virtual ~PMPovrayMatrix( );

   /** */
   virtual PMObject* newObject( ) const { return new PMPovrayMatrix( ); }
   /** */
   virtual QString className( ) const { return QString( "povraymatrix" ); }
   /** */
   virtual QString description( ) const;
   /** */
   virtual PMObjectType type( ) const { return PMTMatrix; }
   /** */
   virtual bool isA( PMObjectType t ) const;

   
   /** */
   virtual void serialize( PMOutputDevice& dev ) const;
   /** */
   virtual void serialize( QDomElement& e, QDomDocument& doc ) const;
   /** */
   virtual void readAttributes( const PMXMLHelper& h );
   /** Returns a new @ref PMPovrayMatrixEdit */
   virtual PMDialogEditBase* editWidget( QWidget* parent ) const;
   /** */
   virtual QString pixmap( ) const { return QString( "pmmatrix" ); }

   /** Returns the matrix values. */
   PMVector values( ) const { return m_values; }
   /** Sets the matrix values. Has to be a vector with size 12. */
   void setValues( const PMVector& v );
   
   /** */
   virtual void restoreMemento( PMMemento* s );
   /** */
   virtual bool hasTransformationMatrix( ) const { return true; }
   /** */
   virtual PMMatrix transformationMatrix( ) const;

private:
   /** IDs for @ref PMMementoData */
   enum PMMatrixMementoID { PMMatrixID };
   PMVector m_values;
};

#endif
