//-*-C++-*-
/*
**************************************************************************
                                description
                             -------------------
    copyright            : (C) 2002 by Andreas Zehender
    email                : zehender@kde.org
**************************************************************************

**************************************************************************
*                                                                        *
*  This program is free software; you can redistribute it and/or modify  *
*  it under the terms of the GNU General Public License as published by  *
*  the Free Software Foundation; either version 2 of the License, or     *
*  (at your option) any later version.                                   *
*                                                                        *
**************************************************************************/


#ifndef PMBLOBSPHERE_H
#define PMBLOBSPHERE_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "pmnamedobject.h"
#include "pmvector.h"
#include "pmviewstructure.h"

/**
 * Class for povray sphere.
 */
class PMBlobSphere : public PMNamedObject
{
   typedef PMNamedObject Base;

public:
   /** Create an empty BlobSphere */
   PMBlobSphere( );
   /** Delete the PMBlobSphere */
   virtual ~PMBlobSphere( );

   /** */
   virtual PMObject* newObject( ) const { return new PMBlobSphere( ); }
   /** */
   virtual QString className( ) const { return QString( "blobsphere" ); }
   /** */
   virtual PMObjectType type( ) const { return PMTBlobSphere; }
   /** */
   virtual QString description( ) const;
   /** */
   virtual bool isA( PMObjectType t ) const;
   
   /** */
   virtual void serialize( PMOutputDevice& dev ) const;
   /** */
   virtual void serialize( QDomElement& e, QDomDocument& doc ) const;
   /** */
   virtual void readAttributes( const PMXMLHelper& h );
   /** Returns a new @ref PMBlobSphereEdit */
   virtual PMDialogEditBase* editWidget( QWidget* parent ) const;
   /** Returns the name of the pixmap that is displayed in the tree view
    * and dialog view */
   virtual QString pixmap( ) const { return QString( "pmblobsphere" ); }
   /** */
   virtual bool canInsert( PMObjectType, const PMObject* after,
                           const PMObjectList* objectsBetween = 0 ) const;

   /** Returns the centre of the sphere */
   PMVector centre( ) const { return m_centre; }
   /** Set the centre of the sphere */
   void setCentre( const PMVector& centre );
   /** returns the radius of the sphere */
   double radius( ) const { return m_radius; }
   /** Sets the radius of the sphere */
   void setRadius( double radius );
   /** Returns the components strength */
   double strength( ) const { return m_strength; }
   /** Sets the strength */
   void setStrength( double s );

   /** */
   virtual void restoreMemento( PMMemento* s );
   /** */
   virtual void controlPoints( PMControlPointList& list );
   /** */
   virtual void controlPointsChanged( PMControlPointList& list );

   /** Sets the number of latitutes */
   static void setUSteps( int u );
   /** Sets the number of longitudes */
   static void setVSteps( int v );
   /** Returns the number or latitutes */
   static int uSteps( ) { return s_uStep; }
   /** Returns the number or longitudes */
   static int vSteps( ) { return s_vStep; }
   /** */
   virtual void cleanUp( ) const;
   
protected:
   /** */
   virtual bool isDefault( );
   /** */
   virtual void createViewStructure( );
   /** */
   virtual PMViewStructure* defaultViewStructure( ) const;
   /** */
   virtual int viewStructureParameterKey( ) const { return s_parameterKey; }

private:
   /** Creates the points for the view structure */
   static void createPoints( PMPointArray& points, const PMVector& centre,
                             double radius );
   
   enum PMBlobSphereMementoID { PMRadiusID, PMCentreID, PMStrengthID };
   /** Radius of the sphere */
   double m_radius;
   /** centre of the sphere */
   PMVector m_centre;
   double m_strength;
   
   static PMViewStructure* s_pDefaultViewStructure;
   static int s_vStep;
   static int s_uStep;
   static int s_parameterKey;
};


#endif
