/** 
 * Copyright (C) 1997-2002 the KGhostView authors. See file AUTHORS.
 * 	
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef SCROLL_BOX_H
#define SCROLL_BOX_H

#include <qframe.h>

class ScrollBox: public QFrame
{
	Q_OBJECT

public:
	ScrollBox( QWidget * parent = 0, const char * name = 0 );

public slots:
	void	setPageSize( QSize );
	void	setViewSize( QSize );
	void	setViewPos( QPoint );
	void	setViewPos( int x, int y ) { setViewPos( QPoint( x, y ) ); }

signals:
	void	valueChanged( QPoint );
	void    valueChangedRelative( int dx, int dy );
	void	button2Pressed(); 
	void	button3Pressed(); 

protected:
	void	mousePressEvent ( QMouseEvent *);
	void	mouseMoveEvent ( QMouseEvent *);
	void	drawContents ( QPainter *);

private:
	void    setBackgroundMode();

private:
	QPoint	viewpos, mouse;
	QSize	pagesize;
	QSize	viewsize;
};

#endif
