/***************************************************************************
                          angle.cpp  -  description
                             -------------------
    begin                : Tue Jul 31 2001
    copyright            : (C) 2001 by Marc Bartsch
    email                : marc.bartsch@web.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "angle.h"

Angle::Angle()
{
	ID = ID_angle;
  identificator = "Angle";

	int temp[] = { ID_geoPoint, 3, -1, ID_arc, 1, -1 };
	convertParams( temp, sizeof( temp ) / sizeof( temp[0] ) );
	pic = QPixmap( UserIcon( "angle" ) );
	picRect  = QRect( 2, 2, 20, 20 );
}

Angle::~Angle()
{
}

void Angle::move()
{
	Coordinates coord1, coord2, coord3, coord4, coord5;

	if ( parents.count() == 3 )
	{
		coord1 = parents.at( 0 )->getCoordinates();
		coord2 = parents.at( 1 )->getCoordinates();
		coord3 = parents.at( 2 )->getCoordinates();
	}
	else
	{
		coord1 = parents.at( 0 )->parents.at( 0 )->getCoordinates();
		coord2 = parents.at( 0 )->parents.at( 1 )->getCoordinates();
		coord3 = parents.at( 0 )->parents.at( 2 )->getCoordinates();
	}

	// Figure out anchorPoint.
  coord4 = coord1 - coord2;
  coord5 = coord3 - coord2;

	if ( coord4.getLength() < coord5.getLength() )
	{
		coord5.normalize( coord4.getLength() );
	}
	else
	{
		coord4.normalize( coord5.getLength() );
	}

	double rad;
	rad = coord5.getLength();
	rad *= 0.6;

  coord4 -= coord5;
	coord4 /= 2;
	coord4 += coord5;
	coord4.normalize( coord5.getLength() * 0.33 );
	coord4 += coord2;

	// Anchor point on the correct side?
	if ( coord3.orientation( coord1, coord2 ) < 0 )
	{
		coord4 = coord2 - coord4;
		coord4 += coord2;
	}

	anchorPoint = QPoint( coord4.getI_X(), coord4.getI_Y() );

	// Calculate angles.
	coord1.invertY();
	coord2.invertY();
	coord3.invertY();

	double myValue = coord2.getAngleDeg( coord1, coord3 );

  value = QString().setNum( myValue,'f',4 );
//	value = value + " ";

	if ( textRect.height() == 0 )
	{
		textRect = QRect( 0, 0, 0, 22 );
  	textRect.moveCenter( anchorPoint );
	}

	coords = Coordinates( textRect.center() );
}
