/*  ksim - a system monitor for kde
 *
 *  Copyright (C) 2001  Robbie Ward <linuxphreak@gmx.co.uk>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef SCROLLWIDGET_H
#define SCROLLWIDGET_H

#include <qscrollview.h>
#include <qvaluelist.h>

class KProcess;
class QTimer;
class QBoxLayout;
namespace KSim
{
  class Progress;
}

class FSysScroller : public QScrollView
{
  Q_OBJECT
  public:
    FSysScroller(bool stackItems, uint speed, 
       QWidget *parent, const char *name = 0);
    ~FSysScroller();

    const QString &text(uint) const;
    int value(uint) const;

    QSize sizeHint() const;
    QSize minimumSizeHint() const;

  public slots:
    void clear();
    void append(uint, int, const QString &);
    void setText(uint, const QString &);
    void setValue(uint, int);
    void setScrollSpeed(uint);
    void insertDummy(); // sort of a hack
    void resizeScroller();
    void setStackScroller(bool);

  protected:
    void wheelEvent(QWheelEvent *);
    void resizeEvent(QResizeEvent *);
    bool eventFilter(QObject *, QEvent *);

  private slots:
    void receivedStderr(KProcess *, char *, int);
    void processExited(KProcess *);
    void startScrolling();
    void stopScrolling();

  private:
    void createProcess(const QString &, const QString &);
    void showMenu(uint);
    void setDirection(int);
    void removeDummy();

    typedef QValueList<QPair<KSim::Progress *, QString> > ProgressList;
    ProgressList m_progressList;
    int m_dummyMax;
    int m_minHeight;
    int m_minWidth;
    bool m_stackItems;
    QBoxLayout *m_layout;
    KProcess *m_mountProcess;
    KSim::Progress *m_dummyProgress;
    QTimer *m_scrollTimer;
    QString m_stderrString;
    QWidget *m_main;
};
#endif
