/*
**************************************************************************
                                 description
                             --------------------
    copyright            : (C) 2002 by Andreas Zehender
    email                : zehender@kde.org
**************************************************************************

**************************************************************************
*                                                                        *
*  This program is free software; you can redistribute it and/or modify  *
*  it under the terms of the GNU General Public License as published by  *
*  the Free Software Foundation; either version 2 of the License, or     *
*  (at your option) any later version.                                   *
*                                                                        *
**************************************************************************/


#include "pmboundedby.h"
#include "pmboundedbyedit.h"
#include "pmoutputdevice.h"
#include "pmxmlhelper.h"
#include "pmmemento.h"

#include <klocale.h>

#include <kdebug.h>
#include "pmglobals.h"

PMBoundedBy::PMBoundedBy( )
      : Base( )
{
}

PMBoundedBy::~PMBoundedBy( )
{
}

bool PMBoundedBy::isA( PMObjectType t ) const
{
   if( t == PMTBoundedBy )
      return true;
   return Base::isA( t );
}

QString PMBoundedBy::description( ) const
{
   return i18n( "bounded by" );
}

bool PMBoundedBy::canInsert( PMObjectType t, const PMObject* /*after*/,
                             const PMObjectList* /*objectsBetween*/ ) const
{
   switch( t )
   {
      case PMTComment:
      case PMTBox:
      case PMTBlob:
      case PMTCone:
      case PMTCylinder:
      case PMTHeightField:
      case PMTJuliaFractal:
      case PMTLathe:
      case PMTPrism:         
      case PMTSphere:
      case PMTSuperquadricEllipsoid:
      case PMTSurfaceOfRevolution:
      case PMTText:
      case PMTTorus:
      case PMTPlane:
      case PMTPolynom:
      case PMTRaw:
      case PMTObjectLink:
         return true;
      default:
         break;
   }
   return false;
}

bool PMBoundedBy::clippedBy( ) const
{
   bool cb = true;
   PMObject* o = firstChild( );
   
   for( ; o && cb; o = o->nextSibling( ) )
      if( o->type( ) != PMTComment )
         cb = false;
   
   return cb;
}

void PMBoundedBy::serialize( PMOutputDevice& dev ) const
{
   dev.objectBegin( "bounded_by" );
   if( clippedBy( ) )
      dev.writeLine( "clipped_by" );
   Base::serialize( dev );
   dev.objectEnd( );
}

void PMBoundedBy::serialize( QDomElement& e, QDomDocument& doc ) const
{
   // no extra data at the moment
   Base::serialize( e, doc );
}

void PMBoundedBy::readAttributes( const PMXMLHelper& h )
{
   // no extra data at the moment
   Base::readAttributes( h );
}

PMDialogEditBase* PMBoundedBy::editWidget( QWidget* parent ) const
{
   return new PMBoundedByEdit( parent );
}

void PMBoundedBy::childRemoved( PMObject* o )
{
   Base::childRemoved( o );

   // add a dummy change
   if( m_pMemento )
      m_pMemento->addData( PMTBoundedBy, PMClippedByID, true );
}

void PMBoundedBy::childAdded( PMObject* o )
{
   Base::childAdded( o );

   if( m_pMemento )
      m_pMemento->addData( PMTBoundedBy, PMClippedByID, true );
}
