/***************************************************************************
                          triangle.cpp  -  description
                             -------------------
    begin                : Sun Mar 26 2000
    copyright            : (C) 2000 by Marc Bartsch
    email                : marc.bartsch@topmail.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "triangle.h"

Triangle::Triangle(): GeoTool()
{
	acceptsGeoPoint = true;
	ID = ID_triangle;
  identificator = "Triangle";

	int temp[] = { ID_geoPoint, 3, -1 };
	convertParams( temp, sizeof( temp ) / sizeof( temp[0] ) );
}

Triangle::~Triangle()
{
}

void Triangle::processObjects()
{
	GeoObjects *pt1 = parents.first();
	GeoObjects *pt2 = parents.next();
	GeoObjects *pt3 = parents.next();

	insertLine( pt1, pt2 );
	insertLine( pt2, pt3 );
	insertLine( pt3, pt1 );
}

void Triangle::insertLine( GeoObjects *pt1, GeoObjects *pt2 )
{
	bool found = false;
	GeoObjects *actual;
	GeoObjects *segment;

	//	Check whether pt1 and pt2 already have a segment as child
	for ( actual = pt1->children.first(); actual; actual = pt1->children.next() )
	{
		if ( pt2->children.find( actual ) != -1 )
		{
			//	Ok, we found a child of p1 and p2. Is it really a segment?
			if ( (actual->identify()==QString( "Segment" )) )
			{
				found = true;
			}
		}
	}

	if ( !found )
	{
		segment = new Segment();

  	segment->setInitComplete( true );

		pt1->children.append( segment );
		segment->parents.append( pt1 );
		pt2->children.append( segment );
		segment->parents.append( pt2 );

		addList.append( segment );

		if ( pt1->getLevel() >= pt2->getLevel() )
		{
			segment->setLevel( pt1->getLevel() + 1 );
		}
		else
		{
			segment->setLevel( pt2->getLevel() + 1 );
		}

		segment->move();
	}
}
