/***************************************************************************
                          geotool.cpp  -  description
                             -------------------
    begin                : Sun Jul 15 2001
    copyright            : (C) 2001 by Marc Bartsch
    email                : marc.bartsch@web.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "geotool.h"

GeoTool::GeoTool() : GeoObjects()
{
	ID = ID_geoTool;
  identificator = "GeoTool";

	canBeDestroyed = true;
}

GeoTool::~GeoTool()
{
}

void GeoTool::initObject( GeoObjects* obj )
{
  parents.append( obj );

	if ( processParams( obj ) )
	{
		processObjects();

		initComplete = true;
	}
	else
	{
		parents.current()->setChosen( true );
	}
}

void GeoTool::processObjects()
{
}

void GeoTool::deleteObjects( QList <GeoObjects> & list )
{
	list.setAutoDelete( true );

	GeoObjects *actual;

  QListIterator<GeoObjects> iter( eraseList );

 	for ( actual = iter.toFirst(); actual; actual = ++iter )
 	{
 		if ( list.contains( actual ) != 0 )
 		{
  		list.removeRef( actual );
 		}
 	}

	list.setAutoDelete( false );
}

void GeoTool::addObjects( QList <GeoObjects> & list )
{
	GeoObjects *actual;

  QListIterator<GeoObjects> iter( addList );

 	for ( actual = iter.toFirst(); actual; actual = ++iter )
 	{
		list.append( actual );
 	}
}


