#ifndef UNIX_H
#define UNIX_H

#include <sys/cdefs.h>
#include <netatalk/endian.h>
#include "volume.h"

#ifdef ultrix
#include <sys/mount.h>
#include <sys/quota.h>
#endif ultrix

/* some GLIBC/old-libc-isms */
#ifdef __GNU_LIBRARY__
#if __GNU_LIBRARY__ < 6
#define USE_VFS_H
#else
#define USE_STATFS_H
#endif
#endif

#if defined(USE_VFS_H) || defined( sun ) || defined( ibm032 ) 
#include <sys/vfs.h>
#endif

#if defined(_IBMR2) || defined(USE_STATFS_H) 
#include <sys/statfs.h>
#endif

#if defined( __svr4__ )
#include <sys/fs/ufs_quota.h>
#include <sys/statvfs.h>
#include <sys/mnttab.h>
#endif __svr4__

#ifdef BSD4_4
#include <ufs/ufs/quota.h>
#include <sys/mount.h>
#define dqb_btimelimit	dqb_btime
#endif BSD4_4

#ifdef linux
#ifdef NEED_QUOTACTL_WRAPPER
#include <asm/types.h>
#include <asm/unistd.h>
#include <linux/quota.h>
#else
#include <sys/quota.h>
#endif

#include <sys/mount.h>
#include <mntent.h>
#define dqb_btimelimit  dqb_btime
#endif

#if !defined( linux ) && !defined( ultrix ) && !defined( __svr4__ ) && \
	!defined( BSD4_4 )
#include <ufs/quota.h>
#include <mntent.h>
#endif linux ultrix __svr4__

#ifdef ibm032
typedef unsigned short	mode_t;
#endif ibm032

#if defined( sun ) && !defined( __svr4__ )
#ifdef i386
typedef int	mode_t;
#endif i386
#endif sun __svr4__

#ifdef __svr4__
#define statfs statvfs
#else __svr4__
#define	f_frsize f_bsize
#endif __svr4__


int getnfsquota __P((struct vol *, const int, const u_int32_t,
		     struct dqblk *));

#endif
