/* -*- C++ -*-

  $Id: EditPointCmd.h,v 1.5 2001/02/13 15:31:15 neundorf Exp $

  This file is part of KIllustrator.
  Copyright (C) 1998 Kai-Uwe Sattler (kus@iti.cs.uni-magdeburg.de)

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU Library General Public License as
  published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU Library General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*/

#ifndef EditPointCmd_h_
#define EditPointCmd_h_

#include <Command.h>

class GDocument;
class GObject;

class EditPointCmd : public Command {
public:
  EditPointCmd (GDocument* doc, GObject* o, int idx,
                float dx, float dy);
  ~EditPointCmd ();

  void execute ();
  void unexecute ();

private:
  GDocument* document;
  GObject* obj;
  int index;
  float xoff, yoff;
};

#endif
