/***************************************************************************
                          reportview.cpp  -  description
                             -------------------
    begin                : Sun Oct 15 2000
    copyright            : (C) 2000 by Ian Reinhart Geiser
    email                : geiseri@msoe.edu
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <qlayout.h>
#include <qpixmap.h>
#include <kdebug.h>
#include <klocale.h>
#include <kstandarddirs.h>
#include <khtml_part.h>

#include "reportview.h"

reportView::reportView(QWidget *parent, const char *name) : QDialog(parent, name, true, WDestructiveClose) {
    QHBoxLayout *layout = new QHBoxLayout(this);
    theReport = new KHTMLPart(this, "Form1");
    theReport->widget()->resize(480,300);
    layout->addWidget(theReport->widget());
    setCaption("KWeather");
}

reportView::~reportView(){
}

/** Render the document */
void reportView::render(){
    QString theReportText =
    "<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Transitional//EN\""
    " \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd\">"
    "<html><head><title>" + i18n( "Weather Report" ) + "</title></head><body>"
    "<h3> " + i18n( "Weather Report as of Current_Date " ) + "</h3><hr />"
    "<table><tr><th colspan=\"2\">" + i18n( "Current Conditions:" ) + "</th></tr>"
    "<tr><td><img width=\"48\" height=\"48\" src=\"Current_Icon\" /></td><td>Current_Weather</td></tr>"
    "<tr><th style=\"text-align: right\">" + i18n( "Temperature:" ) + "</th><td>Current_Temp</td></tr>"
    "<tr><th style=\"text-align: right\">" + i18n( "Air Pressure:" ) + "</th><td>Current_Pressure</td></tr>"
    "<tr><th style=\"text-align: right\">" + i18n( "WindSpeed:" ) + "</th><td>Current_Wind</td></tr></table>"
    "</body></html>";

    QString weatherText = "<ul>\n";

    for (QStringList::const_iterator it = currentCover.begin(); it != currentCover.end(); ++it)
        weatherText += "<li>" + *it + "\n";

    for (QStringList::const_iterator it = currentWeather.begin(); it != currentWeather.end(); ++it)
        weatherText += "<li>" + *it + "\n";

    weatherText += "</ul>\n";

    theReportText.replace( QRegExp("Current_Icon"), KURL(currentIcon).url());
    theReportText.replace( QRegExp("Current_Temp"), currentTemp );
    theReportText.replace( QRegExp("Current_Pressure"), currentPressure );
    theReportText.replace( QRegExp("Current_Wind"), currentWind );
    theReportText.replace( QRegExp("Current_Date"), currentDate );
    theReportText.replace( QRegExp("Current_Weather"), weatherText );
    theReport->begin();
    theReport->write( theReportText );
    theReport->end();
}

void reportView::setTemp( QString temp){
    currentTemp = temp;
}

void reportView::setWind( QString wind){
    currentWind = wind;
}

void reportView::setPressure( QString pressure ){
    currentPressure = pressure;
}

void reportView::setDate( QString date ){
    currentDate = date;
}

void reportView::setCover(QStringList cover){
    currentCover = cover;
}

void reportView::setWeather(QStringList weather){
    currentWeather = weather;
}

void reportView::setWeatherIcon( const QString &icon ){
    currentIcon = locate("data", "kweather/" + icon + ".png");
    setIcon(QPixmap(currentIcon));
}

#include "reportview.moc"
