/***************************************************************************
                          dockwidget.h  -  description
                             -------------------
    begin                : Thu Jul 6 2000
    copyright            : (C) 2000 by Ian Reinhart Geiser
    email                : geiseri@msoe.edu
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#ifndef DOCKWIDGET_H
#define DOCKWIDGET_H

#include <qpushbutton.h>
#include <qlabel.h>
#include <qwidget.h>
#include <qfont.h>
#include <qimage.h>
/**
  *@author ian geiser
  */

class dockwidget : public QWidget  {
    Q_OBJECT

public:
    dockwidget(QWidget *parent=0, const char *name=0);
    ~dockwidget();
    /** Set the current pressure. */
    void setPressure( QString s);
    /** Set the current temperature. */
    void setTemperature( QString s);
    /** Set the current wind speed and direction data. */
    void setWind( QString s);
    void setSmall(bool small);
    void setWeatherIcon(QString icon);
    void setFont(QFont newFont);
    void showWeather();
    /** resize the view **/
    void resizeView( int x, int y);

signals: // Signals
    /** Tell the main application that there was a button event */
    void buttonEvent();

public slots: // Public slots
    /** relay the button pressed to the parent widget */
    void buttonHandler();

private:
    void initDialog();
    void updateFont();
    void showIcon();

    bool isSmall;
    QString temperature;
    QString wind;
    QString pressure;

    QImage theIcon;
    QPushButton *QPushButton_1;
    QLabel *QLabel_1;
    QLabel *QLabel_2;
    QLabel *QLabel_3;
    QFont theFont;
};

#endif
