/**************************
 A program used to send commands to running GnomeICU
 (c) 1999 Jeremy Wise
 (c) 2001 drJeckyll@hotmail.com
 GnomeICU
***************************/

#include <config.h>

#include <glib.h>
#include <fcntl.h>
#include <string.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/socket.h>
#include <sys/un.h>
#include <stdarg.h>
#include <errno.h>
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <netinet/in.h>
#include <pwd.h>


int socket_fd;

int connectme( char *uinstr );
void usage( void );

int main(int ac,char **av)
{
	char c = 1;
	unsigned long u;
	char *buffer;
	int i;
	char *uinstr = NULL;
	int readv = 0;

	if( ac <= 1 || !strcmp( av[1], "-h" ) || !strcmp( av[1], "--help" ) )
		usage();

	buffer = g_malloc0( 8192 );

	for(i=1;i<ac;i++) {
		if(!strcmp(av[i],"-u"))
		{
			i++;
			if(i == ac)
				usage();
			uinstr = av[i++];
			if(i == ac)
				break;
		}
		if(!strcmp(av[i], "readmsg")) {
			readv = i;
			c = 2;
		}
		else if (!strcmp (av[i], "msgcount")) {
			readv = i;
			c = 3;
		}
		else if (!strcmp (av[i], "getstatus") || !strcmp (av[i], "getcoords")) {
			readv = i;
			c = 4;
		}
		else if (!strcmp (av[i], "icuask")) {
			readv = i;
			c = 9;
		}

		strcat(buffer,av[i]);
		strcat(buffer," ");
	}

	buffer[strlen(buffer)-1]=0;

	if ( uinstr != NULL && atol(uinstr)==0 )
	{
		printf("UIN must be a number.\n");
		return(1);
	}

	if (connectme(uinstr)) {
		printf("Unable to connect to running GnomeICU client.\n");
		return(1);
	}

	u=htonl(strlen(buffer)+1);

	write(socket_fd,&c,1);
	write(socket_fd,&u,sizeof(unsigned long));
	write(socket_fd,buffer,strlen(buffer)+1);

	free( buffer );

	if (readv && (
	!strcmp(av[readv], "readmsg") || 
	!strcmp(av[readv], "msgcount") || 
	!strcmp(av[readv], "getstatus") || 
	!strcmp(av[readv], "icuask") || 
	!strcmp(av[readv], "onlinelist")))
	{
		read(socket_fd,&u,sizeof(unsigned long));
		u = ntohl( u );
		if( u < 16384 )
		{
			buffer = malloc( u + 1 );
			read(socket_fd,buffer,u);
			printf( "%s\n\n", buffer );
			free( buffer );
		}
	}

	close(socket_fd);
	return(0);
}

int connectme( char *uinstr )
{
	struct sockaddr_un addr;
	char *user;
	struct passwd *pw;

	pw = getpwuid(getuid());

	if (!pw) {
		fprintf(stderr,"Unable to get current login name, naming service down?\n");
		return(-1);
	}

	user = strdup( pw->pw_name );

	sprintf(addr.sun_path, "/tmp/.gnomeicu-%s/ctl%s%s",
	        user,
	        (uinstr == NULL) ? "" : "-",
	        (uinstr == NULL) ? "" : uinstr );

	addr.sun_family = AF_UNIX;

	if(access(addr.sun_path, R_OK) != 0)
		return 1;

	socket_fd = socket(AF_UNIX, SOCK_STREAM, 0);

	if(socket_fd >= 0) {

		if(connect(socket_fd, (struct sockaddr *)&addr,
			   sizeof(addr.sun_family) + strlen(addr.sun_path) + 1) == 0)
			return 0;
		else
			return 1;
	}
	else
		perror ("socket");
	return -1;
}

void usage (void)
{
	printf ("Usage: icukrell-client [-u YourUIN] command [DestinationUIN] [Data]\n\n");
	printf ("Commands are as follows:\n");
	printf ("%s\t\t%s\n", "msgcount", "show number of incoming messages");
	printf ("%s\t\t\t%s\n", "icuask", "what IcuKrell ask GnomeICU");
	printf ("%s\t\t\t%s\n", "readmsg", "read message");
	printf ("%s\t\t\t%s\n", "getstatus", "get GnomeICU status");
	printf ("%s\t\t\t%s\n", "quit", "close GnomeICU");
	printf ("%s\t\t\t%s\n", "hide", "hide GnomeICU main window");
	printf ("%s\t\t\t%s\n", "show", "show GnomeICU main window");
	printf ("%s\t\t%s\n", "showhide", "show|hide GnomeICU main window");
	printf ("%s\t\t%s\n", "addcontact", "popup GnomeICU useradd dialog");
	printf ("%s\t\t%s\n", "connhistory", "popup GnomeICU connection history window");
	printf ("%s\t\t%s\n", "showprefs", "popup GnomeICU preferencies dialog");
	printf ("%s\t\t%s\n", "changeinfo", "popup GnomeICU user info dialog");
	printf ("%s\t\t%s\n", "ignorelist", "popup GnomeICU ignore list");
	printf ("%s\t\t%s\n", "visiblelist", "popup GnomeICU visible list");
	printf ("%s\t\t%s\n", "invisiblelist", "popup GnomeICU invisible list");
	printf ("%s\t\t%s\n", "notifylist", "popup GnomeICU notify list");
	printf ("%s\t\t%s\n", "away \"msg\"", "set away message");
	printf ("%s\t%s\n", "adduser|useradd UIN", "add user with UIN to the list");
	// onlinelist
	printf ("%s\t\t%s\n", "msg UIN \"msg\"", "send message to UIN");
	printf ("%s\t\t%s\n", "status <status>",
		"set status: online offline away na invisible freechat occupied dnd");
	printf ("%s\t\t%s\n", "readevent", "popup GnomeICU current event window");
	exit (1);
}
